<h1 align="center">
    <b>AEA Framework</b>
</h1>

<p align="center">
Create Autonomous Economic Agents (AEAs)
</p>

<p align="center">
  <a href="https://pypi.org/project/aea/">
    <img alt="PyPI" src="https://img.shields.io/pypi/v/aea">
  </a>
  <a href="https://pypi.org/project/aea/">
    <img alt="PyPI - Python Version" src="https://img.shields.io/pypi/pyversions/aea">
  </a>
  <a href="https://github.com/fetchai/agents-aea/blob/main/LICENSE">
    <img alt="License" src="https://img.shields.io/pypi/l/aea">
  </a>
  <a href="https://pypi.org/project/aea/">
    <img alt="License" src="https://img.shields.io/pypi/dm/aea">
  </a>
  <br />
  <a href="https://github.com/fetchai/agents-aea/workflows/AEA%20framework%20sanity%20checks%20and%20tests">
    <img alt="AEA framework sanity checks and tests" src="https://github.com/fetchai/agents-aea/workflows/AEA%20framework%20sanity%20checks%20and%20tests/badge.svg?branch=main">
  </a>
  <a href="">
    <img alt="Codecov" src="https://img.shields.io/codecov/c/github/fetchai/agents-aea">
  </a>
  <a href="https://discord.gg/hy8SyhNnXf">
    <img src="https://img.shields.io/discord/441214316524339210.svg?logo=discord&logoColor=fff&label=Discord&color=7389d8" alt="Discord conversation" />
  </a>
</p>

The AEA framework allows you to create **Autonomous Economic Agents**:

- An AEA is an <b>Agent</b>, representing an individual, family, organisation or object (a.k.a. its "owner") in the digital world. It looks after its owner's interests and has their preferences in mind when acting on their behalf.
- AEAs are <b>Autonomous</b>; acting with no, or minimal, interference from their owners.
- AEAs have a narrow and specific focus: creating <b>Economic</b> value for their owners.

<p align="center">
  <a href="https://www.youtube.com/embed/xpJA4IT5X88">
    <img src="/data/video-aea.png?raw=true" alt="AEA Video" width="70%"/>
  </a>
</p>

## To install

1. Ensure you have Python (version `3.8`, `3.9` or `3.10`).
2. (optional) Use a virtual environment (e.g. [`pipenv`][pipenv] or [`poetry`][poetry]).
3. Install: `pip install aea[all]`

Please see the [installation page][docs-install] for more details.

## Documentation

The full documentation, including how to get started, can be found [here][docs].

## Contributing

All contributions are very welcome! Remember, contribution is not only PRs and code, but any help with docs or helping other developers solve their issues are very appreciated!

Read below to learn how you can take part in the AEA project.

### Code of Conduct

Please be sure to read and follow our [Code of Conduct][coc]. By participating, you are expected to uphold this code.

### Contribution Guidelines

Read our [contribution guidelines][contributing] to learn about our issue and PR submission processes, coding rules, and more.

### Development Guidelines

Read our [development guidelines][developing] to learn about the development processes and workflows when contributing to different parts of the AEA project.

### Issues, Questions and Discussions

We use [GitHub Issues][issues] for tracking requests and bugs, and [GitHub Discussions][discussion] for general questions and discussion.

## License

The AEA project is licensed under [Apache License 2.0][license].

[poetry]: https://python-poetry.org
[pipenv]: https://pypi.org/project/pipenv/
[docs]: https://docs.fetch.ai
[contributing]: https://github.com/fetchai/agents-aea/blob/main/CONTRIBUTING.md
[developing]: https://github.com/fetchai/agents-aea/blob/main/DEVELOPING.md
[coc]: https://github.com/fetchai/agents-aea/blob/main/CODE_OF_CONDUCT.md
[discussion]: https://github.com/fetchai/agents-aea/discussions
[issues]: https://github.com/fetchai/agents-aea/issues
[license]: https://github.com/fetchai/agents-aea/blob/main/LICENSE
[docs-install]: https://docs.fetch.ai/aea/installation/
