"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystem = exports.FileSystemProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dfs_generated_1 = require("./dfs.generated");
Object.defineProperty(exports, "FileSystemProperty", { enumerable: true, get: function () { return dfs_generated_1.RosFileSystem; } });
/**
 * A ROS resource type:  `ALIYUN::DFS::FileSystem`
 */
class FileSystem extends ros.Resource {
    /**
     * Create a new `ALIYUN::DFS::FileSystem`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosFileSystem = new dfs_generated_1.RosFileSystem(this, id, {
            spaceCapacity: props.spaceCapacity,
            description: props.description,
            storageType: props.storageType === undefined || props.storageType === null ? 'STANDARD' : props.storageType,
            zoneId: props.zoneId,
            partitionNumber: props.partitionNumber,
            protocolType: props.protocolType,
            dataRedundancyType: props.dataRedundancyType === undefined || props.dataRedundancyType === null ? 'LRS' : props.dataRedundancyType,
            fileSystemName: props.fileSystemName,
            provisionedThroughputInMiBps: props.provisionedThroughputInMiBps,
            throughputMode: props.throughputMode === undefined || props.throughputMode === null ? 'Standard' : props.throughputMode,
            storageSetName: props.storageSetName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosFileSystem;
        this.attrFileSystemId = rosFileSystem.attrFileSystemId;
    }
}
exports.FileSystem = FileSystem;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmlsZXN5c3RlbS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImZpbGVzeXN0ZW0udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsOENBQThDO0FBQzlDLG1EQUFnRDtBQUV0QixtR0FGakIsNkJBQWEsT0FFc0I7QUE2RTVDOztHQUVHO0FBQ0gsTUFBYSxVQUFXLFNBQVEsR0FBRyxDQUFDLFFBQVE7SUFZeEM7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUFzQixFQUFFLG1DQUEyQyxJQUFJO1FBQ2pILEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxhQUFhLEdBQUcsSUFBSSw2QkFBYSxDQUFDLElBQUksRUFBRSxFQUFFLEVBQUc7WUFDL0MsYUFBYSxFQUFFLEtBQUssQ0FBQyxhQUFhO1lBQ2xDLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztZQUM5QixXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVcsS0FBSyxTQUFTLElBQUksS0FBSyxDQUFDLFdBQVcsS0FBSyxJQUFJLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLFdBQVc7WUFDM0csTUFBTSxFQUFFLEtBQUssQ0FBQyxNQUFNO1lBQ3BCLGVBQWUsRUFBRSxLQUFLLENBQUMsZUFBZTtZQUN0QyxZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7WUFDaEMsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsa0JBQWtCLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxrQkFBa0I7WUFDbEksY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO1lBQ3BDLDRCQUE0QixFQUFFLEtBQUssQ0FBQyw0QkFBNEI7WUFDaEUsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxjQUFjLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxjQUFjO1lBQ3ZILGNBQWMsRUFBRSxLQUFLLENBQUMsY0FBYztTQUN2QyxFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLGFBQWEsQ0FBQztRQUM5QixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsYUFBYSxDQUFDLGdCQUFnQixDQUFDO0lBQzNELENBQUM7Q0FDSjtBQXRDRCxnQ0FzQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyByb3MgZnJvbSAnQGFsaWNsb3VkL3Jvcy1jZGstY29yZSc7XG5pbXBvcnQgeyBSb3NGaWxlU3lzdGVtIH0gZnJvbSAnLi9kZnMuZ2VuZXJhdGVkJztcbi8vIEdlbmVyYXRlZCBmcm9tIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgU3BlY2lmaWNhdGlvblxuZXhwb3J0IHsgUm9zRmlsZVN5c3RlbSBhcyBGaWxlU3lzdGVtUHJvcGVydHkgfTtcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBBTElZVU46OkRGUzo6RmlsZVN5c3RlbWBcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBGaWxlU3lzdGVtUHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcHJvdG9jb2xUeXBlOiBQcm90b2NvbCB0eXBlLCBvbmx5IHN1cHBvcnQgSERGU++8iEhhZG9vcEZpbGVTeXN0ZW3vvIlcbiAgICAgKi9cbiAgICByZWFkb25seSBwcm90b2NvbFR5cGU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHNwYWNlQ2FwYWNpdHk6IENhcGFjaXR5IG9mIHRoZSBmaWxlIHN5c3RlbS5cbiAgICAgKiBXaGVuIHRoZSBhY3R1YWwgZGF0YSB2b2x1bWUgcmVhY2hlcyB0aGUgZmlsZSBzeXN0ZW0gY2FwYWNpdHksIGRhdGEgY2Fubm90IGJlIHdyaXR0ZW4uXG4gICAgICogVW5pdDogR0JcbiAgICAgKi9cbiAgICByZWFkb25seSBzcGFjZUNhcGFjaXR5OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBzdG9yYWdlVHlwZTogVHlwZSBvZiBzdG9yYWdlIG1lZGlhLlxuICAgICAqIFZhbHVlczpcbiAgICAgKiBTVEFOREFSRCAoZGVmYXVsdCkgOiBzdGFuZGFyZCB0eXBlLlxuICAgICAqIFBFUkZPUk1BTkNFOiBwZXJmb3JtYW5jZSB0eXBlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHN0b3JhZ2VUeXBlOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB6b25lSWQ6IHpvbmUgaWRcbiAgICAgKi9cbiAgICByZWFkb25seSB6b25lSWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGRhdGFSZWR1bmRhbmN5VHlwZTogUmVkdW5kYW5jeSBtb2RlIG9mIHRoZSBmaWxlIHN5c3RlbS5cbiAgICAgKiBWYWx1ZXM6XG4gICAgICogTFJTIChkZWZhdWx0KSA6IGxvY2FsIHJlZHVuZGFuY3kuXG4gICAgICogWlJTOiBpbi1jaXR5IHJlZHVuZGFuY3kuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGF0YVJlZHVuZGFuY3lUeXBlPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZGVzY3JpcHRpb246IFRoZSBkZXNjcmlwdGlvbiBvZiB0aGUgZmlsZSBzeXN0ZW0uXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVzY3JpcHRpb24/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBmaWxlU3lzdGVtTmFtZTogTmFtZSBvZiB0aGUgZmlsZSBzeXN0ZW0uIFRoZSBuYW1pbmcgcnVsZXMgYXJlIGFzIGZvbGxvd3M6XG4gICAgICogVGhlIHZhbHVlIGNvbnRhaW5zIDYgdG8gMTAwIGNoYXJhY3RlcnMuIFxuICAgICAqIEdsb2JhbGx5IHVuaXF1ZSBhbmQgY2Fubm90IGJlIGFuIGVtcHR5IHN0cmluZy5cbiAgICAgKiBUaGUgdmFsdWUgY2FuIGNvbnRhaW4gbGV0dGVycyBhbmQgZGlnaXRzIGFuZCB1bmRlcnNjb3JlcyAoXykuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZmlsZVN5c3RlbU5hbWU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBwYXJ0aXRpb25OdW1iZXI6IFRoZSByZXNlcnZlZCBwYXJhbWV0ZXJzXG4gICAgICovXG4gICAgcmVhZG9ubHkgcGFydGl0aW9uTnVtYmVyPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcHJvdmlzaW9uZWRUaHJvdWdocHV0SW5NaUJwczogUHJlc2V0IGhhbmRsaW5nIGNhcGFjaXR5LlxuICAgICAqIFVuaXQ6IE1CL3NkYXRhIHJhbmdlOiAxLTUxMjBcbiAgICAgKi9cbiAgICByZWFkb25seSBwcm92aXNpb25lZFRocm91Z2hwdXRJbk1pQnBzPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgc3RvcmFnZVNldE5hbWU6IFRoZSByZXNlcnZlZCBwYXJhbWV0ZXJzLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHN0b3JhZ2VTZXROYW1lPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgdGhyb3VnaHB1dE1vZGU6IFRocm91Z2hwdXQgbW9kZVxuICAgICAqIFZhbHVlczpcbiAgICAgKiBTdGFuZGFyZO+8iGRlZmF1bHTvvIk6IHN0YW5kYXJkIHRocm91Z2hwdXRQcm92aXNpb25lZDogcHJlc2V0IHRocm91Z2hwdXRcbiAgICAgKi9cbiAgICByZWFkb25seSB0aHJvdWdocHV0TW9kZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcbn1cblxuLyoqXG4gKiBBIFJPUyByZXNvdXJjZSB0eXBlOiAgYEFMSVlVTjo6REZTOjpGaWxlU3lzdGVtYFxuICovXG5leHBvcnQgY2xhc3MgRmlsZVN5c3RlbSBleHRlbmRzIHJvcy5SZXNvdXJjZSB7XG5cbiAgICAvKipcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XG4gICAgICogY29udGFpbmluZyB0aGUgcHJvcGVydGllcyBvZiB0aGlzIFJPUyByZXNvdXJjZSwgd2hpY2ggd2lsbCBiZSBhc3NpZ25lZCB0byBST1MgcmVzb3VyY2UuXG4gICAgICovXG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgRmlsZVN5c3RlbUlkOiBUaGUgSUQgb2YgdGhlIGZpbGUgc3lzdGVtLlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyRmlsZVN5c3RlbUlkOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFMSVlVTjo6REZTOjpGaWxlU3lzdGVtYC5cbiAgICAgKlxuICAgICAqIFBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogUGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogUGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IHJvcy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBGaWxlU3lzdGVtUHJvcHMsIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OmJvb2xlYW4gPSB0cnVlKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICAgICAgY29uc3Qgcm9zRmlsZVN5c3RlbSA9IG5ldyBSb3NGaWxlU3lzdGVtKHRoaXMsIGlkLCAge1xuICAgICAgICAgICAgc3BhY2VDYXBhY2l0eTogcHJvcHMuc3BhY2VDYXBhY2l0eSxcbiAgICAgICAgICAgIGRlc2NyaXB0aW9uOiBwcm9wcy5kZXNjcmlwdGlvbixcbiAgICAgICAgICAgIHN0b3JhZ2VUeXBlOiBwcm9wcy5zdG9yYWdlVHlwZSA9PT0gdW5kZWZpbmVkIHx8IHByb3BzLnN0b3JhZ2VUeXBlID09PSBudWxsID8gJ1NUQU5EQVJEJyA6IHByb3BzLnN0b3JhZ2VUeXBlLFxuICAgICAgICAgICAgem9uZUlkOiBwcm9wcy56b25lSWQsXG4gICAgICAgICAgICBwYXJ0aXRpb25OdW1iZXI6IHByb3BzLnBhcnRpdGlvbk51bWJlcixcbiAgICAgICAgICAgIHByb3RvY29sVHlwZTogcHJvcHMucHJvdG9jb2xUeXBlLFxuICAgICAgICAgICAgZGF0YVJlZHVuZGFuY3lUeXBlOiBwcm9wcy5kYXRhUmVkdW5kYW5jeVR5cGUgPT09IHVuZGVmaW5lZCB8fCBwcm9wcy5kYXRhUmVkdW5kYW5jeVR5cGUgPT09IG51bGwgPyAnTFJTJyA6IHByb3BzLmRhdGFSZWR1bmRhbmN5VHlwZSxcbiAgICAgICAgICAgIGZpbGVTeXN0ZW1OYW1lOiBwcm9wcy5maWxlU3lzdGVtTmFtZSxcbiAgICAgICAgICAgIHByb3Zpc2lvbmVkVGhyb3VnaHB1dEluTWlCcHM6IHByb3BzLnByb3Zpc2lvbmVkVGhyb3VnaHB1dEluTWlCcHMsXG4gICAgICAgICAgICB0aHJvdWdocHV0TW9kZTogcHJvcHMudGhyb3VnaHB1dE1vZGUgPT09IHVuZGVmaW5lZCB8fCBwcm9wcy50aHJvdWdocHV0TW9kZSA9PT0gbnVsbCA/ICdTdGFuZGFyZCcgOiBwcm9wcy50aHJvdWdocHV0TW9kZSxcbiAgICAgICAgICAgIHN0b3JhZ2VTZXROYW1lOiBwcm9wcy5zdG9yYWdlU2V0TmFtZSxcbiAgICAgICAgfSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgJiYgdGhpcy5zdGFjay5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XG4gICAgICAgIHRoaXMucmVzb3VyY2UgPSByb3NGaWxlU3lzdGVtO1xuICAgICAgICB0aGlzLmF0dHJGaWxlU3lzdGVtSWQgPSByb3NGaWxlU3lzdGVtLmF0dHJGaWxlU3lzdGVtSWQ7XG4gICAgfVxufVxuIl19