"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessGroup = exports.AccessGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dfs_generated_1 = require("./dfs.generated");
Object.defineProperty(exports, "AccessGroupProperty", { enumerable: true, get: function () { return dfs_generated_1.RosAccessGroup; } });
/**
 * A ROS resource type:  `ALIYUN::DFS::AccessGroup`
 */
class AccessGroup extends ros.Resource {
    /**
     * Create a new `ALIYUN::DFS::AccessGroup`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosAccessGroup = new dfs_generated_1.RosAccessGroup(this, id, {
            description: props.description,
            networkType: props.networkType,
            accessGroupName: props.accessGroupName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAccessGroup;
        this.attrAccessGroupId = rosAccessGroup.attrAccessGroupId;
    }
}
exports.AccessGroup = AccessGroup;
//# sourceMappingURL=data:application/json;base64,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