# coding: utf-8

"""
    AYLIEN News API

    The AYLIEN News API is the most powerful way of sourcing, searching and syndicating analyzed and enriched news content. It is accessed by sending HTTP requests to our server, which returns information to your client.   # noqa: E501

    The version of the OpenAPI document: 4.7.4
    Contact: support@aylien.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from aylien_news_api.configuration import Configuration


class DeprecatedEntity(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'indices': 'list[list[int]]',
        'links': 'EntityLinks',
        'text': 'str',
        'stock_ticker': 'str',
        'types': 'list[str]',
        'sentiment': 'EntitySentiment',
        'surface_forms': 'list[DeprecatedEntitySurfaceForm]',
        'prominence_score': 'float'
    }

    attribute_map = {
        'id': 'id',
        'indices': 'indices',
        'links': 'links',
        'text': 'text',
        'stock_ticker': 'stock_ticker',
        'types': 'types',
        'sentiment': 'sentiment',
        'surface_forms': 'surface_forms',
        'prominence_score': 'prominence_score'
    }

    def __init__(self, id=None, indices=None, links=None, text=None, stock_ticker=None, types=None, sentiment=None, surface_forms=None, prominence_score=None, local_vars_configuration=None):  # noqa: E501
        """DeprecatedEntity - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._indices = None
        self._links = None
        self._text = None
        self._stock_ticker = None
        self._types = None
        self._sentiment = None
        self._surface_forms = None
        self._prominence_score = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if indices is not None:
            self.indices = indices
        if links is not None:
            self.links = links
        if text is not None:
            self.text = text
        if stock_ticker is not None:
            self.stock_ticker = stock_ticker
        if types is not None:
            self.types = types
        if sentiment is not None:
            self.sentiment = sentiment
        if surface_forms is not None:
            self.surface_forms = surface_forms
        if prominence_score is not None:
            self.prominence_score = prominence_score

    @property
    def id(self):
        """Gets the id of this DeprecatedEntity.  # noqa: E501

        The unique ID of the entity  # noqa: E501

        :return: The id of this DeprecatedEntity.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DeprecatedEntity.

        The unique ID of the entity  # noqa: E501

        :param id: The id of this DeprecatedEntity.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def indices(self):
        """Gets the indices of this DeprecatedEntity.  # noqa: E501

        The indices of the entity text  # noqa: E501

        :return: The indices of this DeprecatedEntity.  # noqa: E501
        :rtype: list[list[int]]
        """
        return self._indices

    @indices.setter
    def indices(self, indices):
        """Sets the indices of this DeprecatedEntity.

        The indices of the entity text  # noqa: E501

        :param indices: The indices of this DeprecatedEntity.  # noqa: E501
        :type indices: list[list[int]]
        """

        self._indices = indices

    @property
    def links(self):
        """Gets the links of this DeprecatedEntity.  # noqa: E501


        :return: The links of this DeprecatedEntity.  # noqa: E501
        :rtype: EntityLinks
        """
        return self._links

    @links.setter
    def links(self, links):
        """Sets the links of this DeprecatedEntity.


        :param links: The links of this DeprecatedEntity.  # noqa: E501
        :type links: EntityLinks
        """

        self._links = links

    @property
    def text(self):
        """Gets the text of this DeprecatedEntity.  # noqa: E501

        The entity text  # noqa: E501

        :return: The text of this DeprecatedEntity.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this DeprecatedEntity.

        The entity text  # noqa: E501

        :param text: The text of this DeprecatedEntity.  # noqa: E501
        :type text: str
        """

        self._text = text

    @property
    def stock_ticker(self):
        """Gets the stock_ticker of this DeprecatedEntity.  # noqa: E501

        The stock_ticker of the entity (might be null)  # noqa: E501

        :return: The stock_ticker of this DeprecatedEntity.  # noqa: E501
        :rtype: str
        """
        return self._stock_ticker

    @stock_ticker.setter
    def stock_ticker(self, stock_ticker):
        """Sets the stock_ticker of this DeprecatedEntity.

        The stock_ticker of the entity (might be null)  # noqa: E501

        :param stock_ticker: The stock_ticker of this DeprecatedEntity.  # noqa: E501
        :type stock_ticker: str
        """

        self._stock_ticker = stock_ticker

    @property
    def types(self):
        """Gets the types of this DeprecatedEntity.  # noqa: E501

        An array of the entity types  # noqa: E501

        :return: The types of this DeprecatedEntity.  # noqa: E501
        :rtype: list[str]
        """
        return self._types

    @types.setter
    def types(self, types):
        """Sets the types of this DeprecatedEntity.

        An array of the entity types  # noqa: E501

        :param types: The types of this DeprecatedEntity.  # noqa: E501
        :type types: list[str]
        """

        self._types = types

    @property
    def sentiment(self):
        """Gets the sentiment of this DeprecatedEntity.  # noqa: E501


        :return: The sentiment of this DeprecatedEntity.  # noqa: E501
        :rtype: EntitySentiment
        """
        return self._sentiment

    @sentiment.setter
    def sentiment(self, sentiment):
        """Sets the sentiment of this DeprecatedEntity.


        :param sentiment: The sentiment of this DeprecatedEntity.  # noqa: E501
        :type sentiment: EntitySentiment
        """

        self._sentiment = sentiment

    @property
    def surface_forms(self):
        """Gets the surface_forms of this DeprecatedEntity.  # noqa: E501


        :return: The surface_forms of this DeprecatedEntity.  # noqa: E501
        :rtype: list[DeprecatedEntitySurfaceForm]
        """
        return self._surface_forms

    @surface_forms.setter
    def surface_forms(self, surface_forms):
        """Sets the surface_forms of this DeprecatedEntity.


        :param surface_forms: The surface_forms of this DeprecatedEntity.  # noqa: E501
        :type surface_forms: list[DeprecatedEntitySurfaceForm]
        """

        self._surface_forms = surface_forms

    @property
    def prominence_score(self):
        """Gets the prominence_score of this DeprecatedEntity.  # noqa: E501

        Describes how relevant an entity is to the article  # noqa: E501

        :return: The prominence_score of this DeprecatedEntity.  # noqa: E501
        :rtype: float
        """
        return self._prominence_score

    @prominence_score.setter
    def prominence_score(self, prominence_score):
        """Sets the prominence_score of this DeprecatedEntity.

        Describes how relevant an entity is to the article  # noqa: E501

        :param prominence_score: The prominence_score of this DeprecatedEntity.  # noqa: E501
        :type prominence_score: float
        """
        if (self.local_vars_configuration.client_side_validation and
                prominence_score is not None and prominence_score > 1):  # noqa: E501
            raise ValueError("Invalid value for `prominence_score`, must be a value less than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                prominence_score is not None and prominence_score < 0):  # noqa: E501
            raise ValueError("Invalid value for `prominence_score`, must be a value greater than or equal to `0`")  # noqa: E501

        self._prominence_score = prominence_score

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DeprecatedEntity):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DeprecatedEntity):
            return True

        return self.to_dict() != other.to_dict()
