---
hide:
  - navigation
  - toc
  - actions
  - footer
  - feedback
---
# Pyoframe: A loved alternative to GAMS, Pyomo, and Linopy

- Builds linear, non-linear, quadratic, continuous and mixed-integer optimization problems.
- Seamlessly integrates with pandas thanks to its dataframe-centric design.
- Extremely **fast and memory efficient** (even for sparse problems) thanks to Polars, Rust, and Pyoptinterface.
- Clear Pythonic syntax for writing mathematical models.
- Supports Gurobi, HiGHS, and Ipopt solvers.
- Continuously used in high-stakes production environments.
- 100% open-source (MIT License).

---

<div class="grid cards" markdown>

-   :material-clock-fast:{ .lg .middle } __Learn__

    ---

    Install `pyoframe` and learn the library's basics.

    [:octicons-arrow-right-24: Get started](./learn/get-started/installation.md)

-   :octicons-light-bulb-16:{ .lg .middle } __Examples__

    ---

    Jump right in with our annotated examples.

    [:octicons-arrow-right-24: Examples](./examples/index.md)

<!-- -   :fontawesome-brands-markdown:{ .lg .middle } __Why Pyoframe?__

    ---

    Compare our speed and memory-usage to other libraries and prepare to be amazed.

    [:octicons-arrow-right-24: Benchmarks](#)

-   :material-scale-balance:{ .lg .middle } __Deep dive__

    ---
    Understand our unique approach to building models with Polars dataframes. 
    
    [:octicons-arrow-right-24: Deep dive](#) -->

-   :material-format-font:{ .lg .middle } __API Reference__

    ---

    Your go-to reference for understanding our API.

    [:octicons-arrow-right-24: Reference](./reference/index.md)

-   :octicons-discussion-closed-24:{ .lg .middle } __Ask a question__

    ---

    Ask questions and discuss on our forum.

    [:octicons-arrow-right-24: GitHub Discussions](https://github.com/Bravos-Power/pyoframe/discussions)

-   :material-bug:{ .lg .middle } __Report a bug__

    ---

    Bugs and feature requests can be submitted on GitHub.

    [:octicons-arrow-right-24: GitHub Issues](https://github.com/Bravos-Power/pyoframe/issues)

</div>
