"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontToMediaStore = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-cdk/core");
class CloudFrontToMediaStore extends core_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of CloudFrontToMediaStore class.
     * @since 1.76.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        let cloudFrontDistributionProps = props.cloudFrontDistributionProps;
        if (props.existingMediaStoreContainerObj) {
            this.mediaStoreContainer = props.existingMediaStoreContainerObj;
        }
        else {
            let mediaStoreProps;
            if (props.mediaStoreContainerProps) {
                mediaStoreProps = props.mediaStoreContainerProps;
            }
            else {
                this.cloudFrontOriginAccessIdentity = defaults.CloudFrontOriginAccessIdentity(this);
                mediaStoreProps = {
                    containerName: core_1.Aws.STACK_NAME,
                    policy: JSON.stringify({
                        Version: '2012-10-17',
                        Statement: [{
                                Sid: 'MediaStoreDefaultPolicy',
                                Effect: 'Allow',
                                Principal: '*',
                                Action: [
                                    'mediastore:GetObject',
                                    'mediastore:DescribeObject'
                                ],
                                Resource: `arn:${core_1.Aws.PARTITION}:mediastore:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:container/${core_1.Aws.STACK_NAME}/*`,
                                Condition: {
                                    StringEquals: {
                                        'aws:UserAgent': this.cloudFrontOriginAccessIdentity.originAccessIdentityName
                                    },
                                    Bool: {
                                        'aws:SecureTransport': 'true'
                                    }
                                }
                            }]
                    })
                };
                const userAgentHeader = {
                    'User-Agent': this.cloudFrontOriginAccessIdentity.originAccessIdentityName
                };
                if (cloudFrontDistributionProps) {
                    cloudFrontDistributionProps.customHeaders = userAgentHeader;
                }
                else {
                    cloudFrontDistributionProps = {
                        customHeaders: userAgentHeader
                    };
                }
            }
            this.mediaStoreContainer = defaults.MediaStoreContainer(this, mediaStoreProps);
        }
        [this.cloudFrontWebDistribution, this.cloudFrontLoggingBucket, this.cloudFrontOriginRequestPolicy, this.cloudFrontFunction]
            = defaults.CloudFrontDistributionForMediaStore(this, this.mediaStoreContainer, cloudFrontDistributionProps, props.insertHttpSecurityHeaders, props.cloudFrontLoggingBucketProps);
    }
}
exports.CloudFrontToMediaStore = CloudFrontToMediaStore;
_a = JSII_RTTI_SYMBOL_1;
CloudFrontToMediaStore[_a] = { fqn: "@aws-solutions-constructs/aws-cloudfront-mediastore.CloudFrontToMediaStore", version: "1.138.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQWdCQSwyREFBMkQ7QUFDM0Qsd0NBQStDO0FBZ0IvQyxNQUFhLHNCQUF1QixTQUFRLGdCQUFTOzs7Ozs7Ozs7SUFTbkQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFrQztRQUMxRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLFFBQVEsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFM0IsSUFBSSwyQkFBMkIsR0FBRyxLQUFLLENBQUMsMkJBQTJCLENBQUM7UUFFcEUsSUFBSSxLQUFLLENBQUMsOEJBQThCLEVBQUU7WUFDeEMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQyw4QkFBOEIsQ0FBQztTQUNqRTthQUFNO1lBQ0wsSUFBSSxlQUE2QyxDQUFDO1lBRWxELElBQUksS0FBSyxDQUFDLHdCQUF3QixFQUFFO2dCQUNsQyxlQUFlLEdBQUcsS0FBSyxDQUFDLHdCQUF3QixDQUFDO2FBQ2xEO2lCQUFNO2dCQUNMLElBQUksQ0FBQyw4QkFBOEIsR0FBRyxRQUFRLENBQUMsOEJBQThCLENBQUMsSUFBSSxDQUFDLENBQUM7Z0JBRXBGLGVBQWUsR0FBRztvQkFDaEIsYUFBYSxFQUFFLFVBQUcsQ0FBQyxVQUFVO29CQUM3QixNQUFNLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQzt3QkFDckIsT0FBTyxFQUFFLFlBQVk7d0JBQ3JCLFNBQVMsRUFBRSxDQUFDO2dDQUNWLEdBQUcsRUFBRSx5QkFBeUI7Z0NBQzlCLE1BQU0sRUFBRSxPQUFPO2dDQUNmLFNBQVMsRUFBRSxHQUFHO2dDQUNkLE1BQU0sRUFBRTtvQ0FDTixzQkFBc0I7b0NBQ3RCLDJCQUEyQjtpQ0FDNUI7Z0NBQ0QsUUFBUSxFQUFFLE9BQU8sVUFBRyxDQUFDLFNBQVMsZUFBZSxVQUFHLENBQUMsTUFBTSxJQUFJLFVBQUcsQ0FBQyxVQUFVLGNBQWMsVUFBRyxDQUFDLFVBQVUsSUFBSTtnQ0FDekcsU0FBUyxFQUFFO29DQUNULFlBQVksRUFBRTt3Q0FDWixlQUFlLEVBQUUsSUFBSSxDQUFDLDhCQUE4QixDQUFDLHdCQUF3QjtxQ0FDOUU7b0NBQ0QsSUFBSSxFQUFFO3dDQUNKLHFCQUFxQixFQUFFLE1BQU07cUNBQzlCO2lDQUNGOzZCQUNGLENBQUM7cUJBQ0gsQ0FBQztpQkFDSCxDQUFDO2dCQUVGLE1BQU0sZUFBZSxHQUEyQjtvQkFDOUMsWUFBWSxFQUFFLElBQUksQ0FBQyw4QkFBOEIsQ0FBQyx3QkFBd0I7aUJBQzNFLENBQUM7Z0JBRUYsSUFBSSwyQkFBMkIsRUFBRTtvQkFDL0IsMkJBQTJCLENBQUMsYUFBYSxHQUFHLGVBQWUsQ0FBQztpQkFDN0Q7cUJBQU07b0JBQ0wsMkJBQTJCLEdBQUc7d0JBQzVCLGFBQWEsRUFBRSxlQUFlO3FCQUMvQixDQUFDO2lCQUNIO2FBQ0Y7WUFFRCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsUUFBUSxDQUFDLG1CQUFtQixDQUFDLElBQUksRUFBRSxlQUFlLENBQUMsQ0FBQztTQUNoRjtRQUVELENBQUMsSUFBSSxDQUFDLHlCQUF5QixFQUFFLElBQUksQ0FBQyx1QkFBdUIsRUFBRSxJQUFJLENBQUMsNkJBQTZCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQixDQUFDO2NBQ3ZILFFBQVEsQ0FBQyxtQ0FBbUMsQ0FDNUMsSUFBSSxFQUFFLElBQUksQ0FBQyxtQkFBbUIsRUFDOUIsMkJBQTJCLEVBQzNCLEtBQUssQ0FBQyx5QkFBeUIsRUFDL0IsS0FBSyxDQUFDLDRCQUE0QixDQUNuQyxDQUFDO0lBQ04sQ0FBQzs7QUF6RUgsd0RBMEVDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiAgQ29weXJpZ2h0IDIwMjIgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiAgTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKS4gWW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZVxuICogIHdpdGggdGhlIExpY2Vuc2UuIEEgY29weSBvZiB0aGUgTGljZW5zZSBpcyBsb2NhdGVkIGF0XG4gKlxuICogICAgICBodHRwOi8vd3d3LmFwYWNoZS5vcmcvbGljZW5zZXMvTElDRU5TRS0yLjBcbiAqXG4gKiAgb3IgaW4gdGhlICdsaWNlbnNlJyBmaWxlIGFjY29tcGFueWluZyB0aGlzIGZpbGUuIFRoaXMgZmlsZSBpcyBkaXN0cmlidXRlZCBvbiBhbiAnQVMgSVMnIEJBU0lTLCBXSVRIT1VUIFdBUlJBTlRJRVNcbiAqICBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBleHByZXNzIG9yIGltcGxpZWQuIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlIHNwZWNpZmljIGxhbmd1YWdlIGdvdmVybmluZyBwZXJtaXNzaW9uc1xuICogIGFuZCBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuXG5pbXBvcnQgKiBhcyBjbG91ZGZyb250IGZyb20gJ0Bhd3MtY2RrL2F3cy1jbG91ZGZyb250JztcbmltcG9ydCAqIGFzIG1lZGlhc3RvcmUgZnJvbSAnQGF3cy1jZGsvYXdzLW1lZGlhc3RvcmUnO1xuaW1wb3J0ICogYXMgczMgZnJvbSAnQGF3cy1jZGsvYXdzLXMzJztcbmltcG9ydCAqIGFzIGRlZmF1bHRzIGZyb20gJ0Bhd3Mtc29sdXRpb25zLWNvbnN0cnVjdHMvY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QsIEF3cyB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgQ2xvdWRGcm9udFRvTWVkaWFTdG9yZVByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGV4aXN0aW5nTWVkaWFTdG9yZUNvbnRhaW5lck9iaj86IG1lZGlhc3RvcmUuQ2ZuQ29udGFpbmVyO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtZWRpYVN0b3JlQ29udGFpbmVyUHJvcHM/OiBtZWRpYXN0b3JlLkNmbkNvbnRhaW5lclByb3BzO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjbG91ZEZyb250RGlzdHJpYnV0aW9uUHJvcHM/OiBjbG91ZGZyb250LkRpc3RyaWJ1dGlvblByb3BzIHwgYW55O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBpbnNlcnRIdHRwU2VjdXJpdHlIZWFkZXJzPzogYm9vbGVhbjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY2xvdWRGcm9udExvZ2dpbmdCdWNrZXRQcm9wcz86IHMzLkJ1Y2tldFByb3BzXG59XG5cbmV4cG9ydCBjbGFzcyBDbG91ZEZyb250VG9NZWRpYVN0b3JlIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IGNsb3VkRnJvbnRXZWJEaXN0cmlidXRpb246IGNsb3VkZnJvbnQuRGlzdHJpYnV0aW9uO1xuICBwdWJsaWMgcmVhZG9ubHkgbWVkaWFTdG9yZUNvbnRhaW5lcjogbWVkaWFzdG9yZS5DZm5Db250YWluZXI7XG4gIHB1YmxpYyByZWFkb25seSBjbG91ZEZyb250TG9nZ2luZ0J1Y2tldD86IHMzLkJ1Y2tldDtcbiAgcHVibGljIHJlYWRvbmx5IGNsb3VkRnJvbnRPcmlnaW5SZXF1ZXN0UG9saWN5OiBjbG91ZGZyb250Lk9yaWdpblJlcXVlc3RQb2xpY3k7XG4gIHB1YmxpYyByZWFkb25seSBjbG91ZEZyb250T3JpZ2luQWNjZXNzSWRlbnRpdHk/OiBjbG91ZGZyb250Lk9yaWdpbkFjY2Vzc0lkZW50aXR5O1xuICBwdWJsaWMgcmVhZG9ubHkgY2xvdWRGcm9udEZ1bmN0aW9uPzogY2xvdWRmcm9udC5GdW5jdGlvbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENsb3VkRnJvbnRUb01lZGlhU3RvcmVQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgZGVmYXVsdHMuQ2hlY2tQcm9wcyhwcm9wcyk7XG5cbiAgICBsZXQgY2xvdWRGcm9udERpc3RyaWJ1dGlvblByb3BzID0gcHJvcHMuY2xvdWRGcm9udERpc3RyaWJ1dGlvblByb3BzO1xuXG4gICAgaWYgKHByb3BzLmV4aXN0aW5nTWVkaWFTdG9yZUNvbnRhaW5lck9iaikge1xuICAgICAgdGhpcy5tZWRpYVN0b3JlQ29udGFpbmVyID0gcHJvcHMuZXhpc3RpbmdNZWRpYVN0b3JlQ29udGFpbmVyT2JqO1xuICAgIH0gZWxzZSB7XG4gICAgICBsZXQgbWVkaWFTdG9yZVByb3BzOiBtZWRpYXN0b3JlLkNmbkNvbnRhaW5lclByb3BzO1xuXG4gICAgICBpZiAocHJvcHMubWVkaWFTdG9yZUNvbnRhaW5lclByb3BzKSB7XG4gICAgICAgIG1lZGlhU3RvcmVQcm9wcyA9IHByb3BzLm1lZGlhU3RvcmVDb250YWluZXJQcm9wcztcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIHRoaXMuY2xvdWRGcm9udE9yaWdpbkFjY2Vzc0lkZW50aXR5ID0gZGVmYXVsdHMuQ2xvdWRGcm9udE9yaWdpbkFjY2Vzc0lkZW50aXR5KHRoaXMpO1xuXG4gICAgICAgIG1lZGlhU3RvcmVQcm9wcyA9IHtcbiAgICAgICAgICBjb250YWluZXJOYW1lOiBBd3MuU1RBQ0tfTkFNRSxcbiAgICAgICAgICBwb2xpY3k6IEpTT04uc3RyaW5naWZ5KHtcbiAgICAgICAgICAgIFZlcnNpb246ICcyMDEyLTEwLTE3JyxcbiAgICAgICAgICAgIFN0YXRlbWVudDogW3tcbiAgICAgICAgICAgICAgU2lkOiAnTWVkaWFTdG9yZURlZmF1bHRQb2xpY3knLFxuICAgICAgICAgICAgICBFZmZlY3Q6ICdBbGxvdycsXG4gICAgICAgICAgICAgIFByaW5jaXBhbDogJyonLFxuICAgICAgICAgICAgICBBY3Rpb246IFtcbiAgICAgICAgICAgICAgICAnbWVkaWFzdG9yZTpHZXRPYmplY3QnLFxuICAgICAgICAgICAgICAgICdtZWRpYXN0b3JlOkRlc2NyaWJlT2JqZWN0J1xuICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgICBSZXNvdXJjZTogYGFybjoke0F3cy5QQVJUSVRJT059Om1lZGlhc3RvcmU6JHtBd3MuUkVHSU9OfToke0F3cy5BQ0NPVU5UX0lEfTpjb250YWluZXIvJHtBd3MuU1RBQ0tfTkFNRX0vKmAsXG4gICAgICAgICAgICAgIENvbmRpdGlvbjoge1xuICAgICAgICAgICAgICAgIFN0cmluZ0VxdWFsczoge1xuICAgICAgICAgICAgICAgICAgJ2F3czpVc2VyQWdlbnQnOiB0aGlzLmNsb3VkRnJvbnRPcmlnaW5BY2Nlc3NJZGVudGl0eS5vcmlnaW5BY2Nlc3NJZGVudGl0eU5hbWVcbiAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgIEJvb2w6IHtcbiAgICAgICAgICAgICAgICAgICdhd3M6U2VjdXJlVHJhbnNwb3J0JzogJ3RydWUnXG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XVxuICAgICAgICAgIH0pXG4gICAgICAgIH07XG5cbiAgICAgICAgY29uc3QgdXNlckFnZW50SGVhZGVyOiBSZWNvcmQ8c3RyaW5nLCBzdHJpbmc+ID0ge1xuICAgICAgICAgICdVc2VyLUFnZW50JzogdGhpcy5jbG91ZEZyb250T3JpZ2luQWNjZXNzSWRlbnRpdHkub3JpZ2luQWNjZXNzSWRlbnRpdHlOYW1lXG4gICAgICAgIH07XG5cbiAgICAgICAgaWYgKGNsb3VkRnJvbnREaXN0cmlidXRpb25Qcm9wcykge1xuICAgICAgICAgIGNsb3VkRnJvbnREaXN0cmlidXRpb25Qcm9wcy5jdXN0b21IZWFkZXJzID0gdXNlckFnZW50SGVhZGVyO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIGNsb3VkRnJvbnREaXN0cmlidXRpb25Qcm9wcyA9IHtcbiAgICAgICAgICAgIGN1c3RvbUhlYWRlcnM6IHVzZXJBZ2VudEhlYWRlclxuICAgICAgICAgIH07XG4gICAgICAgIH1cbiAgICAgIH1cblxuICAgICAgdGhpcy5tZWRpYVN0b3JlQ29udGFpbmVyID0gZGVmYXVsdHMuTWVkaWFTdG9yZUNvbnRhaW5lcih0aGlzLCBtZWRpYVN0b3JlUHJvcHMpO1xuICAgIH1cblxuICAgIFt0aGlzLmNsb3VkRnJvbnRXZWJEaXN0cmlidXRpb24sIHRoaXMuY2xvdWRGcm9udExvZ2dpbmdCdWNrZXQsIHRoaXMuY2xvdWRGcm9udE9yaWdpblJlcXVlc3RQb2xpY3ksIHRoaXMuY2xvdWRGcm9udEZ1bmN0aW9uXVxuICAgICAgPSBkZWZhdWx0cy5DbG91ZEZyb250RGlzdHJpYnV0aW9uRm9yTWVkaWFTdG9yZShcbiAgICAgICAgdGhpcywgdGhpcy5tZWRpYVN0b3JlQ29udGFpbmVyLFxuICAgICAgICBjbG91ZEZyb250RGlzdHJpYnV0aW9uUHJvcHMsXG4gICAgICAgIHByb3BzLmluc2VydEh0dHBTZWN1cml0eUhlYWRlcnMsXG4gICAgICAgIHByb3BzLmNsb3VkRnJvbnRMb2dnaW5nQnVja2V0UHJvcHNcbiAgICAgICk7XG4gIH1cbn1cbiJdfQ==