/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as cloudfront from '@aws-cdk/aws-cloudfront';
import * as mediastore from '@aws-cdk/aws-mediastore';
import * as s3 from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
/**
 * @summary The properties for the CloudFrontToMediaStore Construct
 */
export interface CloudFrontToMediaStoreProps {
    /**
     * Existing instance of mediastore.CfnContainer obejct.
     *
     * @default - None
     */
    readonly existingMediaStoreContainerObj?: mediastore.CfnContainer;
    /**
     * Optional user provided props to override the default props for the MediaStore.
     *
     * @default - Default props are used
     */
    readonly mediaStoreContainerProps?: mediastore.CfnContainerProps;
    /**
     * Optional user provided props to override the default props for the CloudFront.
     *
     * @default - Default props are used
     */
    readonly cloudFrontDistributionProps?: cloudfront.DistributionProps | any;
    /**
     * Optional user provided props to turn on/off the automatic injection of best practice HTTP security headers in all responses from cloudfront.
     *
     * @default - true
     */
    readonly insertHttpSecurityHeaders?: boolean;
    /**
     * Optional user provided props to override the default props for the CloudFront Logging Bucket.
     *
     * @default - Default props are used
     */
    readonly cloudFrontLoggingBucketProps?: s3.BucketProps;
}
export declare class CloudFrontToMediaStore extends Construct {
    readonly cloudFrontWebDistribution: cloudfront.Distribution;
    readonly mediaStoreContainer: mediastore.CfnContainer;
    readonly cloudFrontLoggingBucket?: s3.Bucket;
    readonly cloudFrontOriginRequestPolicy: cloudfront.OriginRequestPolicy;
    readonly cloudFrontOriginAccessIdentity?: cloudfront.OriginAccessIdentity;
    readonly cloudFrontFunction?: cloudfront.Function;
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of CloudFrontToMediaStore class.
     * @since 1.76.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: CloudFrontToMediaStoreProps);
}
