# Generated by Django 5.2.4 on 2025-07-24 12:40

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Country',
            fields=[
                ('code', models.CharField(help_text='The code used to identify the country.', max_length=2, primary_key=True, serialize=False, verbose_name='code')),
                ('name', models.TextField(help_text='The name of the country.', verbose_name='name')),
                ('place', models.TextField(help_text='The hierarchical name of the country.', verbose_name='place')),
                ('created', models.DateTimeField(auto_now_add=True, help_text='When was the record created.', null=True)),
                ('modified', models.DateTimeField(auto_now=True, help_text='When was the record updated.', null=True)),
            ],
            options={
                'verbose_name': 'country',
                'verbose_name_plural': 'countries',
            },
        ),
        migrations.CreateModel(
            name='County',
            fields=[
                ('code', models.CharField(help_text='The code used to identify the county.', max_length=10, primary_key=True, serialize=False, verbose_name='code')),
                ('name', models.TextField(help_text='The name of the county.', verbose_name='name')),
                ('place', models.TextField(help_text='The hierarchical name of the county.', verbose_name='place')),
                ('created', models.DateTimeField(auto_now_add=True, help_text='When was the record created.', null=True)),
                ('modified', models.DateTimeField(auto_now=True, help_text='When was the record updated.', null=True)),
            ],
            options={
                'verbose_name': 'county',
                'verbose_name_plural': 'counties',
            },
        ),
        migrations.CreateModel(
            name='Observer',
            fields=[
                ('identifier', models.CharField(help_text='The code for the person submitted the checklist.', max_length=15, primary_key=True, serialize=False, verbose_name='identifier')),
                ('name', models.TextField(help_text='The display name of the observer.', verbose_name='name')),
                ('original', models.TextField(help_text='The original name of the observer from eBird.', verbose_name='original name')),
                ('multiple', models.BooleanField(default=False, help_text='Is the name used by more than one eBird account.', verbose_name='Multiple accounts')),
                ('enabled', models.BooleanField(default=True, help_text='Load checklists from the eBird observer.', verbose_name='Enabled')),
                ('data', models.JSONField(blank=True, default=dict, help_text='Data describing an Observer.', verbose_name='Data')),
                ('created', models.DateTimeField(auto_now_add=True, help_text='When was the record created.', null=True)),
                ('modified', models.DateTimeField(auto_now=True, help_text='When was the record updated.', null=True)),
            ],
            options={
                'verbose_name': 'observer',
                'verbose_name_plural': 'observers',
            },
        ),
        migrations.CreateModel(
            name='Species',
            fields=[
                ('taxon_order', models.IntegerField(blank=True, help_text='The position in the eBird/Clements taxonomic order.', null=True, verbose_name='taxonomy order')),
                ('order', models.TextField(blank=True, help_text='The order, e.g. Struthioniformes, from the eBird/Clements taxonomy.', verbose_name='order')),
                ('category', models.TextField(blank=True, choices=[('species', 'Species'), ('slash', 'Species pairs'), ('issf', 'Subspecies'), ('domestic', 'Domestic species'), ('hybrid', 'Hybrids'), ('form', 'Species forms'), ('spuh', 'Unidentified species'), ('intergrade', 'Intergrades')], help_text='The category from the eBird/Clements taxonomy.', verbose_name='category')),
                ('species_code', models.CharField(help_text='The species code, e.g. ostric2, used in the eBird API.', max_length=10, primary_key=True, serialize=False, verbose_name='species code')),
                ('family_code', models.TextField(blank=True, help_text='The family code, e.g. struth1, used in the eBird API.', verbose_name='family code')),
                ('common_name', models.TextField(help_text='The species common name in the eBird/Clements taxonomy.', verbose_name='common name')),
                ('scientific_name', models.TextField(help_text='The species scientific name in the eBird/Clements taxonomy.', verbose_name='scientific name')),
                ('family_common_name', models.TextField(blank=True, help_text='The common name for the species family in the eBird/Clements taxonomy.', verbose_name='family common name')),
                ('family_scientific_name', models.TextField(blank=True, help_text='The scientific name for the species family in the eBird/Clements taxonomy.', verbose_name='family scientific name')),
                ('data', models.JSONField(blank=True, default=dict, help_text='Data describing a Species.', verbose_name='Data')),
                ('created', models.DateTimeField(auto_now_add=True, help_text='When was the record created.', null=True)),
                ('modified', models.DateTimeField(auto_now=True, help_text='When was the record updated.', null=True)),
            ],
            options={
                'verbose_name': 'species',
                'verbose_name_plural': 'species',
            },
        ),
        migrations.CreateModel(
            name='State',
            fields=[
                ('code', models.CharField(help_text='The code used to identify the state.', max_length=6, primary_key=True, serialize=False, verbose_name='code')),
                ('name', models.TextField(help_text='The name of the state.', verbose_name='name')),
                ('place', models.TextField(help_text='The hierarchical name of the state.', verbose_name='place')),
                ('created', models.DateTimeField(auto_now_add=True, help_text='When was the record created.', null=True)),
                ('modified', models.DateTimeField(auto_now=True, help_text='When was the record updated.', null=True)),
            ],
            options={
                'verbose_name': 'state',
                'verbose_name_plural': 'states',
            },
        ),
        migrations.CreateModel(
            name='Location',
            fields=[
                ('identifier', models.CharField(help_text='The unique identifier for the location.', max_length=15, primary_key=True, serialize=False, verbose_name='identifier')),
                ('original', models.TextField(help_text='The original name of the location from eBird.', verbose_name='original name')),
                ('name', models.TextField(help_text='The display name of the location.', verbose_name='name')),
                ('latitude', models.DecimalField(blank=True, decimal_places=7, help_text='The decimal latitude of the location, relative to the equator.', max_digits=9, null=True, verbose_name='latitude')),
                ('longitude', models.DecimalField(blank=True, decimal_places=7, help_text='The decimal longitude of the location, relative to the prime meridian.', max_digits=10, null=True, verbose_name='longitude')),
                ('url', models.URLField(blank=True, help_text='URL of the location page on eBird.', verbose_name='url')),
                ('hotspot', models.BooleanField(blank=True, help_text='Is the location a hotspot.', null=True, verbose_name='is hotspot')),
                ('data', models.JSONField(blank=True, default=dict, help_text='Data describing a Location.', verbose_name='Data')),
                ('created', models.DateTimeField(auto_now_add=True, help_text='When was the record created.', null=True)),
                ('modified', models.DateTimeField(auto_now=True, help_text='When was the record updated.', null=True)),
                ('country', models.ForeignKey(help_text='The country for the location.', on_delete=django.db.models.deletion.PROTECT, related_name='locations', to='data.country', verbose_name='country')),
                ('county', models.ForeignKey(blank=True, help_text='The county for the location.', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='locations', to='data.county', verbose_name='county')),
                ('state', models.ForeignKey(help_text='The state for the location.', on_delete=django.db.models.deletion.PROTECT, related_name='locations', to='data.state', verbose_name='state')),
            ],
            options={
                'verbose_name': 'location',
                'verbose_name_plural': 'locations',
            },
        ),
        migrations.CreateModel(
            name='Checklist',
            fields=[
                ('added', models.DateTimeField(blank=True, help_text='The date and time the checklist was added to eBird.', null=True, verbose_name='added')),
                ('edited', models.DateTimeField(blank=True, help_text='The date and time the eBird checklist was last edited.', null=True, verbose_name='edited')),
                ('published', models.BooleanField(help_text='Is the checklist published?', verbose_name='published')),
                ('identifier', models.CharField(help_text='The unique identifier for the checklist.', max_length=15, primary_key=True, serialize=False, verbose_name='identifier')),
                ('observer_count', models.IntegerField(blank=True, help_text='The total number of observers.', null=True, verbose_name='observer count')),
                ('species_count', models.IntegerField(blank=True, help_text='The number of species reported.', null=True, verbose_name='species count')),
                ('date', models.DateField(db_index=True, help_text='The date the checklist was started.', verbose_name='date')),
                ('time', models.TimeField(blank=True, help_text='The time the checklist was started.', null=True, verbose_name='time')),
                ('started', models.DateTimeField(blank=True, db_index=True, help_text='The date and time the checklist was started.', null=True, verbose_name='date & time')),
                ('protocol_code', models.TextField(blank=True, help_text='The code used to identify the protocol.', verbose_name='protocol code')),
                ('project_code', models.TextField(blank=True, help_text='The code used to identify the project (portal).', verbose_name='project code')),
                ('duration', models.IntegerField(blank=True, help_text='The number of minutes spent counting.', null=True, verbose_name='duration')),
                ('distance', models.DecimalField(blank=True, decimal_places=3, help_text='The distance, in kilometres, covered while travelling.', max_digits=6, null=True, verbose_name='distance')),
                ('area', models.DecimalField(blank=True, decimal_places=3, help_text='The area covered, in hectares.', max_digits=6, null=True, verbose_name='area')),
                ('complete', models.BooleanField(default=False, help_text='All species seen are reported.', verbose_name='complete')),
                ('comments', models.TextField(blank=True, help_text='Any comments about the checklist.', verbose_name='comments')),
                ('url', models.URLField(blank=True, help_text='URL where the original checklist can be viewed.', verbose_name='url')),
                ('data', models.JSONField(blank=True, default=dict, help_text='Data describing a Checklist.', verbose_name='Data')),
                ('created', models.DateTimeField(auto_now_add=True, help_text='When was the record created.', null=True)),
                ('modified', models.DateTimeField(auto_now=True, help_text='When was the record updated.', null=True)),
                ('country', models.ForeignKey(help_text='The country where the checklist was made.', on_delete=django.db.models.deletion.PROTECT, related_name='checklists', to='data.country', verbose_name='country')),
                ('county', models.ForeignKey(blank=True, help_text='The county where the checklist was made.', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='checklists', to='data.county', verbose_name='county')),
                ('location', models.ForeignKey(help_text='The location where checklist was made.', on_delete=django.db.models.deletion.PROTECT, related_name='checklists', to='data.location', verbose_name='location')),
                ('observer', models.ForeignKey(help_text='The person who submitted the checklist.', on_delete=django.db.models.deletion.PROTECT, related_name='checklists', to='data.observer', verbose_name='observer')),
                ('state', models.ForeignKey(help_text='The state where the checklist was made.', on_delete=django.db.models.deletion.PROTECT, related_name='checklists', to='data.state', verbose_name='state')),
            ],
            options={
                'verbose_name': 'checklist',
                'verbose_name_plural': 'checklists',
            },
        ),
        migrations.CreateModel(
            name='Filter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('enabled', models.BooleanField(help_text='Is the filter active?', verbose_name='enabled')),
                ('name', models.TextField(help_text='The name of the filter.', verbose_name='name')),
                ('created', models.DateTimeField(auto_now_add=True, help_text='When was the record created.', null=True)),
                ('modified', models.DateTimeField(auto_now=True, help_text='When was the record updated.', null=True)),
                ('location', models.ForeignKey(blank=True, help_text='The location used to find matching Observations.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='filtered_on', to='data.location', verbose_name='location')),
                ('species', models.ForeignKey(help_text='The species used to find matching Observations.', on_delete=django.db.models.deletion.CASCADE, related_name='filtered_on', to='data.species', verbose_name='species')),
                ('update_species', models.ForeignKey(help_text='Matching Observations are updated to this species.', on_delete=django.db.models.deletion.CASCADE, related_name='filtered_by', to='data.species', verbose_name='update species')),
            ],
            options={
                'verbose_name': 'filter',
                'verbose_name_plural': 'filters',
            },
        ),
        migrations.CreateModel(
            name='Observation',
            fields=[
                ('edited', models.DateTimeField(blank=True, help_text='The date and time the eBird checklist was last edited.', null=True, verbose_name='edited')),
                ('published', models.BooleanField(help_text='Is the observation published?', verbose_name='published')),
                ('identifier', models.CharField(help_text='A global unique identifier for the observation.', max_length=15, primary_key=True, serialize=False, verbose_name='identifier')),
                ('date', models.DateField(db_index=True, help_text='The date the observation was made.', verbose_name='date')),
                ('time', models.TimeField(blank=True, help_text='The time the observation was made.', null=True, verbose_name='time')),
                ('started', models.DateTimeField(blank=True, db_index=True, help_text='The date and time the observation was made.', null=True, verbose_name='date & time')),
                ('count', models.IntegerField(help_text='The number of birds seen.', validators=[django.core.validators.MinValueValidator(0)], verbose_name='count')),
                ('audio', models.BooleanField(default=False, help_text='Have audio recordings been uploaded to the Macaulay library.', verbose_name='has audio')),
                ('photo', models.BooleanField(default=False, help_text='Have photos been uploaded to the Macaulay library.', verbose_name='has photos')),
                ('video', models.BooleanField(default=False, help_text='Have video recordings been uploaded to the Macaulay library.', verbose_name='has video')),
                ('approved', models.BooleanField(default=True, help_text='Has the observation been accepted.', verbose_name='Approved')),
                ('reason', models.TextField(blank=True, help_text='The reason given for the observation to be marked as not approved.', verbose_name='Reason')),
                ('comments', models.TextField(blank=True, help_text='Any comments about the observation.', verbose_name='comments')),
                ('urn', models.TextField(blank=True, help_text='The globally unique identifier for the observation.', verbose_name='URN')),
                ('data', models.JSONField(blank=True, default=dict, help_text='Data describing an Observation.', verbose_name='Data')),
                ('created', models.DateTimeField(auto_now_add=True, help_text='When was the record created.', null=True)),
                ('modified', models.DateTimeField(auto_now=True, help_text='When was the record updated.', null=True)),
                ('checklist', models.ForeignKey(help_text='The checklist this observation belongs to.', on_delete=django.db.models.deletion.CASCADE, related_name='observations', to='data.checklist', verbose_name='checklist')),
                ('country', models.ForeignKey(help_text='The country where the observation was made.', on_delete=django.db.models.deletion.PROTECT, related_name='observations', to='data.country', verbose_name='country')),
                ('county', models.ForeignKey(blank=True, help_text='The county where the observation was made.', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='observations', to='data.county', verbose_name='county')),
                ('location', models.ForeignKey(help_text='The location where the observation was made.', on_delete=django.db.models.deletion.PROTECT, related_name='observations', to='data.location', verbose_name='location')),
                ('observer', models.ForeignKey(help_text='The person who made the observation.', on_delete=django.db.models.deletion.PROTECT, related_name='observations', to='data.observer', verbose_name='observer')),
                ('species', models.ForeignKey(help_text='The identified species.', on_delete=django.db.models.deletion.PROTECT, related_name='observations', to='data.species', verbose_name='species')),
                ('state', models.ForeignKey(help_text='The state where the observation was made.', on_delete=django.db.models.deletion.PROTECT, related_name='observations', to='data.state', verbose_name='state')),
            ],
            options={
                'verbose_name': 'observation',
                'verbose_name_plural': 'observations',
            },
        ),
    ]
