"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.  # noqa: E501

    The version of the OpenAPI document: 2023-01-24
    Contact: developers@klaviyo.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from openapi_client.api_client import ApiClient, Endpoint as _Endpoint
from openapi_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from openapi_client.model.event_create_query import EventCreateQuery
from openapi_client.model.get_catalog_items4_xx_response import GetCatalogItems4XXResponse


class EventsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_event_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/events/',
                'operation_id': 'create_event',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_create_query',
                ],
                'required': [
                    'event_create_query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_create_query':
                        (EventCreateQuery,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'event_create_query': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_event_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/events/{id}/',
                'operation_id': 'get_event',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'fields_event',
                    'fields_metric',
                    'fields_profile',
                    'include',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_event',
                    'fields_metric',
                    'fields_profile',
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_event',): {

                        "METRIC_ID": "metric_id",
                        "PROFILE_ID": "profile_id",
                        "TIMESTAMP": "timestamp",
                        "EVENT_PROPERTIES": "event_properties",
                        "DATETIME": "datetime",
                        "UUID": "uuid"
                    },
                    ('fields_metric',): {

                        "NAME": "name",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "INTEGRATION": "integration"
                    },
                    ('fields_profile',): {

                        "EMAIL": "email",
                        "PHONE_NUMBER": "phone_number",
                        "EXTERNAL_ID": "external_id",
                        "ANONYMOUS_ID": "anonymous_id",
                        "FIRST_NAME": "first_name",
                        "LAST_NAME": "last_name",
                        "ORGANIZATION": "organization",
                        "TITLE": "title",
                        "IMAGE": "image",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "LAST_EVENT_DATE": "last_event_date",
                        "LOCATION": "location",
                        "LOCATION.ADDRESS1": "location.address1",
                        "LOCATION.ADDRESS2": "location.address2",
                        "LOCATION.CITY": "location.city",
                        "LOCATION.COUNTRY": "location.country",
                        "LOCATION.LATITUDE": "location.latitude",
                        "LOCATION.LONGITUDE": "location.longitude",
                        "LOCATION.REGION": "location.region",
                        "LOCATION.ZIP": "location.zip",
                        "LOCATION.TIMEZONE": "location.timezone",
                        "PROPERTIES": "properties"
                    },
                    ('include',): {

                        "METRICS": "metrics",
                        "PROFILES": "profiles"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'fields_event':
                        ([str],),
                    'fields_metric':
                        ([str],),
                    'fields_profile':
                        ([str],),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'fields_event': 'fields[event]',
                    'fields_metric': 'fields[metric]',
                    'fields_profile': 'fields[profile]',
                    'include': 'include',
                },
                'location_map': {
                    'id': 'path',
                    'fields_event': 'query',
                    'fields_metric': 'query',
                    'fields_profile': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'fields_event': 'csv',
                    'fields_metric': 'csv',
                    'fields_profile': 'csv',
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_event_metrics_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/events/{id}/metrics/',
                'operation_id': 'get_event_metrics',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'fields_metric',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_metric',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_metric',): {

                        "NAME": "name",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "INTEGRATION": "integration"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'fields_metric':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'fields_metric': 'fields[metric]',
                },
                'location_map': {
                    'id': 'path',
                    'fields_metric': 'query',
                },
                'collection_format_map': {
                    'fields_metric': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_event_profiles_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/events/{id}/profiles/',
                'operation_id': 'get_event_profiles',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'fields_profile',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_profile',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_profile',): {

                        "EMAIL": "email",
                        "PHONE_NUMBER": "phone_number",
                        "EXTERNAL_ID": "external_id",
                        "ANONYMOUS_ID": "anonymous_id",
                        "FIRST_NAME": "first_name",
                        "LAST_NAME": "last_name",
                        "ORGANIZATION": "organization",
                        "TITLE": "title",
                        "IMAGE": "image",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "LAST_EVENT_DATE": "last_event_date",
                        "LOCATION": "location",
                        "LOCATION.ADDRESS1": "location.address1",
                        "LOCATION.ADDRESS2": "location.address2",
                        "LOCATION.CITY": "location.city",
                        "LOCATION.COUNTRY": "location.country",
                        "LOCATION.LATITUDE": "location.latitude",
                        "LOCATION.LONGITUDE": "location.longitude",
                        "LOCATION.REGION": "location.region",
                        "LOCATION.ZIP": "location.zip",
                        "LOCATION.TIMEZONE": "location.timezone",
                        "PROPERTIES": "properties"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'fields_profile':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'fields_profile': 'fields[profile]',
                },
                'location_map': {
                    'id': 'path',
                    'fields_profile': 'query',
                },
                'collection_format_map': {
                    'fields_profile': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_event_relationships_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/events/{id}/relationships/{related_resource}/',
                'operation_id': 'get_event_relationships',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'related_resource',
                ],
                'required': [
                    'id',
                    'related_resource',
                ],
                'nullable': [
                ],
                'enum': [
                    'related_resource',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('related_resource',): {

                        "METRICS": "metrics",
                        "PROFILES": "profiles"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'related_resource':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'related_resource': 'related_resource',
                },
                'location_map': {
                    'id': 'path',
                    'related_resource': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_events_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/events/',
                'operation_id': 'get_events',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'fields_event',
                    'fields_metric',
                    'fields_profile',
                    'filter',
                    'include',
                    'page_cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'fields_event',
                    'fields_metric',
                    'fields_profile',
                    'include',
                    'sort',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_event',): {

                        "METRIC_ID": "metric_id",
                        "PROFILE_ID": "profile_id",
                        "TIMESTAMP": "timestamp",
                        "EVENT_PROPERTIES": "event_properties",
                        "DATETIME": "datetime",
                        "UUID": "uuid"
                    },
                    ('fields_metric',): {

                        "NAME": "name",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "INTEGRATION": "integration"
                    },
                    ('fields_profile',): {

                        "EMAIL": "email",
                        "PHONE_NUMBER": "phone_number",
                        "EXTERNAL_ID": "external_id",
                        "ANONYMOUS_ID": "anonymous_id",
                        "FIRST_NAME": "first_name",
                        "LAST_NAME": "last_name",
                        "ORGANIZATION": "organization",
                        "TITLE": "title",
                        "IMAGE": "image",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "LAST_EVENT_DATE": "last_event_date",
                        "LOCATION": "location",
                        "LOCATION.ADDRESS1": "location.address1",
                        "LOCATION.ADDRESS2": "location.address2",
                        "LOCATION.CITY": "location.city",
                        "LOCATION.COUNTRY": "location.country",
                        "LOCATION.LATITUDE": "location.latitude",
                        "LOCATION.LONGITUDE": "location.longitude",
                        "LOCATION.REGION": "location.region",
                        "LOCATION.ZIP": "location.zip",
                        "LOCATION.TIMEZONE": "location.timezone",
                        "PROPERTIES": "properties"
                    },
                    ('include',): {

                        "METRICS": "metrics",
                        "PROFILES": "profiles"
                    },
                    ('sort',): {

                        "DATETIME": "datetime",
                        "-DATETIME": "-datetime",
                        "TIMESTAMP": "timestamp",
                        "-TIMESTAMP": "-timestamp"
                    },
                },
                'openapi_types': {
                    'fields_event':
                        ([str],),
                    'fields_metric':
                        ([str],),
                    'fields_profile':
                        ([str],),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page_cursor':
                        (str,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'fields_event': 'fields[event]',
                    'fields_metric': 'fields[metric]',
                    'fields_profile': 'fields[profile]',
                    'filter': 'filter',
                    'include': 'include',
                    'page_cursor': 'page[cursor]',
                    'sort': 'sort',
                },
                'location_map': {
                    'fields_event': 'query',
                    'fields_metric': 'query',
                    'fields_profile': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page_cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'fields_event': 'csv',
                    'fields_metric': 'csv',
                    'fields_profile': 'csv',
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def create_event(
        self,
        event_create_query,
        **kwargs
    ):
        """Create Event  # noqa: E501

        Create an event. Events are created asynchronously. Successful response indicates that the event was validated and submitted for processing, but does not guarantee that processing is complete.<br><br>*Rate limits*:<br>Burst: `350/s`<br>Steady: `3500/m`  **Scopes:** `Events Write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_event(event_create_query, async_req=True)
        >>> result = thread.get()

        Args:
            event_create_query (EventCreateQuery): Event to create.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['event_create_query'] = \
            event_create_query
        return self.create_event_endpoint.call_with_http_info(**kwargs)

    def get_event(
        self,
        id,
        **kwargs
    ):
        """Get Event  # noqa: E501

        Get an event with the given event ID. Include parameters can be provided to get the following related resource data: `metrics`, `profiles`<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `Events Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_event(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the event

        Keyword Args:
            fields_event ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-01-24/reference/api-overview#sparse-fieldsets. [optional]
            fields_metric ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-01-24/reference/api-overview#sparse-fieldsets. [optional]
            fields_profile ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-01-24/reference/api-overview#sparse-fieldsets. [optional]
            include ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-01-24/reference/api-overview#relationships. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_event_endpoint.call_with_http_info(**kwargs)

    def get_event_metrics(
        self,
        id,
        **kwargs
    ):
        """Get Event Metrics  # noqa: E501

        Get the metric for an event with the given event ID.<br><br>*Rate limits*:<br>Burst: `350/s`<br>Steady: `3500/m`  **Scopes:** `Events Read` `Metrics Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_event_metrics(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the event

        Keyword Args:
            fields_metric ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-01-24/reference/api-overview#sparse-fieldsets. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_event_metrics_endpoint.call_with_http_info(**kwargs)

    def get_event_profiles(
        self,
        id,
        **kwargs
    ):
        """Get Event Profiles  # noqa: E501

        Get the profile associated with an event with the given event ID.<br><br>*Rate limits*:<br>Burst: `350/s`<br>Steady: `3500/m`  **Scopes:** `Events Read` `Profiles Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_event_profiles(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the event

        Keyword Args:
            fields_profile ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-01-24/reference/api-overview#sparse-fieldsets. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_event_profiles_endpoint.call_with_http_info(**kwargs)

    def get_event_relationships(
        self,
        id,
        related_resource,
        **kwargs
    ):
        """Get Event Relationships  # noqa: E501

        Get metrics or profile [relationships](https://developers.klaviyo.com/en/reference/api_overview#relationships) for an event with the given event ID.<br><br>*Rate limits*:<br>Burst: `350/s`<br>Steady: `3500/m`  **Scopes:** `Events Read` `Metrics Read` `Profiles Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_event_relationships(id, related_resource, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): 
            related_resource (str): 

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['related_resource'] = \
            related_resource
        return self.get_event_relationships_endpoint.call_with_http_info(**kwargs)

    def get_events(
        self,
        **kwargs
    ):
        """Get Events  # noqa: E501

        Get all events in an account Requests can be sorted by the following fields: `datetime`, `timestamp` Include parameters can be provided to get the following related resource data: `metrics`, `profiles` Returns a maximum of 200 events per page.<br><br>*Rate limits*:<br>Burst: `350/s`<br>Steady: `3500/m`  **Scopes:** `Events Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_events(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            fields_event ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-01-24/reference/api-overview#sparse-fieldsets. [optional]
            fields_metric ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-01-24/reference/api-overview#sparse-fieldsets. [optional]
            fields_profile ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-01-24/reference/api-overview#sparse-fieldsets. [optional]
            filter (str): For more information please visit https://developers.klaviyo.com/en/v2023-01-24/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`metric_id`: `equals`<br>`datetime`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`timestamp`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`. [optional]
            include ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-01-24/reference/api-overview#relationships. [optional]
            page_cursor (str): For more information please visit https://developers.klaviyo.com/en/v2023-01-24/reference/api-overview#pagination. [optional]
            sort (str): For more information please visit https://developers.klaviyo.com/en/v2023-01-24/reference/api-overview#sorting. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_events_endpoint.call_with_http_info(**kwargs)

