# ----------------------------------------------------------------------------
# Description: общие элементы
# Project : iQLib (for iQMemo, iQNote, iQUtils)
#           https://gitflic.ru/project/nikodim/iqlib
# Date    : 17.09.2022
# Version : v 1.0.0
# Author  : KhAN (Alexander Khilchenko)
#           khan.programming@mail.ru, https://gitflic.ru/user/nikodim
# ----------------------------------------------------------------------------

import base64
from PyQt5.QtGui import QPixmap, QIcon

""" глифы для интерфейса"""
images = {
    'отмена форматирования':'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QA/wD/AP+gvaeTAAAAoElEQVRYw2PwySxkGEjMMOqAQeeAWy7Bq267hDhQ2yKQmSCzCTrgpkuoDVDhyxtugU7UshyfmSRroKbleNMANRxBjBkUG0CpXqoZRK4eqhtIqoOpGqTkhBbV4pXc9EKVlE1JYqU4e1GaXSktWl+CMCVF99B0wIBGwYAmwgHNhgNaEA1oUTygldGAVscD2iAZ0CbZgDdKB7xZPtozGnEOAABTrQBwyl5iMAAAACV0RVh0ZGF0ZTpjcmVhdGUAMjAxNS0xMS0yNlQxNToyMzoxMCswMDowMPsJugsAAAAldEVYdGRhdGU6bW9kaWZ5ADIwMTUtMTEtMjZUMTU6MTY6NTYrMDA6MDASBZQyAAAAAElFTkSuQmCC',
    'отменить':'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QA/wD/AP+gvaeTAAABO0lEQVRYw+2XsUoDQRCGg6CNIpgHkCuTp1CbO46d73eRrLWNJ4qNb5A2+hgGX0IDkpcwGIPPILHX5gqxiKdebpsU0y07H//M/jPbsvOrVsxorQCqHvTeJ977JAqA9z4BXoGTxgGAXWAm6bLxEiw7+UKAJpL/BPAIfFSId2AC3AHHIYSNWgC+NN7FogvSNN0EOmZ2amb3wIuko1p6oCrEN+X2gGfgpt/vr/37FfwFwjm3I2ks6TqaD2RZ1i6V8PGc0GwfmC5qzKV7PfAgKUQDkFRIGsZUoANMogGEELaAeTSAPM+3gbdoAM65btQSAGfAbUyAkZn1ogCUc2EWxYhKK54Ch41vxVmWtSWNzWzQ+Fou6QCYmtmglnFcxWicc11JBTCqInttAOVKNgeeJA3NrFcUxfrqa7YC+E18AoC1tMYe4qNFAAAAJXRFWHRkYXRlOmNyZWF0ZQAyMDE1LTExLTI2VDE1OjIzOjEwKzAwOjAw+wm6CwAAACV0RVh0ZGF0ZTptb2RpZnkAMjAxNS0xMS0yNlQxNToxNjo1NiswMDowMBIFlDIAAAAASUVORK5CYII=',
    'повторить': 'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QA/wD/AP+gvaeTAAABeElEQVRYw2PwySxkGEjMMOoAahvo4ODAAcID5gBfX98SIN5OrCOo7oDQ0FBmoAMWA/FOIJtzQNIAKY6gWeIi1hEkGxwUFCTp5+eX5uPjMwto+GYgvRsXBsrvA+J/QLyBYgcEBAQoQH30FuiAJSBHANk+/v7+Lrgw0BE1QDXfgWo9KHIA0AA/oEEvgVStm5sbN5G5wQKqx4OiNAA0IAKIHwOxCQlZkSjLCTrAy8vLAGQQMDh1aWE5QQcADToANCiJlETq7e3tTqzleB0AtNweiK+AstPA1AU+PpOBDigfsMoIaPklYFAaDqQD3rq7uwsNpAO+k1Kt0sIBD0Cl34A5ABj/O4AJMXAgQyAL6IiFA+kAESB+BSxYlAasTQgMgUpQ84qWhRGhBiYLtF6fyMDAwDggrWJgFAgCHXAEGBqraVEuENu8YgOGxARYmwBYS6oNSL8AZDHQAVNA7QOgY14A8Vlw84veHRNQegC1DYHRYwxueo12zYayAwDdTK4CKWPs3wAAACV0RVh0ZGF0ZTpjcmVhdGUAMjAxNS0xMS0yNlQxNToyMzoxMCswMDowMPsJugsAAAAldEVYdGRhdGU6bW9kaWZ5ADIwMTUtMTEtMjZUMTU6MTY6NTYrMDA6MDASBZQyAAAAAElFTkSuQmCCiVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QA/wD/AP+gvaeTAAABeElEQVRYw2PwySxkGEjMMOoAahvo4ODAAcID5gBfX98SIN5OrCOo7oDQ0FBmoAMWA/FOIJtzQNIAKY6gWeIi1hEkGxwUFCTp5+eX5uPjMwto+GYgvRsXBsrvA+J/QLyBYgcEBAQoQH30FuiAJSBHANk+/v7+Lrgw0BE1QDXfgWo9KHIA0AA/oEEvgVStm5sbN5G5wQKqx4OiNAA0IAKIHwOxCQlZkSjLCTrAy8vLAGQQMDh1aWE5QQcADToANCiJlETq7e3tTqzleB0AtNweiK+AstPA1AU+PpOBDigfsMoIaPklYFAaDqQD3rq7uwsNpAO+k1Kt0sIBD0Cl34A5ABj/O4AJMXAgQyAL6IiFA+kAESB+BSxYlAasTQgMgUpQ84qWhRGhBiYLtF6fyMDAwDggrWJgFAgCHXAEGBqraVEuENu8YgOGxARYmwBYS6oNSL8AZDHQAVNA7QOgY14A8Vlw84veHRNQegC1DYHRYwxueo12zYayAwDdTK4CKWPs3wAAACV0RVh0ZGF0ZTpjcmVhdGUAMjAxNS0xMS0yNlQxNToyMzoxMCswMDowMPsJugsAAAAldEVYdGRhdGU6bW9kaWZ5ADIwMTUtMTEtMjZUMTU6MTY6NTYrMDA6MDASBZQyAAAAAElFTkSuQmCC',
    'вставить': 'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QA/wD/AP+gvaeTAAAAY0lEQVRYw2PwySxkGEjMMOqAIeMAX1/f/6Tgoe8AUi0k10F4HYCNTUqIEaOfJANI8S1NHDCgIUBJvFPsAErxqAOo4gBK8v1oFIysNDAaBSM3DYxGwagDaOKAAW2UjvaMRowDAHMWE0xLzzWvAAAAJXRFWHRkYXRlOmNyZWF0ZQAyMDE1LTExLTI2VDE1OjIzOjEwKzAwOjAw+wm6CwAAACV0RVh0ZGF0ZTptb2RpZnkAMjAxNS0xMS0yNlQxNToxNjo1NiswMDowMBIFlDIAAAAASUVORK5CYII=',
    'специальная вставка': '',
    'вставить с форматированием': 'iVBORw0KGgoAAAANSUhEUgAAABsAAAAcCAYAAACQ0cTtAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAATOQAAEzkBj8JWAQAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAIxSURBVEiJtdRPiE1xFMDxzzTIIH+jyJ9JiZUmjA2SjRGKFalZsFAk/xaMUCPZjY2lpETMgiIkK8n4t1HK/ygZRCR/wkxkjsW9Y+487817w3unft37O+ee8z3nd3/nUJpswaESv/1vuY8vGF5p0EJEujZWGnYqA3uAqkqBxqJTcozdwEWVgjXhERZkYGcqAarCU2xL9/dS2E9MKjdsCTowOt1v1lPdgXLDzuJ4Zj8CX1PYOwwuF2g8fmBejv6onuoaywXbh4f+vuZzM7Bb5QANwEvJiMondzLAOf0NnCvLMUFS2ew89quYlb5vwrr+AHPlsp7Mi61OjPtX0FT8QgNG9bHOZYA7/xXWImnkYvNvcQb2HNXBsuBYcDtoDQb1FWAIPmBvCUlV4QliBvGex8GVYHtwI4hgfl8BNqaZTikBBrtXEa+IDckoIwlwOOgKags51kiu++sSQdpobiem9xxnfTA5+B69J08vGYkTqcN31BcDfaaxg0/Tet/Mu+20pMdZk8+vCq2oztE/xZ58DhdpWMSFNbSdT/7xH5lGzQBaHnGtWMJFJagJngW7/jtYCbD9wfNgYB5bbSQDvJDvsP6ARgffguY8tolpxavzQYLm4GZ/YDvS/lmbo18WvEltYzL6IcHW4H6wpViT58IupgGvB3XBiuBS8DY4l9rWB0uCg0F7+hxZMiQD654M3asrOBmMC05n9B8jaYGC/68U2NK0ihfBkWBmxlYXNAUrg6GFYvwGzD7t1yqzDjkAAAAASUVORK5CYII=',
    'копировать': 'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QA/wD/AP+gvaeTAAAAbUlEQVRYw+3XsQ3AIAxEUQ9oD0KZCTJ6MgEETiam+MXV90CWMObtssoYgCMBEfGoSQMopwHwCyB7PiRA5u0AAAAAAIBUQPlbMCx3v8sAvXJ5JVsBjMqlpXQF8FW+FTBTvg0wWy4DlGnnZwSglxc3m/toFgX2KQAAACV0RVh0ZGF0ZTpjcmVhdGUAMjAxNS0xMS0yNlQxNToyMzoxMCswMDowMPsJugsAAAAldEVYdGRhdGU6bW9kaWZ5ADIwMTUtMTEtMjZUMTU6MTY6NTYrMDA6MDASBZQyAAAAAElFTkSuQmCC',
    'вырезать': 'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QA/wD/AP+gvaeTAAAB5klEQVRYw2PwySxkGEjMMOqAIeEAX19fDT8gINZQoFJvIFanmgO8vb11gI644+npyU5IbWhoKBvQ8pv+/v661I0CH5/dQIMrifB9GdCxe6ieBoAGmwAN/gLEcnjUiAPlPwCxBU0SIdCC1UDDF+NJKwuAatbRLBd4eXmpAS35BUwTtljSiTFQ7jcwqvRpmg2BlswB4nPAxMYME2toaGACip0A+n4h7csBHx9poGXfgDgFSSwRGjJKdCmIgJb1APHLgIAAAaCveYHsZ0B6Ct1KwsDAQGFoau8D4m5QiIBChq5FMdDHtaBgB+KfQNxO97oAaKkpEP+HYje6OwBaJuRC8T76OgCY14GW/gPi41D8H+ggR7o5AGjheqTg3wSlD9PFAUCLjKC+vwKqdqFiK8lNC+Q4YDMQ/0WucIBFtAQ0W55mYGBgpJoDgAb6APEpaC14DoiroT6dgUVtIVSuGxgy56F6TsFCiWQHQC1/AExwzm5ubtzABoYLkP8QiF+5u7sLoat3cHBgAcpdwqLnAT5H4HPAaZBBaFnPFWQJHj2XcOg5SY4DPgFrPB40w0Dl/lc8er7i0POJrBAABSEpviFHD8E0ADIA5CtQFgOlAWAQe1FTD8HmNcj1QPwZ7As8BpGrZ7RnNOoAALc/yd8HGg1vAAAAJXRFWHRkYXRlOmNyZWF0ZQAyMDE1LTExLTI2VDE1OjIzOjEwKzAwOjAw+wm6CwAAACV0RVh0ZGF0ZTptb2RpZnkAMjAxNS0xMS0yNlQxNToxNjo1NiswMDowMBIFlDIAAAAASUVORK5CYII=',
    'жирно': 'iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAYAAABw4pVUAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAXEgAAFxIBZ5/SUgAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAARKSURBVHic7dxLqFVVGAfwn4/KR2kvJAt6aE8CKZIiFUKsKMJ5QaNoENHURtE0qEHQrKAyIotoUiANAqlBSUQWNJAKK7S8imXmK69mt8G6By7SUc86a5+1z93fDzb3AWuv7+z/2XufvfY6mxBCCCGEEEIIIYQQQgghhBBCCCGEMTCnofXeh2UNrftcTuBvHMUp/Inj2FepnoE0Fcg2rG9o3bmOYRd+mv75lVTngZpFjco2TI3Bcho78CLuaGRLtMS4BHLm8gUebGB7VPcW9krH89obOWf5EMuLb5Xz0NQ5ZKbFuByXYQ1ewsUZ63lZOu6fxF/T/5uHJViI63ErbsMqzB2maExgI74ecj2tt0reu3bDAH0swxPSIWiYPeUgbs99oeNiqeYDmWkjfsnscwo7pT1w1hp1IKTzwY7Mfqfw3BB9t16NQOAq/JHZ9wFcMGT/52XYE9842YdNmW2vNKIL3S4FAltwOLPtmpKF9NO1QE7gk8y2t5QspJ+uBQI/Zra7tGgVfXQxkNxR38miVfTRxUDmZbbbW7SKProYSO59mh+KVtFHFwO5JrPdR0Wr6KNrgcyVd4G5Xbqx1biuBXKPwYfVp+RfUA6sa4HkbNjX8HnpQtqk1ljWYxl9bjWiMayaagTyiDQTZZD+3pNurs16owzkCulO4z8D9HMMT2e9sjHVdCBzsBov4NAA6z+FV3H1kK9vKPNrdj6g5VghTXqbhwXS+NJCXCfdT78Zaw12rfGrNCnjDSP6aNs2uXtIqWXmXKwNWvZJcxSzTs60VDqU1PKzNAxyUJpmOoFvpJAmKtZVTe095GzLb9ishXtOk9ocyMxlD57HJc1shv83ToesHdI7+MT034el88G/038vxCJpUt4N0sS5Eu/y/XgGHxRYVyuN6jpkgTSBepM09HE6s9/e8or8eymtVmvoZCXelfao3FA2q3NUaVStQHrWSfOsckN5tlAdrVE7ENIMkj2ZdUzipoK1VNeGQOB++YevdwrXUlVbAoG3M2uZlD7NFdeZi58+3sxsdyEeKFlIT9cD+Qy/Z7a9q2QhPV0P5LT86T0rShbS0/VAyJ/JuKRoFdMiEI5ktjtZtIppEUj+TMZGbiFEIOmbVTlyZ9GfVdcDmY8bM9t+W7KQnq4Hsk7e/Y5J6WkVxXU9kKcy222V/2GgddoydLJW/ljWvYVrqaoNgVyL3Zl1bClYRyvUDmS1/Cc77FbvwWyNqRXICrwuXdDl9H8Idw5ZwznVmLl49wj7WomHZiy5r3c/HpbmbzVqFIHMfDzTeunxTDkelUZYD0kn494jmhbhImnPWyyF0FtKHF4+xePSjJexNe4PMJuSZjE+aZZcGozrI/6m8L30dYQq3w0Zp9nvTdqJj/E+vqxZSNcCOS5Ntt6F76TxqO1adH6YjQ9SJn0L6rg0vHFk+vej6s66DyGEEEIIIYQQQgghhBBCCCGEEEKYPf4DrMjBmwH7Gw4AAAAASUVORK5CYII=',
    'курсив': 'iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAYAAABw4pVUAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAXEgAAFxIBZ5/SUgAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAALTSURBVHic7dy/ThVBFMfxryJgSPwvxqiFNDQaCxNDjKDRh/At7HwBH8PXsLLRGMGoDY0mxgIo1JgoipgQkShYDNcCzcxw2bkzZ+b3STY0y+7v3pN7zu7dvQsiIiIiIiIiIiIiIiIiIiIiBuzLHWCXbgInE+/jCfA58T6q8RTYSrxcH9ir+Y/9OXcu/7JWkG/AeqJtbwErCbcfxdoM6TkIHAOObi/jwH3gdMT/rgB3gQVcgXvLapKkDbtBeD58ACZyBYxhrWX5HIpY5yGwlDrIXtRUkGsR6zxLnkL+miXcsiazpWvMKPADfzE+YeAgppaWdQV35OXT+wQVrZaCTEesY2J+1FKQmIE+lzyFAG4ufME/P9aAkVwBW3OR8NHVo2zpdqmGlhUzP8y0qxoKohPCwizhb1e/gCPZ0jXmDOH5MZ8tXR+st6yZiHXMzA+wXxDNj8LME25Z57Kla8xh3MD2FWMxW7o+WW5ZV4GhwDqm5gfYLojmR2EeE54fF7Kla8ww7gtDXzG+YrADmAu87TIwFlhnDtgcQJZOWS1ItfNDBZFOfMQ/P9YJX2OXjkwSPrqazZZujyy2rKouSO1ksSCaH4V5i79dbQLHs6VrzDjuDfcV5FW2dB2w1rJmCN8OanZ+gL2CaH4U5iXhQ97zucK1Zgz4ib8Y77Ol64illjVF+HZQ0/MDbBWkmjvcfSwVRHe4F2QI99Nl3/xYJXyNvXhWPiGXCN8O+hz4PYAsSVkpSBPzA+wURPOjMO/wz48NwtfYpSMThM/OX2RL1zELLavqC1I7WSiIvlAszGvCF6ROZUvXmFu4cwtfQdaAs7kCdq2UZ3+MACdwD7js/Z0G7hDXVheBe8Ay7jfry7gHWX5PEbZmU7g3LXQU1e+yATwY2KvpQO6hPkrcg8f6NYx7BKAZuQsiOxzIvP83wO3E+1hOvH0RERERERERERERERERERGR9vwBLIQqyoiEmHgAAAAASUVORK5CYII=',
    'подчеркнуто':  'iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAYAAABw4pVUAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAXEgAAFxIBZ5/SUgAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAOWSURBVHic7dw5aBRRHMfxbxKNBo+oeERREUWMiOJZWHigpSDY2FgIXtiKltZaaKGFqGAjWAgRQSFaiIKIR2GhYgwogqgQ8QjxSGI8shYvopKdzdud92b+G38fGEIms+/9Z387eW922QciIiIiIiIiIiIiIiIiIiIiVaAmQBt7gV0B2inlInAoYHvTgNaA7f12BjiVpoERAYqYDqwI0E4p9wO3V0+cmlOHXBuiCgmnLkAbY4CfQAfQDfQDo1O03T3Q1jPgEXAPuAY8Tl3pHzW4K/vjwO9jqfzF+R5oB+4CV4CnqauLZCXuCS14bN+Bw8C4XCp1L57ZwBqgJaHG31sHsBVYhHsxVpVRQBdDB7IvrwKLqAH2U7zOh8DMmJ3HHkP6gB8ex3VHrqMcBeB4wt8uA69jdq5B3RgFYowCMUaBGKNAjFEgxigQYxSIMQrEGAVijAIxRoEYo0CMUSDGKBBjFIgxCsQYBWKMAjFGgRijQIxRIMYoEGMUiDEKxBgFYowCMUaBGKNAjMkikILHMda+Z5FbPVkE8s3jmMboVZRnUsL+r7E7ziIQn5OYEL2K8iTV0xu74ywC8TmJagnkv7lC5kWvojzzE/YPiyvkvccxi7E141uasN/nXFLJ4kl45XFMI/EXHyjHhoT9L2N3nEUg7Z7HbY5ahb9mYEGR/T8w/B30cqzF77vqrwiz1EdaRyle34M8iwppJNCJXyixF7EZylTgE8VrO5xjXcGdxS+QDmBKTjUCnEuoq4CtMS61Zbg1UHxCuYq7qrK2u0RNN3OoJ7qh1hD5ezuPW5YjK9twg3axWvqBdRnWkpkm3DzeN5Q7JN+ghdKAG8RLXb0nI9eQq/W4O3ffUHqBI8CMwHXUAzuA50P0fxu31NSwtgX3RPuGUsC9Y9wK7KTyq6YR2AScAN569HkfmFxhXxULseZiJVbj1lFsqvDxnbgbzhfAZ9xCZF24KWsDMP6vrQl3szcH/xvhC8B2oKfC+qrSBOA0/rOvLLYPwJ6YJ10NVgGXyDeYd8BB7H0MkKuFuLvhl2QTwk/gOu5fk5mPkPMaQ0qpBZYDG3Hvuq4CJgZotx83q7oF3MCF8SZAu0FZDKSYWcASYC5uCjwDtxhyHf+G1YcbiHtwS/G9Gfj5BGgDvmRXsojIsJd2DDmAu/uVwY7hpvNlSfsJXTPu/SkZrKWSB6UN5CZuPi+DteVdgIiIiIiIiIiIiIiIAPALngFteBNWQdwAAAAASUVORK5CYII=',
    'по левому краю': 'iVBORw0KGgoAAAANSUhEUgAAABgAAAAVCAYAAABc6S4mAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAASJgAAEiYBF62JUgAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAACESURBVDiN3dUxCgJBDIXhLzAX0CNoY794A4/lNb2C9jZarRYDFiIuzE7A9Yd0yZuENyGBh0QCh8wHlk9gNaP+hvtU0qga3RLHKfGCfVPvlfOM2oUQ2CToXtQPgHaDv8VreQu2SRP8CYGho97Jh83uae7uXbxg3XGCa0etHyH9ooXkm/wENANDc+AYWCAAAAAASUVORK5CYII=',
    'по центру': 'iVBORw0KGgoAAAANSUhEUgAAABgAAAAVCAYAAABc6S4mAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAASJgAAEiYBF62JUgAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAACTSURBVDiN1dVBCsIwEIXhLyAIolt3bj2JN+wJeo+exG133VYEQdBFKEiJCCFR+8MsMiRveDOECXioSMCpZoHlExK5HVaZeneMny514uBzopuLpRwcRRc5jDhnvv1TphbtsS2sfcEwHVr5g30X7VcdLJfXf3AQW1WCAf082Sg34CblYIN1IQc3XAtp/ZjqGy2ovJOfDJhGPdqa5MQAAAAASUVORK5CYII=',
    'по правому краю': 'iVBORw0KGgoAAAANSUhEUgAAABgAAAAVCAYAAABc6S4mAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAASJgAAEiYBF62JUgAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAABrSURBVDiN1ZUxCoAwDEVfcGkXdz2B4DV6qx7eDqXgoFC0v5AH2QLJz0+IARdCDEjKAv6xjpwARGUTmboIn6JHwQbsw9t2w31EkToOGYkfZr7FVAU+ebqDAJzKogcikxsLsCoV+EL+0QzxTy4QFjsNCrBo1wAAAABJRU5ErkJggg==',
    'по ширине страницы': 'iVBORw0KGgoAAAANSUhEUgAAABgAAAAVCAYAAABc6S4mAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAASQwAAEkMBVx6IWQAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAABFSURBVDiN1ZUBDQAgDMM6CVjAAhbwb4mrKMlqoHma/wEeIgGuKegnwLIFeuRjCvoJsG2BHlmdoB99D75EVm9RP/pH0yMPcbMGXYxgl1oAAAAASUVORK5CYII=',
    'заголовок': 'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAC4XpUWHRSYXcgcHJvZmlsZSB0eXBlIGV4aWYAAHja7ZdLkiMpDIb3nGKOkJIQEscheUT0Deb480NS6bKruiOmpxezcBIGUggJ9Alsh/73jxH+wkNZjhDVPOWUDjwxx8wFHT+u52rpiKteD+8hvD/Jwz3AEAlauV5T3/oFcn1MsLjl57M8WN12fBvaAx8GZXqe3raeb0PCl5z2e8h7XomftrM/o/Ia1vMaen2PhmA0hT3hwF1IDtQ+vQhWIFkKakItMpVIFH2WtCT8fezC3X0J3t17id1RtlyeQxGOtBXSS4y2nPT72K0IfV4RPTw/DZjcLr7GbjQfo1+7KzEhUinsTX1sZfWgiHBGWdMSiuGj6NsqGcWxxQpiDTRPlBooEyPagyI1KjSor7ZSxRIjdza0zJVlyVyMM9cFJc5Cgw14WhAHjwpqAjHfa6HlNy9/lRyeG0GTCcYIM76U8J3wd8ptaIyZukSH37HCunhmDZYxyc0aWgBCY8dUV3xXCZ/y5vgEVkBQV5gdGyzHeZk4lR65JYuzQE+PGI7raJC1bQAhgm/FYpDdkY6ExKZEhzEbEeLo4FOwcpbIJwiQKjcKA2xEEuA4T9+YY7R0WfkS42oBCMURMaDBAQKsGBX5Y9GRQ0VFY1DVpKauWUuSFJOmlCzNO6qYWDS1ZGZu2YqLR1dPbu6evWTOgitMc8oWsuecS4HTAtMFsws0Sjn5lDOeeqbTTj/zWSrSp8aqNVWrXnMtjZs0HP+WmoXmLbfSqSOVeuzaU7fuPfcykGtDRhw60rDhI49yU9tUn6nRC7lfU6NNbRKLS88e1CA2+zBB8zrRyQzEOBKI2ySAhObJ7HCKkSe5yezIjEOhDGqkE06jSQwEYyfWQTe7B7lfcgsa/xU3/hm5MNH9CXJhotvkvnL7hlor6xtFFqB5CmdMDxm42KDQvbCX+Z302234rwbeht6G3obeht6G3obehv4/hgZ+POC/Y/gH+o2SB5uu89EAAAAGYktHRADgAJYAljFljpMAAAAJcEhZcwAALiMAAC4jAXilP3YAAAAHdElNRQfjCx4FGiL4lKvlAAAAUklEQVRYw2NgGAWDFCQwMDD8R8IeZJhRgmaGATZFTAPt01EHjDpg1AGjDhhwB7AQqW77aBQMtAM8GRgYGEnEpaNRMOqAUQeMOmDUAaMOGAXEAABKLgj+GDmbHwAAAABJRU5ErkJggg==',
    'маркированный список': 'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QA/wD/AP+gvaeTAAAAbklEQVRYw2PwySxkGEjMMOqAQecA2Rlf2mRnfvkiO/NzK7qcr6/vf0oxYQfM/PwZiP/Lzfz8aWBCAOhzqCNaBl0aoEaQj+aCUQeMOmC0JBxeJeFoLhh1wKgDRkvC0ZKQkrYg3RIhyWlgNBvSGwMAAPf48UNSMY0AAAAldEVYdGRhdGU6Y3JlYXRlADIwMTUtMTEtMjZUMTU6MjM6MTArMDA6MDD7CboLAAAAJXRFWHRkYXRlOm1vZGlmeQAyMDE1LTExLTI2VDE1OjE2OjU2KzAwOjAwEgWUMgAAAABJRU5ErkJggg==',
    'нумированный список': 'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QA/wD/AP+gvaeTAAAAbElEQVRYw2PwySxkGEjMMOqAQecA2Zmf/8Mwupyvr+9/SjFRIYDNcrpGwaB1ADWCfPCHAL5EOFoOjDqA7okQPTHSvSSkR04YWg4gFJzDIwrwJcLRcmDUAQPuALqVhKNRQI0oGDQhMJoGBr0DAO75B4Tyzdb5AAAAJXRFWHRkYXRlOmNyZWF0ZQAyMDE1LTExLTI2VDE1OjIzOjEwKzAwOjAw+wm6CwAAACV0RVh0ZGF0ZTptb2RpZnkAMjAxNS0xMS0yNlQxNToxNjo1NiswMDowMBIFlDIAAAAASUVORK5CYII=',
    'специальный блок': 'iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAYAAABw4pVUAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAXEgAAFxIBZ5/SUgAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAWaSURBVHic7d1fiFRVHMDx75nZXdM1WrXdnXvOrq66JChl7lJbhAgaodVD5kuJZAhRbRGVD4YU9FJQ+KARSglBYEhlPUb/kB4sS9Iw0RAsN5mddUTXzT/7x92ZXw8zjoMQzp291zsz/T5wYS+c+zu/c8/M3HvPPfcuKKWUUkoppZRSqnIYH2XnAo+HlUgN2w/8FEbgjYDo4nv51s9OjvkprMLn5ydrGtARUh617AxwNuoklFJKKaWUUkpVCT9X6l3A1rASqWEfArtKLVznI3ATsNR3OuprP4X9dEgS2OEvFwUcjDoBpZRSSimlqp04t1g8b13UeVQycW65JBKrwq8okVgl1g6LtWPi3H2hV1iFpK3NibVpsTYj1r7kd3s/V+ogchAYBBwin4m1XSaV8jujYjEwy+c2UfkNOF9qYYE6stndQAswCuwLK7FrlTp3v1h7RawVsfZ7gbjPEN8Q/eS1UpcH/TRMrN2S3y8inveMr72S53uinOnv3w+8nl9dgXOvlVNxrRHnHgVeza/uNgMDO8uJ42f4/VrlYLD2C2A1kAVWmlTquxI3vw2YUk69ETgPjN+okHjeHIw5BMwEjpLJ9Jh0+nI5FZbVIQDS0dHE+PhBROYBZ4jFukwy2V9uvGolnZ1TGB7+EegGLpHN9pjTp4+VG6/sub2mr2+I3Gz4EaCFbPZz6e6uLzde1RoZeY9cZ4BI72Q6IxDi3HOFA5m170SazE0m1j5Z1Pb3o86nQDzv43xSWfG81VHnczOItQvE2gtirYhzB6SzM5DjYtnHkGLS2tpIPH4AWAgMkcl0m3T6ryBiVyJpbp5Off0v5Np7Pt/ek0HEDuT5EJNOX8aY1cBFoIl4/Etpa5saROyK1NCwnVxnCLAhqM4InFj7RNFv6vao8wmDWPtCoY3OvR11PjcknrejKOGnos4nSJJI3CPWjubb9oP4HXoqQfCPtDU2vszVmRYi2yWRWBh4HRGQ2bNnEIt9Su6iNk0sttbARND1BHJQv560ts4lHj8M3AocI5VaXJT8FuDeMOoNwSvkP1zi3B5E1gBgzArT3783jAoD/8oBYMxsoDG/9vN1n6Q7qZ4JdzMKf2Wz+zBmTX5tARBKhwT+DZF5825jdPQwMAc4yejo3WZw8EJRkRfJnaFUg23AcSiM330FrASGgS6TSh2PMrmSFF0kZiSRWBZ1PkHK33w6l2/frxU/VCTWPlZ0hvVW1PmEQaxdW3Rq/2bU+fwnaW+3Yu3ZfKKHZNGihqhzCotYuzvfzvGgb2UHctorYJiY2Enu1uwYsdh6c/TolSBiV6SGhueBU0AdIrukuXl6UKGDuQ6xthdjHgZAZJNJJo8EErdCmb6+IYzZQG7oZD719e9GnVOBtLfPF2svFt1jD+XaphKJc1sLo9zOPRJEzEl9QwTqyGQ+AaYDQ8AGk/vU/D9MnboJOAIYRD6S1taWyYac3E+WtW8APfm1XpNKnZpsQtXEnDgxBqwHrgAtxOMfRJaMeF53YTqQc3siS6QCiOdtLjrdf3oyscqbdWLtNHKTyO4A+onF7jLJ5GCJm9fcRDmBGM7tRWQZcIlYbIlJJk+En97VBK4NsWfF81b63LwmJ8pJa+vcwi1da/eVMYEQKOMYItY+hDHPAmDMNjMw4Osp01qVv2t4daLcA1i7saw4fgqLtbcDvwMe8AexWLdJJkd81llzE+WKFQ3Tj2FMj+nvP+xne3/D78bMBM4hMgtYV0ZnAPxTxjbVY2Kil3h8KZAhk2kKvT7p6LhFnFsRekVVTNraesS5ajlxUUoppZRS6mbTN8qFT98oV2H0jXIVRt8op5RSSimllFKqdH7GsmYAS8JKpIb9CfwdRuDlRD9xrRqXzX52sv7r1Qrj5yernuLHhFWpLpF7alcppZRSSimllFJKTc6/pFfK8wBWI10AAAAASUVORK5CYII=',
    'добавить отступ': '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',
    'сохранить': 'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QA/wD/AP+gvaeTAAAAgElEQVRYw+3XwQmAMAyF4SyhOwXMIWN4dAvncyG1V0kxlqQqvMNPoS3l66mUpnmhNyMAPgcQkT2otRlgbazNW2hmHs5x8yBSAGXOi0gDeBGpAA8iHXCH6AIoqeporXUD1M54BPCWAogIAAD+C2h9kkMBEbcFAAAA3IDM8DMC4NoBiQ4P9qr0hhoAAAAldEVYdGRhdGU6Y3JlYXRlADIwMTUtMTEtMjZUMTU6MjM6MTArMDA6MDD7CboLAAAAJXRFWHRkYXRlOm1vZGlmeQAyMDE1LTExLTI2VDE1OjE2OjU2KzAwOjAwEgWUMgAAAABJRU5ErkJggg==',
    'красный маркер':'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',
    'синий маркер':'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',
    'зеленый маркер': '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',
    'красный шрифт': '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',
    'синий шрифт': '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',
    'зеленый шрифт': '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',
    'картинка из файла': 'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QA/wD/AP+gvaeTAAAA+UlEQVRYw2PwySxkGEjMMOqAQecAX1/f/7TERDmAVr4dmg7w9/eXBYqtAeJPULzez89PnS4OgFr+HGhhGRBLgTCQXw4SA8nR3AFQn5djUQNyxCp6OOATyNfoaqAh8XGgHfCBHg5YjyMKKoB4Jc0dAErtoAQHcgRaInzm6ekpQ89suAoU51C8Ep/lbm5u3ANWEAH12gDxSyB2or8DfHwcoJaXgGgQn2YOwAhmqOVwS9H51HQAejDjCnZs4pQ7AC2Y8QU3kvpVVHEADp+/wJXgqJsIccQpvixHNQcQylq0LoqpZjm5DliFM4GNmCbZgDhgQJvloz2jEecAALt8869/w4Q8AAAAJXRFWHRkYXRlOmNyZWF0ZQAyMDE1LTExLTI2VDE1OjIzOjEwKzAwOjAw+wm6CwAAACV0RVh0ZGF0ZTptb2RpZnkAMjAxNS0xMS0yNlQxNToxNjo1NiswMDowMBIFlDIAAAAASUVORK5CYII=',
    'скриншот': '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',
    'блок кода': 'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAN1wAADdcBQiibeAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAADvSURBVFiF7ZaxDcIwEEV/EJRZAOGRnJIBaFKwAB2MQZBYgNYbQYNEkSJQgWQqJCu2L/GRuAD/0rHyX+6ffQGS/l1Z341FUey01ltqj1Kq9/s+moaa+0yklDrUHAAmIeZjiAQY2xwgIuCYUzH4onMCcL+c0x9WBDHKTgLENAc8EXDOM1edxzABJIAEEF3cscpVr/+BLomqsaAvZc67zIaoQBtosb8rcXzMXXstylAA17XtqgiAOgM25zI/mItWBNQckFLqL+bEC0DdXhykB1wye0BUzek5w/q6ym+jAHhKbsIsfc+Cyunqj5ijO+k39Qa3W2Z+3H68oAAAAABJRU5ErkJggg==',
    'горизонтальная линия': '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',
    'таблица': 'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QA/wD/AP+gvaeTAAAAa0lEQVRYw2PwySxkGEjMMOqAQecAX1/f/7TERDlAduZnnBibIch68fl2+DhgNAqGvwMGPBuS6guqh8CoA0bTwJB1wIBWx9gMBxVcZDmAWiEw6gCyHUBuGsBXicHwaBQM7zRAFQeM9oxGnAMAmy98ApQBUa0AAAAldEVYdGRhdGU6Y3JlYXRlADIwMTUtMTEtMjZUMTU6MjM6MTArMDA6MDD7CboLAAAAJXRFWHRkYXRlOm1vZGlmeQAyMDE1LTExLTI2VDE1OjE2OjU2KzAwOjAwEgWUMgAAAABJRU5ErkJggg==',
    'гиперссылка': 'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QA/wD/AP+gvaeTAAAAWklEQVRYw2PwySxkGEjMMOqAUQcMegf4+vr+x4bJVUeWA8j13agDSHYAKfFIjhpsakejYGg4YEDLgdGieNQBlGDZmZ//jzpgZDkAZCEhPBoFow4YLYpHHYCOAXVl2N9ZeAhUAAAAJXRFWHRkYXRlOmNyZWF0ZQAyMDE1LTExLTI2VDE1OjIzOjEwKzAwOjAw+wm6CwAAACV0RVh0ZGF0ZTptb2RpZnkAMjAxNS0xMS0yNlQxNToxNjo1NiswMDowMBIFlDIAAAAASUVORK5CYII=',
    'иконка программы': 'iVBORw0KGgoAAAANSUhEUgAAAJcAAACkCAYAAACacbx6AAAACXBIWXMAAA7DAAAOwwHHb6hkAAAAGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAIABJREFUeJzsnXeYXVXV/z/nlum3T+8z6Z00AgGCpCgBFJUuSBF4lV5EIi8IAor0jgqhSNeASEc6BEgCAUJISCAh08udub33e35/nNvObTMwQd8/fvt5MjM5++y21nd/19r7rLOPwN5JqtNOO+3Mfffd94fl5eUNgiAEw+GwJxgMeoLBoNfv93u8Xq/H5XJ5QqGQw+v1jg4NDQ1v3LhxBAgAPsAPRPZSf/5/+j+QhL1Qh2rNmjX3rVmz5ucGg0Ex1s2hUAi/35/8J7rdbpfb7fY6nU6vz+fzZYIyGAx6vV6vx+12e3w+nysYDFpsNtvIJ598Mmy3291IgPQDwb0wjv+f9nKaMLhOO+20X9588813G43GMYE1kRSNRjNBidfr9blcLo/b7fa6XC5fOBz2hkIhTzAY9AQCAY/P5/MkkjcYDFocDsdIT0/PyM6dO+1IgEyypfhd9vs/kHSa6uq6+fMXTQ5Go7GP3n5jM2D/b3cKQDXRChYuXHjEdw0sAJVKhVarRavVJi9VJv4VTaIoykDp8XhCbo/H43G7PXaHwxcKBr3hcNgbDAY9gVDI4/P5vR6P1+PxuDyBYNDmcTpHB0ZGRrZ89NEoaUD6geh3Nlh5UgOmKXPntk2eMnOWQW/qMNTU1Gu0+vqyqsp6U21DbXV9Q71Gp1fH43G6vtwxsP61Fx9+5uG1V/8H+5g3TRRcgsFgaNwrPfmOkiAIVFZWUlkp4VCEUkRKRagWERETvCVC1t8ioVAIn8+Hz+/H5/XFPT6vy+10epxOl8/v8/lC4bA3HA56gqGQx+f3e4Iev8ftc3l9fr/T7w2M2kYtI1u3fmL2eDwe0qAM5emmVqvV1i7Y78Dphuq66dU1tY16o7G+UqOpr9Lp62obm+uN1TUGrd5EWXk5oihKfUz0WUT6QwQMB9Q2T50z/3Kf2zPp1X/9/SqgC4h9dxIunCYKrjKdTqfZKz35D6SUIhKgEnOuk1IcQElJKeqSUvQGI6KIQkQ0iGAgcb+k1OTfYurvcCRCwO8nEAjiD/hxORzhoaFBn3loOGhz2IRIOIa6rIyy8gpFaXmF2lRbW1Lb0FRhNNUoNDo9gkKZqjMNnjToCwEr+f9KrY4fnfiLw9579fk3/X5/PbCR/wKLTRRcFTqdrmqsm0RR/Ea+nSAIe9UPKgQC+XXSSsq5nlB0ketejwe7zc6o1YrdbhcikQgiAjFRRKFUlmlrGsqaJ89EZzRSVl6ZAZCsejP6KYoQFzP6lQUsMq8lgSYIoijC1DnztFPnLjzgs03vWYEpwM69KdPxpAmDS6vVFmWubwqsb1sG8oNSbu4KmcHi5hEgGovhdDqxWW1YrDZcTqcQjoYREYjG4pSWVwh6vQmd0cTcSdNRlZQUZZfMugsBC6QVlygIiRJC6n5BSJQXskQlIoiIKNWlLFiy9MT5CxcdHo1F3JOmzOgNh0PeUCjkDQZC3oDf5/X7PN5gOOgIhyIWv9s5uv2TD/utVqsNsH4b+WenCYGrvr5eW1VVVb43OrI3UjYoxzKDmUpHEES/z4/NbsNms2MZtQi+QIB4QsuiIKDV6gWtwUhD2ySm76MHQRjTbJHRhuxfsl4x6zrpjmaDLdlOTjlZH9Lla5ta1E319TUi1Cz93opJSpU6Rx6RSJiAP0Aw4CcQCGAdMY/s+PyTjze//+Y1G958c/NE9DEhcM2bN6+hsrKyIMt8WwaaaCpkBqOxGC6HE4vNitVmw+VyEYnEiMXjQlwUhfLycnSmagx6E/t0TJHYJxsEGaYwDZ4MEFDAbME4AJLuayFgFe+DKKtTqVILyaKBQIBKjVreBqBSlVClLaFSqwURmto66ubuu//hk2fMmSuK4jEb33rro2+rhwmBy2Aw1JaX/58hLgB8fj9Wqw2bzYbFasUfCAAQi0tA1xlMGAxGWjqnMMdgJGlqMkEQj6d9HClPziz5AZKPXfIDKxsEYgZyCplH8vRBlPUhix1FKC2vIB6LISiVBAI+KjSasd2CRDsLlx7c8vWXX/x+41tvHZ4e0TdLEwJXWVlZTXKJ/59KsYTvY7VasdlsuN1uwtEo8bgoxONxysorMZlM6E1G2qZMo6SkFMid7anfolhwBUbmvbK8cYAgr3nMD4JMM5UJoPwMlw/cYk7/APTVdXhG+qnSagn4A7n9T1SQ/lt+ffaCffcF6gDzt9HVhMBVVVWlVyqVE6kib/L7/dhsEvtYbTaCCfaJi6IgCAoMBgMGo4nOKdPQGwwIGb6PTLEJIUtMlKuAfCCQCfwbsovsmqxcMRDkslh+AMuBJeapk6xxGWrqGO76kkqNlkDAnwWgjLFk9jNRFqBCo9Mzjo3qQmlC4NLpdNqx78qfkgAym81YrVZisVjKR6uoqKC6uhpTdTXTZ8yktLQkrwKSQoiLZACq0NJ+bGABspn87dlFziCFgJXfPGb0IQtYZPadXGBlg1trqiYYCiEi+VzZfmBmmcx+Jv/2e70hYBHQBIQBL9APuMah4omBq6KiouAeVyQSweVypcxXIME+oigK0WgUnU6HyWRi0qRJLF68GCFrSZ2t1LiYrZz8CsgPrHy+yzdxvvOxi5innTwgKMgu+cxjVh9SzacVnm+s8rx0X8vKKqTVrggBn08uN5ks8l93uxx+JKc0SSLVQBuwA+jOr/l0mug+l76/vx+bzYbT6RSiUdkmsFBdXY3JZKKjo4PS0tIxK0s50IkfmUIcD7DILIdc2JBfAWMxz5jON7l9kDNcEec7pw/jN9HjnURKpbT9EAwGiMfjkguR2Z8suWdedzkcIXIfVwnATKSH40UZbCxwqQHtihUrOidPnjzbZDJ11NTUNOh0uvrS0tLG2tramX6/X9HS0sLcuXNRKIo/v04BoNg9iR/5gJWoZHxKTSix2Mz+duxSyEfK14dC7JIPIEXGOi5w559ESnWJICYqCgWDlJaVk1F9aoyZ9SXH7vU4A+SPsROAVmBbfi1KKQWu+vr6mtWrV5/Q1tY22Wg01ms0mnqTyVTb0tJSX1tbqzGZTDnsI4qiIsecjQNARVMmCMiaTQXNVmFgjTWzZW3J6irELvmBlQsCUd5O0T6MMVZZXmETTVY78biIqrSU5E5+wO+nJAmuguYx3Z+wP1gsTq6iSB6QANfJJ5/8s+OOO+6aFStWdIxlvnJ3wScIJlldcgXIlZofWOM3W/kUkK5Xnje+lWWyQC4IxNx2MsY19ljzAVj6MV7fL7lXp9EZCQY9lJaVEwj40WLK6Z/873QbwVDQX0RdY0ZaqA499ND9zz333NsWL15cnZnxn95dL2628ik1a8ZDEQWQVwHjd76z2hoD8OS0Uwjc39BEF5tEBcZlqG2gd8eQBC6/TzaZMuWWzzwGA/5AEZWNGZKuOvjgg8/JBNZ/45HNeE3G2OySTwHSH4UUIGeXsVdg6bxvyaRFx5oLLNlYs+rMZcbEWMV0nsZoIhgMgSgSDATkdWfWled6wOctZhbDRfIAUDU1NU0Z66bvMmUKtfCsZ3wzG7IUkAUC0goYXzu5wBKz6xyzD/lAkM88pusdaxIV7rsobdlk5FVqdIQTe11B2V5XElLyutJAF/H7vBNjLkEQ4sn//MdNIRmDzFEquWaLMWZ2jgLyscs4VmBZwJL3IZ95LNSHwiaanD5kmaWCk6gQuHOBJYoiCqUSRSIaIuD3ZbRRyDym9eH3eiYGLo/HMzrWTd9FyqtU5IKB8czsXMUVU0BuO1KhfOwyVjvpvL1jonUb38f00r+o3LkdIRQk1NCEddURjPz4GOIKVRFwi+lN5mTXMuQnbUcgRmNRIuEwKrVaXj6fHOJxvG5XMYd+bHA5HI5v9VByIqmgUsVcwRSf2WklkplXQAH5ATL+Fdi32n2PxxEFRW4fMupU+v1MvvB/ML36gkxOmm2fUf3aSzQ+8SBb719HWK/Py865Ty/kfVepS1LXAgE/VSpdQbZKXg/4/QR8vmKbpGOCSzE6OpoC194OL86Xcmd9LrDGVCppgaSyYnEU3d2o336TsgfvR7l925jM821WYHKGy2+iBZ+PhuuvZuaB+7CwRcf8GY20XPFrhAyHOnMSdV56LqZXXyBcXcvOex7m/R3DvLfTzM477ieq06PdsplZ556CGM+eYHJgUWBcJeWVRKNRRCDkD+QFVrYcAoEAHrfDWUSVYzv0Fotlj8/n4z8ROpMtmGx2yW+28ig1g12SeaqPN6NbflCqLe/v/0Bk1pzxsUsqr/AKDCQAiwoFSqsF0z23UfXuWyi8XsKNTVh+dT6uVYehcLuY8tPVlO/YRryigphGi9Ljpu5v91Ha38uXDz0lG2vVZ59Q88I/QaHgiwf+gWfu/FQfzD88mkB9M/NPOAzjxvXUvvEyIysPTwEiG1higXEZahuwD3Sh1ekJBP1pcGeMN1PGAMGAD+vIiKOIOsdmri1btmy3Wq3fOWMB8pkCWYLJumaxoP7fyyj72fGU77cv6vvX5gArkwVUmzZIFSWeGCh6uouySzaLkfH/bHYp/+A9Js2fTscPDkLd00XnyqVU//kOyr7YRklvN1Ub36fj1OMwrnuMxj/8DpXdxu7Hn+XTr8x8unOAPXc/CAoF+jdfRf/267KxGv/9PACO/Q+SASvZB8eiJViXHwpA/T+fSAMrg8WKj0tEa6ohmAi5CaaYK79LkpzQXo87HPC6fUW0OSZzKXbu3Dk4MjLynb+hK7rc8P778Nqr8MEHiA5HhmDy+ENAyS03oXrmnyg/20Lp1VeB20MSVXJ2EVFtlMAV3m8pAMqergILAOla6cYNmM79H5r2X0DbpAZaFs2m+uJzUfX25DBpTKNBPdhPSfceGi86m5hOT/dTL7Gtz8GOrXtw/ORYEEWarrgE07on2PPAE7gOXoEoSG1ajzwa64+PBcD07DrZWMv3fA2Ab+acPMqWLtgOXgmA4eNNkinMMY9F2FkEjcFEKBhOmDt/EWCJxBMh316Xq9A7lkmJjvmqmgKwDQwMjIx1Y97kGiOsRxThiSdgv/0QTEaEg5ehWL0a5bJlqOvrUP74RwhbtuSwGCLEq6sRE29Xi7V1CFYLpXfelp9d4iLqTRsQy8sJ/eQoAFTd3fkVEI1iPO8s6g9bgeaJR1H3dCOq1KgGB9A98iCtBy+h4oP1MsCH2zolYXk8lO3YTve6F/EceDBxtZpwTR19t9xNpL4RpddLYNoMvPMWyhSICI6VEvtUffaxbKyKYCIUKS5mySE9iZz7LAZA7bSjdthSMsqcXAXZGVCXlhFL1Bn0+9IyFDOAJYFWSF53O+xBCoNrXAfGKICow+H4ZuDaswcMBoGmpgxEZCWXC374QzjpJPjoI2hqIn7sscTPPJP48uWgUKB46SXUBy5Fef/avOwSb28HIHzscYjl5ZTecRuCZTQLiCKKPV+jsFiILFhEZOo0AJSDAwjhSI4CDL+7DM1jfyPa3MLoQ0/QvWeA7i976drVh/PUM1B4PTScdgJKqyXVTlSrJWYwAuD8yTFEamplIIiXluNavgqAqN6QApbUP6l979wFAJT19UAkkhprJFGvyuOW1Zk5iWKlZSmxKj3ugqvobPllgltVopZkGQ4Rj8dl4ERaGAiZZbweV5DCpm9MkwgSuHC5XN9sO6KhAdxu8PthJA8uo1E49lh4+WXQaok/9hjRPV3En3iS2J//SvTV1wl/uYv4smUQDqM+9xyUT63LEUy8XWIMQiFCvzoHweul7Prrcvw09aakSdyfWFt7qg+KgX6ZkNVf7kS79i+IFZUMP/sKnh/9mHhZhQTkSg2jN9yOb9khKB0O9PfdIwNIuK1Dqra2Li8I/PMWAiCEw1kMIv0LNjQhqlQIsRhlA/2psfonS5NB9/GmLIBksFgs/Yw4UqnJCywxT7nMPKWqRBCRgi6DwWAGW0lmMMliyfaDAX+QVI9y0riZC6vVOpy8MK7tiIoKOPJIOO002cBT6d574fXXQa0m/uKLiMefAAqFbPDxlhbCL71CfP/9IR5Hff55YJWzUrxDUqiiu5vAJb9B1BukbYbubpnZUm3cKI14yf5EW1ohEdev7OmWmZiKZ56CWAzvj35CuKMzh11EhYDz1DMA0Lz0nJSVAEEoAVoxFktpTQaeBPhKBvsyymWYHJWKUGMzAKV9PalJ5Nh/mSTSrt2Ud3+ddxVt+FgaX6ChiZDBlKpT1vdUe/n3/VSlJZKvJgEHMQ9bpf8WCYdCE9pAhQS4RkdHh7KiSMdOzzwDDzwATU3y6/E4XHedNLbTTkNcekCeWSWNXiwpJXzf/aBWI9htqP76F9nsjXckfJ2eLuJ6A4FLLoVwmPJrr5IJo2TTBhAEQvsuIa5WE22SlKjq7iITBOovtgMQ7ewEEZSjI5R9tAnNU09iuvk66s85E+NdtwJQuudrBI83BYIkc5UMDKQUmNmHUGsif3gIwuGcsSJCsLUdgLK+7lQ51/zFeKfPAmDKNWsgFpMBS+l20b72TgCGjjhaLr/MPkgjzcN+Ul+rDDUEEv5dwO8rACwxNd6Av2hExPjN4uDg4A67/VssGINBsNlkl8SPPoJhiQjFU07JGjwpqSUHFZs6jehhhwOgfuxRGRBjHe0AKPv6IBoj8MuziTc1Ufb0OlSfb0UUQWG1oNq9i8j0GcSkA0OItkuKllaM6bYVbjcA2vv+QkdrDR0zO2g+bDn1Z5+O6YY/oFv3BOrhIfxLluI8+niEoD/Vn3ACGCVJYCT/JZQZamhEVKkRYjFKUuZYPtZAoo7Svp40CBDYdfUtxNUlmNa/yfxTf4pp/ZtU7f6S+heeZslxP6Cirxt/Sztfn3FeQdOZ/6lCehLoq2vxezzE43Eh6PfnmEHZmRMihCSzWCiNi7lUAO+8885Xo6Ojwdra2rKxCqTSTTfBmjVwyinw0EMJQYGwdauUr1AQX7Awy/7n332P/ehHqJ57FkVPD8JAP/GmFkREYolVGuEwisFBoq0t+C6/Es3Zv6TyqisIP/MC6k2bQBQJL9k/VW+0vQPWv5NaMSbbjOv1qe4HDjqYcFsHkfYOwq3tRNo6CLW1Ey8tk/kzKfAkmSmxVSEmB5y8V6Ui1NRMWW83pX09BBL+osx0tkh1lPX1yOTgWLSEbXc9xKxLz8a4cT3Gjetlonbss5jPbrmPiNZAPtakCLCSiqkyVBMOBQQR0qE3qaJZvhsQ8E3soTUkwBUMBq1DQ0Pm2bNnt4+nEAB1ddLvrq5k/0GEuNks0aFOh6hWy1Z12SyWOuRj/iKS8a+Kzz6TzJoIsbY2yX+KxVD0dCG2tOD/2c8pv/N2St94jZL176L+UL6/hQixBHOpertlCghNn0nli88RmjaDwceeLgp4OXhI+Vxq8xBEwqAqkd0rAqHWdsp6uynr6UJctjwHBMHWNgDK+7pzQGBZeRjvv/kp9S8+Q9WOrRCPE6hvwrrfMuyLl+ZsL2SOK595zF5UVGh0hBKuT3JDtVhEqt/rnrBZTMbQe0dHR0eB9vEUAqAzwSoJcCVRLyTDpIPBnFWdnMWSeSC2tKSqFczD6RmkLiHe2Iiivx9FdxccdDAolHivuhb9CUdTddXloJQeCodSzCUSSfhHqp4eWTv+5asw3vwnKja+j3r3V4QnT80LLEB6GTIWQ1RK0QjhxibJ7EUjlPb1EeicLFe2CMHWDnS8TUmSmTLyQMQ7ZQaWQ3+Ed9rMFAgy+xfWG+k96fQxN0lFIBYJMzo0QF1LR3HZJv8rCKk3gUKBQO5KM+PvuBgn4J1YLBdkvKDhcrmGi92Yk5LgGhpC9AcQy8ul4RtN0ukLgQDY7YgGQ97By+i9oiJ5JlDW3pRk4kr6+1F0p2d74PAfUrFkP0o+3ARArK6OSHtnSgGRBHMp3C4UdjvRRB8C++5HYN/9Kf9oIw1nn07/Uy8S1eoy+idppWLD+9Rf/b8M/eEmvAuXSPUqlISbWyjt6aKkrxt/56QcZfrmzsfZczChto6sPGmsvsnT2P7nR4r4SMiA5bJbGerrYWSwl9HhQRyjZhzWUdx2KwGfh/JKDWv+/CTqktJcC5FnwigT0RHRWJRwOCxFS2ToJtErQsEgAZ9nQhERkAGubxx609AA5eUQCCB2dyPOnCENaM5ski+YCVu2EF++PKPzpIFFevC4XKkb4kkwJmdReye8t17aViAtLPfV11F96HIAQkuWymZ2krkAlL1dRAxp32/krntpPmIlZZ99SsdBC3GceCqhqdMQYiLqr3agefsNyj/fIglnZETGLv7Z8yQw5j06CczHn8zw8SfnjlWm6HShSCSMeXCAob5uRgf7sZiHsI0O47RZcDvsxGJRKio1aI3V6KtrMNY1MHXeYmqaWmidPAN14k2evBYiQ1Yk7lGqS1N9Dgb8VKnTb7JnmtdQIIDX455QRARkgGtkZGRYFEUEQUAQBHHMqFRBgI4O2LEDursQZ8yQujh3H6isBJ8P4ZWXEZcvz7L/ubvHys+2pKqNzpotm4WxxF6XMumcJzJD+y3F+vTzxIxGIpMmy4QcMxiJa3Uo3C7U3d0E9lmYAkioYxJ9L75B3SXnUfneu9Tc8ifZsES1Gveq1YyedSHe/ZbKwLPnr4+kwEKi72lF5n8E43TYGeztZqi/l5GhAazmYRzWEZw2Kz63C1VpKTqDEb2pGkNNA1PnLqCmoYX6lnbqWzvGNI9pE5jP9RAz+gKlVRpikQgKlZpQIEClRp+qL3MsQb8P56i5GLi+GXNZLJYur9eLRjO+I05FgI5OhB07YE9XehBlZcR++lOUjz6K8vHHiF7+O0SdLkcwyUpERNTr/gFAvLWVyMzZibrElFkEaUM0W1iBld+XmZjMvEh7O6Wfb0XV252hnATtd0yi9+mXKd31JeUfbkTptBNXlxCYMRvfwsXEyivJnMkyAGW3EwkzPNBHf28P5oE+Rs2DWMxmHDYLLrsNQRDQGowYTDWYautpmzyVxctW0NDWQV1TKwqlCsT8Icq5wMoGj/zebGBll9OZ6rD37aZKZ0isGPNNCAgE/FG30773zOKWLVu222w2UaPRjBlHn+pQZ4fkX3XL95NiF1yE8sknEaxWVJdeQuivawvObOWnn1D6xGMABM+/KHFaX1pYSXApbFbwuBGrtHlNjFyQIr7DjyQ4fxGhOfvImSWjD8Ep0wlMmZaHCeSKdtjs9Pd0Mdjfg3lwgFHzEDbLKA6bBZ/XS2VVFXpTNcaaOmpqG1l80AwamttoaO1AazAWBAGJa/mARXpoBbcXCo0r/8octKYahr7aSqXOQDAjrkvMqs/ndIwVEfHNwLVr167B4eFhS3t7e22xAplKFTrSK0bZjJs7l8jFl6C+8XpUf3sIsayM4PU3QuIBbHJQqvXvUnHySRAOE9n/APxn/DJHAcltBZBMY2zOPFkfCrGL/de/LTjb031ILABCYQYG+ujv6WZooI/hIYl97LZRHDaJfXQGI8bqWqrr6umYMo39DllFc2s79c1tKBMrynzsLAOGTH4ZwMrsfxY7Z44rm50z/Tky6sw/ZpEqnYlQOAyIhPz+3P4k6vO6nQEKgyuabq14yjwrwjEwMDAKFARXhlIFibk6EQChqztFxclfkWuuBcso6oceRP3Xv6D617+IHHkk8ZY2cLtQvfsOqo8+BCCy9EDcTz2DqFKmBZfofsxUjfu6G4m2tBJtaS3ILoXMY1Jhdpud3u499Pf1MjTQj3l4CJtlBLvVis/robJKg8FUjam2ltq6RiYdPJOm5jZaOiej1elyFLY33nvMF/ue2/f0uPKxmIx1Ckym5L3KkkQsvZh8vphGSeaxSh6XY8LhNiAHV8zlco0As/PdmHfwnR0oAKGnG+Jx2SpKFARCf7mX+LJlqK+9BkVXFyX33Ztbb3k5vtvuJJ7yy3Lb8Zxzfl5hZQoyHAoyMNBPd3cXA339DA8NMGIexmYZxW6zIggK9EYjpppaausamDRtGgctX0VreweNLe0oVco8SinEBHmAJUo73z6PG0NNHaIIH7zxMk8/eA87Pt1MNBJm9qL9WXPrWqrrG8cV+17M7OeYx2T5InUCKEukFWM4FCIWjyEoFOk6EmWCgUCxiIhxrRQh65SbQqE3BYXd1iGtGv1+MJsRGxpkbAEQPv5EQsf9DMWnn6Dcth0xHITSMuI1NZRfcjHK7i50qw7B9fDjhFauKiosu9VGV9ceent7GOjvZ3h4CMvICDabBZ9HYh9TdQ3VtbXUNTRy4Pdm0tLaRnvHFLQGvaz/42OC/P7M1s0bsVssLFv9o1Te1o8+4ILjDmPpytVce++TiMAXn3zIMaefxz73LyMWi3HPNZdyx+8u5Or7/iGrUzZWWXvjW1SkrhepM5mS7AUQCgYoLU99WSRVNhwMTDgiArLAZbFYZKE3qe0IMWsAyY5UVBBfvRpRo0WMRQvTuyAQXbCIyIKFMqWGFy+h6sTjKHlvPfpjfozz2j+x/QeH0dXVRX9fLwMDA5jNw1gto9isFhSCAoPJSHV1LbUNDUydNp1DVn6f9o4OmlvbUapURVdL43k9LRwKSZuSibEOD/Rz4+UX0doxmfOv/BMicPX5Z2AxD/GHex9n6crDAJGP3nmDtinTGU7tzouccenvJeZ1udi1fQu1Ta28/fzTBPw+ypJKzZpEafnlM/t5ZJs1rnx1yhSuLiMuighI+1kl5ZVZzCUSKn5GxLdjrpGRkYFwOExJSUnq2lh+Q/jZ53MGX4zeLTYbe/bsobu7h76+XkamzeIgmwNXwM/X9/6VLc8/j7a2jpraOhoaG5kxcyatre10TpmMTm8YN7vkAxaAz+1h5/atRCIRZs5bSKU2fcLxCSv3p+frXTz2+gbaJkmPhja89SrbP/kI24g5VVdjaztT58znnj9czqKDDkFdUsbm997iiBNO5YGbryEuxhEQcDnt3PLb89i5ZTNT58ynuXMKcTFO3+6vmDJ3QUFg5Zdf8XHJJ0x+YIG0YgzYRyitqCIY8KPJU9feiIgGu9LjAAAgAElEQVSALHAlQ2/q6+uTY/mGJgOCoSC9ff3s/noPPb29DAwOMDw0xOjoKFaLBYVCgdFkoqamlvqGBqbMmoX60MNY3NnJ0e3tKJXKPOySz5fIw6SJfu3ZvQvLiJnJ02eiN1WnMq+/4jc8v+5xJk+bSTgcpq/7a/785PPM3GchoggVVVW0TprCrVdeyu2PPwsifLj+LVYfdQIvP/V4qp2G1g4UCgXzlizlyXvv5Ic/Ow2HdZT9VxzGPdf8FofFgqGmlsfuvJF4LMYj67ehUpcQj8d5/pH7GO7vYfKcBQXGlc88Zsk7CwzFzGN20tXUYR/oSoArIJNxsq4xYrm+Hbhef/31XRaLxVdfX19Z1HlExB8M8sTf/0FvXz+DQ0OMjJixWW0E/H70BgPVNbXU19fR2NjEPnP3oa2jncmTJlGl0abod8xZmEdYogixeJzhoQH6erqJRqMsXbac999+g1eefZoqrY43X3kRrU5HX/cerv/zQyxbdSiiCPMW7ce5l/0+8e0dkbW3Xs+tV1/G2mdeSzFSeUUVu3d8zruvvMDSlYfy+ceb+MVFl7Huwb/gstvRGow0trTz6ab1/O6O+znj8INQqFQsOOB71DY0olKXMNzfg76mlpGhfjpnzEGllj6W8On7bxONRjAP9KbGVciUZVuITLAl5Qe58sssly9p9CbCISmYMRT0y+pOyj3gLxoR8e3ABVj7+/vNs+fMmZQNrGyajsXjfLBhI40NjSxetIi2tjYmT+6kpbkVRSqkeQx6Ry6YZDuRaJSvdn5BeUUVrR0dCIkPEbz/zltceckFWEZHqK1voKW9ncX7Hcj+y5YTjUR4/um/c8gPDueVD7chCAIP//UuLj/vTF7ctA2NTs/3jzwKl9PJe288w46tn/Ll9s/Z9ulmfD4f5ZUVNLV2sH3LZi6+5mYuP+tkSsormDR9Fm1TpqFQKhnq60GjN9LQ2sbwuh50xhpO+NVF3HPtZVx2630ICiV1TS0M9fcwff6+LFy2koduvpqyykr8Hg/v//s59j3kUEYGevOwczZ48luIzIkZjUbxuZ2E/D6MjW2ycoVSeZWWWFyKdg0F8u11QcDjKebQfzufCwhYLJZRUWRSsT0jgMryCu6/9695zVa+1U/2LOzt7aFEXUptQ4NsFv79sYe57srLMJpqGB0xM2nKVB7+5wtUaXSUlJYx0N/Ltn6bzHkXEWlu6yASDnPMyaenzqU/8cyzuf/Om9nwzpt8/8ij2PbJZi4+/QTm77uU+UuWMm/JAXy4/i36e/YwdeYcGlvbee25p5g2Zx/2PWg5f/z1WRx7+lmolGpqG5oY7Oth6tz5NLS2Mzo0SCQa4Ucnns6Cpd+jqX0SItDQ0s5wXw8Ahx13Ckqlkq+2foq+ppZrH/oXVXoDJaVleYCVb3tBJODz4HE68LoceF32xG8HfpeDUNBPhdaAobYRY2PrmMAC6fuTCqUUZxcKBGS6RYRIOETQ7/UUqeJbMxcul8ecf9OuuI3PB0SXy4XT4aSlVZpV11/7e2bP24e7b72ZoaEB7DYbq484kjvufQClSk1/Xy+/veBs7n1sHSsPPQynw8kJP/oBV192CTfevZaW9naikQgj5mEamlpks66xrQ1BECgvL0+BW1AomDprDl27vwIR1t5+PUce93POWnMlIuBMhHYP9nYzJQGu4YF+YvE4Z15yBaa6elYdeWzKZA4lQpwbWjtQqlQ4RkepbmiiZfLU1LgvvuEeKqu0qUm06uiTWHnUSQXlF4tF8XnduB12fC4HbmcaRB6HDUGhoFJnoEpnoFJroLqxldYZ86jUGCjT6hBQyCzEuJSeWLDFY3HC4RCqktKEvkWCAT9+z8TDbSAPuBxOu1nu84zPxm/e/BEvvfA8Pd3d9HR30dvdTSgcoqNzEm9t2IyIyIcbP2Dtn+/mxjvu4cijj2VwoJ+fHrqCO2+5gQvXXMG/X3qeSVOmsfLQwxBF0Or1XLDmCi765Wlce8td1NTWU15eQX9PN/VJcCX6UFpSRk19A7t2fMHcRUtSoIuEQqjV0geVYrE4kUg4lffk/fegVpcwmNg+aGxtJxIOMTo8SF1jM6eevyY11qNO/RU6UzWI0veDXv5iWHoOmqlYEYw1dWTvvgeDATwOB26nDY/Tgdtlx+N04HHaU3FZGr2RSq2BKr2BlrpZVGkNVOpNiW2Rwj7ZNwUWkPhglvR3yB+Q4rwS9YYCAZx264TDbSAPuEbM5qG4KCbOXBBEEVEYj/O9dcsWnnzsUW65825a2ztob+9g08YN/OLE41MCaGvvZHhoiCOPPlZadTU1c+4la7jr5hu4YM0VBAMBNFqtrJ058xcS8PsY7OulffJUmtva6OvtZtEBy3L60NzWwWNr7+Gwo4+jrLyS7t1fse3Tj7noqusQgaNPPoNLzzyJ3Tt34LTbMJhM/OyX51FWUYEogrG2nhsf+Ds6gynHD1q66jAZm2cCKxqL4nO7cTntuB12nA47Hqcdt9OO02ZFqVRSpTeg1Rmp0hsw1TXRNnU2Gr2BCo0OhMzX7vL4uVnASo/5mwMLoLxKRyQiBQuGgn7KdbrU2MJBX8xrG5lwuA3kAdfoqO1rl9uNVqtLDGJ8S+C2jg78Ph+HHnZESghtHZ14PG5sVisGUzWt7R18ueMLmbD2WbiYgb5e3E4nLW3tfL3rS2LxOEJiURAJS4+4FCpVCkD9PT15mbS5tR2Xw87xqw6kua2DLZs38vNfnZ/aajjo+4fx5Bub+PrLL6iua2D2wn1l30wUgKUrV+dZhIgE/QFcTjtOux2X047LIYHH5bDj97qpqNKi1Ruo0hvR6g2Yps1Gqzei0ZtQl8o/7JmsU+5eFAAWaVkV8mm/aTLUNjCw6wuq9OnoiGTyedyBWCy29/e5AD74YP12y6glrtXqFGPGvmfktbV34Ha7sNltGBIvbjY2N6NSqejt6cZgrKa9o5OuPV+nnmnJ9mIEOOB7K4hEovz9kQc54RTp5dSnn3yM9s7JNCdCh1vaOujv7c7LpM1t7VhGzPzhrrXs3vkFl11/O/XNLbLZ3jZ5Kq2TpmSBB2LRCB63G4dDApDTacNlt+N02nFYLChVSrR6IzqDEY3eSG1DI5NmJACkMyAKjCv2Pfmj0AoxV7bj330fb9IaqwmF/FSKBkJZT3q8LsdYERHxAnk5KQdcZrPZbB4xj3ZOmlSfb/BxRIEswYBIc0srSqWSnu5u9AYTIiIqlZrGpmZ6urqZt2AxLR0dOB12nn36H/zkmBMA+PcLzzFzzlyqtNKD6+tuv4ffnHMmr774PKFgkK92bOOOBx8n+V3Ew396DC6XK6+Jbm7r4IWnn8RYU8u+1bU5TBAIBHDYbdjtNpxJEDnsOBw26dmkRoPeYERrMKLXm6id2YROb0Rnqk7FqRda7MTj8XEB67vcfR9vqtQZiSbeVQgH5VtaPikiopBfNW7WgvyfZ3H29/ePilAvH3xCsOQCSxRBXVJCY1MTPd3dzFuwKDXT2jo66E3Ev7cmYtvvvOl63n79VYLBEO++8RoPPfVsqp0f/vRY5s5fxPbPt1BWXsG+By6jrEz6WIMoisxZsDhLYYk+iVDf3MJwfx+7d32Fy+nAYbfhsNtxOOzYLCMolCr0BiN6owm93kh9UxNTZ81BbzCi0RsAYQwQ5AeWKIqEAgEGe/ZgHuijokrL7CUHkE9+qTIZeXtr9328SaVWpz6lkw2ukN8XoPDxSBMGV9zj9phFmJvXxheh97b2Tnq6u2SzsLW9UwKXKGIwGtFodVxx7fUEQ0F8Xi/X3HQ7pprajHagpaOD5vbs+HGpTr8/gN1mw5YAjvTbht1ux2G3seqYk9iw/h0MJhMGg4nps5oxGIwYqiX2yWynqKNMltmKxxgdHmKovwdBoWD2oqWIwHB/D3dfeTG7t31GY/skAj4vdS1tzFpyQEFTlpZfFrDyTJhMsGWWm2hSJWQRCYeJx6JSuDUQDgYmdPa8rI18F10up3ksweSb2UsPWoZWq5Up5vJr/khZWXmqrtb2DgYHBzjxtDPzmphINPEpPZsNu00CTxJMltFRlColBqMJo8GEwWiksamJWbPnojca0emNyTfUshRW3FFOjtXr8eDzuqmub0zd1/f1Lq74nxNwWEYw1jUAoDdWc9OTL4Mo8sANV1JSVs4jH+xEqVLz+tOP8dzf/lKA4TLlVxhYY5XbG0mlTn+GJxwKUpb4umEk2wmTpwkzFxabdTg1m6WQdqHYzE6O+Ne/vTxHIDqdXvb/1vYOur7eTV/iU3rWxD+7zYbVbsPjcqPRajGZJPCYjCZmz5mLwWiiuqaGkgzfZzyAl7OEnAnMQwP85borGerrYaivh2DAx6yFS7j50edS5TR6A4M9e3j0na3UNrfywWsvcc/VvwFR2ssKh0Loq2tRqtSIooipvpGRgV7pO4cJM1to9z2zn8kO5gNWstDeAhZASVkZYmJVHgr4U+AKBYp+TGri4Bo1m/uDoRAlJSVFlFN4FobDEVxuNxarFavNhsWaBlFIUDNotbPu6XWYjCaMJhMtzc3MmzcXo1H6uHlaKXJzIGOinD4UAlZhR1khKHjzhX9y8yP/YvbCJWx469+svfHqxGCle7UGIwqlErttlJqmVhpa2rGPmgkGAqjLyvjJL87lhgt/wanLZiGKIuFgkFAwgMM6ir66rgBrZmwjpPJy/a7kj9RY9mLSVddhMw9QXqmR+V3BQNE3rSduFnv6+r6w2WzUNzTkoXf5LLQ7Xbz93nsSiCwSgCKRMKZqEzUmEyaTCaPRxKTOTunv885Lv9CQqlfM087YwCKVN8YKDHmdiSz01TUIgkClRkNpRQUNLYlnhpGIxESIICjQGUx4Eqdm1zW3Sqw32Edz51Rm73sA9/57M79YMY/L736MGQv347gFzZj7e9BV1+aZmGKeiVlo0n43wALp1Juh7l254JrgJ1kyU15wbVi/fo/VMuqpr2/QyJWTOwsRQK1WMWfWTKpNJkymajRVmnGzSyblF12GJ9tPlcsCG0WYIIPFMvuuVKkpr6jE6/WAKD10jsWijAwN0NDanuH4i8TFOKIoUlpRid5UzXBfD02dU0GEFx9fy4z5+zJzseTk1zS2YO7rZto++xadmOOdMMVSJBzC67TjddpRKlU0Tpo2RgkpVRlMRBMb1JngChQ/gGTi4AKsAwMD5llz5mmy2QXkwtJptRz2gx98S3bJt0stZ5d8LJabl80E43eUBUEgFpH2fDR6I5UaLUN93dS3tAPgdbnwOB3UNDannhfWNbdj7u8BEbweJ8/+7S/8/v6nU3VOmbsw9VGBYhNzXBMmHsfvdeN12FIREV6nXXq47XQQj0Wp0hmp1Buoa+kct+LLKqoQ49J+aBJcsWiEoM/nLVJs4mYRCFksllERphQ2W3lmIeMQFskfhQBSHFhjM0ERRxl5ey6H9FpZS+fU1PVkyExsvygjA/3c8ttzmTF/MS2TpqX60DpleuIYIpHB7j2cftkf6Zw1LzW48667J2tc+SZmuq+xSAS/z4vHbsPjsuNxOfA47PhcdlxWC0qViiq9gUqd9HSgrrWTSfpFVOmNVGr1OR+fH08SBCH1wDoUDCT8xQABv9ddpNheYS68bs9wjtkiV6ljs0s+8zgGCLLqJLNc0T6M4Shn9CEaDfOvh9dSUirFvw/39zLc38PIUD93//5SrCNmFn9vFfsu/wGHn3B64hQeqfx5196RamvynAVMmrMgkVd4tSpFRkjAcScebHtddjwOOwGvh7JKjQQWvRRa0zpttvSc0liDSq3+Jjodd1InQm/EeJxIOEQo4MfrsE/oqxmZqSC4HA67maQCE28CZQoLxsMu+cxjFpPlA0GyibwsVogJvpmjvPXDDay7/24WHXQI/V27aWhtZ87ipZx84f+ye/tWNq9/g2nzFjF17kKpb2OMKxoN4/N6cDvsuJ0S83icEngctlGJfXRGqnTSw21TfSOtU2dRZTBRodUnq0nX+R9IyY1UkExjOBgQndbhvRJuA0XAZR4ZHo7FEtEJZCpnvOySzzzmggAKs0t+gIh58r6ho4wU8Ffd0MQ19z4JyBknHhfZseWjBKikvHg8jt/nlQL7nA7cdhtupz0Vp+X3SnFZVQYjmkRoTdu02VKojakGpSq5rZNffpny+E+lSq2BUMCHuqSUcDCAz+MORvbCKc7JVBBcltHRXS63K/U6F5AWDHLBJLLyAkSel49d8pnH/CYmWUjeh+KOsrwPacXWNDQxZdY8WblgIIDLYScSCbP/ysN596VnJCZy2PG4nahLStHopeeQGr0JU30T7dPmUGWQTFmm6fxv7r6PNxnq6un9YmsKXAFP0U+yxBnHR9MzU0FwfbhhwxdWizWq1RlUQGI5LgqZ8U9jma0x2YVcYBVeABT2Z3L7kN9Ex2IxPC4XTocNt8PO9w7/Kf9+6jEpyM9pJxqJUlGlQauXmEejM9LYPhlNIjJClXFYWr5xpfNEotEIlqEByhKHtxUCVuaE+U8nraGacCi5HeHH6yz6SZZvZBKhCLisVuvIiNk80jl5SlNKWVnAGktYxdkln3mUs0u6ukLAyu1DwO9PRYM67TZcDjsuhw2Xw4bb5aSkpEyKwTJIsVnNnVOYoTegMZjQ6o3JSSSvN98kAtwOm7RXViW9WDs61M8/772FHZs/wO2wEYtGOebc37L6pF9lySP9IzWW/0Kq0hmIRSXMhAJ+Aj5PkMKm7xuZRCgCLsBlHh4aFUWxKSmQeFw6eTCfeSzMLmnpFTMHRX2kjHKxaAyP24XDZsWVASLpt5VYNEZllQat0YTWYERrMNDcKbGPsaY2dehsIROdCSzptXdpmf/2c+vomDmXlsnTEUV4+Ym1PPDHyzjzyptYdcypiMCN555I2/TZXPHAvzDVNfGXK85ltL+3wJj/u8ACUChVKBTS10bCwQCRUHCvbaBCcXCJLrfLLAdPMYAUBlYuwyUry2K3xH3BgB+H3Y7TIYXTOO1SOLHTlmCf0tIEcIzoDCZaJk1htt6ANsk+Y/ZBDizzYB9W8zDT56djxV5/5gle/cfD3Pj3fyOK8Oq6R9j/+0fQPGk6YjzGK4/fj7G2gZEUeERGBno55tzLMNU1IQI1TW18ve2TohPmv52SK8ZoJEIo4N1r4TZQHFy4HA4JXBmfSkMYm10Km0cJWLFYDLfLhcNmw+Gw4UxEh7oSMVkgPe+r0mgTADLS1jkFrSHBPiq1DCzjMdE+j4dXn3mCrR9+gLq0lMOPPzUVk7XpzVd487l13PrU66lx6U01DPWmD7Wra2lLvI8o8ul7byEolBz0w2Mw93Wlxn/QD4/h3qsuYOaiA/D7PAzs/pKyyqqC/uT/haTOOBfE73IV8rdgLzMXVovVnAIWCRZAGIfzDX6/PxUFardaU+bLbrPh9bip1GjRG03oEuCZMXueBCS9kdLyipTC0u1QYGUp4vN56dq1k6HeHgb7ehju72Xm/EUcftwpErB8Xs49ahX1La2sOPI47BYzvzvzeC6/628sOPAQ6prbMPf3yti5rrkNj9OOz+2mXKOlrrmN3ds+RRThpcfuY/WJZ6BQqNi64e1UuV9cfhNzl67gjktO56LbHyYSCXPPmv+RHrMIilyz/38glZRXEI/HUCiUeL2uYgDau8xlGbX0BgIBSsvLE4oVEPIBS4S+nm42vvcuDrsde+J1Kr3JJIUVG0w0NDUzffZcdAYTGp0+8YKGmFFXlu+V0U4sHueLzz5m947t1De3su9By2Vnp37ywbtccdbJHHrUz2hsacduGeHj997msAS4Xnj8QUrKyrj2vr+nFiXxuMjjd9/IPku/R11LO26HjcfvvgHL8CDm/h7MibemzQO9dEyfQ11zG++//C8Gunax54vP+PXtf2PX5x+nfarEGD57/00O/vEJzD1wBU7LCNFwGNvIMMb6xv9zwALQV9dhGeylvEqLz+ksBq69y1xdu3dvtzvs1Jc1JjirsPOt0eiYPW8BepPERKVl5RkAyd3zyQaW1TLK6PAQGr2BxubWVJ7TYee8E48kFAgyZ9ESnlx7D42tbdz4wDoEpbTBW9vYQjwW44Lf30hJWRnPPno/L697LNVe7+4vMdbU8vK6RxhOMFvv7p0M9nQRDoWoa5Le1nbarMzb/2C+f+zJ1Da18eujlmPu76F9+mxqm9sZHerjxUfv5ZCf/IzS8gpqm9rwe914nA4qdQZGBnrZ8Mo/ueGZ90AEramWkrJyRgd6MCSiW7+LFPL7Ug+1fS47WmMNzVNmjqusrqaegd07Ka/S4ve6i326Lh+4OoGzgFlAK/AB8CjwPowBri1bPuoZNZud9Q2N+kLON4nfOqMRrVF+fpaUl3/3PVnu+isu4fl1j0tv2RiM9Hz9FT887uf85tqbEYG7rvsd1bX13LD2CRRKFYFAgFNXH8jL/3ycw479OaIIGp0eURTxuJ0Yy+qpb2lnuL8n5XcJCgVdX35Bc+dUGlramb3vgdS1tFHX2JzaOTfW1jNv/2Xst+qI1LjqWtoY6e9J+FztREIh3n3+H9z2/EZEUcRY34hSpcbc302nzsD2Te9y3PmXY6iVJiOCwO2vbaWsSjshJysej+F1OvAlz4twShERUoSEDYVCSZXBmHq8pM54rDNW0ugMRKJh6VtDHvd4mascuAK4ECgFlInr04GTkYBmKQouwDY8NGSes88CfTGApACXkVfYR5Lfq1AoWbZyNX+85wFEEd5781X+96xTuOTamxER2fTOm1xw5XUMDw4w2NfNYF8PVTodG958ldXH/FwaaSJE1+/zYhChobUdj8uJx+WgSqtnzuKlfPjOa5xy4eWoysqkBYAoEgmHicViCEplAb+rXTruSJQOTZs6bzGzlxxIdUOz1Heliltf/BB9TR2IIocc9fMcE58E1ljYCgcD6XAapz3BQg48ThtBr5eyqio0elPq3AhTQwtVeiNVeqN0sMm3TKUVlSCKRCIhQn5PMYc+DFBaWnrE2Wef/UQkEim9++67S7LuUSKB8ArgxrHAFXY5HSMiTM80h2nwyIEFZKwQx7f73tTWweeffoRtdJTuPbv556MP8NOfn5ECaSQS5k+XnkdjazuNbdLhuKuPPpHOqTNSddqs0qeQtXrpZdy6xhYEhYLhvh4mz96HA37wQx6/52auPuckjv2fC1GXlPLV55/y/CP3ctXadTS0dtDUMQWvyykb15Gnn4sgSK9gCQhc+9jLOROmuqE5fS0LWJmr1Xg8ht/jToFHAo4UVuNx2hEQZGE1xrrGVGREpUYnHYybJ7lso3Rv38K0hfuPocrCSaUqIRIO4/d6Q6S9n+ykBh6+/vrrf3bhhReqXC4X7777Ltu2bct3Xy3QMha4cHtcw/mEJTORY7BYOi93972ptZ1tn2zmlB8tlw4XiYu8/+a/WXHET5gxbwGdU2cwY95Czrrs6twFQKLOXV9spa6pBY3egNVsZqi/h8oqDf+4706O/eUFTJo5j5uffIVHbv8ja/90BfF4nI5pszj76ltpSHxH8ZxrbssZV1PH1NxxkW5byktfCwUDqQNGvIlDR7xF2CcJnmLs43U5cFpGMNQ18PXWj9j08jP8+Ow1VOkMiKLIXRedzJwDVk4MXKUlRMNh/F6XFygh9xHQlNLS0nuvvPLK2vPOO08FoNPpuOuuu1i1ahWRiMyaBoEtQPmY4LLZbCOiCKIYF+QvTqRZDMiZtXLzmOunJc1jU2s7AE++8SHlFdIhtH+45BweuP16bnpoHYf+9Hhu+/2lLF3xA+Yu3p9YLM4XWzbzxvNPc/7vb+TjD97hrt+vIRwKcsScZvSmGhpa2zn48J/S37Wb7R9vonPmPPTVNZx37W1Z/Sv0IDnfuKT9OZ/bjcdhk8JqnHY8CRB5HDYQFImQGomBDHWNtIyHfawjmHt20zptTk7e8/fdjN/t4oxr76Z95nxeefgebj37WC7569Ns++BN7CPDHPrzs8ZSY9FUUlKGx26JxCKREJIPlQSXAjh+9uzZR/35z38uOeigg1Jl1q9fz+TJk/nNb37DdYnPTidEqAC+BGxjgmvUPDIUi0Ul8yDkKiBXOUmtZLEb+c1jY2sbCoWCwd5uJs+YjdvpoK/ra5oSZ0OsPuZERoYGuOikn6A3miS/qrqWo06Vntd5nE6mzV3ARdfeRnVjEwpl+kMJLz35N3p3f0kqdAYKAD/9dyjoTwTzOXBngMjtsBHweSmvrKJKb0qBqG36HCq1RqoMRtQlZXLWTiSXdSRxapCUgn4vt593Ir+87q8Y6hrY/PrzfPjqs1z+t5dy5F/T1MbHO18ApDelz7p+LXdfciq3nnM8bruFn5y1RvKbJpCqdAYG93wVRvKrkquBOuB/Tz/99JYbbrhBbTKZAAiHw9x2221cddVVLFu2jHXr1vHOO++wYcOGOOADfosEzqExweWwjH7pcrrQGQxAMfNIrtkibTYKMZy6tAxTbT3X/vocAn4fDpuFpcu/zzn/ey0ikgNw6gVrOOGXF2AZMVNWWYneWAMJJTa0thMM+KlraZMpVhRh6fePYO5+B8mAFY/F8Lpd0oNspx13Ih7L7XDgdkgfQ6jSG6hK+D6m+kZap81CqzdJxx2l4tvSdUbCIUb7exkd7MHrcmBqaGXqgv0k+Y0Oc8nq+dz08qcY6xoBKC2vpPfLzxnp78JQ10BNUxvWwd688q9pasMykM5TlZRwzs0Pcc1J38frtLNo5RFjqXDMpK9rwOOwRpBe4y8FVjQ0NPzqzjvvLD366KNTs2Lbtm2cddZZfPDBBwC8/vrrXHzxxVgsljBgBdYAI8BngHVMcG36YP1Om80S1hoMpUIBgCRNTG5evtAXuZ+GCJddfwdl5eU0tLZT29CEkHiYmunPqEvLUm/kkAGijmkzufyOB2XASh535HbacNls7N7+WSouy+f1UFFVhcYgsY9Gb6Rj+lyq9PrEcUdlGT4O5AQAACAASURBVH3NZed4PM5z999OpU7PimNOA+CSwxdTWlFJ67RZlJRVsOWd33HoKedw+Gnno6+pp6S0DMtAbwpcgiCkQDN90QHUNLXhtlt57fF7sZsHCQX86GvqWXnCGdQ0t+G2WwgF/JSWS2dmOEaGsPT30Ng5lbsuPoUL73yCksRb7d8maQ3VRCNhEWm1d/bq1aun33nnnerJkydDYswPP/wwF198MU6nPFD1oYceCgIfAzcDdiRgeWCMfS4At9s9ah4aMndMmtomCnKFF/dd8plHObCS9x+w8gcyxoFC7Ug/kpERTocUUuN22PnkvbdwOe04rFYUSoUU1KczoDUYqa5vomP6nMTpfQn2kZlHkWAgwHBfNyMDvYz09+J1Oznm7Et5+fH72L31E8694V5E4JN3X+Xpe66nc/Z8lh9zGqIINc1tLFxxOKt+9ksAnl97C7s+3cThp52PIAhUN7WyfePb2M0DWAZ7sQz24bSYsSTYqrqpFUEQGNi9g0lzFlJWWcUbT95P17ZPOOfmBwGwDvXRNGk6AP+8+48s/v6RnLTmT9x67vHcdfEpnH/7o99ofyszVWh1uGyj6oqKinOvuuqqsosvvlihUknQGB4e5vzzz+fpp5/OLiYimdH7gFeQGGs7GfthY4IL8FhHR0ZFaCNL4VITueE3xR7r5HOU860sA4moUKfDjiszLstuS7CPRoqCMEgmrHPWXDQ6I1pjNerS0tRrU8m6XXYbvV9/SZVOT8tkaRsjGg7zu1OPZGSgl0gohM/jYtEhh9LcOY36tk5EoLxSw2DXV6lxvfbEWhatOJyvPtmY6n9NUxvdX3zG1vWv0b/rCza++BQnX35TSoA1TW1sfu05Zi5ZRk1T2/9r77zDoyq3tv+b3msy6ZXQCUXKOSAqIKgIdhR8ARVUFA8iWI4VLK9HRNFjBQuKokesIDZUECkioihFikhLQkhPpmXSZ2Z/f+yp6YSAnvfzvq5JZmbP3rNn9j1rrWc997MW/c8+D299XYhcSrUGY0wcZ4wcyxkjLwRAIpXx9oK7Q9vKjueRnNWTw7u38+uW9SxYtRWVVsfc59/h6X9MZPm/7uKGR54/4ZVAPm8Dq19+EqmnQvfNN99Ihg0Ljzo//vhj5syZQ35+fuPd6gEX8CBwFPgdaOLX20MuobLSXSIEsh/RJGg9+94csYKPvV4vlZWiMsLdSJflKC9DKpNiNIdlNbbEJLJ6Z2M0x6A3mUEiBQT8QXclCOQc2I/b5SSta49QuXKXo4Kn7rqZ33f/TGJ6F8qLCkjJ6s6Dr36EXKlgxoOLiE1MQa3TM3VQGhNuvpPM3v1D525LTqf0eB4IAvmHfiP/4H7ufuUj5k86l2qPG7XOgC05nXXvLcXv82GNTyYzeyCvPTibu19dRXxaF2zJ6ah1hijCucpL+WFN2BrYktMpOHwAW0oGBYcP8PmyZ+k7fHRoW5CI+7ZtYvI/H8MSKIqi0RuZ99ZX7biMTVF49CCL/3k9Ey8dz3tbtkiCjVydTifz589n8eLFYQ8URtANPg04EN1gswV620MuyisqKiKJFRXQEmnFoi1RTU11oMBaBY4KkTguhx1HRQVVHjdavQGzNSZEom59+onV+2JiUCgjezOKIj63w4FSo0USUBj4BXj35WcwmMx8s/p93HZx6VZ8ShoPvfwuRmssEpmMs8dfwbxX3kUmlVNXW8u9Uy7k6w/eZNzUGaR37xP6XLYkcRl+Ru9wT0dbSjq11VW47OWsXbGUEZdPJTGjGxKplNLjeaR1zyY2OQ1TTBwzF74a+s4eveYCfvz6Yy6ZcSe2lHSO7gu3WgbxuGURQbwtJZ117y5l1+a1JGZ2Y9y02fx97OUA3PbsW2j04oW/9Oa72nPJWoUgCGxa+RZbP3qd1158jvHjx4W2bdiwgVtuuYXff/+9yW604QYbo13kKj6ebw8ePuTKaBwjic/v/uUnfvxuEy6nA5Vag9liwWgWC64lpWXQs99ATNYYdDp9lGw6SNia6mqcFRXYEpNDx3znpWf4+K1Xqaupwe/3M/XWu5lwwywEoDDvKBs/X8mM+x9j3KRp1FRX8eCNE3nlsfu46+ml6AwmRl/+P5QXF7Hnpy0cO3QAn9fL7q0buHDKDCI/V1xyeqgBQfBzWW0JyJVKjuzZyba1n7Dgo83IFEqscYmUHc8jtXs2tpR0yguOIfj91NVWs//HzRTlHGL89NsAmh0NpvXIZtz02aFKM9c/9EyoRlZj6AJLzzoDbnsZL997MwN7ZrJpw7ckJycDYhjy5JNPsmDBAurrm6hrGgAnbbjBxmgXuUqLC0uqq6pQa3UtxkhBwqV16UZCchomixW5QtHiyFIA9u74mS3rv6LwWA4FeaJawVPppkvP3ryyegMCAp+8s4xP31nGwjdWktm9N0cPHeDOq8eR2rUHg0eMISElA5lMzgVXTkUQBFQaLZNn38vDMyYGuoNp+eKd13n3xScYMmosXfr0Z8BZ5/Ljus8jzl08/7gU0QVGDiqQSrElpfHhiwvoN3w0lvhkCMRZQctjS06nob6OuedlI5FISO/Vn2kPPsPAc8cD0HPIWcx/++uo79RsS+CCqeHkZ0vEag8EQaC2qjIwneQQJ7WdFaT37BdVO2LHhjV89O8Hue+ef3LrrFnIZOKofN++fcyaNYtNmzY1d/h6YDewANEN7kYkWptoH7mKisvsdjuJWl2b2fdwZzGRhAf27mbF0iX89utOjGYzk66/hVHjL0MA9u36mTUfvsPcR54gKS2TxNQMdv+0lX/dcXPomJ+/t5xJM2aT2b03fsBosTDwrJF8++kHDD5nDAlpGSjVaqTScDPOrtkDaKivoyjvKEkZ3Xjjyfk8uvxTuvUbjIDAhlXv8kXRK3i9YkW94LnaUjL49fv1gQsW/lHYktP59fv1XHf/kxB47YCRYzHFiBURTbHxPPzuemwp6aE6V5FQabShNEJH4W1owOOsCE9oB5b7B6U2SrVGHA2bxAFOQkY3jLHi+dXX1vDuU/PAUcDXaz6nf39xSZ3f7+f111/nrrvuwu1usopfQMx7rQXeQ7RUrbrBxmgXuRQ6LfaKchKSU0JvGx4dtpx9Lzx+jBlXXMCEa2/k4edeZccPW5h/6w08Y7Yw6MwRJKZlUFdXyzkXXBy6mIlpGbgddlGtqjficTn56qMVfP7ecsqKCzFZYkhITafPoKEIQEJKOq6KclyOCgyBiWufV5QlSaUyfD4vPp8vRCJvfT0bP30fn89LWVEBcSlpoXOPTwm4xUY/mEtvuoPx02eT1X9w6DzPm3xT6PuRSCSkdu/T3u+8RZyoMiIuNUNc8m+JDXXFaIycfTt5+Z4Z3HzDdOY98BpqtRjL5uXlMWfOHD755JPmdvMBHmAFUAT8hjhfeEJoF7niEpI09ooKoPEosPXs+yfvvU2X7r2Y/cC/EASB7tn9yTn8O2+9+G8GnjmC5NR0XPYKPJViakEA4pPFxlSFuTl0ze6PyRpLWtceXDv3PmLjk0IlxoPvH6yX9fGyJVx7x3wQYNMXK7HGJZDcpTsSmYzhYy/j8VlTGHDWuRzY8SPnTphKTXUV1R531I+i/1lj6DNsZJMfTFbfwVFxZkfh93mp9lQ2q4xwRTRDaFYZcYIFR/w+L2vefIHfN6/hnTdf5/zzzw9tW716NbNnz+b48ePN7eoFCoB3EJOhOYhx1gmjXeQyGAymBq+3RWJFxlORSdLigny69OgVNbIcPuZCHph5LYLfT0KqqAAtOJZL1959EQRQqlTExCVQkJ9Ll+z+nDlmHGs+eAuNVh8iltfnZdv6Lxk2ZjxGaywanZ6fNnzN77/+gkKpYt/2rdz1zDIkMhkIMHvBC/y8cR2VLgcXXXsLKV17cfH0W5ucu1ylQiY0V02x0aR7KzhR6xMqONKK9TlRlBfm8+Kd0znv7KFs/HY9NpsNEFMM8+bNY8mSJU1TDBKJ2B3Y798JHAJKEV2hlw5InKGd5NLpTYbo1EPwm490j9HEEgTQ6gwUBJoxBS+O3mCkob4OATF5GBufSOGxHLr26kswnklMy6DwWC6CAJdNm8n2zeu5efxwBp8zhrraGn79cQsZ3XszdMx4ECAhNYNx/3M9ad16Yi8vZc7CJejN1lBqRCpTMGT0uEaDisY/ipZ+MNHE8nkbqKnynBbr0xF8/9n7vP/vB3llyWKmTJkStW369OmsXr26yT5yhRKN3kBaj+yyfds2HUScJywgXDL81JFLo9UZAjV3JSeSfR80/Gw+//A/2MvLsMSIv559O38mrUu3UBoiRKQAsfyIzxUFnlNrtCx65zN+2vQNZcUFCAJMvPl20rr2CL1PQko6xfm5nDfx2qaxX6PzDG5sjljitkhdVkVAVnP6rc+JQBAEDu36kc+WPsORX7dTV1PN+vXrmTBhAmq1miNHjrBmzRpycnKa7KtQqsjMPoPzp9zM/h+/k+7btqkAMVGqCvwXOJXkUmk1BmQyfA1epHJZi8Rq7B7PGn0h3Xr15a7pE5kycw4lhYW8/swC7nj06dCF7jdkGCq1Bj/hY86491GxvHiQr1IpQ0aeHyaBEE2a+NT0kByZiHOKsqqhbWIdh2qPB7ejIiTuC+qyXBVlSGVy9CYzOrOoSz/d1qe98DjtrH3nZXau/4wxo0bhLjgaarfyxhtvUFBQQH19PZs3b8bvb9RVRSJBrlAw8srryB42EmOMjd5DRyi//WBZ8CcYnKj00sFQs33kUqt1epMFp9OOJcbW6IJFEIswsQQBZHI5i5a9z/LFT/PlyvcwmMw8/tp7DBo+EgL733jXfJFYEe7KZLG2mB9rTCxBEDjvqmtpqKsNHVMgXGzNHRDyNdZlqXWi9Qnpsnr0FV1ZjC1cbFfo4Ld6GuD3+1i16G7mzryR96tL+fdTT7J27VomT54ces3atWub3Vd0g0Yuv+VuYpJSQ1NUCqVaL5MpdD5fSDQIHbRa0E5yyeUqg8FkxeGowBwkV4AJbblHvcnMP+5/tMV4pjGxmrqrMLEii7B5vQ1UVYpNMIMkOrzvV9xOB86KUqQyOYZIXVa8qMsymMVia5KIdY9NXWfbxCrKPYxUKiU+TaxDWl9Xy1Mzr+S8yTcx5LxL2n8FOoiVzz9GRdFx+vXtS9esLB5//HEWLVrEV199xVtvvdXifgqlioze/blg6kx0Jiup3Xuj0RsBMFhjpbHJKbaSYzl2IKi7PuHFsEG0j1wqpcFksZJ/cC8ZXQkxoXkSNB8o02ibv1GgHN4Wdme11TUBQZ+ohnAH+hmG29AZ0OgMVLqdVBQXcd7E6zDb4jBZbdHljiLPNcI9Rlvb6B+Ms7wETaD1McAv6z9n3YqlTLrjETL7DODA9i2sfOEx7lj8Hl36DmLdO6/QUFfL4NEnL95rCzs3foXUns+SF55n7ty5rFq1isTERFauXMmiRYvYvHkzubm50TtJJMjlCkZMuIa+Z56LwWojpWtPZPJwSUydwYQlLimm5FgOnCbLJVUqtXq1TofH4wmQoI1AmabEinx9kFgNDQ1UV1aKpY6CxAncd5SJpR4jdVkxCclk9OyL0WxBplCy7In5bPzsQ9K79aZr9hlY4xOx2hKaxH6RxCdwTnV1tUhlMrHfM7B93Wc4yooZc7W48mjelefwjydfo9ffRCXrx0sWUno8j+LcQ2T2GcCoq6bh8zbwzOzJzPjXYr5880VmPbWsRZ18Z8DnbWDli4+x4cPl9O3Tm4EDBzJ06FCWLFnCnDlzmDZtGoMHD+b555/n0ksvDX33coUCjd7IZbfcTWxSWsgNNoZEKsVsSzAEHgbJdUotl1ZrMOgFAXx+odVAuTlXVttIl+VsRZdlCOiyjCYr5lhbqOVJU8so8NANV+LzeXl53U5MVluzg4qaag87N3+DvbQIW1I6Z4w8H4lEhs/v46bhXXlg2aehYrllBcfYvWUdo68W+zzaktMoK8ijF2ez74cN+AWBPn8/J0rJMOZ/ZuBtaOC5OVPJPvNcev0tvIChs1FemM+Ld0yjJP8o9bU1/PLLLzz55JM88MADXHHFFYwYMYIHH3yQhx56iDfeeIObbrqJV155BYVSRXrv/oydOhOt0UJajz4hN9gcTNbY4PyVFJEfp9RyaXUGoz5AnEA6oqklaEysbz9bxb5dP6PVGTBaxGJrRksMyRld6DVgMEZLTKDgSNi6ELF/40UVBN5PQOC3HT9xeO8uXlizjUO/7qSq0kliehZZ2WeEzqMg9xD/O/0ykjK7kZLVg09ee44eXwxj9qLXkEhlxCamUHLsKF2yByIgYEtJo6zgWOhD21LC2vVv3nuNMZNuoPjYkajXAHTJHohMriB3/y4KjhwIqUU7E1s+fZcVTz5AQ10dfn+4cuTjjz/O6NGjefrpp5k7dy4rV65k2LBhLF26lDFjxvD6sjcYOeEasltwg83BYLVFTo6qOeXk0huMgiAK8lqLkSLd47DRYznnwkuQSGWhoL2lAUATYiESy+N2ceS3vQD0HDAEmUJ0YUcP7MVgsXLPpPMxx8YRk5DEzxu/5pLptzJx1r0ICKx6+d9kZQ/kjmeXg0TC2Gtu4b4rR7B9/RcMGX0RXfsP4btP36PX388W9VoV5ThKi/DW1yNXKgMiwVyK845wZM8vzFz4Kt+tXsEv68MrdARB4INnH+aiG+bg8/l4auZV3L30YxIzunb0ekShpqqSZQ/NYe8PG5r0RQQxrJg1axZbtmzh8ssvZ9GiRcyfP59p06bx/Q8/kNV3EHW1NShUatJ7Nl221hxMtng9opbeh+gaTx25uvToEavWapUCAmqtgWqPuLwqRAKad49iZZxAz9pWiJV38ACeSjcZ3XuLtawAwS/wxB0z2L5xLZk9s6l02qmu8rBwxRpiE1LQ6PQU5R3lrHFXMPdJUdu+7+et/O/1VzBo5Fi69O7P/u3fM2nOvECjc9HN9T9rDDs3rWXw6IuYMOs+XnvoNuZdOQKzLYGYpFQEv5+Konzi07OwJaez/6fvWP/ea5x18dWotfoomQ3AT1+vxl5SxAXX/AOVRou3vo6nZl7JPUs/Ji41s6PXBICDO7ex5J83UlPlxttUXxXC3r17eeyxx1i4cCFTpkxhy5YtjBs3jg9Xfcxll15HbGIKWf2GtPt949O66AEt4ryiilMZc8WnpCcoA0TRm6047PYACVrSdQWC9kYxUuS2b1Z/wLEjv1N0LJcDu3cglUqpranmoZdXkNW7HwADho1gzoIXxfa/CDx336288+wC5ixcQnJmNwBGXDIpdMxeg86ka9+BbF+/hszewSrNQbcqnmBCeheO7t2JIIAlPpG7Xv4war5wzrm9KCvIE8mVkk5J3lFK83N5aMU6QHSVrvIS6utqkUgkrFq8gMtuuTskp7lqzoNk9RvcrJVpDwS/n0qnndUvPcHWLz4M5e7awjPPPIPFYsFTVcW106Zjy+zFNfcuxGRLIKNXvxNqkmCNT1IZrDHmSntFkFynznLpjOY4lUr88oxmC47SAhJSU5txj2FL5m8UIzW2WFVuFx+99iIXTrqON77dgd8v8NKj97Dw9ht5Zc0PSKQyzrtyKi5HBdvWf8HR3/ZSnJ8rVvoTICmzKxKJRFwAS9hqJmd1p6woHwFI79mXg7u2c9ZFV4mnIoCrogy1Ltz0ighiQVB6LMZUscnp1FZ7OGPk2NDIypaSwVVzH8Tv8yKTK3j4vW/R6AxRxxg4ahytobWJ7YrCfHZ/t44ajxtvQ/uvqYCER/71GH+/4DIumjUPvclKTGIKlvjEUM3T9sJgjiE2MTWu0l6Rz6kml0KhtinU6kBC1MKxg3ubiZFEEoVjq2iyBW/BPwmpGdTX1XHJNTPE10skXDvnfr5YsYyDe3bRvf8gtm9ax3P3zaL/mSPp0X8wIy6eyEsP34Gn0oXWYCSzVz8O791J36EjAu8nUOV2YrDEIggw4vLJvHjPTQy78HJ6DBzGkb07+Wntp9zwyHMRFjUaw8ZdhS1ZrA0Wm5TKojU7sNgSQtuVKnWUerS5pVxtFRzxe31N5iYT0rM4sucXvn77Jepra/D72l/uXaFUkdq9NxdMvQWDNZbEzG4YrbZ2798YcqUSky3eFHio5lS6Rb3BaBBrRAhIZFIaGsSJ8sZJ0nBs1YhYUe5RfJyQKloClUYXSlloDUYSUtI5duR3uvUfxFv/fpTJt93PBROvE4P4/WI1leL8XDJ79eOci6/i46XPMmzs5cQlp3Fk3y52b/mWO557G4DBoy7kkuvnsOgfV6NUa5DKZIybNptB544Ln1MjjL76htB9qVQWWsTaGK1Zn2q3C4VSFaWMSEjPQm8eIhYdMVmijlVTVcmbj9zOnq0bqKupautyhCBXKFGoVFx43SzSe/bDbEsgMbNbm6PB9sBsSwiOGBWcYGODqHNs6wVqrd4QmUPyi1ySNEesxu6xpZFlXEoaEqmU3IP7scYlhJ73er3I5HJxcrmhPvS8XxBY8+7ryOQKSvLzyOzVjwsnz+Dwnp3cddlZWOOTcDsquOSGOWQPPSe032Uz7+LCabdSU+VBZ7KElps1R6xIdNT66M1WTIG5yfbg6N4dvHD7ddR43DTUt1YaKxpypZKeg4YzcsI1aI0Wkrv2bELak4HRHBOZjlAAHQoi2ySXSqs2hMgBCP5oixVllWhKrKj0QuA1coUKW0ISq5Ytpt/Qs5HK5Oz5aStlRcfp93cxEXnBpGm88cR8dm75luL8PDJ79eWciyaE5heRSrn1iZdwlJbgdtpJSMtCrlQ2SY0oVOpmC4S0R9Sn1RtR6wxtWp8ThSAIfLV8MZ8ufZqGutrw9FgbkCuUqLU6xk2fTXLXXsQkpBCf3uWE46q2YBRzXRJEq6UGWmuT1yLaJpdao4t0bxK5nAZvA/LAapWW5hejtzUdWSakZuAoK+W2y0ZhS0plz09buPGef2GJS0AQ4KJrbqZbv0HkHvyNjB696Zo9MOo9gsc02eIxxcY32gY+n2h9Qj0MnZ1TbK051NVUI5FI2lWvweNy8PK9N3F0z472jyoD84K9/nY2I66Yii5grTpzyVkkYpPTdIjBvBsxLdEhtEkuuUJliLxoeqMFt8OOJTauRUVEcyQAotxjQko6SRlZXHHDbHIO7OUfDz+NNT4h6pjd+g2mW79BjQYO4WPWtdDD0O2wU9tKD0O9ydLhwh0Hd2yjtqaKfoHV0OtWvMrm1e8wb/mXbe6bs28nz99+LdWVrlZzV5FQKFVoDEbGT7+NhIyu2JLSiEvNPKVzmHEpmTqFQqVvaKizAx2uz9QOcikNodGgX5DoTGYc9grMMXFRxCKSWDQlVuPse1xKOnu3byUxLZOE1MxmR5Z+nxeP2yWqIQI9DN3OCjyBskcgCZFFb7ZijexhqDeBVBId+7UCn7chFCsd+fVn1r+/jKKcg+iMZi6cdit9ho4E4LefvuPYwb30Gz6ao3t+4dOlT3P/ss9bXTomCAJr//Myn7yyKCTmawsSiQSZXEHf4aM565JJ6EwWkrN6tjov2FkwWGOktpR0W2HOwaOcQsslUSiUhmDHMgEwWGI4/vtuMohOL7RkxYDobX6RRAmp6XyzagW1NTVifSynA5c9ICtupoehPtDDMKNHX7F+VlS5o7a17yBqrnL27qDseB5lhcfE/wV5lBfkkd6rH3OfX0HBkQMsunkC466/jfOn3MzuzWt5/vZreeDNL0jr0RdbSjq/fPsFVW4nL917E1PuXkBiIKnbHDxOO4v/eT25+3e32w3KlUr0Rgvjr7+NuLQup8VaRUKjN2KMjY8pzDno4xSSS6MxGHRBYiGIiypqqmsiLmbLxBIINIKqDBRbs1eE6mSVFubTc8AQ3luyCEOgBZ0x1MMwLCkOljuCMIkap0EInYu4rbbaw4ZVb/PbT1vw+3ycedFE/j72ctwVZax580VsyWnIFUq2r/2E+f/5irjUzNBi1o0fLafnkOFcMuNOADJ69yf/0H6+XL6Ymxe8TGxALfH6g7NxlBbhtpe3+OUd3LGNF++cRm1NFb52JEUlUilyuYK/X3AZg8dcHLJWJ1s58EQhkUiwxCXoESXOp4xcWp3eEIq5QLx4Pr/QIrEau8ePl79MbW0NBpMFU8ACdUlMof/wUWLNdJWq+cSrQJTlEQQBn9+HXxCQSuUhYn20eCF7ftjI7c/9B4M1loaGehbedAV6k5WRV15HfW01Hzz7CDUeNyOvvI7bX1gBiBZl3YpXMZhjo1ZJVxQdJyVQYimIAeecz6olCwFx9XV9bQ32kkLue/1Tnp0zBb3JwpkXTQy9XhAE1ix7ns+XPdtua6VQqrDEJTJu+mxiElOIS+1CTGLKH6bXN8bYDIjkkhFdJ7XdaJNcGp3REBkHCQTbxglhwkX8aUy2y6+fBUH5TCOLEzl6FARxeXne4d9wlpdhtsWTGpCvCILAV+++zn+eeojzr76ByXc9AoJAQ10d3370FtWVbkqO56K3xPLj1x9T5XLywJtfhOovKJQq3n1qPiOvvC70wfRmKxqdgbKCvFA5IgC1To+roiz6SzCa8AbyUObYeBRKFRNufYCsfoOZ/e/lPHfbVLQGEwNGXECNx80r98/k4I5t7SKWRCpFJpfztwsuZch5l4atVQeW//u8DVS5nVENEDwuB1WBkfL4629r9wjTaInVEU6g6uhsclniU0wqrVYb6X4ERCWpX5y3aSbWib7fmFj2shIO7d2FIAj0Gvh3dEYzggB7t3/PC/ffilKlxhqfyJG9uxhx6SSuu+cxcZRqtqDVG/hx3aeMuHwySV26c2DHNrpkD6Q49zCl+Xlk9R1Ece4R9GYrGz5cTllBHqXHcynJO4LbUY69uABrQnLo8wXLGAXrlwL0HDyc1S89SV11Vcgd5ezdSUJARiORSolNTsPjFFegdz9jKDcteIlX77+FSXc8wuqXFlLVztGgQqXGGp/EuGmzsSYkE5/WBWtCcqvW6kQX3cYmSbAQ/wAAEF1JREFUpXWoGYIlLlGPKBgE0TXa271zAK2Sq0tW90SlWtskYFZpjVRVVqIzGCOI1byuK/L5lx+9m29Xvx+Q0Thw2ct58oN12JLSUGm13P38W2T0zEYQoLy4gNsvHsaIyyaT1qMPtuQMqtwurp8/j7eeeIB7XvmQPT9sJHvYCHzeBkqP5yAIYrWYsoI8Kh0VpHbvwxkjL8SWko7FltAkII5tVMwWYOi4K1n37lJeuHMaY66+kaLcw6x//3VmPrE09Jqeg4YjlYUTl/3PPo9x029jxaIH8NbXtZkUlcpkyOQKzrlsMv2Gj0ZviSW5a08UShV+v1iOvLnZAbe9XGzF0kn5udYQn56pJ7xIo0NxV6vk0pjN8Uq1Oto6AXqTFbfDjlZvDKcXaBojNQ7Ax06axrR//q/4JQoCd04Yxe6tmxh95VSyeg9AAH7ftZ3fftlGYd4RZAole3/cTFr3PsSlpOPzeek56Ew2fryC7d98zp4fNjDriaUUHj1EWaCuVo/BZ7LmzecZddV1mGLjQ5/F523A11Af9ettrM8CcXL6riUf8Pmy59i4cjmm2HjuWPweXfv/LfSaqfctDN2vrfawdN4sfvvpu3ZJZBQqNXEpGZxzxVQUChVVlW6qqzzk7Nt5Us0QOhsWW6IyNiE5pry44AinglwqjcqmjOo+FiCX2Yy9OJ/41IyooJ5WiIUAad16UV9Xz5Hf9rD7B7EW1KCR54MAPr+PJ269htLCfP42ejz9zhyFs7yUwpzDCIhSELVOT2nhMa6593GenXstEqlUTCwmp7Nrs1j/qvvAoXTpO4hnb5vCRTfMxRhjI2fvTjauepvrHngqqtNEzyHDKc3PafK5TbHxTLl7QZPnG6Mo5xDP3jYZV0VZm8SSSmVIpBKSMrsRl5pJeUEeiZndUWt16CII1JnW52SgM1mJSclIKi8ugFNBLq1ab5IE6l6FLZeAzmCm4ODeqCRplHuMIFZ4m/haR3kJi+fPQaMzUFtTzS8b13LuhKns+n4jR/fv5oWvdyBXiEvif/rmC0qO54beNy45ndL8PEZOOIfLb7kbfaDlsJgeEHVYUqmMuc+v4Kvli9nw4ZvUVleR2r0P19y7sEkLk2CWvSPYvPod3l00r11zg3KFgvi0LEZdNQ1bcjqpPfqEanv9WSFXKLDGJ1oDDzuUC2ndchkCI8XgSDB4XyrF6/O1mH2Pdo/RbjM2KZVFH34LCOzbvpVHb7qKsy6eiN/nw+fzhqowF+UdZe+2TYE2vuL+tpR0SgvEZftnXXJ16H0yswcyLlAiEsRia5fO/GdHvo8QWip35K4o5cevV1OUcwift/XclUyuQK5QcP6Um+nafwjGmDiSuvQ4IWXoHwlzTEjXFWx7d0Lym9ZjLo1OHyJWRMyFAD5fYPQYOUL0N00vNKfrCh6vtDAfuVKFTCan99/OwmiJ5d6Jo4lPzST3wB4mzZnH1jUr8QsCEiRccuPtqNTaqGMCWOOTOHfi9BP53MCJj7z0Jgufvfo0LntZm8SSK5Sk9cjmgmtmojfHkNSlB0Zr7Amf4x8JvdkaKf8I6urbjVbJpVAp9VGT0RC674+MtSBkcaLTEtEkKMnPY9nCB1BptJQcz6M4P4dZj72IRCpFpdbw2Ltr2fPDZpCIsZPWYGLE5VNC75Pes1+TY7aG1oqttTnyalRw5Nfv1/PqvH9QX1sT/qzNfaEKJUq1hguvm0Vaj2ys8ckkZGSdVM3TPwo6c4wZMR3hp/PJpTZEzK5EjQQlMgX19XXIlapwDizSitHUPVrjEzj3isnU1tRgjU8iK3sgiggNllKjZeCosaHYra1jwukptrbxo+W8/8zDbSZF5Uol3QcMZdTEaehN1lMqizkdiEtOMyPGW5V0IO5qlVwyuaiIiAzmg/f1phhcTgcxtvh2Zd8FQKZQMnjUhY0Sr9FpDCG4Q+CfN2B9grosj/P0FVvz+3188O+H2bz6nVaJJVcoUWm0jJt2Kynd+2CNSyIhs2uni/hON6wJSWaVXh9T5/FU0oERY+vkUikNkcSKtGJakxm3vaIZXVdzCoXo/RsTK1juyONyhGpmeZx23E47NQFdVrBSse40FVurr6vludumkLNvZ8symYCIr9/ZYxh+0SR0JjPJWT3F7mb/B6C3xEiSMrqn5ezdkUsnk0ul0ep1UYQhMtcVQ+Fvx0hrRCzxRZGuDPyCH3tpcaDpZUCb5RIVEh6XE5Vai8EiWhq92YotJZ3M3gPQWayotQYiBxSnCxuWP8ut0ydz66zvm92uUKrQGc2Mu/42sbDHaZbFnA6otXoscQmJOeLDTiWXVqs36CPdViRpFEoltbXVEduaiZECQb0ECVu/XI1aq0dvsWKMiSGpSzcx62w0I40sOBJxjMj82Okk1m/btzD1otFcNH48P27bxttvvx3aJor45Aw8dxxDx16B1mgmpVuvZuvP/9kgCAK11Z4may1bgkQiwRwbH8x1aWm5/3WzaJVcap3BGHnBIUwYAJ+/EemaIVZw2/hrb4lyj63vxx9GrJqqSup/38rFNz8NwBNPPMGmTZs4duwYCpUaiy2Bsdf+g9jkNGzJ6diS0/9U1spbX48n2PzAKcaowXUDVW4nGp2ei2fc2e5Y1GiNDaYjpITrpLYLLZJLr48xqjR6XXR+K9qK+QMP2tR1tRp3NTMKjHyuvZ+kk7DhzWd4ZdGjoceJiYncc++9PPDgIwy/5Gq6DxyKKSaOuNTMk+6K0VGcimYILUFntkTmunR0BrkyevaKV2k00uaIFSSBHzGeChb7iCRWdAohbMUCh4p6PsjF8Lb257I6E/u2beT8oQOIsYqe4Ndf9/DqsjcoalAy/aFnMFhiiUvLbLdb6Sj+TOXIzTEJZsJiQS1Q0d59W7Zc1ph4RWDSOugGo5KmAqj1hkBrO1MEQZqTPdOCC2yf9v10wOdt4M1H70Qthfj4eL5au47CeiVZfQeTHRNHXGpGp5Lqz9AMoT2IS0m3yGQyk8/nK+UEg/oWyaXQquOUKnWUZYkO7AV0Jisuu11cadOieyRs9RoRi8jj/oHEAtj93TpSu/cho1c/Pv81H2PvsxkQcCkdWXHzZ7I+JwNjbJwqNiUjsSTvSOeRS63SW6RyRXQwH7ovkkhrtOIqzGl2aViUrivyecLEaiv7fjoxcNS4UIUab0NDuyaXO2x9rLb/mslrndFMbFJKWknekd2cYJa+RXKptJpGwXx0fCQAGoORokp3FDGi46fWs+/Nuc4/A4IXvlXrU16GTC7/r7A+JwOZXIHFlhgsm9M5lsvn9TY0R6xIyyKRSPD6/S3EVi3InmlKrMiR5enG/w/W52RhiokLTpAqETnjbeXlIbRIruOHDm+sKC682xKfpIgM0hsjVBgEIuKyFmTPEH1rNAA4FfjL+pw81AZjZIZYSzsLk7RIrj3bvtnw/WfvfTZ22q1XyAK12ptD0/ipBdkzzbnAkyeW4PdTVemixuOmJiiv+cv6dCpqqyojZ+01nCy5AN+37756fYPPX/e3MRddYkvtomvuQshVaupqawNL609N9v1Ei639ZX06D9Uup3B414+7Ip5qWczWCO351iUpPftmp3XrNUqjN8WotVqDIAhpUqksTqXRqOs8VTHjplzfxRqf2GiKqPn0gtAMsVortuZxOvB5vU1VoYHVMH9Zn1OH+rpaPl6ycOva/7y8CDHO8gHraGfM1dGfdH8gNXDf+q8VXy/Jyj5DB01zWZFWrKG+geNHfsMTaAAuNv8WZTUavUEsNhLoIqYPtKPTmSx/2DTL/28Q/H6qPW7cFWW+/N/3FO7+fv32bWtWriC82no/J9CSuKPaWxdhcrlLj+U4s7LP0LVGLEEAn6+BYwf3oTNaxHJHPfuiN1nQGk3/9cK6/xY01NfhcdpxFBf6S/KPOl0VZZ5Ke4XHZS/xOMpKPM7SoorywmP7vfX1vxIutlsPHARyT+S9Okqu40BXxBW5Xqe93CEIJDdOkjbOvivUGoZffHUH3/IvtBf1tTV4nHacZcW4Ksqoq63GW19HQ10d3oZ65Aol33/24e6cfb98SbSLqwvcDiJaqerAzU0Hxl0dJZcX+AkYDGgr3XbHnzn7/n8NwYUnbkc5ztJiqlx2Gurq8dbXUVdXg1QiRaZUotHqUWl14pyozoBEKkWhVKFUqtgmX1WAaImChKohHKzv5QStVHM4mSUpbmAjEFfrqT4qwNnNZ9+jVQ9/oX0IjpDdFWW4Kkqpr60OEcjrrUcmVyJTyNHoDCjVWpRqMS6VyeUo1VpUag1KtQaVRosycD9YqjNn/66q4txDa4CiFt6+w40NInGy6538QHFtddV+wecLFWprmpn/i1uNEbI+5aX+ssJjXmdZcUN1pctX43H7qytdQkNDveCrqxc0RrPUaIlVaPUGlUKjUai0Wkz6eHQGM2qtDqUmgkhaXZuxa5XLIax9+6UvPS5Hfisv63Bjg0h0ymK6SkfZAU+lC53Jclqz7392BK2Po6SwvrzgWKXbXu6ptJd5nBWllY6yYo+ztKi88OjBYsS4JjL28RF2V8He8qg0Grk5Nkmnt5jNaq3BpNEbdGqdXqPW6jVqnU6tVGs1SpVGq1Sr1WqdQa03mdU6k0Wj0ep1Pp/Xl7t/d/7P33y2Yfd361a3cep/CssFwJ5ftu53O+z1WqNF2ZnZ9z87QtanotRXXnis2l5S7PE4yj1ue5nHUVLscdlLHQVHfy+u9VS6EBWcEbacesIEirxFxj5RqKupoST/CCWt2Zww5Igiv+ANRKFfe6zSn4dcdW53maOkqCQ+PSv1RLPvf3YErY+ztLi2ND/H7Sgv9lS7nJVuR7nbUVrkcZYWlRflHCr3+/21RF+USOtTh0iuyMenGt7Arf09X8LolPPrrDXmbmdFaQkCqf9txArODlTay7wVJQUue2GBq9JZ4ax0lDudZSVOt728pPDwgaOVLns54CTsvvyIhAkO14PkakC0DlJEFYEi4n/j+wo67xp0FiI/40mhsz6YUF3lLv6jFlW0haD1cZWVVJcW5DpdFaXOaqfT4bKXOR3lJQ5XWfHx4wf35fn9fhfR9RAaCJOnGtEKBO/X0DkfVUrzpGvpceTznQ0BONBZB+u0X0212138R+Wy2mV9cg4erbSXt2V9qhrd75RfcFunT8ddZXsI2JzlbG7arwYxv9Vy7fMTRKeRq7wo/7DP6z1l1Vxqqz14nA4cJQXu8qJ8R6W9wulxOhwue6nDUVJcXlF0PL8471ABYv4tcvnT6bA+fxTq6VjaQE402RroYBa+NXSaFsWa3DXl+vmP/9BryNkpHdnf7/eJJa4dFQ2lBXkOZ2mhs8rtdLjt5Q5XWbHdUVZSVHDk92M1HncFousKjqj8tEyeak6iX+BfODl0mpmxFxw+vu3LVQ/qTdanU7v3abZnXF1NtThpWlbkLsvPc1Y6Kpwet93uKi91OMtKKuzFx/MLjx48jkieSIFaHdGEiSRRuxdp/oXTi05X0fUbPvrsHoPPnKnWGQcg+ORVbpfDbS93OstL7O6y4uKC3MN5VU570PoErUpj69OYRH9Zn/9CnEqJpgRID9z0iLFBDU3dVtD6/DfHPn+hGfw/vlKssXVeMOgAAAAASUVORK5CYII=',
    'иконка документа':'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',
    'заголовок1':'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',
    'заголовок2':'iVBORw0KGgoAAAANSUhEUgAAADAAAAAwEAYAAAAHkiXEAAABimlDQ1BHSU1QIGJ1aWx0LWluIHNSR0IAACiRfZE9SMNAHMVfU8UiFQc7iIhkqE4WxIo4ahWKUCHUCq06mFz6BU0akhQXR8G14ODHYtXBxVlXB1dBEPwAcXRyUnSREv+XFFrEeHDcj3f3HnfvAKFRYZrVNQFoum2mkwkxm1sVe14RwgiAOIIys4w5SUrBd3zdI8DXuxjP8j/35+hT8xYDAiLxLDNMm3iDeHrTNjjvE0dYSVaJz4nHTbog8SPXFY/fOBddFnhmxMyk54kjxGKxg5UOZiVTI54ijqqaTvlC1mOV8xZnrVJjrXvyF4bz+soy12kOI4lFLEGCCAU1lFGBjRitOikW0rSf8PEPuX6JXAq5ymDkWEAVGmTXD/4Hv7u1CvFJLymcALpfHOdjFOjZBZp1x/k+dpzmCRB8Bq70tr/aAGY+Sa+3tegR0L8NXFy3NWUPuNwBBp8M2ZRdKUhTKBSA9zP6phwwcAv0rnm9tfZx+gBkqKvUDXBwCIwVKXvd592hzt7+PdPq7wdVc3Kbdp95qQAAAAlwSFlzAAAuIwAALiMBeKU/dgAAABl0RVh0Q29tbWVudABDcmVhdGVkIHdpdGggR0lNUFeBDhcAABSkSURBVHicrZx73GVVWcf32nufc973nQuMQiJqzih5STEtQK2wSUswiSIzMXIcMxQwzBJMh8pR0oy80I2gEqYkxC6WdiNvDWpAGlppClQ0ioaiAznvvLez916rP/b3u/ucxfvysQ+uf57PPmefvdZ61nP9Pc8+oehHDa2y6zF0Ap2HLmR0DjoqZkcHXYOuZtdTaAsN2Tqcdy6j4+y+lD0nn0faQCO0hLpf1z/OqJ87n+v0Oc6b73Mlo34+7NuJXYgTOKEbltFboEdk15uhMswFumEXcBi6lC3I+xxu3APflM3j567fA5ABy9l8y9n3Ms51Op/7nc+u3Zfz+TsFTIbm+1zM7ne43uQDc4l3ATL4SOhR0KMzug0qo5zQDR+C3gP9n2yB3udw41uz50tdl4yRoTLa5zvf16AevAeu4DmfB7wlowqg/HF/Sr7zus+7oQeh+cHd6wB8sBMp4TL4WOh26I6MPgTqQalJbvgu6H9n9CvZfS7QjTu/zz82+9z1yggZ/SXoF6F3QmWMkuo6ZfwDoN8EVeDcl/O5TjXYg3beL0A/n1174I7hAFyAEvZg6COhx0NPYP6ncH0S9PFQGaQJc8P/Cf035oUWt2f3uUAZzPzB5z8O6sHLGE2AjL4F+inm+yzXn4N6UB6AjP5m5vsWrh8BfShUwXSoaTKaedI/c/1J6L9C1Vj3ORyAG34Y1A1/Nwv6Qa5/HPoBPj+LaxnjAarSqiYbTjAk/DWf35BtwIUdl80vA7dDFRglVYlWAtGwxPPDO/n8Y1APSkHxQBWom/gd8w/70iRq8pR8Gf83/O43+PxP+fwvub4eOhyEG1bSvxMKo8MbuP4g19iu8hmz35d/B70VimSX/8h9+7h+GddoUECiAqockOTwQOhO6AXQa3kOklXeAf0PqOt8C9c/xrWahNMMmMQAAwOmJXwHv/tJri+FwsDyI9D9fM7Bhov4/Olcq1kfnV1P8SLo90AfAy3eBkVywkt54IOgMKjG9o0wUWM2NoZxExYy+XXod/E916P38xwksGYhFba6+iqfP4f7kdARJmz8Hp77o9A/hP4KFEaOT+F35/C83+H5HECFBlZoRI1prW/jd7/Lc86AcsAT9juBL+ProPisEZagxmRXT+xpeXpPw29D9SXXelJsRNUJ/w5FBcsnQLGNFZJbcV/FAVUwqiKKKmF8iUSXSvCLmVdJfiX0RigbK7+d53Hg9U9wjfOuPMD/mn1uqYT/GvQz0E/zvZrLetXU6q+gMKh6GtR1XQN9IZ/v4Ro+hl+FcoDF90PVAH3PS7jvpUh0OB+KLQ6nzS6s5LrCxlVIcKVK7uR3MKjAxCScW4KRHTYw8tyoKhp9cH/gukQiy++DYiJLNEnGpvdBMRURjYysN6LZ8Re4j3UGNCkoqdj+Eh9Wss+AgARtOAec8EUR0xMxSR0a3P0QnyOIuo5hHQc5uRKJCpgMJaN6b09rnPLoxJ6O/wD6A9Bfhvr9bn7HQdRv4rkydi8UxgwSiKZU+5gPho//GIpETYhmxudBf4l5kPCKIKH8Waga+G6+x1dUb+d3hLkj8pjxTuijoAjQ+Ke4TxOnJqJ5FdFP+S89Dex7cPb4hIIDL05CA0qdK6pccWNNODfCdo6JasY/39PJ9/L9o/mdYRsnHAm/WmxtQxTUEPe3hJER219o6lDREbZ0hLMaER3VMKpE0hMH0RFdtGh0A4OaV/M9TjtBA1FghabVRDv165nvSXyvKTaKIhqKJ2TzEY1NMWFTDmSK4LQcZEtU2Z3JAVQwpIJxNZL/MuLfS/YX35Cxi+feyMYbbHQHY/+c+074vfs3zxew1afgY6ZoTEtmGv+2p+VVPT0aE3LOyT19+vN6eiwWocEnfQ7J3o8tefeBni7+PfM8t6erRIErz+caU7mGwE0vZz0P4gBqwscKGzyCARNUewsSdyIa8Ho+f8yeYt1xAxJ7FZJzO/H10j+xMGz2mozBlBVsYBuZ+bMu6elFhMuTT8zOE7/c0yuQ9A+x8a/gBFdweqs40wbJTERTT8DGX85924QSvs7xJebZS5R164d7uvxnPV0i6FhCM5cv7ukaJnv6BjYWsIWBcKrE2ZRmkpimz+K8rvqR+17YO1nIIpK9iYRogYOe/ElPx8f0dPTDXGNjp1f29H3Md8MGjLntFXwPphRQ8c34joVn9XSe9c8h0Q97c08vxzT8fxnvOAZT+SY04pGY6iN5/hb4uYAAzv1iT0ff1tP6PDNhnGcgbg4wrCQfqMg4jd8XzeyGRGJ2dDBiE6l6BGqYcjAjMsSGxCyi2gW2uQLbGWFKDgleZWPp3J5uvoz1mQFjatqXsx6xJ5zzy9nHNg76w8/u6XsxSXfCj01ENcdzQGfgSx4q1MA4kvW/GCjjrT/NvnDO7T/0tEFgBh/4fDPhOzIqhIC3DjAskPDcCz5mJKMiGD1+bU914rVxuuEmkhpw9oGEzEy0RNPSG9efLxDmTZ7JfGToIyCJGltf4ay3ntnTUxGMKzmgi7n/VqKoBgausv9Psd+3EF7eKoiYjRMxudtwypsIX+fxAROiyxEHUO/yAIiXE84hYePThVAkTPx7SDTyga+oAeVqDqzieeFnoPu4nzBvgKVFNXdyH1FH+OD604VXMY9hM+FeKcSgoHBQT8G0foxE8ko0qGM/7VN72uBLpqxrysGsYNuvxrZ3gnaMGo19CAyePLynRo2GtzV5RHkdB5CwyQVOIpGgiIImoqGEM0vvL9YfOM8K2x+wvYJ5AyPFmh7LtXDzdqhYESpb7F5/uiAGhVMV2xFvT4CLCdDwUWS6VxKNtKxjSnS2eqCnyySIy6xvCQ1ZgsFfBpK4XRAwGwnNrc7uaQ2mVAH6VWb+16sB2PSE8yhItRPOIokCCseev/7EwrsyvERlhZMD0YCSGQwCcFaBeQKSLOweXrPBfJiqwrAVJx8xoZG4voORl+IEbyaDX8NkraBJyxzE4Z09XSSMXETSD+NDlmDkPR+YXU6Ejwf5nRlzeAcUTQ2Ex+FqnTBOYoCN90IpJCRUM4EWpouK9YcMJdoISIDoYYlKlzjvEgkssbminhWqXrLRcNsG8wklIJFqZiKqi2S+LZrSgkY2mMgIJhRw0hXhodjSFIyrQQM6NZIEbNM1s8u5BWxsmeitI/iIhL8RE5g48HSJB2ABw8II8bq4eAEDElHAkDGdPLsANWAA4UhgqtdBBdXINGszSkqSwYQQgaiEs7P43zGYKDZUEMUk8ovuZiimpyHqmZKHdIafrFPJrLD5o49zHwwv2McIdHSHJhTGXw+Dp5jQBmffsq8O0xjNyC/zAEhohpqmKb42W1Svyu7PB88rMQGV2AvRT42K1sDfI5xywlkFMRkYOOLAy2M2mE94F5NpEJCQcH1WhyB1hJeNoNmTuc9KGeGk0ES0VCrUAkh3PKZsAcYf4PcfYb0tmjgleJm+lc+BwTssSzzgAVjF16kYlbgwK1bCqYBb+QhX9PTi9b8uitOz61uy6zzcvKO4zxGE0Y12RGFJ7CLrFLXUhHSYnpb9RRgqKpxEQYXDEZAWAT0Tp5p4/mVo1ipwfotmrDLPlM8bLMaABV3gAbgBw8C8n8Xv7Zaw9puNhES/jni7wUkt4gu+hm1dJG5fphTaWFpkwWMOfNO7eno2PuOUS2fnC2BXgmqFecqHoEhgJLEcnDNOvft91o3kDk5fGBkNS4CTT2P+J8GXawhfP42mWUdp8F2rZMBrWIyG8LUlOIlDHuBIGXW4Mjc6X9znCJQCC/KI8JtQfYdO3xqxBSBUPwjnktAVp20wEZWpQSDUUJ6fwGgKMnrziwTqmjCtifVZlwj4kpKweiuo7h74dfPP9fTtmOSGfGYNLGsNQVz7o55O2XeDxrT8vrsib8jKO8Sk3mcbxkY+AEwkotpGS5HMN+LsIhloRCVNaDpsbQdjOsC+DZCIIqH6CVh8MGFEPUPXhcNmA+oE5iklGlFSUixx3jV8eTO+cAXN3sN+WvjT4jMb4Os1TNmUTHx63ex98VuhO/LGJON9K1RHZ9celP02+cCEJfKFznBM1SMPaDA1DYleg4Y1fg9E0WIi4jM2mI/nJ6M0sKziAPRU6F/0JHDAJfBxBVRS7eppjUCM8AGvxKcdR4J3Php5GI1K/K4DsmjEuBAo99lxfwd4F6nwpYMegE7V/heciF0COrdBgtSUfHAAHeFXB4MFxRo23uDcGvH6fVyjss0BKM4qZSm/IyGRyYIOlbqCilWwawLNsLRZWTznoEfkI2MY+kI+P40w9Bx84N3wq8ZnmXknTGHEN0Qy84hAJwRAk6dAFPd4APbFyHBg3AECEMMhYRraV/IBVpRI5SMZqvFvh+oPKksU0xLHN5isloy0RfPihetPp4lL+ghBPmvJHKgl0No4nnBwTKY8h4CcgS/YRVR4Lj7kEIy0FDrCB9aWcAUTgT5sf7GpIIA5ldj+AZrZ6gHIeLz/kOD8FteemI1HJj75YGKL05EFRqKazuI0kmgJscOkdfiWDsZ3Srhhcj7MRG30siuBjLpEcGpMQY1Ej4nC5ojHT6cO8RIStFcAjazQDbEA5DFPODthnjEJ2gg4e8RBnAwE8RzbXkBJKwSuUjOP05SosjYOEb4FG4uMi+3bYcJ7DRaWbsooKpmQOLsEEs4vWoegPjDYdA6u2qBgIlpqZ1rY39OSqKrGF9VEMWMkuCa8fCbrfR6J3KsIIlryiC0cjH1DNoIloh5N9GZM9klEYbtBlV9AjXxi1EM01GGy2rs5ANszCkqAwQMQFMO2iZkcpeQRhTgCGesCYeCyUQwgX7LVz4QHkKqgASoZlwMFWF944Aalz83Y5kQNVwGy3qCt1+Qkwstnc8CvfgH3kze8Z/1p/m9sYArzoOTzRE13YaonZMYtsHyDyasfrgkCPg3g1gWMCJicCc7z8aT6Z+2973WegSofDYZjgpaEiWHE0JZuTypY0VZS91OJw0/IUEfHDhK8p+ID5t81u34LOjWCdhaSuccuB33dN3jchITP4Vsn7Ne2lxqwsLzAVkP6bmokYQzDzyMheqPNpPdzXIiE3gjMvQxW1AAPv4No7IlfLe7XuAvM52zqAI/gIN923v177tc7LiT4+Ayl0UNgTofIxBfxjcuv8QCQmBonMQKWnUO1NhENbCGOPgJTdAQ2dgu2dU6cH1BtSli7hG1dJDw9vJ8F4GNawzNUdIwTX+B5m0EztzL/AijpmITLAtIUQVrB5C1TaJrqa3Dm9qJO0MB5Erl5nPU8tnvEPDWZsxBHwoe0aFQDf1bRyGXyqsM48UMEHTYpLBKNLd/oAWArK1R5BBg3wUTNEzVsptCwGR+whbBtAUxkIr7OyTf026xQgVpiIctkmqvkF60Hd+7sxudIXDbhkxaIMuZxujb76osaDnwVgVoDfTXRS/vZJ0HFGHBwbjuUuseEgxqxj4qMNlzd0yi6ynNboQh84DLBwxLvQRwmD1mEP0usf0UnbO9mMnzEFrfg2w3OeZWTL4VpUa2GLoERBxh0OmSwUyTIfqBVEpkpEtXZZQC41nEACVW2l7NFcteofNW+XwBE0hLNmegJB1t6NAEqaZadEr00tBCumZDZ6mi4SCIY0GCxpA5YvRV23slzoFbYLHGuER43QCDtPg/Aio0tfqbsSJSYxlCZMqzClq3BQHs6A6rXYdMbMuQpTrgho240DRaAUN2WDHmQML6fErfbk1nqdPEZkUJPSzAxtD6CvSRg4dJwGohkFRNpPF+TB1QUXgJ88f0EM1qbgDsy4hYoY4oJW9vO84nKVkEGpqCk7djeUNusaRUsmaBCtWoYaaJh0+wI51bTD2P3g7XaKKiGyWo9eZxRx/MiYaQQSEnYW2OCakCumri7Im4vCVctIEVMZCRj7wj3zJSTDWfkHRUaWNn/RFha2TZvF4hNA5hiNTUZ1xPtdQQtLQLYkI9M8VGGnw2mqn2A7enYyqEzzoOg1loJXtmPDwTgixQlcXaJEy9waiZSNl51SJgMj9Ra4xdnNxqwzSXPsQ2+koG+q2YGz0gkbNEMWmrDlhJNwlSSoJXuy24MBKMUGdDX2KSgJth1QdASse0dGtDy+YCJsZ8Oi9K9yAPwhAkLhf/L3VwTrdg+XmL7S35XEqXY9VCo8jDShCuCgUQbrnyHSiyHTHl4kQKJCUjq8F6ArxDtL2YXjA1PRDfWmgsy2wFGB+UMaHiJ8w9kvrbLBA5ogF7QdGvlSQ0DotBnRQpIEcHp8DliY/a0xucKL9s2sZtrYVzbzfnBkKmK62sLyWQj0UWHZHSYpIizikAHcR8U3xBhkL5ocL6sz4pUxPZHggKL5Z222O6FvVCccbRFkv1Eop2IJFv7jXRjdJg4K2YtPqAlcWsxwR1BRYtmt5o+ws2OaKrDtEUhFoKI9EkPwLcAxWSsaAkd4OUTkpd2ZA+iVCcjIwvQ6UULJ5YGRTGFCJBAD6AgvE3Ey75m6sHZLhMxCdE3VTwwfh+N7nyLEYYMGTlRScSUJtDToXSJZkZMSLSdRZTWQhOZbrQmvWv2+4FPaFbChxQfFYzTmaGyCbBsKAUKBVhKpIaagJcLbat1A0uWOKHkK/22sdj6aOWKvMCCTyKhErZNSJBtM3bEDU0DDipggnlDW40mVpOkqbQEqsZjUgbB0wJoGgk6BnQWUzuYOGrSw3vChLeJon9BlDY0D1yr7fQ1VStg26GPm/1B4WuYZq5Wqny/1t/55r1vyPti9scz6jte3mdjlzVeXxB/cjaP67Im7LBplmhrKElq+20u8AVv6yCPnaU2eg0vrFsp1GL4Yrh9VAQbwwvoREGD4Np7i/Md3hf+hAfgm+L+RYAlSBfgQh+dLRhnE7Znz3GhZNRGIUOpUHrn7H2DM5VBHkT21wjDAckYh7A1cX7yQCzWq4lqqO8j23ckVRC3ZvcLXub/EeFBsJ90gGvbbjwYBE7LUNzhhn3z3Nqwf7phL6iMzbsQHpx97wG6UNtafKVfhhzMPrfY73rcsL5JhhyVfe56HXlfk1RG+ZqizQb5Pj34/F9Z8j/pyP8lJftHAAUgf3N/EDg18p7/BfJS5u+gGR6NAAAAAElFTkSuQmCC',
    'заголовок3':'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',
    'заголовок4':'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',
    'блок кода python':'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',
    'блок кода java':'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',
    'блок кода bash':'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'
}

""" Очень служебные функции"""
def getImage(name=None):
    """ возврат картинки-глифа по ее имени"""
    if name not in images: name=None
    if name!=None:
        #     получим картинку по ее текстовому коду
        base64_data = images[name]
        pm = QPixmap()
        pm.loadFromData(base64.b64decode(base64_data))
        i = QIcon()
        i.addPixmap(pm)
        return i
    else:
        return QIcon()
