#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_iam_1 = require("@aws-cdk/aws-iam");
const principals_1 = require("@aws-cdk/aws-iam/lib/principals");
const aws_sns_1 = require("@aws-cdk/aws-sns");
const core_1 = require("@aws-cdk/core");
const budget_notifier_1 = require("./budget_notifier");
const NotificationType_1 = require("./NotificationType");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'BudgetNotifierStack');
const topic = new aws_sns_1.Topic(stack, 'topic');
const statement = new aws_iam_1.PolicyStatement({
    effect: aws_iam_1.Effect.ALLOW,
    principals: [new principals_1.ServicePrincipal('budgets.amazonaws.com')],
    actions: ['SNS:Publish'],
    sid: 'Allow budget to publish to SNS',
    resources: [topic.topicArn],
});
topic.addToResourcePolicy(statement);
new budget_notifier_1.BudgetNotifier(stack, 'notifier', {
    topicArn: topic.topicArn,
    availabilityZones: ['eu-central-1'],
    costCenter: 'MyCostCenter',
    limit: 10,
    unit: 'USD',
    threshold: 15,
    notificationType: NotificationType_1.NotificationType.FORECASTED,
});
//# sourceMappingURL=data:application/json;base64,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