# 2022.3.20 snt-mkf 
import en,difflib,requests,sys,traceback
trans_diff		= lambda src, trg:  [] if src == trg else [s for s in difflib.ndiff(src, trg) if not s.startswith('?')] #src:list, trg:list
trans_diff_merge= lambda src, trg:  [] if src == trg else [s.strip() for s in "^".join([s for s in difflib.ndiff(src, trg) if not s.startswith('?')]).replace("^+","|+").split("^") if not s.startswith("+") ]
mkf_input		= lambda i, snt, gec, toklist, gec_toklist, doc, diffmerge: 	{"pid":0, "sid":i, "snt":snt, "tok": toklist,  #"offset":-1,"len":-1,"re_sntbr":0,  normally, offset =0
				"pos":[t.tag_ for t in doc], "dep": [t.dep_ for t in doc],"head":[t.head.i for t in doc],  #"tag":[t.tag_ for t in doc],
				"seg":[ ("NP", sp.start, sp.end) for sp in doc.noun_chunks] + [ (np.label_, np.start,np.end) for np in doc.ents] , 
				"gec": gec, "diff": trans_diff_merge( toklist , gec_toklist) if diffmerge else trans_diff( toklist , gec_toklist)	}

def sntmkf(dskhost:str, snt:str, gec:str, diffmerge:bool=False): 
	''' snt -> mkf, for debug only '''
	try:
		doc		= spacy.nlp(snt) 
		tdoc	= spacy.nlp(gec)
		input	= mkf_input( 0,snt,gec, [t.text for t in doc], [t.text for t in tdoc], doc, diffmerge ) 
		return requests.post(f"http://{dskhost}/parser", data={"q":json.dumps({"snts": [input]}).encode("utf-8")}).json()
	except Exception as ex:
		print(">>sntmkf Ex:", ex, "\t|", snt)

def sntsmkf(dskhost:str, sntdic:dict ={"She has ready.":"She is ready."}, asdsk:bool=False , diffmerge:bool=False, use_cache=True):
	''' snts -> mkfs  '''
	try:
		snts	= [ snt for snt in sntdic ] 
		docs	= [ spacy.getdoc(snt,use_cache) for snt in snts ] 
		input	= {"snts" : [ mkf_input(i,snts[i],sntdic[snts[i]], [t.text for t in doc], [t.text for t in spacy.nlp(sntdic[snts[i]]) ], doc, diffmerge)  for i, doc in enumerate(docs)]} 
		return requests.post(f"http://{dskhost}/parser", data={"q":json.dumps(dict(input, **{"rid":"10"}) if asdsk else input).encode("utf-8")}).json()
	except Exception as ex:
		print(">>gecv1_dsk Ex:", ex, "\t|", sntdic)
		exc_type, exc_value, exc_traceback_obj = sys.exc_info()
		traceback.print_tb(exc_traceback_obj)
		return str(ex)

if __name__ == '__main__':
	res = sntsmkf("dsk.jukuu.com", asdsk=True)
	print (res)