import * as cdk from 'aws-cdk-lib';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
/**
 * An Alexa Skill, either managed by this CDK app, or imported.
 */
export interface ISkill extends cdk.IResource {
    /**
     * The ID associated with this Skill.
     *
     * @attribute
     */
    readonly skillId: string;
}
declare abstract class SkillBase extends cdk.Resource implements ISkill {
    abstract readonly skillId: string;
}
/**
 * Construction properties for an Alexa Skill object
 */
export interface SkillProps {
    /**
     * The Lambda Function to be configured as the endpoint for the Alexa Skill.
     *
     * @default - No endpoint Lambda Function
     */
    readonly endpointLambdaFunction?: lambda.IFunction;
    /**
     * The relative path to the skill package directory containing all configuration files for the Alexa Skill.
     */
    readonly skillPackagePath: string;
    /**
     * Vendor ID associated with Alexa Developer account.
     */
    readonly alexaVendorId: string;
    /**
     * Client ID of Login with Amazon (LWA) Security Profile.
     */
    readonly lwaClientId: string;
    /**
     * Client secret associated with Login with Amazon (LWA) Client ID.
     */
    readonly lwaClientSecret: cdk.SecretValue;
    /**
     * Refresh token associated with Login with Amazon (LWA) Security Profile.
     */
    readonly lwaRefreshToken: cdk.SecretValue;
}
/**
 * Defines an Alexa Skill.
 *
 * @resource Alexa::ASK::Skill
 */
export declare class Skill extends SkillBase {
    /**
     * Reference an existing Skill,
     * defined outside of the CDK code, by Skill ID.
     */
    static fromSkillId(scope: Construct, id: string, skillId: string): ISkill;
    /**
       * The Skill ID of this Alexa Skill
       */
    readonly skillId: string;
    constructor(scope: Construct, id: string, props: SkillProps);
}
export {};
