"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionSecret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const action_secrets_1 = require("../handler/secrets/action-secrets");
class ActionSecret extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { githubTokenSecret, repositorySecretName, repositoryName, repositoryOwner, sourceSecret } = props;
        const awsRegion = aws_cdk_lib_1.Stack.of(this).region;
        const handler = new action_secrets_1.ActionSecretHandlerFunction(this, 'CustomResourceHandler', {
            functionName: 'GitHubActionSecretCustomResourceHandler',
            description: 'Handles the creation/deletion of a GitHub Action (repository) secret - created by cdk-github',
            architecture: aws_lambda_1.Architecture.ARM_64,
            timeout: aws_cdk_lib_1.Duration.minutes(10),
        });
        githubTokenSecret.grantRead(handler);
        sourceSecret.grantRead(handler);
        const provider = new custom_resources_1.Provider(this, 'SecretProvider', {
            onEventHandler: handler,
            logRetention: aws_logs_1.RetentionDays.ONE_WEEK,
        });
        const githubRepositorySecretEventProps = {
            githubTokenSecret: githubTokenSecret.secretArn,
            repositoryOwner,
            repositoryName,
            sourceSecretArn: sourceSecret.secretArn,
            repositorySecretName,
            awsRegion,
        };
        new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::GitHubActionSecret',
            properties: githubRepositorySecretEventProps,
        });
    }
}
exports.ActionSecret = ActionSecret;
_a = JSII_RTTI_SYMBOL_1;
ActionSecret[_a] = { fqn: "cdk-github.ActionSecret", version: "0.0.0" };
//# sourceMappingURL=data:application/json;base64,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