import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as iam from '@aws-cdk/aws-iam';
import * as lambda from '@aws-cdk/aws-lambda';
import { ConstructNode, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * (experimental) Properties for creating a Lambda@Edge function.
 *
 * @experimental
 */
export interface EdgeFunctionProps extends lambda.FunctionProps {
    /**
     * (experimental) The stack ID of Lambda@Edge function.
     *
     * @default - `edge-lambda-stack-${region}`
     * @experimental
     */
    readonly stackId?: string;
}
/**
 * (experimental) A Lambda@Edge function.
 *
 * Convenience resource for requesting a Lambda function in the 'us-east-1' region for use with Lambda@Edge.
 * Implements several restrictions enforced by Lambda@Edge.
 *
 * Note that this construct requires that the 'us-east-1' region has been bootstrapped.
 * See https://docs.aws.amazon.com/cdk/latest/guide/bootstrapping.html or 'cdk bootstrap --help' for options.
 *
 * @experimental
 * @resource AWS::Lambda::Function
 */
export declare class EdgeFunction extends Resource implements lambda.IVersion {
    private static readonly EDGE_REGION;
    /**
     * (experimental) The ARN of the version for Lambda@Edge.
     *
     * @experimental
     */
    readonly edgeArn: string;
    /**
     * (experimental) The name of the function.
     *
     * @experimental
     */
    readonly functionName: string;
    /**
     * (experimental) The ARN fo the function.
     *
     * @experimental
     */
    readonly functionArn: string;
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    readonly grantPrincipal: iam.IPrincipal;
    /**
     * (experimental) Whether or not this Lambda function was bound to a VPC.
     *
     * If this is is `false`, trying to access the `connections` object will fail.
     *
     * @experimental
     */
    readonly isBoundToVpc = false;
    /**
     * (experimental) The construct node where permissions are attached.
     *
     * @experimental
     */
    readonly permissionsNode: ConstructNode;
    /**
     * (experimental) The IAM role associated with this function.
     *
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) The most recently deployed version of this function.
     *
     * @experimental
     */
    readonly version: string;
    private readonly functionStack;
    private readonly _edgeFunction;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: EdgeFunctionProps);
    /**
     * (experimental) The underlying AWS Lambda function.
     *
     * @experimental
     */
    get lambda(): lambda.IFunction;
    /**
     * (experimental) Convenience method to make `EdgeFunction` conform to the same interface as `Function`.
     *
     * @experimental
     */
    get currentVersion(): lambda.IVersion;
    /**
     * (experimental) Defines an alias for this version.
     *
     * @experimental
     */
    addAlias(aliasName: string, options?: lambda.AliasOptions): lambda.Alias;
    /**
     * (experimental) Not supported.
     *
     * Connections are only applicable to VPC-enabled functions.
     *
     * @experimental
     */
    get connections(): ec2.Connections;
    /**
     * (experimental) The `$LATEST` version of this function.
     *
     * Note that this is reference to a non-specific AWS Lambda version, which
     * means the function this version refers to can return different results in
     * different invocations.
     *
     * To obtain a reference to an explicit version which references the current
     * function configuration, use `lambdaFunction.currentVersion` instead.
     *
     * @experimental
     */
    get latestVersion(): lambda.IVersion;
    /**
     * (experimental) Adds an event source that maps to this AWS Lambda function.
     *
     * @experimental
     */
    addEventSourceMapping(id: string, options: lambda.EventSourceMappingOptions): lambda.EventSourceMapping;
    /**
     * (experimental) Adds a permission to the Lambda resource policy.
     *
     * @experimental
     */
    addPermission(id: string, permission: lambda.Permission): void;
    /**
     * (experimental) Adds a statement to the IAM role assumed by the instance.
     *
     * @experimental
     */
    addToRolePolicy(statement: iam.PolicyStatement): void;
    /**
     * (experimental) Grant the given identity permissions to invoke this Lambda.
     *
     * @experimental
     */
    grantInvoke(identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Return the given named metric for this Lambda Return the given named metric for this Function.
     *
     * Return the given named metric for this Lambda Return the given named metric for this Function.
     *
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the Duration of this Lambda How long execution of this Lambda takes.
     *
     * Average over 5 minutes
     * Metric for the Duration of this Lambda How long execution of this Lambda takes.
     *
     * Average over 5 minutes
     *
     * @experimental
     */
    metricDuration(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) How many invocations of this Lambda fail.
     *
     * Sum over 5 minutes
     *
     * @experimental
     */
    metricErrors(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of invocations of this Lambda How often this Lambda is invoked.
     *
     * Sum over 5 minutes
     * Metric for the number of invocations of this Lambda How often this Lambda is invoked.
     *
     * Sum over 5 minutes
     *
     * @experimental
     */
    metricInvocations(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of throttled invocations of this Lambda How often this Lambda is throttled.
     *
     * Sum over 5 minutes
     * Metric for the number of throttled invocations of this Lambda How often this Lambda is throttled.
     *
     * Sum over 5 minutes
     *
     * @experimental
     */
    metricThrottles(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Adds an event source to this function.
     *
     * @experimental
     */
    addEventSource(source: lambda.IEventSource): void;
    /**
     * (experimental) Configures options for asynchronous invocation.
     *
     * @experimental
     */
    configureAsyncInvoke(options: lambda.EventInvokeConfigOptions): void;
    /** Create a function in-region */
    private createInRegionFunction;
    /** Create a support stack and function in us-east-1, and a SSM reader in-region */
    private createCrossRegionFunction;
    private createCrossRegionArnReader;
    private edgeStack;
}
