# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pamogk',
 'pamogk.data_processor',
 'pamogk.gene_mapper',
 'pamogk.kernels',
 'pamogk.lib',
 'pamogk.pathway_reader',
 'pamogk.result_processor']

package_data = \
{'': ['*']}

install_requires = \
['biopython>=1.76',
 'gensim>=3.8.0',
 'mkkm_mr>=0.2.1,<0.3.0',
 'mosek>=9.2.0',
 'networkx>=2.4.0',
 'numpy>=1.18.0',
 'pandas>=1.0.0',
 'requests>=2.23.0',
 'scikit-learn>=0.23.0',
 'scipy>=1.5.2,<2.0.0',
 'snf_simple>=0.1.0,<0.2.0',
 'snfpy']

setup_kwargs = {
    'name': 'pamogk',
    'version': '2.2.0',
    'description': 'PAMOGK',
    'long_description': "PAMOGK\n=====\n\n# Installation\n\n## Getting the Code Base\nYou can either checkout the code base through git:\n```bash\ngit clone https://github.com/tastanlab/pamogk.git\n```\nor you can download the master branch from:\n> https://github.com/tastanlab/pamogk/archive/master.zip\n\n## Python Environment\nProject mainly uses python, but some of the plot generation codes use matlab or output html files (plotly.js). Also some\n libraries might be dependent on operating system. In our tests we used Debian 12.04LTS and macOS Catalina.\n\nFirst install `pipenv` using the instructions given:\n\n> https://github.com/pypa/pipenv#installation\n\nWe are using [pipenv](https://github.com/pypa/pipenv#installation) because of version locking and predictive builds.\n\n## Setting up MOSEK\nWe are using [MOSEK Optimizer API](https://docs.mosek.com/9.1/pythonapi/index.html) for optimizing view weights, and in\norder to use MOSEK you will need a license file. MOSEK provides free certificates for academic purposes and free trial\ncertificates for Commercial usages. You can see check the link below for information on how to acquire an academic license:\n\n> https://www.mosek.com/products/academic-licenses/\n\n### License File Placement\nYou can either place the license file under user's home directory in a folder named `mosek` e.g:\n```bash\n$HOME/mosek/mosec.lic # *nix/macOS users\n%USERPROFILE%\\mosek\\mosek.lic # windows users\n```\nOther option is to set the `MOSEKLM_LICENSE_FILE` environment variable to your license file location.\n\nWe also look for the license file paths in some custom paths (by overwriting `MOSEKLM_LICENSE_FILE` if not present).\nYou can check `pamogk.config.MOSEK_SUPPORTED_PATHS` to see a list of supported paths.\n\nFor more information:\n\n> https://docs.mosek.com/9.2/install/installation.html#setting-up-the-license\n\n## Dependencies\nInstall dependencies with:\n```bash\npipenv install\n```\n\n## Required Environment Variables\nYou can add a `.env` file that will be loaded by `pipenv`\n\nAlso please don't forget to export `MOSEKLM_LICENSE_FILE` variable as well if you are using a path other\nthan `$HOME/mosek/mosek.lic`:\n\n```bash\n# required for experiment running\nPYTHONPATH=${PYTHONPATH}:.\nMOSEKLM_LICENSE_FILE=$MY_MOSEK_LICENSE_FILE_PATH\n```\n\n# Folder Structure\n- **pamogk:** package root folder\n  - **kernels:** Kernel methods to calculate distance between patients. Will try to extend these!\n  - **data_processor:** Data processors/converters used to convert different forms of data to usable forms.\n   Will try to extend these!\n  - **gene_mapper:** Uniprot/Entrez gene mapping matcher for different datasets using different gene IDs. Will try to\n   separate to its own package or along with other tools.\n  - **pathway_reader:** https://.ndexbio.org CX format, and http://kegg.jp KGML format reader and converters. Will try\n   to separate to its own package or along with other tools.\n- **data:** Data files that are both raw or generated by the project. Keeping intermediate files saves a lot of\n computation time where applicable. (not included in package)\n- **experiments:** Experiments done on real data. (not included in package)\n\n\n# Experiments\n## Running Experiments\nYou should run experiments either by starting a pipenv environment shell by:\n```bash\npipenv shell\n```\n\nor through pipenv with:\n```bash\npipenv run experiments/pamogk_all_exp_1.py\n```\nThis ensures that experiments are run with correct environment.\n\n## Experiment Parameters\nExperiments are code entry points that have arguments that change per experiment. You can see their arguments by\n running them with `--help` parameter. e.g:\n```bash\n./experiments/pamogk_all_exp_1.py --help\n```\nand you should see help as such:\n```\nusage: pamogk_all_exp_1.py [-h] [--rs-patient-data file-path]\n                           [--rp-patient-data file-path]\n                           [--som-patient-data file-path]\n\nRun PAMOGK-mut algorithms on pathways\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --rs-patient-data file-path, -rs file-path\n                        rnaseq pathway ID list\n  --rp-patient-data file-path, -rp file-path\n                        rppa pathway ID list\n  --som-patient-data file-path, -s file-path\n                        som mut pathway ID list\n```\n",
    'author': 'Fma',
    'author_email': 'fmakdemir@users.noreply.github.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/tastanlab/pamogk',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
