// Copyright (c) Mito
import React from 'react';
import { AggregationType } from './PivotTaskpane';
import Select from '../../elements/Select';
import XIcon from '../../icons/XIcon';
import Row from '../../spacing/Row';
import Col from '../../spacing/Col';
import DropdownItem from '../../elements/DropdownItem';
import { getDisplayColumnHeader } from '../../../utils/columnHeaders';
/*
  A custom component that displays the column headers chosen as the key for the pivot table.
*/
const PivotTableValueAggregationCard = (props) => {
    // Create a list of the possible aggregation methods
    const aggregationTypeList = Object.values(AggregationType);
    const setAggregationType = (aggregationType) => {
        // Declare the aggregationType param of type AggregationType and then make sure that it is
        const aggregationTypeCast = aggregationType;
        if (aggregationTypeList.includes(aggregationTypeCast)) {
            props.editPivotValueAggregation(aggregationTypeCast, props.columnID);
        }
    };
    return (React.createElement(Row, { align: 'center' },
        React.createElement(Col, null,
            React.createElement(Select, { value: props.aggregationType, onChange: setAggregationType, width: 'small', dropdownWidth: 'small' }, aggregationTypeList.map(aggregationType => {
                return (React.createElement(DropdownItem, { key: aggregationType, title: aggregationType }));
            }))),
        React.createElement(Col, { offset: 1, flex: '1' },
            React.createElement(Select, { value: props.columnID, onChange: (columnID) => {
                    props.editPivotValueAggregation(props.aggregationType, columnID);
                }, searchable: true }, Object.keys(props.columnIDsMap).map(columnID => {
                const columnHeader = props.columnIDsMap[columnID];
                return (React.createElement(DropdownItem, { key: columnID, id: columnID, title: getDisplayColumnHeader(columnHeader) }));
            }))),
        React.createElement(Col, { offset: 1, offsetRight: 1 },
            React.createElement(XIcon, { onClick: () => props.removePivotValueAggregation() }))));
};
export default PivotTableValueAggregationCard;
//# sourceMappingURL=PivotTableValueAggregationCard.js.map