// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.
import React, { useState } from 'react';
import DefaultTaskpane from '../DefaultTaskpane/DefaultTaskpane';
import Row from '../../spacing/Row';
import Col from '../../spacing/Col';
import Select from '../../elements/Select';
import DropdownItem from '../../elements/DropdownItem';
import MultiToggleBox from '../../elements/MultiToggleBox';
import MultiToggleItem from '../../elements/MultiToggleItem';
import { getDisplayColumnHeader } from '../../../utils/columnHeaders';
import LoadingDots from '../../elements/LoadingDots';
import { useDebouncedEffect } from '../../../hooks/useDebouncedEffect';
import DefaultTaskpaneHeader from '../DefaultTaskpane/DefaultTaskpaneHeader';
import DefaultTaskpaneBody from '../DefaultTaskpane/DefaultTaskpaneBody';
import DefaultEmptyTaskpane from '../DefaultTaskpane/DefaultEmptyTaskpane';
// Millisecond delay between changing params, so that
// we don't load send too many drop duplicate messages when the user
// is just configuring. 
const SEND_MESSAGE_DELAY = 250;
/*
    A taskpane that allows a user to drop duplicates
    in a sheet
*/
const DropDuplicatesTaskpane = (props) => {
    var _a, _b, _c;
    const [stepID, setStepID] = useState(undefined);
    const [originalNumRows, setOriginalNumRows] = useState(((_a = props.sheetDataArray[props.selectedSheetIndex]) === null || _a === void 0 ? void 0 : _a.numRows) || 0);
    const [loading, setLoading] = useState(false);
    const [dropDuplicateParams, setDropDuplicateParams] = useState({
        sheetIndex: props.selectedSheetIndex,
        columnIDs: ((_c = (_b = props.sheetDataArray[props.selectedSheetIndex]) === null || _b === void 0 ? void 0 : _b.data) === null || _c === void 0 ? void 0 : _c.map(c => c.columnID)) || [],
        keep: 'first',
    });
    // Send a drop duplicates message if we change the params
    useDebouncedEffect(() => {
        void sendDropDuplicates(dropDuplicateParams);
    }, [dropDuplicateParams], SEND_MESSAGE_DELAY);
    if (props.sheetDataArray.length === 0) {
        return React.createElement(DefaultEmptyTaskpane, { setUIState: props.setUIState });
    }
    const columnIDsAndHeaders = props.sheetDataArray[dropDuplicateParams.sheetIndex].data.map(c => [c.columnID, c.columnHeader]);
    const sendDropDuplicates = async (params) => {
        setLoading(true);
        const newStepID = await props.mitoAPI.dropDuplicates(params.sheetIndex, params.columnIDs, params.keep, stepID);
        setStepID(newStepID);
        setLoading(false);
    };
    return (React.createElement(DefaultTaskpane, null,
        React.createElement(DefaultTaskpaneHeader, { header: 'Drop Duplicates', setUIState: props.setUIState }),
        React.createElement(DefaultTaskpaneBody, null,
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", { className: 'text-header-3' }, "Sheet to Deduplicate")),
                React.createElement(Col, null,
                    React.createElement(Select, { width: 'medium', value: props.sheetDataArray[dropDuplicateParams.sheetIndex].dfName, onChange: (newDfName) => {
                            const newSheetIndex = props.dfNames.indexOf(newDfName);
                            setDropDuplicateParams(dropDuplicateParams => {
                                return Object.assign(Object.assign({}, dropDuplicateParams), { sheetIndex: newSheetIndex, columnIDs: props.sheetDataArray[newSheetIndex].data.map(c => c.columnID) });
                            });
                            setOriginalNumRows(props.sheetDataArray[newSheetIndex].numRows);
                            props.setUIState(prevUIState => {
                                return Object.assign(Object.assign({}, prevUIState), { selectedSheetIndex: newSheetIndex });
                            });
                        } }, props.dfNames.map(dfName => {
                        return (React.createElement(DropdownItem, { key: dfName, title: dfName }));
                    })))),
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", { className: 'text-header-3' }, "Duplicates to Keep")),
                React.createElement(Col, null,
                    React.createElement(Select, { width: 'medium', value: dropDuplicateParams.keep + '', onChange: (newKeep) => {
                            if (newKeep === 'false') {
                                newKeep = false;
                            }
                            setDropDuplicateParams(dropDuplicateParams => {
                                return Object.assign(Object.assign({}, dropDuplicateParams), { keep: newKeep });
                            });
                        } },
                        React.createElement(DropdownItem, { title: 'first', subtext: 'Keep the first instance of the duplicated row.' }),
                        React.createElement(DropdownItem, { title: 'last', subtext: 'Keep the last instance of the duplicated row.' }),
                        React.createElement(DropdownItem, { id: 'false', title: 'none', subtext: 'Keep none of the duplicated rows.' })))),
            React.createElement("p", { className: 'text-header-3 mt-10px' }, "Columns to Deduplicate On"),
            React.createElement(MultiToggleBox, { searchable: true, toggleAllIndexes: (indexesToToggle, newToggle) => {
                    const columnIDsToToggle = indexesToToggle.map(index => columnIDsAndHeaders[index][0]);
                    setDropDuplicateParams(oldDropDuplicateParams => {
                        const newSelectedColumnIDs = [...oldDropDuplicateParams.columnIDs];
                        columnIDsToToggle.forEach(columnID => {
                            if (newToggle) {
                                if (!newSelectedColumnIDs.includes(columnID)) {
                                    newSelectedColumnIDs.push(columnID);
                                }
                            }
                            else {
                                if (newSelectedColumnIDs.includes(columnID)) {
                                    newSelectedColumnIDs.splice(newSelectedColumnIDs.indexOf(columnID), 1);
                                }
                            }
                        });
                        return Object.assign(Object.assign({}, oldDropDuplicateParams), { columnIDs: newSelectedColumnIDs });
                    });
                }, height: 'large' }, columnIDsAndHeaders.map(([columnID, columnHeader], index) => {
                return (React.createElement(MultiToggleItem, { key: index, title: getDisplayColumnHeader(columnHeader), toggled: dropDuplicateParams.columnIDs.includes(columnID), index: index, onToggle: () => {
                        setDropDuplicateParams(oldDropDuplicateParams => {
                            const newSelectedColumnIDs = [...oldDropDuplicateParams.columnIDs];
                            if (!newSelectedColumnIDs.includes(columnID)) {
                                newSelectedColumnIDs.push(columnID);
                            }
                            else {
                                newSelectedColumnIDs.splice(newSelectedColumnIDs.indexOf(columnID), 1);
                            }
                            return Object.assign(Object.assign({}, oldDropDuplicateParams), { columnIDs: newSelectedColumnIDs });
                        });
                    } }));
            })),
            loading &&
                React.createElement(Row, { className: 'mt-5' },
                    React.createElement("p", { className: 'text-subtext-1' },
                        "Deduplicating ",
                        React.createElement(LoadingDots, null))),
            stepID !== undefined && !loading &&
                React.createElement(Row, { className: 'mt-5' },
                    React.createElement("p", { className: 'text-subtext-1' },
                        "Removed ",
                        originalNumRows - props.sheetDataArray[dropDuplicateParams.sheetIndex].numRows,
                        " rows")))));
};
export default DropDuplicatesTaskpane;
//# sourceMappingURL=DropDuplicates.js.map