// Copyright (c) Mito
import React from 'react';
import "../../../../css/taskpanes/DefaultTaskpane.css";
import { TaskpaneType } from '../taskpanes';
import DefaultTaskpane from './DefaultTaskpane';
import DefaultTaskpaneBody from './DefaultTaskpaneBody';
import DefaultTaskpaneHeader from './DefaultTaskpaneHeader';
/*
    DefaultEmptyTaskpane is a convenient taskpane to display when the
    user tries to open a taskpane that needs data displayed.

    It allows them to easily navigate to the import taskpane, which is
    nice UX!
*/
const DefaultEmptyTaskpane = (props) => {
    const openImportTaskpane = () => {
        props.setUIState(prevUIState => {
            return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: { type: TaskpaneType.IMPORT } });
        });
    };
    return (React.createElement(DefaultTaskpane, null,
        React.createElement(DefaultTaskpaneHeader, { header: 'Import data first', setUIState: props.setUIState }),
        React.createElement(DefaultTaskpaneBody, null,
            React.createElement("p", { className: 'text-body-1 text-overflow-wrap' },
                props.message ? props.message : 'Before performing that action, you need to import data into Mito.',
                ' ',
                React.createElement("span", { className: 'text-body-1-link', onClick: openImportTaskpane }, "Click here to import data."),
                "."))));
};
export default DefaultEmptyTaskpane;
//# sourceMappingURL=DefaultEmptyTaskpane.js.map