import React, { Component } from "react";
import { DISCORD_INVITE_LINK } from "../../data/documentationLinks";
class ErrorBoundary extends Component {
    constructor() {
        super(...arguments);
        this.state = {
            hasError: false
        };
    }
    static getDerivedStateFromError() {
        // Update state so the next render will show the fallback UI.
        return { hasError: true };
    }
    componentDidCatch(error) {
        var _a;
        void this.props.mitoAPI.sendLogMessage('frontend_render_failed', {
            'error_name': error.name,
            'error_message': error.message,
            'error_stack': (_a = error.stack) === null || _a === void 0 ? void 0 : _a.split('\n'),
        });
    }
    render() {
        if (this.state.hasError) {
            return (React.createElement("p", { className: 'text-body-1 text-color-red p-10px' },
                "Looks like Mito had an error! Sorry about that. Rerun the Jupyter Cell above, and ",
                React.createElement("a", { className: 'text-body-1-link', href: DISCORD_INVITE_LINK, target: '_blank', rel: "noreferrer" }, "join our Discord for support"),
                " if this error occurs again."));
        }
        return this.props.children;
    }
}
export default ErrorBoundary;
//# sourceMappingURL=ErrorBoundary.js.map