/*
 * Decompiled with CFR 0.152.
 */
package basicUtils;

import basicUtils.GFFFile;
import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class Homology2GFFConverter {
    public static String UsageInfo = "basicUtils.Homology2GFFConverger version 2010.08.04\nConverts the output of Doruk's tool to a GFF file which can be used\nto build a splice graph.  Expects a file in the following tab-delimited format:\nQueryName ChrName BlastP%ID BlastPCoverage TBlastn%ID TBlastnCoverage QueryIndices SubjectIndices SubjectStrand\n- QueryIndices and SubjectIndices are of the form S-E;S-E;S-E;\n- For QueryIndices the start is always less than or equal to the end, however if the mapping is to the reverse strand\nthen the intervals are in reverse order (e.g. 100-200;50-90)\n- For SubjectIndices the start is <= end only on the reverse strand, otherwise the start >= end.  If the mapping is \nto the reverse strand then the intervals are in reverse order\n- The indices are 1-numbered, end inclusive.\nREQUIRED:\n -r [FILE] Homology file\n -w [FILE] Output file\nOPTIONAL:\n -c Split output file into separate chromosomes\n";
    private String InputFile = null;
    private String OutputFile = null;
    private boolean SplitByChr = false;
    private Hashtable OrthologCount = null;

    public Homology2GFFConverter(String InputFile, String OutputFile) {
        this.InputFile = InputFile;
        this.OutputFile = OutputFile;
        this.OrthologCount = new Hashtable();
    }

    public void Convert() {
        BufferedReader buf = null;
        FileWriter w = null;
        String Line = null;
        FileWriter currWriter = null;
        int ReadLineCount = 0;
        int WroteLineCount = 0;
        Hashtable<String, FileWriter> AllFileWriters = new Hashtable<String, FileWriter>();
        try {
            buf = new BufferedReader(new FileReader(this.InputFile));
            if (!this.SplitByChr) {
                w = new FileWriter(this.OutputFile);
            }
            Line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        String[] GFFLine = new String[GFFFile.GFFColumns.NumColumns];
        while (Line != null) {
            String[] SIndices;
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            ++ReadLineCount;
            String[] Bits = Line.split("\t");
            String[] QIndices = Bits[6].split(";");
            if (QIndices.length != (SIndices = Bits[7].split(";")).length) {
                System.err.println("ERROR: Homology file line '" + Line + "' does not have the same number of subject and query intervals");
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            int Strand = Integer.parseInt(Bits[8]);
            GFFLine[GFFFile.GFFColumns.SequenceName] = Bits[1];
            if (this.SplitByChr) {
                if (AllFileWriters.containsKey(Bits[1])) {
                    currWriter = (FileWriter)AllFileWriters.get(Bits[1]);
                } else {
                    String NewOutputFile = String.valueOf(Utils.GetFileNameNoExtension(this.OutputFile)) + "." + Bits[1] + Utils.GetFileExtension(this.OutputFile);
                    System.out.println("Creating new file " + NewOutputFile);
                    try {
                        currWriter = new FileWriter(NewOutputFile);
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                    AllFileWriters.put(Bits[1], currWriter);
                }
            }
            GFFLine[GFFFile.GFFColumns.Source] = "HomologyScript";
            GFFLine[GFFFile.GFFColumns.FeatureType] = "CDS";
            GFFLine[GFFFile.GFFColumns.Frame] = "0";
            GFFLine[GFFFile.GFFColumns.Score] = "1.0";
            GFFLine[GFFFile.GFFColumns.Strand] = Bits[8];
            int Count = 0;
            if (this.OrthologCount.containsKey(Bits[0])) {
                Count = (Integer)this.OrthologCount.get(Bits[0]);
            }
            GFFLine[GFFFile.GFFColumns.Attributes] = "parent=" + Bits[0] + "." + Count + ";%ID=" + Bits[4] + ";Coverage=" + Bits[5];
            this.OrthologCount.put(Bits[0], new Integer(++Count));
            int[] Starts = new int[QIndices.length];
            int[] Ends = new int[QIndices.length];
            int i = 0;
            while (i < QIndices.length) {
                if (QIndices[i].length() != 0) {
                    int PrevEnd;
                    int CurrStart;
                    String[] sCoords = SIndices[i].split("-");
                    if (Strand == 1) {
                        CurrStart = Integer.parseInt(sCoords[0]);
                        if (i <= 0 || (CurrStart = Math.max(CurrStart, PrevEnd = Ends[i - 1])) == PrevEnd) {
                            // empty if block
                        }
                        Starts[i] = ++CurrStart;
                        Ends[i] = Integer.parseInt(sCoords[1]);
                    } else {
                        CurrStart = Integer.parseInt(sCoords[1]);
                        if (i <= 0 || (CurrStart = Math.max(CurrStart, PrevEnd = Ends[i - 1])) == PrevEnd) {
                            // empty if block
                        }
                        Starts[i] = ++CurrStart;
                        Ends[i] = Integer.parseInt(sCoords[0]);
                    }
                    if ((Ends[i] - Starts[i] + 1) % 3 != 0) {
                        int n = i;
                        Ends[n] = Ends[n] + (3 - (Ends[i] - Starts[i] + 1) % 3);
                    }
                    GFFLine[GFFFile.GFFColumns.Start] = String.valueOf(Starts[i]);
                    GFFLine[GFFFile.GFFColumns.End] = String.valueOf(Ends[i]);
                    try {
                        ++WroteLineCount;
                        if (!this.SplitByChr) {
                            w.write(String.valueOf(GFFFile.toString(GFFLine, "\t")) + "\n");
                        } else {
                            currWriter.write(String.valueOf(GFFFile.toString(GFFLine, "\t")) + "\n");
                        }
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                }
                ++i;
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            buf.close();
            if (!this.SplitByChr) {
                w.close();
            } else {
                Enumeration chrs = AllFileWriters.keys();
                while (chrs.hasMoreElements()) {
                    currWriter = (FileWriter)AllFileWriters.get(chrs.nextElement());
                    currWriter.close();
                }
            }
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        System.out.println("Read " + ReadLineCount + " lines from " + this.InputFile);
        System.out.println("Wrote " + WroteLineCount + " exons");
    }

    public static void main(String[] args) {
        String InputFile;
        String[] options = new String[]{"-r", "-w", "-c"};
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[1] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!CommandLineArgs.containsKey("-r") || !CommandLineArgs.containsKey("-w")) {
            System.err.println("ERROR: Missing required arguments!");
            System.err.println(UsageInfo);
            System.exit(-1);
        }
        if (!Utils.IsFile(InputFile = (String)CommandLineArgs.get("-r"))) {
            System.err.println("ERROR: Input file '" + InputFile + "' is not a valid file");
            System.exit(-1);
        }
        String OutputFile = (String)CommandLineArgs.get("-w");
        Homology2GFFConverter C = new Homology2GFFConverter(InputFile, OutputFile);
        if (CommandLineArgs.containsKey("-c")) {
            C.SplitByChr = true;
        }
        C.Convert();
    }
}

