/*
 * Decompiled with CFR 0.152.
 */
package ms2dbUtils;

import basicUtils.ProteoDB;
import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import ms2dbUtils.BuildMS2DB;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import trieUtils.TrieDB;
import trieUtils.TrieNode;

public class MS2DB
extends ProteoDB {
    public static final int MS2DB_RECORD_SIZE = 92;
    public String[] Peptides = null;
    TrieNode Root = null;
    public BuildMS2DB Builder = null;
    public Hashtable Locations = null;
    public ArrayList Exons = null;
    public ArrayList Introns = null;
    public Hashtable Genes = null;
    public int ForwardGeneCount = 0;
    public int ForwardExonCount = 0;
    public int ForwardIntronCount = 0;
    public int ForwardAACount = 0;
    public int ReverseGeneCount = 0;
    public int ReverseExonCount = 0;
    public int ReverseIntronCount = 0;
    public int ReverseAACount = 0;
    String SpliceArray = null;
    ArrayList Splices = null;
    DataOutputStream OutFile = null;

    public MS2DB(String DatabaseName) {
        this.DBFileName = DatabaseName;
    }

    public void WriteIfTargetGene(BuildMS2DB.MS2Gene currGene) {
        if (currGene.GeneName.substring(0, 3).compareTo("XXX") == 0) {
            return;
        }
        try {
            this.Builder.OutputMS2Gene(currGene);
        }
        catch (Exception E) {
            E.printStackTrace();
            Utils.WaitForEnter();
            return;
        }
    }

    public void UnShuffleMS2DB(String OutputDBName) {
        SAXParserFactory ParserFactory = SAXParserFactory.newInstance();
        MS2DBContentHandler MS2DBHandler = new MS2DBContentHandler(this, 6);
        this.Builder = new BuildMS2DB();
        this.Builder.OutputFileName = OutputDBName;
        this.Builder.OutputFile = null;
        try {
            this.Builder.OutputFile = new FileWriter(this.Builder.OutputFileName);
            this.Builder.OutputFile.write("<Database CreatedBy=\"MS2DB:UnShuffleMS2DB.java\">\n");
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        try {
            SAXParser Parser2 = ParserFactory.newSAXParser();
            Parser2.parse(new File(this.DBFileName), (DefaultHandler)MS2DBHandler);
        }
        catch (Exception E) {
            E.printStackTrace();
            return;
        }
        try {
            this.Builder.OutputFile.write("\n</Database>\n");
            this.Builder.OutputFile.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
    }

    @Override
    public Hashtable GetAllLocations(String[] Peptides) {
        this.Peptides = Peptides;
        this.Root = TrieDB.BuildTrieStruct(Peptides);
        this.Locations = new Hashtable();
        SAXParserFactory ParserFactory = SAXParserFactory.newInstance();
        MS2DBContentHandler MS2DBHandler = new MS2DBContentHandler(this, 1);
        this.Builder = new BuildMS2DB();
        try {
            SAXParser Parser2 = ParserFactory.newSAXParser();
            Parser2.parse(new File(this.DBFileName), (DefaultHandler)MS2DBHandler);
        }
        catch (Exception E) {
            E.printStackTrace();
            return null;
        }
        return this.Locations;
    }

    public void SearchSplicableGene(BuildMS2DB.MS2Gene Gene) {
        boolean LocalDebug = false;
        if (this.Root == null) {
            if (LocalDebug) {
                System.out.println("Trying to search gene but no Trie!!");
            }
            return;
        }
        Hashtable<Integer, ArrayList> VisitedExonHash = new Hashtable<Integer, ArrayList>();
        if (LocalDebug) {
            System.out.println("Searching out bitch!");
        }
        int TotalExonCount = 0;
        int TotalSequenceLength = 0;
        this.SpliceArray = "";
        if (this.Splices == null) {
            this.Splices = new ArrayList();
        } else {
            this.Splices.clear();
        }
        TrieNode CurrentNode = null;
        int ExonIndex = 0;
        while (ExonIndex < Gene.Exons.size()) {
            ArrayList Locs;
            ArrayList<BuildMS2DB.MS2Exon> ExonArray;
            BuildMS2DB.MS2Exon Exon;
            boolean SeqPos = false;
            BuildMS2DB.MS2Exon ActiveExon = Exon = (BuildMS2DB.MS2Exon)Gene.Exons.get(ExonIndex);
            if (LocalDebug) {
                System.out.println("Searching Exon " + Exon.Index);
                Exon.DebugPrint(true);
            }
            int SequenceLength = Exon.Sequence.length();
            ++TotalExonCount;
            TotalSequenceLength += SequenceLength;
            BuildMS2DB.MS2Edge Edge = null;
            Edge = Gene.ForwardFlag == 1 ? Exon.ReverseIntrons : Exon.ForwardIntrons;
            while (Edge != null) {
                if (Edge.SpecialAA == '\u0000') {
                    if (LocalDebug) {
                        System.out.println("Edge from exon " + Edge.LinkTo.Index + " has no split codon!");
                        Utils.WaitForEnter();
                    }
                } else {
                    if (LocalDebug) {
                        System.out.println("Edge from exon " + Edge.LinkTo.Index + " has a split codon " + Edge.SpecialAA + "!");
                        Utils.WaitForEnter();
                    }
                    ExonArray = new ArrayList();
                    ExonArray.add(Edge.LinkTo);
                    ExonArray.add(Exon);
                    this.Splices.add(this.GetReciprocalExonEdge(Edge, Gene.ForwardFlag));
                    this.SpliceArray = Edge.LinkTo.End == Exon.Start || Edge.LinkTo.Start == Exon.End ? String.valueOf(this.SpliceArray) + ";" + Edge.SpecialAA + ";" : String.valueOf(this.SpliceArray) + Edge.SpecialAA;
                    CurrentNode = this.Root.GetNext(Edge.SpecialAA);
                    if (CurrentNode != null) {
                        Locs = null;
                        Locs = VisitedExonHash.containsKey(new Integer(Exon.Index)) ? (ArrayList)VisitedExonHash.get(new Integer(Exon.Index)) : new ArrayList();
                        if (!Utils.IntegerArrayListContains(Locs, CurrentNode.StateNum)) {
                            Locs.add(new Integer(CurrentNode.StateNum));
                            VisitedExonHash.put(new Integer(Exon.Index), Locs);
                            this.GetSplicedMatches(Gene, Exon, 0, CurrentNode, ExonArray, VisitedExonHash);
                        } else if (LocalDebug) {
                            System.out.println("We've already searched exon " + Exon.Index + " starting at node " + CurrentNode.StateNum);
                        }
                        if (CurrentNode.GetOutput() != null) {
                            this.AddMatches(Gene, 0, CurrentNode, ExonArray);
                        }
                    }
                }
                Edge = Edge.Next;
            }
            if (LocalDebug) {
                System.out.println("Finished considering spliced codons into this guy!");
                Utils.WaitForEnter();
            }
            ExonArray = new ArrayList<BuildMS2DB.MS2Exon>();
            ExonArray.add(Exon);
            Locs = null;
            Locs = VisitedExonHash.containsKey(new Integer(Exon.Index)) ? (ArrayList)VisitedExonHash.get(new Integer(Exon.Index)) : new ArrayList();
            if (!Utils.IntegerArrayListContains(Locs, this.Root.StateNum)) {
                Locs.add(new Integer(this.Root.StateNum));
                VisitedExonHash.put(new Integer(Exon.Index), Locs);
                this.GetSplicedMatches(Gene, Exon, 0, this.Root, ExonArray, VisitedExonHash);
            } else if (LocalDebug) {
                System.out.println("We've already searched exon " + Exon.Index + " starting at node " + this.Root.StateNum);
            }
            ++ExonIndex;
        }
    }

    private BuildMS2DB.MS2Edge GetReciprocalExonEdge(BuildMS2DB.MS2Edge Edge, int ForwardFlag) {
        BuildMS2DB.MS2Edge OtherEdge = Edge.LinkTo.ReverseIntrons;
        while (OtherEdge != null) {
            if (OtherEdge.LinkTo.compareTo(Edge.LinkFrom) == 0 && OtherEdge.SpecialAA == Edge.SpecialAA) {
                return OtherEdge;
            }
            OtherEdge = OtherEdge.Next;
        }
        OtherEdge = Edge.LinkTo.ForwardIntrons;
        while (OtherEdge != null) {
            if (OtherEdge.LinkTo.compareTo(Edge.LinkFrom) == 0 && OtherEdge.SpecialAA == Edge.SpecialAA) {
                return OtherEdge;
            }
            OtherEdge = OtherEdge.Next;
        }
        System.err.println("ERROR: There was no reciprocal edge for: ");
        Edge.DebugPrint();
        return null;
    }

    private void GetSplicedMatches(BuildMS2DB.MS2Gene Gene, BuildMS2DB.MS2Exon Exon, int ExonPos, TrieNode CurrentNode, ArrayList ExonsVisited, Hashtable VisitedExonHash) {
        boolean LocalDebug = false;
        if (LocalDebug) {
            System.out.println("getSplicedMatches:");
            System.out.println("Gene: " + Gene.GeneName + " on " + Gene.SequenceName);
            System.out.println("Exon: " + Exon.Index + " : " + Exon.Sequence);
            System.out.println("ExonPos: " + ExonPos);
            Utils.WaitForEnter();
        }
        if (CurrentNode == null) {
            return;
        }
        int CurrPos = ExonPos;
        String Sequence = Utils.CleanUpPeptideString(Exon.Sequence);
        while (CurrPos < Sequence.length()) {
            if (LocalDebug) {
                System.out.println("Considering char at Pos " + CurrPos + "/" + Sequence.length() + "=" + Sequence.charAt(CurrPos));
            }
            if (CurrentNode.GetNext(Sequence.charAt(CurrPos)) == null) {
                if (LocalDebug) {
                    System.out.println("FAIL!");
                }
                CurrentNode = CurrentNode.GetFailure();
            } else {
                if (LocalDebug) {
                    System.out.println("SUCCESS!");
                }
                CurrentNode = CurrentNode.GetNext(Sequence.charAt(CurrPos));
                ++CurrPos;
            }
            if (CurrentNode.GetOutput() == null) continue;
            if (LocalDebug) {
                System.out.println("There are output guys here!!");
            }
            this.AddMatches(Gene, CurrPos, CurrentNode, ExonsVisited);
        }
        if (LocalDebug) {
            System.out.println("Finished exon!!");
        }
        if (Gene.ForwardFlag == 1) {
            BuildMS2DB.MS2Edge Edge = Exon.ForwardIntrons;
            while (Edge != null) {
                TrieNode NewStart = CurrentNode;
                ArrayList<BuildMS2DB.MS2Exon> NewExonsVisited = new ArrayList<BuildMS2DB.MS2Exon>(ExonsVisited);
                NewExonsVisited.add(Edge.LinkTo);
                if (LocalDebug) {
                    System.out.println("Considering Forward edge " + Exon.Index + " to " + Edge.LinkTo.Index);
                }
                if (Edge.SpecialAA != '\u0000') {
                    if (LocalDebug) {
                        System.out.println("Considering special AA: " + Edge.SpecialAA);
                    }
                    while (NewStart.GetNext(Edge.SpecialAA) == null) {
                        if ((NewStart = NewStart.GetFailure()).GetOutput() == null) continue;
                        this.AddMatches(Gene, Sequence.length(), NewStart, ExonsVisited);
                    }
                    if ((NewStart = NewStart.GetNext(Edge.SpecialAA)).GetOutput() != null) {
                        this.AddMatches(Gene, 0, NewStart, NewExonsVisited);
                    }
                }
                ArrayList Locs = null;
                String Key = String.valueOf(Exon.Index) + "_" + Edge.LinkTo.Index;
                Locs = VisitedExonHash.containsKey(Key) ? (ArrayList)VisitedExonHash.get(Key) : new ArrayList();
                if (!Utils.IntegerArrayListContains(Locs, NewStart.StateNum)) {
                    Locs.add(new Integer(NewStart.StateNum));
                    VisitedExonHash.put(Key, Locs);
                    this.GetSplicedMatches(Gene, Edge.LinkTo, 0, NewStart, NewExonsVisited, VisitedExonHash);
                } else if (LocalDebug) {
                    System.out.println("We've already searched exon " + Edge.LinkTo.Index + " starting at node " + CurrentNode.StateNum);
                }
                Edge = Edge.Next;
            }
        } else {
            BuildMS2DB.MS2Edge Edge = Exon.ReverseIntrons;
            while (Edge != null) {
                TrieNode NewStart = CurrentNode;
                ArrayList<BuildMS2DB.MS2Exon> NewExonsVisited = new ArrayList<BuildMS2DB.MS2Exon>(ExonsVisited);
                NewExonsVisited.add(Edge.LinkTo);
                if (LocalDebug) {
                    System.out.println("Considering reverse edge " + Exon.Index + " to " + Edge.LinkTo.Index);
                }
                if (Edge.SpecialAA != '\u0000') {
                    if (LocalDebug) {
                        System.out.println("Considering special AA: " + Edge.SpecialAA);
                    }
                    while (NewStart.GetNext(Edge.SpecialAA) == null) {
                        if ((NewStart = NewStart.GetFailure()).GetOutput() == null) continue;
                        this.AddMatches(Gene, Sequence.length(), NewStart, ExonsVisited);
                    }
                    if ((NewStart = NewStart.GetNext(Edge.SpecialAA)).GetOutput() != null) {
                        this.AddMatches(Gene, 0, NewStart, NewExonsVisited);
                    }
                }
                ArrayList Locs = null;
                String Key = String.valueOf(Exon.Index) + "_" + Edge.LinkTo.Index;
                Locs = VisitedExonHash.containsKey(Key) ? (ArrayList)VisitedExonHash.get(Key) : new ArrayList();
                if (!Utils.IntegerArrayListContains(Locs, NewStart.StateNum)) {
                    Locs.add(new Integer(NewStart.StateNum));
                    VisitedExonHash.put(Key, Locs);
                    this.GetSplicedMatches(Gene, Edge.LinkTo, 0, NewStart, NewExonsVisited, VisitedExonHash);
                } else if (LocalDebug) {
                    System.out.println("We've already searched exon " + Edge.LinkTo.Index + " starting at node " + CurrentNode.StateNum);
                }
                Edge = Edge.Next;
            }
        }
    }

    private void AddMatches(BuildMS2DB.MS2Gene Gene, int ExonPos, TrieNode CurrentNode, ArrayList ExonsVisited) {
        String[] Output;
        boolean LocalDebug = false;
        if (LocalDebug) {
            System.out.println("Adding a new match...");
        }
        if ((Output = CurrentNode.GetOutput()) == null) {
            return;
        }
        int i = 0;
        while (i < Output.length) {
            if (LocalDebug) {
                System.out.println("Backtracking for peptide " + Output[i]);
                System.out.println("Have " + ExonsVisited.size() + " exons to visit");
                int f = 0;
                while (f < ExonsVisited.size()) {
                    BuildMS2DB.MS2Exon tempExon = (BuildMS2DB.MS2Exon)ExonsVisited.get(f);
                    tempExon.DebugPrint(false);
                    ++f;
                }
            }
            String SplicedAAString = "";
            String PlainString = "";
            String SpliceString = "";
            String LeftAA = "*";
            String RightAA = "*";
            int ExonIndex = ExonsVisited.size() - 1;
            BuildMS2DB.MS2Exon CurrExon = (BuildMS2DB.MS2Exon)ExonsVisited.get(ExonIndex);
            BuildMS2DB.MS2Exon PrevExon = null;
            if (ExonIndex > 0) {
                PrevExon = (BuildMS2DB.MS2Exon)ExonsVisited.get(ExonIndex - 1);
            }
            String Sequence = Utils.CleanUpPeptideString(CurrExon.Sequence);
            int CurrPos = ExonPos - 1;
            if (ExonPos < Sequence.length()) {
                RightAA = "" + Sequence.charAt(ExonPos);
            } else if (ExonPos == Sequence.length()) {
                BuildMS2DB.MS2Edge F = null;
                F = Gene.ForwardFlag == 1 ? CurrExon.ForwardIntrons : CurrExon.ReverseIntrons;
                while (F != null && F.SpecialAA == '\u0000' && (F.LinkTo.Sequence == null || F.LinkTo.Sequence.length() == 0)) {
                    F = F.Next;
                }
                if (F != null) {
                    RightAA = F.SpecialAA != '\u0000' ? "" + F.SpecialAA : "" + Sequence.charAt(0);
                }
            }
            int Start = -1;
            int End = -1;
            if (Gene.ForwardFlag == 1) {
                End = CurrExon.Start + CurrExon.Prefix.length() + ExonPos * 3;
            } else {
                Start = CurrExon.End - CurrExon.Prefix.length() - ExonPos * 3;
            }
            while (CurrExon != null) {
                BuildMS2DB.MS2Edge Edge;
                if (LocalDebug) {
                    System.out.println("Looking at exon -" + Sequence + "-");
                }
                while (CurrPos >= 0) {
                    SplicedAAString = String.valueOf(Sequence.charAt(CurrPos)) + SplicedAAString;
                    PlainString = String.valueOf(Sequence.charAt(CurrPos)) + PlainString;
                    --CurrPos;
                    if (LocalDebug) {
                        System.out.println("Continuing on this Exon: " + SplicedAAString + "  -  " + PlainString);
                    }
                    if (PlainString.compareTo(Output[i]) == 0) break;
                }
                if (PlainString.compareTo(Output[i]) == 0) break;
                if (PrevExon == null) {
                    System.out.println("THERE IS NO PREV EXON< BUT WE DON'T HAVE ALL THE SEQ!!!");
                    int k = 0;
                    while (k < ExonsVisited.size()) {
                        ((BuildMS2DB.MS2Exon)ExonsVisited.get(k)).DebugPrint(true);
                        ++k;
                    }
                    Utils.WaitForEnter();
                }
                if (CurrPos >= 0) continue;
                if (Gene.ForwardFlag == 1) {
                    Edge = null;
                    Edge = CurrExon.ReverseIntrons;
                    while (Edge != null) {
                        if (Edge.LinkTo.equals(PrevExon)) break;
                        Edge = Edge.Next;
                    }
                    if (Edge == null) {
                        System.err.println("ERROR: No edge between Exon " + CurrExon.Index + "and PrevExon " + PrevExon.Index + ", how did this happen?");
                        Gene.DebugPrint(true);
                        int k = 0;
                        while (k < ExonsVisited.size()) {
                            ((BuildMS2DB.MS2Exon)ExonsVisited.get(k)).DebugPrint(false);
                            ++k;
                        }
                        Utils.WaitForEnter();
                        System.exit(0);
                    }
                    if (Edge.SpecialAA != '\u0000' && PrevExon.End != CurrExon.Start) {
                        SplicedAAString = ";" + Edge.SpecialAA + ";" + SplicedAAString;
                        PlainString = String.valueOf(Edge.SpecialAA) + PlainString;
                        SpliceString = String.valueOf(PrevExon.End) + "-" + CurrExon.Start + "," + SpliceString;
                        if (LocalDebug) {
                            System.out.println("End of exon, adding splice: " + SpliceString);
                        }
                        if (LocalDebug) {
                            System.out.println("Have a spanning AA: " + SplicedAAString + "  -  " + PlainString);
                        }
                    } else if (PrevExon.End != CurrExon.Start) {
                        SplicedAAString = ":" + SplicedAAString;
                        SpliceString = String.valueOf(PrevExon.End) + "-" + CurrExon.Start + "," + SpliceString;
                        if (LocalDebug) {
                            System.out.println("End of exon, adding splice: " + SpliceString);
                        }
                        if (LocalDebug) {
                            System.out.println("Have no spanning AA: " + SplicedAAString + "  -  " + PlainString);
                        }
                    } else if (Edge.SpecialAA != '\u0000') {
                        SplicedAAString = String.valueOf(Edge.SpecialAA) + SplicedAAString;
                        PlainString = String.valueOf(Edge.SpecialAA) + PlainString;
                        if (LocalDebug) {
                            System.out.println("Have a spanning AA but abutting: " + SplicedAAString + "  -  " + PlainString);
                        }
                    }
                    CurrExon = PrevExon;
                    PrevExon = null;
                    if (--ExonIndex > 0) {
                        PrevExon = (BuildMS2DB.MS2Exon)ExonsVisited.get(ExonIndex - 1);
                    }
                    Sequence = Utils.CleanUpPeptideString(CurrExon.Sequence);
                    CurrPos = Sequence.length() - 1;
                } else {
                    Edge = null;
                    Edge = CurrExon.ForwardIntrons;
                    while (Edge != null) {
                        if (Edge.LinkTo.equals(PrevExon)) break;
                        Edge = Edge.Next;
                    }
                    if (Edge == null) {
                        System.err.println("ERROR: No edge between Exon " + CurrExon.Index + " and PrevExon " + PrevExon.Index + ", how did this happen?");
                        Gene.DebugPrint(true);
                        return;
                    }
                    if (Edge.SpecialAA != '\u0000' && PrevExon.Start != CurrExon.End) {
                        SplicedAAString = ";" + Edge.SpecialAA + ";" + SplicedAAString;
                        PlainString = String.valueOf(Edge.SpecialAA) + PlainString;
                        SpliceString = String.valueOf(PrevExon.Start) + "-" + CurrExon.End + "," + SpliceString;
                        if (LocalDebug) {
                            System.out.println("End of exon, adding splice: " + SpliceString);
                        }
                        if (LocalDebug) {
                            System.out.println("Have a spanning AA: " + SplicedAAString + "  -  " + PlainString);
                        }
                    } else if (PrevExon.Start != CurrExon.End) {
                        SplicedAAString = ":" + SplicedAAString;
                        SpliceString = String.valueOf(PrevExon.Start) + "-" + CurrExon.End + "," + SpliceString;
                        if (LocalDebug) {
                            System.out.println("End of exon, adding splice: " + SpliceString);
                        }
                        if (LocalDebug) {
                            System.out.println("Have no spanning AA: " + SplicedAAString + "  -  " + PlainString);
                        }
                    } else if (Edge.SpecialAA != '\u0000') {
                        SplicedAAString = String.valueOf(Edge.SpecialAA) + SplicedAAString;
                        PlainString = String.valueOf(Edge.SpecialAA) + PlainString;
                        if (LocalDebug) {
                            System.out.println("Have a spanning AA but abutting: " + SplicedAAString + "  -  " + PlainString);
                        }
                    }
                    CurrExon = PrevExon;
                    PrevExon = null;
                    if (--ExonIndex > 0) {
                        PrevExon = (BuildMS2DB.MS2Exon)ExonsVisited.get(ExonIndex - 1);
                    }
                    Sequence = Utils.CleanUpPeptideString(CurrExon.Sequence);
                    CurrPos = Sequence.length() - 1;
                }
                if (PlainString.compareTo(Output[i]) == 0) break;
            }
            if (LocalDebug) {
                System.out.println("Matched the peptide!!!");
            }
            if (Gene.ForwardFlag == 1) {
                Start = CurrExon.End - CurrExon.Suffix.length() - (Sequence.length() - CurrPos - 1) * 3;
            } else {
                End = CurrExon.Start + CurrExon.Suffix.length() + (Sequence.length() - CurrPos - 1) * 3;
            }
            if (CurrPos >= 0) {
                LeftAA = "" + CurrExon.Sequence.charAt(CurrPos);
            } else if (CurrPos < 0) {
                BuildMS2DB.MS2Edge F = null;
                F = Gene.ForwardFlag == 1 ? CurrExon.ReverseIntrons : CurrExon.ForwardIntrons;
                while (F != null && F.SpecialAA == '\u0000' && (F.LinkTo.Sequence == null || F.LinkTo.Sequence.length() == 0)) {
                    F = F.Next;
                }
                if (F != null) {
                    LeftAA = F.SpecialAA != '\u0000' ? "" + F.SpecialAA : "" + F.LinkTo.Sequence.charAt(F.LinkTo.Sequence.length() - 1);
                }
            }
            if (SpliceString != null && SpliceString.length() > 1) {
                SpliceString = SpliceString.substring(0, SpliceString.length() - 1);
            }
            if (LocalDebug) {
                System.out.println("Match: " + Output[i] + "(" + Start + "-" + End + "), " + SplicedAAString + "," + SpliceString);
                Utils.WaitForEnter();
            }
            PlainString = String.valueOf(LeftAA) + "." + PlainString + "." + RightAA;
            Object[] Location = new Object[]{PlainString, new Integer(Start), new Integer(End), SplicedAAString, SpliceString, Gene.SequenceName, Gene.GeneName, new Integer(Gene.ForwardFlag)};
            ArrayList Temp = null;
            Temp = !this.Locations.containsKey(Output[i]) ? new ArrayList() : (ArrayList)this.Locations.get(Output[i]);
            Temp = this.AddNoRedundancy(Temp, Location);
            this.Locations.put(Output[i], Temp);
            ++i;
        }
    }

    private ArrayList AddNoRedundancy(ArrayList AllLocations, Object[] NewLocation) {
        boolean LocalDebug = false;
        int i = 0;
        while (i < AllLocations.size()) {
            Object[] CurrLoc = (Object[])AllLocations.get(i);
            if (((Integer)CurrLoc[1]).intValue() == ((Integer)NewLocation[1]).intValue() && ((Integer)CurrLoc[2]).intValue() == ((Integer)NewLocation[2]).intValue() && ((Integer)CurrLoc[7]).intValue() == ((Integer)NewLocation[7]).intValue() && ((String)CurrLoc[3]).compareTo((String)NewLocation[3]) == 0 && ((String)CurrLoc[4]).compareTo((String)NewLocation[4]) == 0) {
                if (LocalDebug) {
                    System.out.println("We've seen this guy before!!!");
                }
                return AllLocations;
            }
            ++i;
        }
        AllLocations.add(NewLocation);
        if (LocalDebug) {
            System.out.println("This location is new!!");
        }
        return AllLocations;
    }

    public void ShuffleMS2DB(String OutputDBName) {
        SAXParserFactory ParserFactory = SAXParserFactory.newInstance();
        MS2DBContentHandler MS2DBHandler = new MS2DBContentHandler(this, 2);
        this.Builder = new BuildMS2DB();
        this.Builder.OutputFileName = OutputDBName;
        this.Builder.OutputFile = null;
        try {
            this.Builder.OutputFile = new FileWriter(this.Builder.OutputFileName);
            this.Builder.OutputFile.write("<Database CreatedBy=\"MS2DB:ShuffleMS2DB.java\">\n");
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        try {
            SAXParser Parser2 = ParserFactory.newSAXParser();
            Parser2.parse(new File(this.DBFileName), (DefaultHandler)MS2DBHandler);
        }
        catch (Exception E) {
            E.printStackTrace();
            return;
        }
        try {
            this.Builder.OutputFile.write("\n</Database>\n");
            this.Builder.OutputFile.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
    }

    public void ShuffleAndWriteGene(BuildMS2DB.MS2Gene Gene) {
        boolean LocalDebug = false;
        Gene.RepairSingleExonCustomAAs();
        try {
            this.Builder.OutputMS2Gene(Gene);
        }
        catch (Exception E) {
            E.printStackTrace();
            Utils.WaitForEnter();
            return;
        }
        if (LocalDebug) {
            Gene.DebugPrint(true);
            System.out.println("That was the gene before shuffling");
            Utils.WaitForEnter();
        }
        Gene = Gene.ShuffleGene();
        Gene.RepairSingleExonCustomAAs();
        if (LocalDebug) {
            Gene.DebugPrint(true);
            System.out.println("That was the raw gene shuffled");
            Utils.WaitForEnter();
        }
        this.Builder.SortMS2GeneExons(Gene);
        if (LocalDebug) {
            Gene.DebugPrint(true);
            System.out.println("That was the gene after shuffling");
            Utils.WaitForEnter();
        }
        try {
            this.Builder.OutputMS2Gene(Gene);
        }
        catch (Exception E) {
            E.printStackTrace();
            Utils.WaitForEnter();
            return;
        }
    }

    public String CreateIndex() {
        String IndexFile = String.valueOf(Utils.GetFileNameNoExtension(this.DBFileName)) + ".index";
        this.CreateIndex(IndexFile);
        return IndexFile;
    }

    public void CreateIndex(String IndexFileName) {
        SAXParserFactory ParserFactory = SAXParserFactory.newInstance();
        MS2DBContentHandler MS2DBHandler = new MS2DBContentHandler(this, 3);
        this.Builder = new BuildMS2DB();
        try {
            this.OutFile = new DataOutputStream(new FileOutputStream(IndexFileName));
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        try {
            SAXParser Parser2 = ParserFactory.newSAXParser();
            Parser2.parse(new File(this.DBFileName), (DefaultHandler)MS2DBHandler);
        }
        catch (Exception E) {
            E.printStackTrace();
            return;
        }
        try {
            this.OutFile.close();
        }
        catch (IOException E) {
            E.printStackTrace();
        }
    }

    public void AddToIndex(BuildMS2DB.MS2Gene Gene, int FilePos) {
        String RevisedName = Gene.GeneName.substring(0, Math.min(80, Gene.GeneName.length()));
        int RevisedLength = RevisedName.length();
        if (RevisedName.length() < 80) {
            int i = 0;
            while (i < 80 - RevisedLength) {
                RevisedName = String.valueOf(RevisedName) + '\u0000';
                ++i;
            }
        }
        byte[] B = RevisedName.getBytes();
        try {
            this.OutFile.writeLong(((BuildMS2DB.MS2Exon)Gene.Exons.get((int)0)).Start);
            this.OutFile.writeInt(FilePos);
            this.OutFile.write(B);
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void DetermineGraphCoverage(String SpliceGraph, String GFFFile, String Chromosome) {
        this.Exons = new ArrayList<E>();
        this.Introns = new ArrayList<E>();
        this.Genes = new Hashtable<K, V>();
        Reader = null;
        Line = null;
        CurrGeneName = null;
        FirstExon = -1;
        FirstIntron = -1;
        try {
            Reader = new BufferedReader(new FileReader(GFFFile));
            Line = Reader.readLine();
            if (true) ** GOTO lbl71
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        do {
            if ((Line = Line.trim()).length() > 0 && Line.charAt(0) != '#' && (Bits = Line.split("\t"))[0].compareTo(Chromosome) == 0) {
                if (Bits[2].compareTo("gene") == 0) {
                    if (CurrGeneName != null) {
                        Indexes = new int[]{FirstExon, this.Exons.size() - 1, FirstIntron, this.Introns.size() - 1};
                        this.Genes.put(CurrGeneName, Indexes);
                    }
                    CurrGeneName = null;
                    FirstExon = this.Exons.size();
                    FirstIntron = this.Introns.size();
                    Notes = Bits[8].split(";");
                    i = 0;
                    while (i < Notes.length) {
                        Vals = Notes[i].split("=");
                        if (Vals[0].compareTo("Name") == 0) {
                            CurrGeneName = Vals[1];
                            break;
                        }
                        ++i;
                    }
                    if (CurrGeneName == null) {
                        System.err.println("ERROR: No gene name!!");
                        System.err.println(Line);
                        Utils.WaitForEnter();
                    }
                } else if (Bits[2].compareTo("CDS") == 0) {
                    Start = Integer.parseInt(Bits[3]) - 1;
                    End = Integer.parseInt(Bits[4]);
                    Strand = Bits[6];
                    ForwardFlag = 0;
                    Frame = Integer.parseInt(Bits[7]);
                    if (Strand.compareTo("+") == 0) {
                        Frame = (Start + Frame) % 3;
                        ForwardFlag = 1;
                    } else {
                        Frame = (End - 1 - Frame) % 3;
                    }
                    NewExon = new int[]{Start, End, ForwardFlag, Frame};
                    this.Exons.add(NewExon);
                } else if (Bits[2].compareTo("intron") == 0) {
                    Start = Integer.parseInt(Bits[3]) - 1;
                    End = Integer.parseInt(Bits[4]);
                    Strand = Bits[6];
                    ForwardFlag = 0;
                    if (Strand.compareTo("+") == 0) {
                        ForwardFlag = 1;
                    }
                    NewIntron = new int[]{Start, End, ForwardFlag};
                    this.Introns.add(NewIntron);
                }
            }
            try {
                Line = Reader.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return;
            }
lbl71:
            // 2 sources

        } while (Line != null);
        try {
            Reader.close();
        }
        catch (IOException E) {
            E.printStackTrace();
        }
        ParserFactory = SAXParserFactory.newInstance();
        MS2DBHandler = new MS2DBContentHandler(this, 4);
        try {
            Parser = ParserFactory.newSAXParser();
            Parser.parse(new File(this.DBFileName), (DefaultHandler)MS2DBHandler);
        }
        catch (Exception E) {
            E.printStackTrace();
            return;
        }
    }

    public void ComputeCoverage(BuildMS2DB.MS2Gene Gene) {
        int i = 0;
        while (i < Gene.Exons.size()) {
            BuildMS2DB.MS2Exon mS2Exon = (BuildMS2DB.MS2Exon)Gene.Exons.get(i);
            ++i;
        }
    }

    public void CountStuff(BuildMS2DB.MS2Gene Gene) {
        boolean LocalDebug = false;
        if (LocalDebug) {
            System.out.println("New gene on strand: " + Gene.ForwardFlag);
        }
        if (Gene.ForwardFlag == 1) {
            ++this.ForwardGeneCount;
        } else {
            ++this.ReverseGeneCount;
        }
        ArrayList CurrExons = Gene.Exons;
        if (LocalDebug) {
            System.out.println("Exons: " + CurrExons.size());
        }
        if (Gene.ForwardFlag == 1) {
            this.ForwardExonCount += CurrExons.size();
        } else {
            this.ReverseExonCount += CurrExons.size();
        }
        int i = 0;
        while (i < CurrExons.size()) {
            BuildMS2DB.MS2Exon CurrExon = (BuildMS2DB.MS2Exon)CurrExons.get(i);
            BuildMS2DB.MS2Edge CurrEdge = CurrExon.ForwardIntrons;
            while (CurrEdge != null) {
                if (Gene.ForwardFlag == 1) {
                    ++this.ForwardIntronCount;
                    if (CurrEdge.SpecialAA != '\u0000') {
                        ++this.ForwardAACount;
                    }
                } else {
                    ++this.ReverseIntronCount;
                    if (CurrEdge.SpecialAA != '\u0000') {
                        ++this.ReverseAACount;
                    }
                }
                CurrEdge = CurrEdge.Next;
            }
            if (Gene.ForwardFlag == 1) {
                this.ForwardAACount += CurrExon.Sequence.length();
            } else {
                this.ReverseAACount += CurrExon.Sequence.length();
            }
            ++i;
        }
    }

    public void CountDriver() {
        SAXParserFactory ParserFactory = SAXParserFactory.newInstance();
        MS2DBContentHandler MS2DBHandler = new MS2DBContentHandler(this, 5);
        this.Builder = new BuildMS2DB();
        try {
            SAXParser Parser2 = ParserFactory.newSAXParser();
            Parser2.parse(new File(this.DBFileName), (DefaultHandler)MS2DBHandler);
        }
        catch (Exception E) {
            E.printStackTrace();
            return;
        }
        System.out.println("Forward Strand Stats:");
        System.out.println("  Exons: " + this.ForwardExonCount);
        System.out.println("  Introns: " + this.ForwardIntronCount);
        System.out.println("  AAs: " + this.ForwardAACount);
        System.out.println("  Genes: " + this.ForwardGeneCount);
        System.out.println("Reverse Strand Stats:");
        System.out.println("  Exons: " + this.ReverseExonCount);
        System.out.println("  Introns: " + this.ReverseIntronCount);
        System.out.println("  AAs: " + this.ReverseAACount + "\n");
        System.out.println("  Genes: " + this.ReverseGeneCount);
        Utils.WaitForEnter();
    }

    public static void main(String[] args) {
        MS2DB Tester = new MS2DB("/home/natalie/Projects/Maize/OneGene.ms2db");
        String[] Peptides = new String[]{"LSLTRVCFTR", "PGIRSWTRIEGR", "NRTQASRPLSL", "TYIRTGTTMKT", "GLIPFFKA", "ESRNVIR", "PPPPP", "MKHIGSTWDSAKSV", "IQYFCFPGKKEK", "RKKGKGGREK", "KKGKGGREK", "RDKHKPR"};
        Hashtable Rest = Tester.GetAllLocations(Peptides);
        Enumeration Keys = Rest.keys();
        while (Keys.hasMoreElements()) {
            String Peptide2 = (String)Keys.nextElement();
            System.out.println("Peptide: " + Peptide2);
            ArrayList Locs = (ArrayList)Rest.get(Peptide2);
            int i = 0;
            while (i < Locs.size()) {
                Object[] Loc = (Object[])Locs.get(i);
                System.out.println("Location[" + i + "]: " + Loc[5] + " " + Loc[1] + "-" + Loc[2] + ", on gene: " + Loc[6] + " strand: " + Loc[7] + " SpliceString: " + Loc[3] + ", Splices: " + Loc[4]);
                ++i;
            }
        }
    }

    public class MS2DBContentHandler
    extends DefaultHandler {
        public static final int NONE = 0;
        public static final int DATABASE = 1;
        public static final int GENE = 2;
        public static final int EXON = 3;
        public static final int EXONEXTENDS = 5;
        public static final int EXONLINKFROM = 6;
        public static final int GENECROSSREFERNCE = 7;
        public static final int ERROR = -1;
        public static final int SEARCH_MODE = 1;
        public static final int SHUFFLE_MODE = 2;
        public static final int INDEX_MODE = 3;
        public static final int COVERAGE_MODE = 4;
        public static final int COUNT_MODE = 5;
        public static final int UNSHUFFLE_MODE = 6;
        public int Mode = 0;
        public int RunMode = 0;
        public MS2DB Parent = null;
        public BuildMS2DB.MS2Gene CurrGene = null;
        public BuildMS2DB.MS2Exon CurrExon = null;
        public int CurrGeneFilePos = -1;
        private Locator locator = null;
        public boolean LocalDebug = false;

        public MS2DBContentHandler(MS2DB Parent, int Mode) {
            this.Parent = Parent;
            this.RunMode = Mode;
        }

        @Override
        public void characters(char[] arg0, int start, int length) throws SAXException {
            if (this.Mode != 3) {
                return;
            }
            if (this.CurrExon.Sequence == null) {
                this.CurrExon.Sequence = "";
            }
            int i = start;
            while (i < start + length) {
                this.CurrExon.Sequence = String.valueOf(this.CurrExon.Sequence) + arg0[i];
                ++i;
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (this.Mode == -1) {
                if (this.LocalDebug) {
                    System.out.println("Skipping due to ERROR mode!!");
                }
                return;
            }
            if (this.LocalDebug) {
                System.out.println("End ELEMENT!!");
                System.out.println("uri: " + uri);
                System.out.println("localName: " + localName);
                System.out.println("name: " + name);
                System.out.println("mode: " + this.Mode);
                Utils.WaitForEnter();
            }
            if (name.compareTo("Gene") == 0) {
                if (this.LocalDebug) {
                    System.out.println("Finished loading Gene: " + this.CurrGene.SequenceName);
                    this.CurrGene.DebugPrint(true);
                    Utils.WaitForEnter();
                }
                if (this.RunMode == 1) {
                    this.Parent.SearchSplicableGene(this.CurrGene);
                } else if (this.RunMode == 2) {
                    this.Parent.ShuffleAndWriteGene(this.CurrGene);
                } else if (this.RunMode == 3) {
                    this.Parent.AddToIndex(this.CurrGene, this.CurrGeneFilePos);
                } else if (this.RunMode == 4) {
                    this.Parent.ComputeCoverage(this.CurrGene);
                } else if (this.RunMode == 5) {
                    this.Parent.CountStuff(this.CurrGene);
                } else if (this.RunMode == 6) {
                    this.Parent.WriteIfTargetGene(this.CurrGene);
                } else {
                    System.out.println("We finished a gene, but now we are doing nothing...PICK A MODE!");
                }
            }
            if (name.compareTo("Exon") == 0) {
                this.CurrExon.Sequence = Utils.CleanUpPeptideString(this.CurrExon.Sequence);
                this.CurrGene.Exons.add(this.CurrExon);
                if (this.LocalDebug) {
                    System.out.println("Finished EXON!!");
                    System.out.println(this.CurrExon.Sequence);
                    this.CurrExon.DebugPrint(true);
                }
            }
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            block43: {
                block45: {
                    block44: {
                        if (this.Mode == -1) {
                            if (this.LocalDebug) {
                                System.out.println("Skipping due to ERROR mode!!");
                            }
                            return;
                        }
                        if (this.LocalDebug) {
                            System.out.println("Start ELEMENT!!");
                            System.out.println("uri: " + uri);
                            System.out.println("localName: " + localName);
                            System.out.println("name: " + name);
                            System.out.println("mode: " + this.Mode);
                            Utils.WaitForEnter();
                        }
                        if (name.compareTo("Database") != 0) break block44;
                        this.Mode = 1;
                        break block43;
                    }
                    if (name.compareTo("Gene") != 0) break block45;
                    this.Mode = 2;
                    this.CurrGeneFilePos = this.locator.getLineNumber();
                    this.CurrGene = this.Parent.Builder.NewMS2Gene();
                    String GeneName = atts.getValue("Name");
                    if (GeneName == null) {
                        System.err.println("ERROR: Cannot find attribute 'Name' in start of Element Gene");
                        this.Mode = -1;
                        return;
                    }
                    String Temp = atts.getValue("ForwardFlag");
                    if (Temp == null) {
                        System.err.println("ERROR: Cannot find attribute 'ForwardFlag' in start of Element Gene");
                        this.Mode = -1;
                        return;
                    }
                    this.CurrGene.ForwardFlag = Integer.parseInt(Temp);
                    this.CurrGene.GeneName = GeneName;
                    this.CurrGene.SequenceName = BuildMS2DB.GetSequenceNameFromGene(GeneName);
                    if (!this.LocalDebug) break block43;
                    System.out.println("SequenceName: " + this.CurrGene.SequenceName);
                    break block43;
                }
                if (name.compareTo("Exon") == 0) {
                    String Temp;
                    this.Mode = 3;
                    String[] Names = new String[]{"Index", "Start", "End", "PrefixLen", "SuffixLen", "ReadingFrame"};
                    int[] Values = new int[Names.length];
                    String[] sNames = new String[]{"Prefix", "Suffix"};
                    String[] sValues = new String[sNames.length];
                    int i = 0;
                    while (i < Values.length) {
                        Temp = atts.getValue(Names[i]);
                        if (Temp == null) {
                            System.err.println("ERROR: Cannot find attribute '" + Names[i] + "' in start of Element Exon");
                            if (this.LocalDebug) {
                                Utils.WaitForEnter();
                            }
                            this.Mode = -1;
                            return;
                        }
                        Values[i] = Integer.parseInt(Temp);
                        ++i;
                    }
                    i = 0;
                    while (i < sValues.length) {
                        Temp = atts.getValue(sNames[i]);
                        if (Temp == null) {
                            System.err.println("ERROR: Cannot find attribute '" + sNames[i] + "' in start of Element Exon");
                            if (this.LocalDebug) {
                                Utils.WaitForEnter();
                            }
                            this.Mode = -1;
                            return;
                        }
                        sValues[i] = Temp;
                        ++i;
                    }
                    int ReadingFrame = 0;
                    ReadingFrame = Values[5];
                    this.CurrExon = this.Parent.Builder.NewMS2Exon(Values[1], Values[2], ReadingFrame, this.CurrGene.SequenceName, this.CurrGene.ForwardFlag);
                    this.CurrExon.ParentGene = this.CurrGene;
                    this.CurrExon.Index = Values[0];
                    this.CurrExon.Prefix = sValues[0];
                    this.CurrExon.Suffix = sValues[1];
                } else if (name.compareTo("LinkFrom") == 0) {
                    String Temp = atts.getValue("Index");
                    if (Temp == null) {
                        System.err.println("ERROR: Cannot find attribute 'Index' in start of Element LinkFrom");
                        this.Mode = -1;
                        return;
                    }
                    int LinkFromIndex = Integer.parseInt(Temp);
                    Temp = atts.getValue("AA");
                    if (Temp == null) {
                        ArrayList Exons = this.CurrGene.Exons;
                        int i = 0;
                        while (i < Exons.size()) {
                            BuildMS2DB.MS2Exon Exon = (BuildMS2DB.MS2Exon)Exons.get(i);
                            if (Exon.Index == LinkFromIndex) {
                                if (this.CurrGene.ForwardFlag == 1) {
                                    Exon.LinkExonForward(this.CurrExon);
                                } else {
                                    this.CurrExon.LinkExonForward(Exon);
                                }
                                break;
                            }
                            ++i;
                        }
                    } else {
                        ArrayList Exons = this.CurrGene.Exons;
                        int i = 0;
                        while (i < Exons.size()) {
                            BuildMS2DB.MS2Exon Exon = (BuildMS2DB.MS2Exon)Exons.get(i);
                            if (Exon.Index == LinkFromIndex) {
                                if (this.CurrGene.ForwardFlag == 1) {
                                    Exon.LinkExonForward(this.CurrExon, Temp.toCharArray()[0]);
                                } else {
                                    this.CurrExon.LinkExonForward(Exon, Temp.toCharArray()[0]);
                                }
                                break;
                            }
                            ++i;
                        }
                    }
                    this.Mode = 6;
                } else if (name.compareTo("ExtendsExon") == 0) {
                    this.Mode = 5;
                    String Temp = atts.getValue("Index");
                    if (Temp == null) {
                        System.err.println("ERROR: Cannot find attribute 'Index' in start of Element ExtendsExon");
                        this.Mode = -1;
                        return;
                    }
                    int LinkFromIndex = Integer.parseInt(Temp);
                    if (this.LocalDebug) {
                        System.out.println("LinkFromIndex: " + LinkFromIndex + " to " + this.CurrExon.Index);
                        Utils.WaitForEnter();
                    }
                    if ((Temp = atts.getValue("AA")) == null) {
                        if (this.LocalDebug) {
                            System.out.println("We have no spanning AA!");
                        }
                        ArrayList Exons = this.CurrGene.Exons;
                        int i = 0;
                        while (i < Exons.size()) {
                            BuildMS2DB.MS2Exon Exon = (BuildMS2DB.MS2Exon)Exons.get(i);
                            if (Exon.Index == LinkFromIndex) {
                                if (this.LocalDebug) {
                                    System.out.println("Found Exon " + LinkFromIndex);
                                }
                                if (this.CurrGene.ForwardFlag == 1) {
                                    Exon.LinkExonForward(this.CurrExon);
                                } else {
                                    this.CurrExon.LinkExonForward(Exon);
                                }
                                break;
                            }
                            ++i;
                        }
                    } else {
                        if (this.LocalDebug) {
                            System.out.println("We have  spanning AA = " + Temp);
                        }
                        ArrayList Exons = this.CurrGene.Exons;
                        int i = 0;
                        while (i < Exons.size()) {
                            BuildMS2DB.MS2Exon Exon = (BuildMS2DB.MS2Exon)Exons.get(i);
                            if (Exon.Index == LinkFromIndex) {
                                if (this.CurrGene.ForwardFlag == 1) {
                                    Exon.LinkExonForward(this.CurrExon, Temp.toCharArray()[0]);
                                } else {
                                    this.CurrExon.LinkExonForward(Exon, Temp.toCharArray()[0]);
                                }
                                break;
                            }
                            ++i;
                        }
                    }
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }

    public static class MS2DBLocationColumns {
        public static final int Peptide = 0;
        public static final int Start = 1;
        public static final int End = 2;
        public static final int SplicedAAString = 3;
        public static final int SpliceString = 4;
        public static final int SequenceName = 5;
        public static final int GeneName = 6;
        public static final int ForwardFlag = 7;
    }
}

