/*
 * Decompiled with CFR 0.152.
 */
package basicUtils;

import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class InspectAnnotation {
    public static final String RESERVED_CHAR = "@";
    public static String EMPTY_STRING = "";
    public String SpectrumFile;
    public int ScanNumber;
    public String AnnotationWithFlanking;
    public String Annotation;
    public String ProteinName;
    public int Charge;
    public double MQScore;
    public int Length;
    public int NTT;
    public double FDR;
    public double FScore;
    public double DeltaScoreAny;
    public double DeltaScore;
    public int ProteinID;
    public int TrieDBPos;
    public int SpecFileOffset;
    public double ParentMZ;
    public double MZError;
    public int Chromosome = -1;
    public int Strand = -1;
    public String GenomicPos = EMPTY_STRING;
    public String SplicedSequence = EMPTY_STRING;
    public String Splices = EMPTY_STRING;
    public String SearchDB = EMPTY_STRING;
    public double SpecProb = -1.0;
    public double LocalFDR = -1.0;
    public double DeltaKnown = Double.NaN;
    public String DeltaKnownAnn = null;
    public boolean IsNovel;
    public String OriginalLine;
    public String OriginalFileName = EMPTY_STRING;
    public String SourceProgram = "Inspect";
    public boolean IsUnique = false;
    public static String HeaderLine = "#SpectrumFile\tScan#\tAnnotation\tProtein\tCharge\tMQScore\tLength\tTotalPRMScore\tMedianPRMScore\tFractionY\tFractionB\tInstensity\tNTT\tp-value\tF-Score\tDeltaScore\tDeltaScoreOther\tRecordNumber\tDBFilePos\tSpecFilePos\tFileMZ\tMZError\tUnModdedAnnotation\n";
    public static String SplicedHeaderLine = "#SpectrumFile\tScan#\tAnnotation\tProtein\tCharge\tMQScore\tLength\tTotalPRMScore\tMedianPRMScore\tFractionY\tFractionB\tInstensity\tNTT\tp-value\tF-Score\tDeltaScore\tDeltaScoreOther\tRecordNumber\tDBFilePos\tSpecFilePos\tFileMZ\tMZError\tChromosome\tStrand\tGenomicPos\tSplicedSequence\tSplices\tSearchDB\tOriginalFile\tLocalFDR\tDeltaKnown\tDeltaKnownAnn\tIsNovel\tSpecProb\n";
    public static String SplicedHeaderLineNoSpecProb = "#SpectrumFile\tScan#\tAnnotation\tProtein\tCharge\tMQScore\tLength\tTotalPRMScore\tMedianPRMScore\tFractionY\tFractionB\tInstensity\tNTT\tp-value\tF-Score\tDeltaScore\tDeltaScoreOther\tRecordNumber\tDBFilePos\tSpecFilePos\tFileMZ\tMZError\tChromosome\tStrand\tGenomicPos\tSplicedSequence\tSplices\tSearchDB\tOriginalFile\tLocalFDR\tDeltaKnown\tDeltaKnownAnn\tIsNovel\n";

    public InspectAnnotation() {
    }

    public InspectAnnotation(String FileLine) {
        this(FileLine, false);
    }

    public InspectAnnotation(String line, boolean isMSGFDBLine) {
        if (!isMSGFDBLine) {
            String FileLine = line;
            if (FileLine.length() == 0 || FileLine.charAt(0) == '#') {
                System.out.println("AA");
                return;
            }
            String[] Elements = FileLine.split("\t", -1);
            if (Elements.length == JackFormatColumns.MinElements || Elements.length == JackFormatColumns.MinElements + 1) {
                this.SpectrumFile = Elements[JackFormatColumns.SpectrumFile];
                try {
                    this.ScanNumber = Integer.parseInt(Elements[JackFormatColumns.ScanNumber]);
                }
                catch (NumberFormatException E) {
                    System.err.println("ERROR: Unable to parse scan number from " + Elements[InspectColumns.ScanNumber]);
                    return;
                }
                this.Annotation = Elements[JackFormatColumns.Annotation];
                this.AnnotationWithFlanking = Elements[JackFormatColumns.Annotation];
                this.Annotation = this.Annotation.substring(2, this.Annotation.length() - 2);
                this.Charge = Integer.parseInt(Elements[JackFormatColumns.Charge]);
                this.SourceProgram = Elements[JackFormatColumns.SourceProgram];
                this.ProteinName = Elements[JackFormatColumns.ProteinName];
                try {
                    this.SpecProb = Double.parseDouble(Elements[JackFormatColumns.SpecProb]);
                }
                catch (Exception E2) {
                    E2.printStackTrace();
                    this.Length = 0;
                    return;
                }
                String pep = Utils.GetUnModded(this.Annotation);
                this.Length = pep.length();
                this.OriginalLine = FileLine;
                return;
            }
            if (Elements.length < InspectColumns.MinElements) {
                System.out.println("ShortLine: " + FileLine);
                return;
            }
            this.SpectrumFile = Elements[InspectColumns.SpectrumFile];
            try {
                this.ScanNumber = Integer.parseInt(Elements[InspectColumns.ScanNumber]);
            }
            catch (NumberFormatException E) {
                System.err.println("ERROR: Unable to parse scan number from " + Elements[InspectColumns.ScanNumber]);
                return;
            }
            this.Annotation = Elements[InspectColumns.Annotation];
            this.AnnotationWithFlanking = Elements[InspectColumns.Annotation];
            this.Annotation = this.Annotation.substring(2, this.Annotation.length() - 2);
            this.ProteinName = Elements[InspectColumns.ProteinName];
            if (this.ProteinName == null) {
                System.out.println("PROTEIN NAME IS NULL!!");
                System.out.println(FileLine);
            }
            this.Charge = Integer.parseInt(Elements[InspectColumns.Charge]);
            this.MQScore = Double.parseDouble(Elements[InspectColumns.MQScore]);
            try {
                this.Length = Integer.parseInt(Elements[InspectColumns.Length]);
            }
            catch (NumberFormatException e) {
                try {
                    this.Length = (int)Double.parseDouble(Elements[InspectColumns.Length]);
                }
                catch (Exception E) {
                    System.err.println("ERROR: Unable to parse length from " + Elements[InspectColumns.Length]);
                    return;
                }
            }
            try {
                this.NTT = Integer.parseInt(Elements[InspectColumns.NumTrypTermini]);
            }
            catch (NumberFormatException e) {
                try {
                    this.NTT = (int)Double.parseDouble(Elements[InspectColumns.NumTrypTermini]);
                }
                catch (Exception E) {
                    System.err.println("ERROR: Unable to parse NTT from " + Elements[InspectColumns.NumTrypTermini]);
                    this.Length = 0;
                    return;
                }
            }
            try {
                this.FDR = Double.parseDouble(Elements[InspectColumns.FDR]);
            }
            catch (Exception E) {
                this.FDR = 1.0;
            }
            this.FScore = Double.parseDouble(Elements[InspectColumns.FScore]);
            this.DeltaScoreAny = Double.parseDouble(Elements[InspectColumns.DeltaScoreAny]);
            this.DeltaScore = Double.parseDouble(Elements[InspectColumns.DeltaScore]);
            this.ProteinID = Integer.parseInt(Elements[InspectColumns.ProteinID]);
            this.TrieDBPos = Integer.parseInt(Elements[InspectColumns.TrieDBPos]);
            this.SpecFileOffset = Integer.parseInt(Elements[InspectColumns.SpecFileOffset]);
            if (Elements.length > InspectColumns.ParentMZ) {
                try {
                    this.ParentMZ = Double.parseDouble(Elements[InspectColumns.ParentMZ]);
                }
                catch (Exception E) {
                    this.ParentMZ = 0.0;
                }
            }
            if (Elements.length > InspectColumns.MZError) {
                try {
                    this.MZError = Double.parseDouble(Elements[InspectColumns.MZError]);
                }
                catch (Exception E) {
                    this.MZError = 0.0;
                }
            }
            if (Elements.length > InspectColumns.OriginalFileName) {
                try {
                    this.Chromosome = Integer.parseInt(Elements[InspectColumns.Chromosome]);
                }
                catch (Exception E) {
                    this.Chromosome = -1;
                }
                try {
                    this.Strand = Integer.parseInt(Elements[InspectColumns.Strand]);
                }
                catch (Exception E) {
                    this.Strand = -1;
                }
                try {
                    this.GenomicPos = Elements[InspectColumns.GenomicPos];
                    if (this.GenomicPos.length() == 0) {
                        this.GenomicPos = EMPTY_STRING;
                    }
                }
                catch (Exception E) {
                    this.GenomicPos = EMPTY_STRING;
                }
                try {
                    this.SplicedSequence = Elements[InspectColumns.SplicedSequence];
                    if (this.SplicedSequence.length() == 0) {
                        this.SplicedSequence = EMPTY_STRING;
                    }
                }
                catch (Exception E) {
                    this.SplicedSequence = EMPTY_STRING;
                }
                try {
                    this.Splices = Elements[InspectColumns.Splices];
                    if (this.Splices.length() == 0 || this.Splices.compareTo("null") == 0) {
                        this.Splices = " ";
                    }
                }
                catch (Exception E) {
                    this.Splices = EMPTY_STRING;
                }
                try {
                    this.SearchDB = Elements[InspectColumns.SearchDB];
                    if (this.SearchDB.length() == 0) {
                        this.SearchDB = EMPTY_STRING;
                    }
                }
                catch (Exception E) {
                    this.SearchDB = EMPTY_STRING;
                }
            } else if (Elements.length > InspectColumns.MZError + 1) {
                try {
                    this.SpecProb = Double.parseDouble(Elements[InspectColumns.MZError + 1]);
                }
                catch (Exception E) {
                    this.SpecProb = -1.0;
                }
            }
            if (Elements.length > InspectColumns.OriginalFileName) {
                try {
                    this.OriginalFileName = Elements[InspectColumns.OriginalFileName];
                    if (this.OriginalFileName.length() == 0) {
                        this.OriginalFileName = EMPTY_STRING;
                    }
                }
                catch (Exception E) {
                    this.OriginalFileName = EMPTY_STRING;
                }
            }
            if (Elements.length > InspectColumns.LocalFDR) {
                try {
                    this.LocalFDR = Double.parseDouble(Elements[InspectColumns.LocalFDR]);
                }
                catch (Exception E) {
                    this.LocalFDR = -1.0;
                }
            }
            if (Elements.length > InspectColumns.DeltaKnown) {
                try {
                    this.DeltaKnown = Double.parseDouble(Elements[InspectColumns.DeltaKnown]);
                }
                catch (Exception E) {
                    this.DeltaKnown = Double.NaN;
                }
            }
            if (Elements.length > InspectColumns.DeltaKnownAnn) {
                try {
                    this.DeltaKnownAnn = Elements[InspectColumns.DeltaKnownAnn];
                }
                catch (Exception E) {
                    this.DeltaKnownAnn = null;
                }
            }
            if (Elements.length > InspectColumns.IsNovel) {
                try {
                    this.IsNovel = Boolean.parseBoolean(Elements[InspectColumns.IsNovel]);
                }
                catch (Exception E) {
                    this.IsNovel = false;
                }
            }
            if (Elements.length > InspectColumns.SpecProb) {
                try {
                    this.SpecProb = Double.parseDouble(Elements[InspectColumns.SpecProb]);
                }
                catch (Exception E) {
                    this.SpecProb = -1.0;
                }
            }
        } else {
            String[] Elements = line.split("\t", -1);
            if (Elements.length < MSGFDBFormatColumns.MinElements) {
                System.out.println("ShortLine: " + line);
                return;
            }
            this.SpectrumFile = Elements[MSGFDBFormatColumns.SpectrumFile];
            try {
                this.ScanNumber = Integer.parseInt(Elements[MSGFDBFormatColumns.ScanNumber]);
            }
            catch (NumberFormatException E) {
                System.err.println("ERROR: Unable to parse scan number from " + Elements[MSGFDBFormatColumns.ScanNumber]);
                return;
            }
            if (this.ScanNumber <= 0) {
                try {
                    this.ScanNumber = Integer.parseInt(Elements[MSGFDBFormatColumns.SpecIndex]) - 1;
                }
                catch (NumberFormatException E) {
                    System.err.println("ERROR: Unable to parse scan number from " + Elements[MSGFDBFormatColumns.SpecIndex]);
                    return;
                }
            }
            this.Annotation = Elements[MSGFDBFormatColumns.Annotation];
            this.AnnotationWithFlanking = Elements[MSGFDBFormatColumns.Annotation];
            if (this.Annotation.indexOf(46) >= 0) {
                this.Annotation = this.Annotation.substring(2, this.Annotation.length() - 2);
            }
            this.ProteinName = Elements[MSGFDBFormatColumns.Protein];
            if (this.ProteinName == null) {
                System.out.println("PROTEIN NAME IS NULL!!");
                System.out.println(line);
            }
            this.Charge = Integer.parseInt(Elements[MSGFDBFormatColumns.Charge]);
            this.MQScore = -1.0;
            this.Length = this.Annotation.length();
            try {
                this.FDR = Double.parseDouble(Elements[MSGFDBFormatColumns.FDR]);
            }
            catch (Exception E) {
                this.FDR = 1.0;
            }
            this.FScore = Double.NaN;
            this.DeltaScoreAny = Double.NaN;
            this.DeltaScore = Double.NaN;
            this.ProteinID = -1;
            this.TrieDBPos = -1;
            this.SpecFileOffset = -1;
            this.ParentMZ = Double.parseDouble(Elements[MSGFDBFormatColumns.PrecursorMZ]);
            this.MZError = Double.parseDouble(Elements[MSGFDBFormatColumns.PrecursorPPM]);
            this.SpecProb = Double.parseDouble(Elements[MSGFDBFormatColumns.SpecProb]);
        }
        this.OriginalLine = line;
    }

    public static InspectAnnotation[] LoadInpsectResultsDir(String Dir) {
        File DirFile = new File(Dir);
        if (DirFile.isFile()) {
            return InspectAnnotation.LoadInspectResultsFile(Dir);
        }
        System.out.println("We are loading from a directory: " + Dir);
        ArrayList<InspectAnnotation> Annotations = new ArrayList<InspectAnnotation>();
        String[] Files = DirFile.list();
        int i = 0;
        while (i < Files.length) {
            System.out.println("Loading from " + Files[i]);
            InspectAnnotation[] Temp = InspectAnnotation.LoadInspectResultsFile(String.valueOf(DirFile.getAbsolutePath()) + File.separator + Files[i]);
            int j = 0;
            while (j < Temp.length) {
                Temp[j].OriginalFileName = Files[i];
                Annotations.add(Temp[j]);
                ++j;
            }
            ++i;
        }
        System.out.println("Loaded " + Annotations.size() + " annotations from directory " + Dir);
        InspectAnnotation[] Ret = new InspectAnnotation[Annotations.size()];
        int i2 = 0;
        while (i2 < Ret.length) {
            Ret[i2] = (InspectAnnotation)Annotations.get(i2);
            ++i2;
        }
        return Ret;
    }

    public static String[] LoadPeptidesDir(String Dir) {
        File DirFile = new File(Dir);
        if (DirFile.isFile()) {
            return InspectAnnotation.LoadPeptidesFile(Dir);
        }
        System.out.println("We are loading from a directory: " + Dir);
        ArrayList<String> Annotations = new ArrayList<String>();
        String[] Files = DirFile.list();
        int i = 0;
        while (i < Files.length) {
            System.out.println("Loading from " + Files[i]);
            String[] Temp = InspectAnnotation.LoadPeptidesFile(String.valueOf(DirFile.getAbsolutePath()) + File.separator + Files[i]);
            int j = 0;
            while (Temp != null && j < Temp.length) {
                String UnModded = Utils.GetUnModded(Temp[j]);
                if (!Annotations.contains(UnModded)) {
                    Annotations.add(UnModded);
                }
                ++j;
            }
            ++i;
        }
        System.out.println("Loaded " + Annotations.size() + " annotations from directory " + Dir);
        return Utils.ConvertArraylistToStringArray(Annotations);
    }

    public static String[] LoadPeptidesFile(String File2) {
        String Line;
        BufferedReader Reader2;
        try {
            Reader2 = new BufferedReader(new FileReader(File2));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        ArrayList<String> Annotations = new ArrayList<String>();
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) != '#') {
                String[] Bits = Line.split("\t");
                if (Bits.length <= InspectColumns.Annotation) continue;
                String UnModded = Utils.GetUnModded(Bits[InspectColumns.Annotation]);
                if (!Annotations.contains(UnModded)) {
                    Annotations.add(UnModded);
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        return Utils.ConvertArraylistToStringArray(Annotations);
    }

    public static InspectAnnotation[] LoadInspectResultsFile(String File2) {
        String Line;
        BufferedReader Reader2;
        boolean LocalDebug = false;
        try {
            Reader2 = new BufferedReader(new FileReader(File2));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        if (LocalDebug) {
            System.out.println("Loading InsPecT results from " + File2);
        }
        ArrayList<InspectAnnotation> Annotations = new ArrayList<InspectAnnotation>();
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) != '#') {
                if (LocalDebug) {
                    System.out.println("Adding annotation:");
                    System.out.println(Line);
                }
                InspectAnnotation NewAnnotation = new InspectAnnotation(Line);
                if (NewAnnotation.Length > 0) {
                    NewAnnotation.OriginalFileName = File2;
                    Annotations.add(NewAnnotation);
                    if (LocalDebug) {
                        System.out.println("Added the new annotation!!");
                    }
                } else if (LocalDebug) {
                    System.out.println("Did not add the new annotation!!");
                }
                if (LocalDebug) {
                    Utils.WaitForEnter();
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        InspectAnnotation[] Ret = new InspectAnnotation[Annotations.size()];
        int i = 0;
        while (i < Annotations.size()) {
            Ret[i] = (InspectAnnotation)Annotations.get(i);
            ++i;
        }
        return Ret;
    }

    public static InspectAnnotation[] LoadInspectResultsFileIncreasingOrder(String File2, int Column) {
        String Line;
        BufferedReader Reader2;
        try {
            Reader2 = new BufferedReader(new FileReader(File2));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        ArrayList Annotations = new ArrayList();
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) != '#') {
                InspectAnnotation NewAnnotation = new InspectAnnotation(Line);
                if (NewAnnotation.Length > 0) {
                    NewAnnotation.OriginalFileName = File2;
                    Annotations = InspectAnnotation.InsertIncreasingOrder(Annotations, NewAnnotation, 0, Annotations.size(), Column);
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        InspectAnnotation[] Ret = new InspectAnnotation[Annotations.size()];
        int i = 0;
        while (i < Annotations.size()) {
            Ret[i] = (InspectAnnotation)Annotations.get(i);
            ++i;
        }
        return Ret;
    }

    public static InspectAnnotation[] LoadInspectResultsFileIncreasingOrderTwoVotes(String File2, int Column) {
        String Line;
        BufferedReader Reader2;
        if (Column != InspectColumns.SpecProb && Column != InspectColumns.FScore) {
            System.out.println("WARNING: Cannot sort by anything but SpecProb or FScore!!");
            return InspectAnnotation.LoadInspectResultsFile(File2);
        }
        try {
            Reader2 = new BufferedReader(new FileReader(File2));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        ArrayList Annotations = new ArrayList();
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) != '#') {
                InspectAnnotation NewAnnotation = new InspectAnnotation(Line);
                if (NewAnnotation.Length > 0) {
                    NewAnnotation.OriginalFileName = File2;
                    Annotations = InspectAnnotation.InsertIncreasingOrder(Annotations, NewAnnotation, 0, Annotations.size(), Column);
                } else {
                    System.err.println("WARNING: Skipping invalid file line: " + Line);
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        int Index = 0;
        Hashtable<String, boolean[]> ScanHash = new Hashtable<String, boolean[]>();
        boolean LocalDebug = false;
        System.out.println("Loaded " + Annotations.size() + " anns");
        while (Index < Annotations.size()) {
            InspectAnnotation CurrAnn = (InspectAnnotation)Annotations.get(Index);
            String HashKey = String.valueOf(CurrAnn.SpectrumFile) + "_" + CurrAnn.ScanNumber;
            if (LocalDebug) {
                System.out.println("CurrAnn: " + HashKey + " - " + CurrAnn.SpecProb + " - " + CurrAnn.ProteinName);
            }
            boolean[] FoundInfo = null;
            if (ScanHash.containsKey(HashKey)) {
                FoundInfo = (boolean[])ScanHash.get(HashKey);
                if (LocalDebug) {
                    System.out.println("We've seen this guy before!!");
                    System.out.println("Seen true: " + FoundInfo[0]);
                    System.out.println("Seen false: " + FoundInfo[1]);
                }
            } else {
                FoundInfo = new boolean[]{false, false};
                if (LocalDebug) {
                    System.out.println("We've NEVER seen this guy before!!");
                }
            }
            if (CurrAnn.ProteinName == null) {
                System.out.println(CurrAnn.OriginalLine);
            }
            if (Utils.IsDecoyProtein(CurrAnn.ProteinName) && FoundInfo[1] || !Utils.IsDecoyProtein(CurrAnn.ProteinName) && FoundInfo[0]) {
                Annotations.remove(Index);
                if (!LocalDebug) continue;
                System.out.println("We've seen the same version of this guy before, removing it from list!!");
                Utils.WaitForEnter();
                continue;
            }
            if (Utils.IsDecoyProtein(CurrAnn.ProteinName)) {
                FoundInfo[1] = true;
            } else {
                FoundInfo[0] = true;
            }
            ScanHash.put(HashKey, FoundInfo);
            ++Index;
            if (!LocalDebug) continue;
            System.out.println("We're adding new info about this guy!!");
            System.out.println("Seen true: " + FoundInfo[0]);
            System.out.println("Seen false: " + FoundInfo[1]);
            Utils.WaitForEnter();
        }
        System.out.println("Reduced to " + Annotations.size() + " anns of extreme values only");
        InspectAnnotation[] Ret = new InspectAnnotation[Annotations.size()];
        int i = 0;
        while (i < Annotations.size()) {
            Ret[i] = (InspectAnnotation)Annotations.get(i);
            ++i;
        }
        return Ret;
    }

    public static InspectAnnotation[] LoadInspectResultsFileDecreasingOrderTwoVotes(String File2, int Column) {
        String Line;
        BufferedReader Reader2;
        if (Column != InspectColumns.SpecProb && Column != InspectColumns.FScore) {
            System.out.println("WARNING: Cannot sort by anything but SpecProb or FScore!!");
            return InspectAnnotation.LoadInspectResultsFile(File2);
        }
        try {
            Reader2 = new BufferedReader(new FileReader(File2));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        ArrayList Annotations = new ArrayList();
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) != '#') {
                InspectAnnotation NewAnnotation = new InspectAnnotation(Line);
                if (NewAnnotation.Length > 0) {
                    NewAnnotation.OriginalFileName = File2;
                    Annotations = InspectAnnotation.InsertDecreasingOrder(Annotations, NewAnnotation, 0, Annotations.size(), Column);
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        int Index = 0;
        Hashtable<String, boolean[]> ScanHash = new Hashtable<String, boolean[]>();
        boolean LocalDebug = false;
        System.out.println("Loaded " + Annotations.size() + " anns");
        while (Index < Annotations.size()) {
            InspectAnnotation CurrAnn = (InspectAnnotation)Annotations.get(Index);
            String HashKey = String.valueOf(CurrAnn.SpectrumFile) + "_" + CurrAnn.ScanNumber;
            if (LocalDebug) {
                System.out.println("CurrAnn: " + HashKey + " - " + CurrAnn.SpecProb + " - " + CurrAnn.ProteinName);
            }
            boolean[] FoundInfo = null;
            if (ScanHash.containsKey(HashKey)) {
                FoundInfo = (boolean[])ScanHash.get(HashKey);
                if (LocalDebug) {
                    System.out.println("We've seen this guy before!!");
                    System.out.println("Seen true: " + FoundInfo[0]);
                    System.out.println("Seen false: " + FoundInfo[1]);
                }
            } else {
                FoundInfo = new boolean[]{false, false};
                if (LocalDebug) {
                    System.out.println("We've NEVER seen this guy before!!");
                }
            }
            if (Utils.IsDecoyProtein(CurrAnn.ProteinName) && FoundInfo[1] || !Utils.IsDecoyProtein(CurrAnn.ProteinName) && FoundInfo[0]) {
                Annotations.remove(Index);
                if (!LocalDebug) continue;
                System.out.println("We've seen the same version of this guy before, removing it from list!!");
                Utils.WaitForEnter();
                continue;
            }
            if (Utils.IsDecoyProtein(CurrAnn.ProteinName)) {
                FoundInfo[1] = true;
            } else {
                FoundInfo[0] = true;
            }
            ScanHash.put(HashKey, FoundInfo);
            ++Index;
            if (!LocalDebug) continue;
            System.out.println("We're adding new info about this guy!!");
            System.out.println("Seen true: " + FoundInfo[0]);
            System.out.println("Seen false: " + FoundInfo[1]);
            Utils.WaitForEnter();
        }
        System.out.println("Reduced to " + Annotations.size() + " anns of extreme values only");
        InspectAnnotation[] Ret = new InspectAnnotation[Annotations.size()];
        int i = 0;
        while (i < Annotations.size()) {
            Ret[i] = (InspectAnnotation)Annotations.get(i);
            ++i;
        }
        return Ret;
    }

    public static Hashtable LoadInspectScoresTwoVotes(String File2, int Column) {
        String Line;
        BufferedReader Reader2;
        boolean LowIsBetter = true;
        if (Column == InspectColumns.SpecProb || Column == InspectColumns.FDR || Column == InspectColumns.LocalFDR) {
            LowIsBetter = true;
        } else if (Column == InspectColumns.MQScore || Column == InspectColumns.FScore || Column == InspectColumns.DeltaScore || Column == InspectColumns.DeltaScoreAny) {
            LowIsBetter = false;
        } else {
            System.out.println("WARNING: You are trying to rank Inspect results by a non-canonical column.  We assume that a higher value is better\n");
            LowIsBetter = false;
        }
        try {
            Reader2 = new BufferedReader(new FileReader(File2));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        Hashtable<String, double[]> ScanHash = new Hashtable<String, double[]>();
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) != '#') {
                String[] Bits = Line.split("\t");
                if (Bits[InspectColumns.SpectrumFile].indexOf(RESERVED_CHAR) >= 0) {
                    System.err.println("ERROR: Cannot hash file name '" + Bits[InspectColumns.SpectrumFile] + "' containing reserved char '" + RESERVED_CHAR + "'!");
                    System.exit(-1);
                }
                String HashKey = String.valueOf(Bits[InspectColumns.SpectrumFile]) + RESERVED_CHAR + Bits[InspectColumns.ScanNumber];
                double[] FoundInfo = null;
                if (ScanHash.containsKey(HashKey)) {
                    FoundInfo = (double[])ScanHash.get(HashKey);
                } else {
                    FoundInfo = new double[2];
                    if (LowIsBetter) {
                        FoundInfo[0] = Double.POSITIVE_INFINITY;
                        FoundInfo[1] = Double.POSITIVE_INFINITY;
                    } else {
                        FoundInfo[0] = Double.NEGATIVE_INFINITY;
                        FoundInfo[1] = Double.NEGATIVE_INFINITY;
                    }
                }
                double CurrVal = Double.parseDouble(Bits[Column]);
                int Index = 0;
                if (Utils.IsDecoyProtein(Bits[InspectColumns.ProteinName])) {
                    Index = 1;
                }
                if (LowIsBetter && CurrVal < FoundInfo[Index]) {
                    FoundInfo[Index] = CurrVal;
                } else if (!LowIsBetter && CurrVal > FoundInfo[Index]) {
                    FoundInfo[Index] = CurrVal;
                }
                ScanHash.put(HashKey, FoundInfo);
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        return ScanHash;
    }

    private static ArrayList InsertIncreasingOrder(ArrayList CurrList, InspectAnnotation NewAnn, int Start, int End, int ScoreColumn) {
        double CurrScore;
        double NewScore;
        boolean LocalDebug = false;
        if (LocalDebug) {
            System.out.println("[" + Start + "-" + End + "]");
        }
        if (Start == End) {
            if (LocalDebug) {
                System.out.println("Start = End (" + Start + "): adding NewAnn with value " + NewAnn.SpecProb + " here");
                Utils.WaitForEnter();
            }
            CurrList.add(Start, NewAnn);
            return CurrList;
        }
        int MidIndex = Start + (End - Start) / 2;
        InspectAnnotation CurrAnn = (InspectAnnotation)CurrList.get(MidIndex);
        if (ScoreColumn == InspectColumns.SpecProb) {
            NewScore = NewAnn.SpecProb;
            CurrScore = CurrAnn.SpecProb;
        } else if (ScoreColumn == InspectColumns.FScore) {
            NewScore = NewAnn.FScore;
            CurrScore = CurrAnn.FScore;
        } else {
            System.err.println("ERROR: Unsupported score type for p-Value computation!!");
            return null;
        }
        if (NewScore < CurrScore) {
            if (LocalDebug) {
                System.out.println("New Ann < CurrAnn[" + MidIndex + "], " + NewAnn.SpecProb + " < " + CurrAnn.SpecProb);
                Utils.WaitForEnter();
            }
            return InspectAnnotation.InsertIncreasingOrder(CurrList, NewAnn, Start, MidIndex, ScoreColumn);
        }
        if (NewScore > CurrScore) {
            if (LocalDebug) {
                System.out.println("New Ann > CurrAnn[" + MidIndex + "], " + NewAnn.SpecProb + " > " + CurrAnn.SpecProb);
                Utils.WaitForEnter();
            }
            return InspectAnnotation.InsertIncreasingOrder(CurrList, NewAnn, MidIndex + 1, End, ScoreColumn);
        }
        if (LocalDebug) {
            System.out.println("New Ann = CurrAnn[" + MidIndex + "], " + NewAnn.SpecProb + " = " + CurrAnn.SpecProb);
            Utils.WaitForEnter();
        }
        CurrList.add(MidIndex, NewAnn);
        return CurrList;
    }

    private static ArrayList InsertDecreasingOrder(ArrayList CurrList, InspectAnnotation NewAnn, int Start, int End, int ScoreColumn) {
        double CurrScore;
        double NewScore;
        boolean LocalDebug = false;
        if (LocalDebug) {
            System.out.println("[" + Start + "-" + End + "]");
        }
        if (Start == End) {
            if (LocalDebug) {
                System.out.println("Start = End (" + Start + "): adding NewAnn with value " + NewAnn.SpecProb + " here");
                Utils.WaitForEnter();
            }
            CurrList.add(Start, NewAnn);
            return CurrList;
        }
        int MidIndex = Start + (End - Start) / 2;
        InspectAnnotation CurrAnn = (InspectAnnotation)CurrList.get(MidIndex);
        if (ScoreColumn == InspectColumns.SpecProb) {
            NewScore = NewAnn.SpecProb;
            CurrScore = CurrAnn.SpecProb;
        } else if (ScoreColumn == InspectColumns.FScore) {
            NewScore = NewAnn.FScore;
            CurrScore = CurrAnn.FScore;
        } else {
            System.err.println("ERROR: Unsupported score type for p-Value computation!!");
            return null;
        }
        if (NewScore > CurrScore) {
            if (LocalDebug) {
                System.out.println("New Ann < CurrAnn[" + MidIndex + "], " + NewAnn.SpecProb + " < " + CurrAnn.SpecProb);
                Utils.WaitForEnter();
            }
            return InspectAnnotation.InsertDecreasingOrder(CurrList, NewAnn, Start, MidIndex, ScoreColumn);
        }
        if (NewScore < CurrScore) {
            if (LocalDebug) {
                System.out.println("New Ann > CurrAnn[" + MidIndex + "], " + NewAnn.SpecProb + " > " + CurrAnn.SpecProb);
                Utils.WaitForEnter();
            }
            return InspectAnnotation.InsertDecreasingOrder(CurrList, NewAnn, MidIndex + 1, End, ScoreColumn);
        }
        if (LocalDebug) {
            System.out.println("New Ann = CurrAnn[" + MidIndex + "], " + NewAnn.SpecProb + " = " + CurrAnn.SpecProb);
            Utils.WaitForEnter();
        }
        CurrList.add(MidIndex, NewAnn);
        return CurrList;
    }

    public static Hashtable LoadInspectResultsFileToHash(String File2) {
        String Line;
        BufferedReader Reader2;
        try {
            Reader2 = new BufferedReader(new FileReader(File2));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        Hashtable<String, InspectAnnotation> Annotations = new Hashtable<String, InspectAnnotation>();
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) != '#') {
                InspectAnnotation NewAnnotation = new InspectAnnotation(Line);
                NewAnnotation.OriginalFileName = File2;
                if (NewAnnotation.Length > 0) {
                    String HashKey;
                    String fileName = Utils.GetBaseNameNoExtension(NewAnnotation.SpectrumFile);
                    if (fileName.indexOf(RESERVED_CHAR) >= 0) {
                        System.err.println("ERROR: Cannot hash file name '" + fileName + "' containing reserved char '" + RESERVED_CHAR + "'!");
                        System.exit(-1);
                    }
                    if (Annotations.containsKey(HashKey = String.valueOf(fileName) + RESERVED_CHAR + NewAnnotation.ScanNumber)) {
                        InspectAnnotation OldAnnotation = (InspectAnnotation)Annotations.get(HashKey);
                        if (OldAnnotation.MQScore < NewAnnotation.MQScore) {
                            Annotations.put(HashKey, NewAnnotation);
                        }
                    } else {
                        Annotations.put(HashKey, NewAnnotation);
                    }
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        return Annotations;
    }

    public static Hashtable LoadInspectResultsFileToPeptideHash(String File2) {
        String Line;
        BufferedReader Reader2;
        try {
            Reader2 = new BufferedReader(new FileReader(File2));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        Hashtable<String, InspectAnnotation> Annotations = new Hashtable<String, InspectAnnotation>();
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) != '#') {
                InspectAnnotation NewAnnotation = new InspectAnnotation(Line);
                NewAnnotation.OriginalFileName = File2;
                if (NewAnnotation.Length > 0) {
                    String HashKey = NewAnnotation.Annotation;
                    if (Annotations.containsKey(HashKey)) {
                        InspectAnnotation OldAnnotation = (InspectAnnotation)Annotations.get(HashKey);
                        if (OldAnnotation.SpecProb > NewAnnotation.SpecProb) {
                            Annotations.put(HashKey, NewAnnotation);
                        }
                    } else {
                        Annotations.put(HashKey, NewAnnotation);
                    }
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        return Annotations;
    }

    public static Hashtable LoadIntoProteinHashtable(String FileName) {
        BufferedReader buf = null;
        String Line = null;
        Hashtable<String, Object[]> Result = new Hashtable<String, Object[]>();
        try {
            buf = new BufferedReader(new FileReader(FileName));
            Line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        while (Line != null) {
            Object[] Value;
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            String[] Bits = Line.split("\t");
            String ProteinName = Bits[InspectColumns.ProteinName];
            String Peptide2 = Bits[InspectColumns.Annotation];
            if (Result.containsKey(ProteinName)) {
                Value = (Object[])Result.get(ProteinName);
                if (!((ArrayList)Value[0]).contains(Peptide2)) {
                    ((ArrayList)Value[0]).add(Peptide2);
                }
                int NewSpecCount = (Integer)Value[1] + 1;
                Value[1] = new Integer(NewSpecCount);
                Result.put(ProteinName, Value);
            } else {
                Value = new Object[2];
                Value[0] = new ArrayList();
                ((ArrayList)Value[0]).add(Peptide2);
                Value[1] = new Integer(1);
                Result.put(ProteinName, Value);
            }
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        return Result;
    }

    public static InspectAnnotation[] ArrayListToList(ArrayList Old) {
        InspectAnnotation[] Ret = new InspectAnnotation[Old.size()];
        int i = 0;
        while (i < Old.size()) {
            Ret[i] = (InspectAnnotation)Old.get(i);
            ++i;
        }
        return Ret;
    }

    public boolean compareToNoSpecFile(InspectAnnotation Ann) {
        if (this.ScanNumber != Ann.ScanNumber) {
            return false;
        }
        if (this.AnnotationWithFlanking.compareTo(Ann.AnnotationWithFlanking) != 0) {
            return false;
        }
        if (this.Charge != Ann.Charge) {
            return false;
        }
        if (this.MQScore != Ann.MQScore) {
            return false;
        }
        if (this.FDR != Ann.FDR) {
            return false;
        }
        return this.SpecProb == Ann.SpecProb;
    }

    public static int indexOfNoSpecFile(InspectAnnotation[] CurrList, InspectAnnotation CurrAnn) {
        int i = 0;
        while (i < CurrList.length) {
            if (CurrList[i] != null && CurrList[i].compareToNoSpecFile(CurrAnn)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toStringMinimal() {
        String[] Bits = this.OriginalLine.split("\t");
        String Ret = "";
        Ret = String.valueOf(Ret) + this.SpectrumFile + "\t" + this.ScanNumber + "\t" + this.AnnotationWithFlanking + "\t" + this.ProteinName + "\t";
        Ret = String.valueOf(Ret) + this.Charge + "\t" + this.MQScore + "\t" + this.Length + "\t" + Bits[InspectColumns.TotalPRMScore] + "\t" + Bits[InspectColumns.MedianPRMScore] + "\t";
        Ret = String.valueOf(Ret) + Bits[InspectColumns.FractionY] + "\t" + Bits[InspectColumns.FractionB] + "\t" + Bits[InspectColumns.Intensity] + "\t" + this.NTT + "\t";
        Ret = String.valueOf(Ret) + this.FDR + "\t" + this.FScore + "\t" + this.DeltaScoreAny + "\t" + this.DeltaScore + "\t" + this.ProteinID + "\t" + this.TrieDBPos + "\t";
        Ret = String.valueOf(Ret) + this.SpecFileOffset;
        if (Bits.length > InspectColumns.ParentMZ) {
            Ret = this.ParentMZ != 0.0 ? String.valueOf(Ret) + "\t" + this.ParentMZ + "\t" + this.MZError : String.valueOf(Ret) + "\t \t ";
        }
        if (Bits.length > InspectColumns.Chromosome) {
            Ret = String.valueOf(Ret) + "\t" + this.Chromosome;
            Ret = String.valueOf(Ret) + "\t" + this.Strand;
            Ret = String.valueOf(Ret) + "\t" + this.GenomicPos;
            Ret = String.valueOf(Ret) + "\t" + this.SplicedSequence;
            Ret = String.valueOf(Ret) + "\t" + this.Splices;
            Ret = String.valueOf(Ret) + "\t" + this.SearchDB;
        }
        if (Bits.length > InspectColumns.OriginalFileName) {
            Ret = String.valueOf(Ret) + "\t" + this.OriginalFileName;
        }
        if (Bits.length > InspectColumns.LocalFDR) {
            Ret = this.LocalFDR != -1.0 ? String.valueOf(Ret) + "\t" + this.LocalFDR : String.valueOf(Ret) + "\t";
        }
        if (Bits.length > InspectColumns.DeltaKnown) {
            Ret = this.DeltaKnown != Double.NaN ? String.valueOf(Ret) + "\t" + this.DeltaKnown : String.valueOf(Ret) + "\t";
        }
        if (Bits.length > InspectColumns.DeltaKnownAnn) {
            Ret = this.DeltaKnownAnn != null ? String.valueOf(Ret) + "\t" + this.DeltaKnownAnn : String.valueOf(Ret) + "\t";
        }
        if (Bits.length > InspectColumns.IsNovel) {
            Ret = String.valueOf(Ret) + "\t" + this.IsNovel;
        }
        if (Bits.length > InspectColumns.SpecProb && this.SpecProb != -1.0) {
            Ret = String.valueOf(Ret) + "\t" + this.SpecProb;
        }
        return Ret;
    }

    public String toJackFormatString() {
        String ret = "";
        String[] Bits = this.OriginalLine.split("\t");
        ret = String.valueOf(ret) + this.SpectrumFile + "\t" + this.ScanNumber + "\t" + this.ScanNumber + "\t" + Bits[JackFormatColumns.Score] + "\t";
        ret = String.valueOf(ret) + this.AnnotationWithFlanking + "\t" + this.Charge + "\t" + this.SourceProgram + "\t" + this.SpecProb + "\t" + this.ProteinName + "\t";
        ret = String.valueOf(ret) + this.FDR;
        return ret;
    }

    public String toString() {
        String[] Bits = this.OriginalLine.split("\t");
        if (Bits.length == JackFormatColumns.MinElements) {
            return this.toJackFormatString();
        }
        String Ret = "";
        Ret = String.valueOf(Ret) + this.SpectrumFile + "\t" + this.ScanNumber + "\t" + this.AnnotationWithFlanking + "\t" + this.ProteinName + "\t";
        Ret = String.valueOf(Ret) + this.Charge + "\t" + this.MQScore + "\t" + this.Length + "\t" + Bits[InspectColumns.TotalPRMScore] + "\t" + Bits[InspectColumns.MedianPRMScore] + "\t";
        Ret = String.valueOf(Ret) + Bits[InspectColumns.FractionY] + "\t" + Bits[InspectColumns.FractionB] + "\t" + Bits[InspectColumns.Intensity] + "\t" + this.NTT + "\t";
        Ret = String.valueOf(Ret) + this.FDR + "\t" + this.FScore + "\t" + this.DeltaScoreAny + "\t" + this.DeltaScore + "\t" + this.ProteinID + "\t" + this.TrieDBPos + "\t";
        Ret = String.valueOf(Ret) + this.SpecFileOffset;
        Ret = this.ParentMZ != 0.0 ? String.valueOf(Ret) + "\t" + this.ParentMZ + "\t" + this.MZError : String.valueOf(Ret) + "\t \t ";
        Ret = String.valueOf(Ret) + "\t" + this.Chromosome;
        Ret = String.valueOf(Ret) + "\t" + this.Strand;
        Ret = String.valueOf(Ret) + "\t" + this.GenomicPos;
        Ret = String.valueOf(Ret) + "\t" + this.SplicedSequence;
        Ret = String.valueOf(Ret) + "\t" + this.Splices;
        Ret = String.valueOf(Ret) + "\t" + this.SearchDB;
        Ret = String.valueOf(Ret) + "\t" + this.OriginalFileName;
        Ret = this.LocalFDR != -1.0 ? String.valueOf(Ret) + "\t" + this.LocalFDR : String.valueOf(Ret) + "\t";
        Ret = this.DeltaKnown != Double.NaN ? String.valueOf(Ret) + "\t" + this.DeltaKnown : String.valueOf(Ret) + "\t";
        Ret = this.DeltaKnownAnn != null ? String.valueOf(Ret) + "\t" + this.DeltaKnownAnn : String.valueOf(Ret) + "\t";
        Ret = String.valueOf(Ret) + "\t" + this.IsNovel;
        if (this.SpecProb != -1.0) {
            Ret = String.valueOf(Ret) + "\t" + this.SpecProb;
        }
        return Ret;
    }

    public static Hashtable LoadInspectAnnotationsIntoSpecHash(String[] files) {
        Hashtable<String, Boolean> ret = new Hashtable<String, Boolean>();
        BufferedReader buf = null;
        String Line = null;
        int i = 0;
        while (i < files.length) {
            try {
                buf = new BufferedReader(new FileReader(files[i]));
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            while (Line != null) {
                if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                    try {
                        Line = buf.readLine();
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                    continue;
                }
                String[] Bits = Line.split("\t");
                String fileName = Utils.GetBaseName(Bits[InspectColumns.SpectrumFile]);
                if (fileName.indexOf(RESERVED_CHAR) >= 0) {
                    System.err.println("ERROR: Cannot hash file name '" + fileName + "' containing reserved char '" + RESERVED_CHAR + "'!");
                    System.exit(-1);
                }
                String scanNum = Bits[InspectColumns.ScanNumber];
                String hashKey = String.valueOf(fileName) + RESERVED_CHAR + scanNum;
                ret.put(hashKey, new Boolean(true));
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
            }
            try {
                buf.close();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            ++i;
        }
        return ret;
    }

    public static Hashtable LoadInspectAnnotationsIntoSpec2PeptideHash(String Dir) {
        Hashtable ret = new Hashtable();
        Object buf = null;
        Object Line = null;
        String[] files = Utils.IsDir(Dir) ? Utils.ListDir(Dir) : new String[]{Dir};
        return InspectAnnotation.LoadInspectAnnotationsIntoSpec2PeptideHash(files);
    }

    public static Hashtable LoadInspectAnnotationsIntoSpec2PeptideHash(String[] files) {
        Hashtable<String, String> ret = new Hashtable<String, String>();
        BufferedReader buf = null;
        String Line = null;
        int i = 0;
        while (i < files.length) {
            try {
                buf = new BufferedReader(new FileReader(files[i]));
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            while (Line != null) {
                if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                    try {
                        Line = buf.readLine();
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                    continue;
                }
                String[] Bits = Line.split("\t");
                String fileName = Utils.GetBaseName(Bits[InspectColumns.SpectrumFile]);
                if (fileName.indexOf(RESERVED_CHAR) >= 0) {
                    System.out.println("ERROR: Cannot hash file with reserved char '@'!");
                    System.exit(-1);
                }
                String scanNum = Bits[InspectColumns.ScanNumber];
                String hashKey = String.valueOf(fileName) + RESERVED_CHAR + scanNum;
                if (!ret.containsKey(hashKey)) {
                    ret.put(hashKey, Bits[InspectColumns.Annotation]);
                }
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
            }
            try {
                buf.close();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            ++i;
        }
        return ret;
    }

    public void DebugPrint() {
        System.out.println("FileName: " + this.SpectrumFile + " Scan: " + this.ScanNumber);
        System.out.println("Peptide: " + this.Annotation);
        System.out.println(this.toString());
        System.out.println("SpecProb: " + this.SpecProb);
    }

    public static Hashtable LoadInspectAnnotationsIntoSpec2PeptideAndScoreHash(String[] files) {
        Hashtable<String, String[]> ret = new Hashtable<String, String[]>();
        BufferedReader buf = null;
        String Line = null;
        int i = 0;
        while (i < files.length) {
            try {
                buf = new BufferedReader(new FileReader(files[i]));
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            while (Line != null) {
                if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                    try {
                        Line = buf.readLine();
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                    continue;
                }
                String[] Bits = Line.split("\t");
                String fileName = Utils.GetBaseName(Bits[InspectColumns.SpectrumFile]);
                String scanNum = Bits[InspectColumns.ScanNumber];
                if (fileName.indexOf(RESERVED_CHAR) >= 0) {
                    System.err.println("ERROR: Cannot hash file name '" + fileName + "' containing reserved char '" + RESERVED_CHAR + "'!");
                    System.exit(-1);
                }
                String hashKey = String.valueOf(fileName) + RESERVED_CHAR + scanNum;
                String[] val = new String[]{Bits[InspectColumns.Annotation], Bits[InspectColumns.MQScore]};
                if (!ret.containsKey(hashKey)) {
                    ret.put(hashKey, val);
                }
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
            }
            try {
                buf.close();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            ++i;
        }
        return ret;
    }

    public static Hashtable GetAllAnnotatedScanNums(String fileName) {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        BufferedReader buf = null;
        String Line = null;
        try {
            buf = new BufferedReader(new FileReader(fileName));
            Line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        while (Line != null) {
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            String[] Bits = Line.split("\t");
            String specFile = Utils.GetBaseName(Bits[InspectColumns.SpectrumFile]);
            int scanNum = Integer.parseInt(Bits[InspectColumns.ScanNumber]);
            ArrayList scanNums = null;
            scanNums = map.containsKey(specFile) ? (ArrayList)map.get(specFile) : new ArrayList();
            Utils.InsertInAscendingOrder(scanNums, scanNum);
            map.put(specFile, scanNums);
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        Enumeration E = map.keys();
        while (E.hasMoreElements()) {
            String f = (String)E.nextElement();
            ArrayList scans = (ArrayList)map.get(f);
            int[] scanList = Utils.ConvertArraylistToIntArray(scans);
            map.put(f, scanList);
        }
        return map;
    }

    public static Hashtable GetAllAnnotatedScanNumsWithPeptides(String fileName, ArrayList peptideList) {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        BufferedReader buf = null;
        String Line = null;
        try {
            buf = new BufferedReader(new FileReader(fileName));
            Line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        while (Line != null) {
            if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            String[] Bits = Line.split("\t");
            String specFile = Utils.GetBaseName(Bits[InspectColumns.SpectrumFile]);
            int scanNum = Integer.parseInt(Bits[InspectColumns.ScanNumber]);
            String peptide = Utils.GetUnModded(Bits[InspectColumns.Annotation]);
            if (!peptideList.contains(peptide)) {
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            ArrayList scanNums = null;
            scanNums = map.containsKey(specFile) ? (ArrayList)map.get(specFile) : new ArrayList();
            Utils.InsertInAscendingOrder(scanNums, scanNum);
            map.put(specFile, scanNums);
            try {
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        Enumeration E = map.keys();
        while (E.hasMoreElements()) {
            String f = (String)E.nextElement();
            ArrayList scans = (ArrayList)map.get(f);
            int[] scanList = Utils.ConvertArraylistToIntArray(scans);
            map.put(f, scanList);
        }
        return map;
    }

    public static Hashtable LoadInspectResultsPep2FileNameHash(String[] files) {
        Hashtable<String, ArrayList> ret = new Hashtable<String, ArrayList>();
        BufferedReader buf = null;
        String Line = null;
        int i = 0;
        while (i < files.length) {
            try {
                buf = new BufferedReader(new FileReader(files[i]));
                Line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            while (Line != null) {
                if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                    try {
                        Line = buf.readLine();
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                    continue;
                }
                String[] Bits = Line.split("\t");
                String fileName = Utils.GetBaseName(Bits[InspectColumns.SpectrumFile]);
                String peptide = Bits[InspectColumns.Annotation];
                if (peptide.indexOf(46) >= 0) {
                    peptide = peptide.substring(2, peptide.length() - 2);
                }
                String hashKey = peptide;
                String val = fileName;
                ArrayList fileNames = null;
                fileNames = !ret.containsKey(hashKey) ? new ArrayList() : (ArrayList)ret.get(hashKey);
                if (!fileNames.contains(val)) {
                    fileNames.add(val);
                }
                ret.put(hashKey, fileNames);
                try {
                    Line = buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
            }
            try {
                buf.close();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            ++i;
        }
        return ret;
    }

    public static InspectAnnotation[] LoadMSGFDBResultsFile(String fileName, double FDRcutoff) {
        String Line;
        BufferedReader Reader2 = null;
        boolean LocalDebug = false;
        try {
            Reader2 = new BufferedReader(new FileReader(fileName));
            Line = Reader2.readLine();
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return null;
        }
        if (LocalDebug) {
            System.out.println("Loading MSGFDB results from " + fileName);
        }
        ArrayList<InspectAnnotation> Annotations = new ArrayList<InspectAnnotation>();
        while (Line != null) {
            if (Line.length() > 0 && Line.charAt(0) != '#') {
                if (LocalDebug) {
                    System.out.println("Adding annotation:");
                    System.out.println(Line);
                }
                InspectAnnotation NewAnnotation = new InspectAnnotation(Line, true);
                if (NewAnnotation.Length > 0 && NewAnnotation.FDR <= FDRcutoff) {
                    NewAnnotation.OriginalFileName = fileName;
                    Annotations.add(NewAnnotation);
                    if (LocalDebug) {
                        System.out.println("Added the new annotation!!");
                    }
                } else if (LocalDebug) {
                    System.out.println("Did not add the new annotation!!");
                }
                if (LocalDebug) {
                    Utils.WaitForEnter();
                }
            }
            try {
                Line = Reader2.readLine();
            }
            catch (Exception E) {
                System.err.println(E.getMessage());
                return null;
            }
        }
        InspectAnnotation[] Ret = new InspectAnnotation[Annotations.size()];
        int i = 0;
        while (i < Annotations.size()) {
            Ret[i] = (InspectAnnotation)Annotations.get(i);
            ++i;
        }
        return Ret;
    }

    public static class InspectColumns {
        public static int MinElements = 20;
        public static int SpectrumFile = 0;
        public static int ScanNumber = 1;
        public static int Annotation = 2;
        public static int ProteinName = 3;
        public static int Charge = 4;
        public static int MQScore = 5;
        public static int Length = 6;
        public static int TotalPRMScore = 7;
        public static int MedianPRMScore = 8;
        public static int FractionY = 9;
        public static int FractionB = 10;
        public static int Intensity = 11;
        public static int NumTrypTermini = 12;
        public static int FDR = 13;
        public static int FScore = 14;
        public static int DeltaScoreAny = 15;
        public static int DeltaScore = 16;
        public static int ProteinID = 17;
        public static int TrieDBPos = 18;
        public static int SpecFileOffset = 19;
        public static int ParentMZ = 20;
        public static int MZError = 21;
        public static int Chromosome = 22;
        public static int Strand = 23;
        public static int GenomicPos = 24;
        public static int SplicedSequence = 25;
        public static int Splices = 26;
        public static int SearchDB = 27;
        public static int OriginalFileName = 28;
        public static int LocalFDR = 29;
        public static int DeltaKnown = 30;
        public static int DeltaKnownAnn = 31;
        public static int IsNovel = 32;
        public static int SpecProb = 33;
    }

    public static class JackFormatColumns {
        public static int MinElements = 10;
        public static int SpectrumFile = 0;
        public static int ScanNumber = 1;
        public static int LastScanNumber = 2;
        public static int Score = 3;
        public static int Annotation = 4;
        public static int Charge = 5;
        public static int SourceProgram = 6;
        public static int SpecProb = 7;
        public static int PeptideType = 8;
        public static int ProteinName = 9;
    }

    public static class MSGFDBFormatColumns {
        public static int MinElements = 13;
        public static int SpectrumFile = 0;
        public static int SpecIndex = 1;
        public static int ScanNumber = 2;
        public static int FragmentationMethod = 3;
        public static int PrecursorMZ = 4;
        public static int PrecursorPPM = 5;
        public static int Charge = 6;
        public static int Annotation = 7;
        public static int Protein = 8;
        public static int DeNovoScore = 9;
        public static int MSGFScore = 10;
        public static int SpecProb = 11;
        public static int pvalue = 12;
        public static int FDR = 13;
    }
}

