"""Added aggregator_computer_name and aggregator_version to RecentRun

Revision ID: 5dbc834cf70e
Revises: 95bfa6af85ea
Create Date: 2024-02-06 14:30:02.409741

"""
from socket import gethostname
from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op
from openpectus import __version__

# revision identifiers, used by Alembic.
revision: str = '5dbc834cf70e'
down_revision: Union[str, None] = '95bfa6af85ea'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('RecentRuns', schema=None) as batch_op:
        batch_op.add_column(sa.Column('aggregator_computer_name', sa.String(), nullable=False, server_default=gethostname()))
        batch_op.add_column(sa.Column('aggregator_version', sa.String(), nullable=False, server_default=__version__))
        batch_op.alter_column(column_name='aggregator_computer_name', server_default=None)
        batch_op.alter_column(column_name='aggregator_version', server_default=None)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('RecentRuns', schema=None) as batch_op:
        batch_op.drop_column('aggregator_version')
        batch_op.drop_column('aggregator_computer_name')

    # ### end Alembic commands ###
