/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.utilities.TextStreamWriter;

public class CSVWriter
extends TextStreamWriter {
    public CSVWriter(OutputStream out) throws UnsupportedEncodingException {
        super(out);
    }

    protected String csvEscape(String s2) {
        if (s2 == null) {
            return "";
        }
        if (s2.contains("\"")) {
            return s2.substring(0, s2.indexOf("\"")) + "\"" + this.csvEscape(s2.substring(s2.indexOf("\"") + 1));
        }
        if (s2.contains(",")) {
            return "\"" + s2 + "\"";
        }
        return s2;
    }

    public void line(String ... fields) throws IOException {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (String s2 : fields) {
            if (first) {
                first = false;
            } else {
                b.append(",");
            }
            b.append(this.csvEscape(s2));
        }
        this.ln(b.toString());
    }
}

