/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AdverseEventSeverity {
    MILD,
    MODERATE,
    SEVERE,
    NULL;


    public static AdverseEventSeverity fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("mild".equals(codeString)) {
            return MILD;
        }
        if ("moderate".equals(codeString)) {
            return MODERATE;
        }
        if ("severe".equals(codeString)) {
            return SEVERE;
        }
        throw new FHIRException("Unknown AdverseEventSeverity code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case MILD: {
                return "mild";
            }
            case MODERATE: {
                return "moderate";
            }
            case SEVERE: {
                return "severe";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/adverse-event-severity";
    }

    public String getDefinition() {
        switch (this) {
            case MILD: {
                return "";
            }
            case MODERATE: {
                return "";
            }
            case SEVERE: {
                return "";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case MILD: {
                return "Mild";
            }
            case MODERATE: {
                return "Moderate";
            }
            case SEVERE: {
                return "Severe";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

