/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.util.CoverageIgnore;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class NonPrettyPrintWriterWrapper
implements XMLStreamWriter {
    private static final String PRE = "pre";
    private XMLStreamWriter myTarget;
    private int myInsidePre = 0;

    public NonPrettyPrintWriterWrapper(XMLStreamWriter target) {
        this.myTarget = target;
    }

    @Override
    public void flush() throws XMLStreamException {
        this.myTarget.flush();
    }

    @Override
    public void close() throws XMLStreamException {
        this.myTarget.close();
    }

    @Override
    @CoverageIgnore
    public String getPrefix(String theUri) throws XMLStreamException {
        return this.myTarget.getPrefix(theUri);
    }

    @Override
    @CoverageIgnore
    public void setPrefix(String thePrefix, String theUri) throws XMLStreamException {
        this.myTarget.setPrefix(thePrefix, theUri);
    }

    @Override
    @CoverageIgnore
    public void setDefaultNamespace(String theUri) throws XMLStreamException {
        this.myTarget.setDefaultNamespace(theUri);
    }

    @Override
    @CoverageIgnore
    public void setNamespaceContext(NamespaceContext theContext) throws XMLStreamException {
        this.myTarget.setNamespaceContext(theContext);
    }

    @Override
    @CoverageIgnore
    public NamespaceContext getNamespaceContext() {
        return this.myTarget.getNamespaceContext();
    }

    @Override
    public void writeStartElement(String theLocalName) throws XMLStreamException {
        if (PRE.equals(theLocalName) || this.myInsidePre > 0) {
            ++this.myInsidePre;
        }
        this.myTarget.writeStartElement(theLocalName);
    }

    @Override
    public void writeStartElement(String theNamespaceURI, String theLocalName) throws XMLStreamException {
        if (PRE.equals(theLocalName) || this.myInsidePre > 0) {
            ++this.myInsidePre;
        }
        this.myTarget.writeStartElement(theNamespaceURI, theLocalName);
    }

    @Override
    public void writeStartElement(String thePrefix, String theLocalName, String theNamespaceURI) throws XMLStreamException {
        if (PRE.equals(theLocalName) || this.myInsidePre > 0) {
            ++this.myInsidePre;
        }
        this.myTarget.writeStartElement(thePrefix, theLocalName, theNamespaceURI);
    }

    @Override
    @CoverageIgnore
    public void writeEmptyElement(String theNamespaceURI, String theLocalName) throws XMLStreamException {
        this.myTarget.writeEmptyElement(theNamespaceURI, theLocalName);
    }

    @Override
    @CoverageIgnore
    public void writeEmptyElement(String thePrefix, String theLocalName, String theNamespaceURI) throws XMLStreamException {
        this.myTarget.writeEmptyElement(thePrefix, theLocalName, theNamespaceURI);
    }

    @Override
    @CoverageIgnore
    public void writeEmptyElement(String theLocalName) throws XMLStreamException {
        this.myTarget.writeEmptyElement(theLocalName);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        if (this.myInsidePre > 0) {
            --this.myInsidePre;
        }
        this.myTarget.writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.myTarget.writeEndDocument();
    }

    @Override
    public void writeAttribute(String theLocalName, String theValue) throws XMLStreamException {
        this.myTarget.writeAttribute(theLocalName, theValue);
    }

    @Override
    @CoverageIgnore
    public void writeAttribute(String thePrefix, String theNamespaceURI, String theLocalName, String theValue) throws XMLStreamException {
        this.myTarget.writeAttribute(thePrefix, theNamespaceURI, theLocalName, theValue);
    }

    @Override
    @CoverageIgnore
    public void writeAttribute(String theNamespaceURI, String theLocalName, String theValue) throws XMLStreamException {
        this.myTarget.writeAttribute(theNamespaceURI, theLocalName, theValue);
    }

    @Override
    public void writeNamespace(String thePrefix, String theNamespaceURI) throws XMLStreamException {
        this.myTarget.writeNamespace(thePrefix, theNamespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String theNamespaceURI) throws XMLStreamException {
        this.myTarget.writeDefaultNamespace(theNamespaceURI);
    }

    @Override
    public void writeComment(String theData) throws XMLStreamException {
        this.myTarget.writeComment(theData);
    }

    @Override
    @CoverageIgnore
    public void writeProcessingInstruction(String theTarget) throws XMLStreamException {
        this.myTarget.writeProcessingInstruction(theTarget);
    }

    @Override
    @CoverageIgnore
    public void writeProcessingInstruction(String theTarget, String theData) throws XMLStreamException {
        this.myTarget.writeProcessingInstruction(theTarget, theData);
    }

    @Override
    @CoverageIgnore
    public void writeCData(String theData) throws XMLStreamException {
        this.myTarget.writeCData(theData);
    }

    @Override
    @CoverageIgnore
    public void writeDTD(String theDtd) throws XMLStreamException {
        this.myTarget.writeDTD(theDtd);
    }

    @Override
    @CoverageIgnore
    public void writeEntityRef(String theName) throws XMLStreamException {
        this.myTarget.writeEntityRef(theName);
    }

    @Override
    @CoverageIgnore
    public void writeStartDocument() throws XMLStreamException {
        this.myTarget.writeStartDocument();
    }

    @Override
    @CoverageIgnore
    public void writeStartDocument(String theVersion) throws XMLStreamException {
        this.myTarget.writeStartDocument(theVersion);
    }

    @Override
    public void writeStartDocument(String theEncoding, String theVersion) throws XMLStreamException {
        this.myTarget.writeStartDocument(theEncoding, theVersion);
    }

    @Override
    public void writeCharacters(String theText) throws XMLStreamException {
        if (this.myInsidePre > 0) {
            this.myTarget.writeCharacters(theText);
        } else {
            this.writeCharacters(theText.toCharArray(), 0, theText.length());
        }
    }

    @Override
    public void writeCharacters(char[] theText, int theStart, int theLen) throws XMLStreamException {
        NonPrettyPrintWriterWrapper.writeCharacters(theText, theStart, theLen, this.myTarget, this.myInsidePre);
    }

    static void writeCharacters(char[] theText, int theStart, int theLen, XMLStreamWriter target, int insidePre) throws XMLStreamException {
        if (theLen > 0) {
            if (insidePre > 0) {
                target.writeCharacters(theText, theStart, theLen);
            } else {
                int start;
                int initialEnd = theStart + (theLen - 1);
                int end = initialEnd;
                for (start = theStart; Character.isWhitespace(theText[start]) && start < end; ++start) {
                }
                while (Character.isWhitespace(theText[end]) && end > start) {
                    --end;
                }
                if (start == end && Character.isWhitespace(theText[start])) {
                    target.writeCharacters(" ");
                    return;
                }
                if (start > theStart) {
                    target.writeCharacters(" ");
                }
                target.writeCharacters(theText, start, end - start + 1);
                if (end < initialEnd) {
                    target.writeCharacters(" ");
                }
            }
        }
    }

    @Override
    @CoverageIgnore
    public Object getProperty(String theName) throws IllegalArgumentException {
        return this.myTarget.getProperty(theName);
    }
}

