/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.utilities;

import au.csiro.pathling.errors.InvalidUserInputError;
import au.csiro.pathling.errors.UnexpectedResponseException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.exceptions.FHIRException;

public abstract class Preconditions {
    public static void check(boolean expression) {
        if (!expression) {
            throw new AssertionError();
        }
    }

    public static void check(boolean expression, @Nonnull String messageTemplate, Object ... params) {
        if (!expression) {
            throw new AssertionError((Object)String.format(messageTemplate, params));
        }
    }

    public static void checkArgument(boolean expression, @Nonnull String errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Nonnull
    public static <T> T checkNotNull(@Nullable T object) {
        return Objects.requireNonNull(object);
    }

    @Nonnull
    public static <T> T checkPresent(@Nonnull Optional<T> object) {
        return Preconditions.checkPresent(object, null);
    }

    @Nonnull
    public static <T> T checkPresent(@Nonnull Optional<T> object, @Nullable String message) {
        try {
            return object.orElseThrow();
        }
        catch (NoSuchElementException e) {
            throw new AssertionError((Object)(message == null ? e.getMessage() : message));
        }
    }

    public static void checkUserInput(boolean expression, @Nonnull String errorMessage) {
        if (!expression) {
            throw new InvalidUserInputError(errorMessage);
        }
    }

    public static void checkState(boolean expression, @Nonnull String errorMessage) {
        if (!expression) {
            throw new IllegalStateException(errorMessage);
        }
    }

    public static void checkResponse(boolean expression, @Nonnull String messageTemplate, Object ... params) {
        if (!expression) {
            throw new UnexpectedResponseException(String.format(messageTemplate, params));
        }
    }

    public static <T, R> Function<T, R> wrapInUserInputError(@Nonnull Function<T, R> func) {
        return s2 -> {
            try {
                return func.apply(s2);
            }
            catch (FHIRException ex) {
                throw new InvalidUserInputError(ex.getMessage(), ex);
            }
        };
    }
}

