/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology;

import au.csiro.pathling.fhirpath.encoding.SimpleCoding;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class Relation
implements Serializable {
    private static final long serialVersionUID = -8124924480216379884L;
    @Nonnull
    private final Map<SimpleCoding, List<SimpleCoding>> mappings;

    private Relation(@Nonnull Map<SimpleCoding, List<SimpleCoding>> mappings) {
        this.mappings = mappings;
    }

    @Nonnull
    private Set<SimpleCoding> expand(@Nonnull Set<SimpleCoding> codings) {
        CodingSet baseSet = new CodingSet(codings);
        return Stream.concat(codings.stream(), this.mappings.entrySet().stream().filter(kv -> baseSet.contains((SimpleCoding)kv.getKey())).flatMap(kv -> ((List)kv.getValue()).stream())).collect(Collectors.toSet());
    }

    public boolean anyRelates(@Nonnull Collection<SimpleCoding> left, @Nonnull Collection<SimpleCoding> right) {
        Set<SimpleCoding> leftSet = left.stream().filter(SimpleCoding::isDefined).collect(Collectors.toSet());
        CodingSet expansion = new CodingSet(this.expand(leftSet));
        return right.stream().anyMatch(expansion::contains);
    }

    @Nonnull
    public static Relation fromMappings(@Nonnull Collection<Entry> entries) {
        Map<SimpleCoding, List<Entry>> groupedMappings = entries.stream().collect(Collectors.groupingBy(Entry::getFrom));
        Map<SimpleCoding, List<SimpleCoding>> groupedCodings = groupedMappings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(Entry::getTo).collect(Collectors.toList())));
        return new Relation(groupedCodings);
    }

    @Nonnull
    public static Relation equality() {
        return new Relation(Collections.emptyMap());
    }

    public String toString() {
        return "Relation(mappings=" + this.mappings + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Relation)) {
            return false;
        }
        Relation other = (Relation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<SimpleCoding, List<SimpleCoding>> this$mappings = this.mappings;
        Map<SimpleCoding, List<SimpleCoding>> other$mappings = other.mappings;
        return !(this$mappings == null ? other$mappings != null : !((Object)this$mappings).equals(other$mappings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Relation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<SimpleCoding, List<SimpleCoding>> $mappings = this.mappings;
        result = result * 59 + ($mappings == null ? 43 : ((Object)$mappings).hashCode());
        return result;
    }

    static class CodingSet {
        @Nonnull
        private final Set<SimpleCoding> allCodings;
        @Nonnull
        private final Set<SimpleCoding> unversionedCodings;

        CodingSet(@Nonnull Set<SimpleCoding> allCodings) {
            this.allCodings = allCodings;
            this.unversionedCodings = allCodings.stream().map(SimpleCoding::toNonVersioned).collect(Collectors.toSet());
        }

        boolean contains(@Nonnull SimpleCoding c) {
            return this.allCodings.contains(c) || (c.isVersioned() ? this.allCodings.contains(c.toNonVersioned()) : this.unversionedCodings.contains(c));
        }
    }

    public static class Entry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @NonNull
        private final SimpleCoding from;
        @NonNull
        private final SimpleCoding to;

        @NonNull
        public SimpleCoding getFrom() {
            return this.from;
        }

        @NonNull
        public SimpleCoding getTo() {
            return this.to;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SimpleCoding this$from = this.getFrom();
            SimpleCoding other$from = other.getFrom();
            if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
                return false;
            }
            SimpleCoding this$to = this.getTo();
            SimpleCoding other$to = other.getTo();
            return !(this$to == null ? other$to != null : !((Object)this$to).equals(other$to));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SimpleCoding $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
            SimpleCoding $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
            return result;
        }

        public String toString() {
            return "Relation.Entry(from=" + this.getFrom() + ", to=" + this.getTo() + ")";
        }

        private Entry(@NonNull SimpleCoding from, @NonNull SimpleCoding to) {
            if (from == null) {
                throw new NullPointerException("from is marked non-null but is null");
            }
            if (to == null) {
                throw new NullPointerException("to is marked non-null but is null");
            }
            this.from = from;
            this.to = to;
        }

        public static Entry of(@NonNull SimpleCoding from, @NonNull SimpleCoding to) {
            return new Entry(from, to);
        }
    }
}

