/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.config;

import java.io.Serializable;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.annotation.Nullable;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.URL;

@ValidTerminologyAuthConfiguration
public class TerminologyAuthConfiguration
implements Serializable {
    private static final long serialVersionUID = 6321330066417583745L;
    @NotNull
    private boolean enabled;
    @Nullable
    @URL
    private String tokenEndpoint;
    @Nullable
    private String clientId;
    @Nullable
    private String clientSecret;
    @Nullable
    private String scope;
    @NotNull
    private long tokenExpiryTolerance;

    @NotNull
    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Nullable
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    @NotNull
    public long getTokenExpiryTolerance() {
        return this.tokenExpiryTolerance;
    }

    public void setEnabled(@NotNull boolean enabled) {
        this.enabled = enabled;
    }

    public void setTokenEndpoint(@Nullable String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public void setClientId(@Nullable String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(@Nullable String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setScope(@Nullable String scope) {
        this.scope = scope;
    }

    public void setTokenExpiryTolerance(@NotNull long tokenExpiryTolerance) {
        this.tokenExpiryTolerance = tokenExpiryTolerance;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TerminologyAuthConfiguration)) {
            return false;
        }
        TerminologyAuthConfiguration other = (TerminologyAuthConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getTokenExpiryTolerance() != other.getTokenExpiryTolerance()) {
            return false;
        }
        String this$tokenEndpoint = this.getTokenEndpoint();
        String other$tokenEndpoint = other.getTokenEndpoint();
        if (this$tokenEndpoint == null ? other$tokenEndpoint != null : !this$tokenEndpoint.equals(other$tokenEndpoint)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TerminologyAuthConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        long $tokenExpiryTolerance = this.getTokenExpiryTolerance();
        result = result * 59 + (int)($tokenExpiryTolerance >>> 32 ^ $tokenExpiryTolerance);
        String $tokenEndpoint = this.getTokenEndpoint();
        result = result * 59 + ($tokenEndpoint == null ? 43 : $tokenEndpoint.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }

    public String toString() {
        return "TerminologyAuthConfiguration(enabled=" + this.isEnabled() + ", tokenEndpoint=" + this.getTokenEndpoint() + ", clientId=" + this.getClientId() + ", scope=" + this.getScope() + ", tokenExpiryTolerance=" + this.getTokenExpiryTolerance() + ")";
    }

    public static class TerminologyAuthConfigValidator
    implements ConstraintValidator<ValidTerminologyAuthConfiguration, TerminologyAuthConfiguration> {
        @Override
        public void initialize(ValidTerminologyAuthConfiguration constraintAnnotation) {
        }

        @Override
        public boolean isValid(TerminologyAuthConfiguration value, ConstraintValidatorContext context) {
            if (value.isEnabled()) {
                return value.getTokenEndpoint() != null && value.getClientId() != null && value.getClientSecret() != null;
            }
            return true;
        }
    }

    @Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={TerminologyAuthConfigValidator.class})
    @Documented
    public static @interface ValidTerminologyAuthConfiguration {
        public String message() default "If terminology authentication is enabled, token endpoint, client ID and client secret must be supplied.";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }
}

