"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
/**
 * Supported instance types for SageMaker instance-based production variants.
 */
class InstanceType {
    constructor(instanceType) {
        if (cdk.Token.isUnresolved(instanceType) || instanceType.startsWith('ml.')) {
            this.instanceTypeIdentifier = instanceType;
        }
        else {
            throw new Error(`instance type must start with 'ml.'; (got ${instanceType})`);
        }
    }
    /**
     * Builds an InstanceType from a given string or token (such as a CfnParameter).
     * @param instanceType An instance type as string
     * @returns A strongly typed InstanceType
     */
    static of(instanceType) {
        return new InstanceType(instanceType);
    }
    /**
     * Return the instance type as a string
     * @returns The instance type as a string
     */
    toString() {
        return this.instanceTypeIdentifier;
    }
}
exports.InstanceType = InstanceType;
_a = JSII_RTTI_SYMBOL_1;
InstanceType[_a] = { fqn: "@aws-cdk/aws-sagemaker-alpha.InstanceType", version: "2.58.0-alpha.0" };
/**
 * ml.c4.2xlarge
 */
InstanceType.C4_2XLARGE = InstanceType.of('ml.c4.2xlarge');
/**
 * ml.c4.4xlarge
 */
InstanceType.C4_4XLARGE = InstanceType.of('ml.c4.4xlarge');
/**
 * ml.c4.8xlarge
 */
InstanceType.C4_8XLARGE = InstanceType.of('ml.c4.8xlarge');
/**
 * ml.c4.large
 */
InstanceType.C4_LARGE = InstanceType.of('ml.c4.large');
/**
 * ml.c4.xlarge
 */
InstanceType.C4_XLARGE = InstanceType.of('ml.c4.xlarge');
/**
 * ml.c5.18xlarge
 */
InstanceType.C5_18XLARGE = InstanceType.of('ml.c5.18xlarge');
/**
 * ml.c5.2xlarge
 */
InstanceType.C5_2XLARGE = InstanceType.of('ml.c5.2xlarge');
/**
 * ml.c5.4xlarge
 */
InstanceType.C5_4XLARGE = InstanceType.of('ml.c5.4xlarge');
/**
 * ml.c5.9xlarge
 */
InstanceType.C5_9XLARGE = InstanceType.of('ml.c5.9xlarge');
/**
 * ml.c5.large
 */
InstanceType.C5_LARGE = InstanceType.of('ml.c5.large');
/**
 * ml.c5.xlarge
 */
InstanceType.C5_XLARGE = InstanceType.of('ml.c5.xlarge');
/**
 * ml.c5d.18xlarge
 */
InstanceType.C5D_18XLARGE = InstanceType.of('ml.c5d.18xlarge');
/**
 * ml.c5d.2xlarge
 */
InstanceType.C5D_2XLARGE = InstanceType.of('ml.c5d.2xlarge');
/**
 * ml.c5d.4xlarge
 */
InstanceType.C5D_4XLARGE = InstanceType.of('ml.c5d.4xlarge');
/**
 * ml.c5d.9xlarge
 */
InstanceType.C5D_9XLARGE = InstanceType.of('ml.c5d.9xlarge');
/**
 * ml.c5d.large
 */
InstanceType.C5D_LARGE = InstanceType.of('ml.c5d.large');
/**
 * ml.c5d.xlarge
 */
InstanceType.C5D_XLARGE = InstanceType.of('ml.c5d.xlarge');
/**
 * ml.c6i.12xlarge
 */
InstanceType.C6I_12XLARGE = InstanceType.of('ml.c6i.12xlarge');
/**
 * ml.c6i.16xlarge
 */
InstanceType.C6I_16XLARGE = InstanceType.of('ml.c6i.16xlarge');
/**
 * ml.c6i.24xlarge
 */
InstanceType.C6I_24XLARGE = InstanceType.of('ml.c6i.24xlarge');
/**
 * ml.c6i.2xlarge
 */
InstanceType.C6I_2XLARGE = InstanceType.of('ml.c6i.2xlarge');
/**
 * ml.c6i.32xlarge
 */
InstanceType.C6I_32XLARGE = InstanceType.of('ml.c6i.32xlarge');
/**
 * ml.c6i.4xlarge
 */
InstanceType.C6I_4XLARGE = InstanceType.of('ml.c6i.4xlarge');
/**
 * ml.c6i.8xlarge
 */
InstanceType.C6I_8XLARGE = InstanceType.of('ml.c6i.8xlarge');
/**
 * ml.c6i.large
 */
InstanceType.C6I_LARGE = InstanceType.of('ml.c6i.large');
/**
 * ml.c6i.xlarge
 */
InstanceType.C6I_XLARGE = InstanceType.of('ml.c6i.xlarge');
/**
 * ml.g4dn.12xlarge
 */
InstanceType.G4DN_12XLARGE = InstanceType.of('ml.g4dn.12xlarge');
/**
 * ml.g4dn.16xlarge
 */
InstanceType.G4DN_16XLARGE = InstanceType.of('ml.g4dn.16xlarge');
/**
 * ml.g4dn.2xlarge
 */
InstanceType.G4DN_2XLARGE = InstanceType.of('ml.g4dn.2xlarge');
/**
 * ml.g4dn.4xlarge
 */
InstanceType.G4DN_4XLARGE = InstanceType.of('ml.g4dn.4xlarge');
/**
 * ml.g4dn.8xlarge
 */
InstanceType.G4DN_8XLARGE = InstanceType.of('ml.g4dn.8xlarge');
/**
 * ml.g4dn.xlarge
 */
InstanceType.G4DN_XLARGE = InstanceType.of('ml.g4dn.xlarge');
/**
 * ml.g5.12xlarge
 */
InstanceType.G5_12XLARGE = InstanceType.of('ml.g5.12xlarge');
/**
 * ml.g5.16xlarge
 */
InstanceType.G5_16XLARGE = InstanceType.of('ml.g5.16xlarge');
/**
 * ml.g5.24xlarge
 */
InstanceType.G5_24XLARGE = InstanceType.of('ml.g5.24xlarge');
/**
 * ml.g5.2xlarge
 */
InstanceType.G5_2XLARGE = InstanceType.of('ml.g5.2xlarge');
/**
 * ml.g5.48xlarge
 */
InstanceType.G5_48XLARGE = InstanceType.of('ml.g5.48xlarge');
/**
 * ml.g5.4xlarge
 */
InstanceType.G5_4XLARGE = InstanceType.of('ml.g5.4xlarge');
/**
 * ml.g5.8xlarge
 */
InstanceType.G5_8XLARGE = InstanceType.of('ml.g5.8xlarge');
/**
 * ml.g5.xlarge
 */
InstanceType.G5_XLARGE = InstanceType.of('ml.g5.xlarge');
/**
 * ml.inf1.24xlarge
 */
InstanceType.INF1_24XLARGE = InstanceType.of('ml.inf1.24xlarge');
/**
 * ml.inf1.2xlarge
 */
InstanceType.INF1_2XLARGE = InstanceType.of('ml.inf1.2xlarge');
/**
 * ml.inf1.6xlarge
 */
InstanceType.INF1_6XLARGE = InstanceType.of('ml.inf1.6xlarge');
/**
 * ml.inf1.xlarge
 */
InstanceType.INF1_XLARGE = InstanceType.of('ml.inf1.xlarge');
/**
 * ml.m4.10xlarge
 */
InstanceType.M4_10XLARGE = InstanceType.of('ml.m4.10xlarge');
/**
 * ml.m4.16xlarge
 */
InstanceType.M4_16XLARGE = InstanceType.of('ml.m4.16xlarge');
/**
 * ml.m4.2xlarge
 */
InstanceType.M4_2XLARGE = InstanceType.of('ml.m4.2xlarge');
/**
 * ml.m4.4xlarge
 */
InstanceType.M4_4XLARGE = InstanceType.of('ml.m4.4xlarge');
/**
 * ml.m4.xlarge
 */
InstanceType.M4_XLARGE = InstanceType.of('ml.m4.xlarge');
/**
 * ml.m5.12xlarge
 */
InstanceType.M5_12XLARGE = InstanceType.of('ml.m5.12xlarge');
/**
 * ml.m5.24xlarge
 */
InstanceType.M5_24XLARGE = InstanceType.of('ml.m5.24xlarge');
/**
 * ml.m5.2xlarge
 */
InstanceType.M5_2XLARGE = InstanceType.of('ml.m5.2xlarge');
/**
 * ml.m5.4xlarge
 */
InstanceType.M5_4XLARGE = InstanceType.of('ml.m5.4xlarge');
/**
 * ml.m5.large
 */
InstanceType.M5_LARGE = InstanceType.of('ml.m5.large');
/**
 * ml.m5.xlarge
 */
InstanceType.M5_XLARGE = InstanceType.of('ml.m5.xlarge');
/**
 * ml.m5d.12xlarge
 */
InstanceType.M5D_12XLARGE = InstanceType.of('ml.m5d.12xlarge');
/**
 * ml.m5d.24xlarge
 */
InstanceType.M5D_24XLARGE = InstanceType.of('ml.m5d.24xlarge');
/**
 * ml.m5d.2xlarge
 */
InstanceType.M5D_2XLARGE = InstanceType.of('ml.m5d.2xlarge');
/**
 * ml.m5d.4xlarge
 */
InstanceType.M5D_4XLARGE = InstanceType.of('ml.m5d.4xlarge');
/**
 * ml.m5d.large
 */
InstanceType.M5D_LARGE = InstanceType.of('ml.m5d.large');
/**
 * ml.m5d.xlarge
 */
InstanceType.M5D_XLARGE = InstanceType.of('ml.m5d.xlarge');
/**
 * ml.p2.16xlarge
 */
InstanceType.P2_16XLARGE = InstanceType.of('ml.p2.16xlarge');
/**
 * ml.p2.8xlarge
 */
InstanceType.P2_8XLARGE = InstanceType.of('ml.p2.8xlarge');
/**
 * ml.p2.xlarge
 */
InstanceType.P2_XLARGE = InstanceType.of('ml.p2.xlarge');
/**
 * ml.p3.16xlarge
 */
InstanceType.P3_16XLARGE = InstanceType.of('ml.p3.16xlarge');
/**
 * ml.p3.2xlarge
 */
InstanceType.P3_2XLARGE = InstanceType.of('ml.p3.2xlarge');
/**
 * ml.p3.8xlarge
 */
InstanceType.P3_8XLARGE = InstanceType.of('ml.p3.8xlarge');
/**
 * ml.p4d.24xlarge
 */
InstanceType.P4D_24XLARGE = InstanceType.of('ml.p4d.24xlarge');
/**
 * ml.r5.12xlarge
 */
InstanceType.R5_12XLARGE = InstanceType.of('ml.r5.12xlarge');
/**
 * ml.r5.24xlarge
 */
InstanceType.R5_24XLARGE = InstanceType.of('ml.r5.24xlarge');
/**
 * ml.r5.2xlarge
 */
InstanceType.R5_2XLARGE = InstanceType.of('ml.r5.2xlarge');
/**
 * ml.r5.4xlarge
 */
InstanceType.R5_4XLARGE = InstanceType.of('ml.r5.4xlarge');
/**
 * ml.r5.large
 */
InstanceType.R5_LARGE = InstanceType.of('ml.r5.large');
/**
 * ml.r5.xlarge
 */
InstanceType.R5_XLARGE = InstanceType.of('ml.r5.xlarge');
/**
 * ml.r5d.12xlarge
 */
InstanceType.R5D_12XLARGE = InstanceType.of('ml.r5d.12xlarge');
/**
 * ml.r5d.24xlarge
 */
InstanceType.R5D_24XLARGE = InstanceType.of('ml.r5d.24xlarge');
/**
 * ml.r5d.2xlarge
 */
InstanceType.R5D_2XLARGE = InstanceType.of('ml.r5d.2xlarge');
/**
 * ml.r5d.4xlarge
 */
InstanceType.R5D_4XLARGE = InstanceType.of('ml.r5d.4xlarge');
/**
 * ml.r5d.large
 */
InstanceType.R5D_LARGE = InstanceType.of('ml.r5d.large');
/**
 * ml.r5d.xlarge
 */
InstanceType.R5D_XLARGE = InstanceType.of('ml.r5d.xlarge');
/**
 * ml.t2.2xlarge
 */
InstanceType.T2_2XLARGE = InstanceType.of('ml.t2.2xlarge');
/**
 * ml.t2.large
 */
InstanceType.T2_LARGE = InstanceType.of('ml.t2.large');
/**
 * ml.t2.medium
 */
InstanceType.T2_MEDIUM = InstanceType.of('ml.t2.medium');
/**
 * ml.t2.xlarge
 */
InstanceType.T2_XLARGE = InstanceType.of('ml.t2.xlarge');
//# sourceMappingURL=data:application/json;base64,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