/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Funk.CloseButton;
import Trace.PhdFile;
import Trace.TraceCanvas;
import Trace.TraceFile;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class TracePanel
extends Applet
implements ActionListener,
AdjustmentListener {
    String filename;
    private TraceCanvas canvas;
    private boolean start_rc = false;
    private int start_position = 0;
    private TraceFile trace = null;
    private boolean is_applet = false;
    private Button center_button = null;
    private Panel manual_panel = null;
    private String trace_label = null;
    private Scrollbar hs;
    private int last_value = 0;
    private boolean have_last_value = false;

    public void init() {
        this.is_applet = true;
        this.filename = this.getParameter("filename");
        this.setup();
    }

    public TracePanel() {
    }

    public TracePanel(String filename) {
        this.filename = filename;
        this.setup();
    }

    public TracePanel(TraceFile t) {
        this.filename = t.name;
        this.trace = t;
        this.setup();
    }

    public TracePanel(String filename, int position) {
        this.filename = filename;
        this.start_position = position;
        this.setup();
    }

    public TracePanel(String filename, boolean reverse_complemented) {
        this.filename = filename;
        this.start_rc = reverse_complemented;
        this.setup();
    }

    public TracePanel(TraceFile t, Panel manual_panel) {
        this.filename = t.name;
        this.trace = t;
        this.manual_panel = manual_panel;
        this.setup();
    }

    public TracePanel(TraceFile t, String trace_label) {
        this.trace = t;
        this.filename = t.name;
        this.trace_label = trace_label;
        this.setup();
    }

    public TracePanel(String filename, int position, boolean reverse_complemented) {
        this.filename = filename;
        this.start_rc = reverse_complemented;
        this.start_position = position;
        this.setup();
    }

    void setup() {
        this.setLayout(new BorderLayout());
        Panel cp = null;
        if (this.manual_panel != null) {
            cp = this.manual_panel;
        } else if (!(this.trace_label != null || this.start_position <= 0 && this.is_applet)) {
            cp = new Panel();
            cp.setLayout(new BorderLayout());
            if (!this.is_applet) {
                cp.add("East", new CloseButton());
            }
            if (this.start_position > 0) {
                this.center_button = new Button("Center");
                this.center_button.addActionListener(this);
                cp.add("West", this.center_button);
            }
        }
        if (cp != null) {
            this.add("North", cp);
        }
        this.hs = new Scrollbar(0, 0, 0, 0, 0);
        this.hs.addAdjustmentListener(this);
        this.canvas = this.trace == null ? new TraceCanvas(this.filename, this.start_position, this.start_rc, this.hs) : new TraceCanvas(this.trace, this.start_position, this.hs, this.trace_label);
        this.add("Center", this.canvas);
        this.add("South", this.hs);
    }

    public void center_on(int i) {
        if (this.canvas != null) {
            this.canvas.center_on(i);
        }
    }

    public void center_on(int i, boolean auto_rc) {
        if (this.canvas != null) {
            this.canvas.center_on(i, auto_rc);
        }
    }

    public void go_to(TraceFile tf, int offset) {
        this.canvas.go_to(tf, offset);
    }

    public void setPhd(PhdFile p) {
        this.canvas.setPhd(p);
    }

    public boolean loaded() {
        return this.canvas.loaded();
    }

    public boolean error() {
        return this.canvas.error();
    }

    public TraceFile get_trace() {
        return this.canvas.get_trace();
    }

    public void actionPerformed(ActionEvent e) {
        this.center_on(this.start_position);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.canvas.repaint();
    }

    public Scrollbar get_scrollbar() {
        return this.hs;
    }

    public synchronized void mimic_AdjustmentEvent(AdjustmentEvent e, int delta) {
        int type = e.getAdjustmentType();
        int direction = 1;
        int amount = 0;
        if (type == 1) {
            direction = 1;
            amount = this.hs.getUnitIncrement();
        } else if (type == 2) {
            direction = -1;
            amount = this.hs.getUnitIncrement();
        } else if (type == 4) {
            direction = 1;
            amount = this.hs.getBlockIncrement();
        } else if (type == 3) {
            direction = -1;
            amount = this.hs.getBlockIncrement();
        } else if (type == 5) {
            System.err.println("using delta: " + delta);
            direction = delta >= 0 ? 1 : -1;
            amount = Math.abs(delta);
        } else {
            System.err.println("WARNING: unhandled AdjustmentEvent type: " + e);
        }
        if (amount > 0) {
            this.hs.setValue(this.hs.getValue() + amount * direction);
            this.canvas.repaint();
        }
    }

    public int get_bases_delta_since_start() {
        return this.canvas.get_bases_delta_since_start();
    }

    public void apply_absolute_delta(int d) {
        this.canvas.apply_absolute_delta(d);
    }
}

