/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Trace.TraceFile;

public class TraceDataView {
    private static double DEFAULT_SCALE_FACTOR_LIMIT = 5.0;
    private TraceFile tf;
    private int start_point;
    private int chunk_size;
    private int[] buffer;
    private int[] max_by_type = new int[4];
    private double scale_factor = 1.0;
    private double scale_factor_limit = DEFAULT_SCALE_FACTOR_LIMIT;
    private double max_scale_factor;
    private static boolean GLOBAL_AUTOSCALE = false;
    private static double GLOBAL_SCALE_FACTOR_LIMIT = DEFAULT_SCALE_FACTOR_LIMIT;
    private boolean autoscale = false;

    public TraceDataView(TraceFile tf) {
        this.tf = tf;
    }

    public void set_buffer(int[] buffer) {
        this.buffer = buffer;
        this.chunk_size = buffer.length;
    }

    public void set_start_point(int sp) {
        this.start_point = sp;
    }

    public int get_sample(int base_type, int index) {
        return (int)((double)this.tf.trace_data[base_type][index] * this.scale_factor);
    }

    public void get_samples(int base_type) {
        this.set_scale_factor();
        for (int i = 0; i < this.chunk_size; ++i) {
            this.buffer[i] = (int)((double)this.tf.trace_data[base_type][this.start_point + i] * this.scale_factor);
        }
    }

    private void set_scale_factor() {
        if (GLOBAL_AUTOSCALE) {
            this.scale_factor = this.max_scale_factor;
            if (GLOBAL_SCALE_FACTOR_LIMIT > 0.0 && this.scale_factor > GLOBAL_SCALE_FACTOR_LIMIT) {
                this.scale_factor = GLOBAL_SCALE_FACTOR_LIMIT;
            }
        } else if (this.autoscale) {
            this.scale_factor = this.max_scale_factor;
            if (this.scale_factor > this.scale_factor_limit) {
                this.scale_factor = this.scale_factor_limit;
            }
        } else {
            this.scale_factor = 1.0;
        }
    }

    public void analyze() {
        int end = this.start_point + this.chunk_size;
        int max_for_all = 0;
        for (int base = 0; base < 4; ++base) {
            int max = 0;
            for (int i = this.start_point; i < end; ++i) {
                int v = this.tf.trace_data[base][i];
                if (v <= max) continue;
                max = v;
            }
            this.max_by_type[base] = max;
            if (max <= max_for_all) continue;
            max_for_all = max;
        }
        this.max_scale_factor = (double)this.tf.max_amplitude / (double)max_for_all;
    }

    public static void set_static_auto_normalization(boolean status) {
        GLOBAL_AUTOSCALE = status;
    }

    public static void set_static_auto_normalization_limit(double factor) {
        GLOBAL_SCALE_FACTOR_LIMIT = factor;
    }
}

