/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.Options;
import TCGA.Range;
import TCGA.SelectionNotifier;
import TCGA.SummaryPanel;
import TCGA.TrackInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JScrollBar;

public class TrackPanel
extends SummaryPanel
implements MouseListener {
    private static int BUFFER_HEIGHT = 1;
    private TrackInfo ti;
    private int image_height = 0;
    private static Color COLOR_TEXT = Color.black;
    private Color COLOR_BACKGROUND = Color.white;
    private SelectionNotifier sn = null;

    public TrackPanel(TrackInfo ti, JScrollBar jsb_h) {
        this.ti = ti;
        Font f = new Font("Times", 1, Options.SUMMARY_PANEL_FONT_HEIGHT);
        FontMetrics fm = this.getFontMetrics(f);
        this.image_height = fm.getHeight();
        this.set_raw_size(new Dimension(ti.get_width(), this.image_height));
        this.set_horizontal_scrollbar(jsb_h);
        this.setToolTipText(ti.get_name());
        this.addMouseListener(this);
        this.sn = new SelectionNotifier();
    }

    protected void paintComponent(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(this.COLOR_BACKGROUND);
        g.fillRect(0, 0, d.width, d.height);
        int avail_y = this.image_height - BUFFER_HEIGHT * 2;
        byte max_v = this.ti.get_max_value();
        float scale_by = (float)avail_y / (float)max_v;
        ArrayList<Point> any = this.digest_array(this.ti.get_active(), max_v, scale_by, false);
        g.setColor(this.ti.get_color());
        this.render_array(g, any, d.height - BUFFER_HEIGHT, false);
        FontMetrics fm = this.getFontMetrics(this.get_label_font());
        this.draw_label(g, this.ti.get_name(), this.COLOR_BACKGROUND, COLOR_TEXT, d.height / 2 + fm.getDescent());
    }

    public void mousePressed(MouseEvent e) {
        Rectangle sel;
        Point p = this.get_unscaled_point(e.getPoint());
        if (e.getClickCount() > 1 && (sel = this.ti.get_range_selection(p.x)) != null) {
            this.sn.set_selection(sel);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public SelectionNotifier get_selection_notifier() {
        return this.sn;
    }

    public String getToolTipText(MouseEvent e) {
        Point mp = this.get_unscaled_point(e.getPoint());
        Range r = this.ti.get_range(mp.x);
        String name = this.ti.get_name();
        String text = null;
        if (r != null) {
            text = "double-click to zoom to " + name;
        }
        return text;
    }
}

