/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.Cluster;
import TCGA.ClusterTool;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSample;
import TCGA.JButtonGenerator;
import TCGA.PearsonRCluster;
import TCGA.SampleSortTools;
import TCGA.VisibilityToggle;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import layout.SpringUtilities;

public abstract class StatClusterControl
implements ActionListener,
VisibilityToggle {
    private JFrame jf;
    private JComboBox jc_distance;
    private JCheckBox jc_separate;
    private JCheckBox jc_zoom;
    private JCheckBox jc_report;
    private GenomicMeasurement gm;
    private ClusterTool ct;
    private static final String LABEL_OK = "OK";
    private static final String LABEL_CANCEL = "Cancel";
    private static final String LABEL_DISTANCE_MAX = "Maximum (complete linkage)";
    private static final String LABEL_DISTANCE_MIN = "Minimum (single linkage)";
    private static final String LABEL_DISTANCE_AVG = "Mean (average linkage)";

    protected abstract Cluster get_control_cluster();

    protected abstract int init_control_components(JPanel var1);

    protected abstract String cluster_setup(ClusterTool var1);

    protected abstract void final_panel_setup(JPanel var1);

    public StatClusterControl() {
        this.setup();
    }

    public StatClusterControl(GenomicMeasurement gm, Observer o) {
        this.gm = gm;
        this.ct = new ClusterTool(gm);
        this.ct.addObserver(o);
        this.setup();
    }

    private void setup() {
        this.jf = new JFrame();
        Cluster cc = this.get_control_cluster();
        this.jf.setTitle(this.get_control_cluster().get_method_name() + " cluster control");
        JPanel jp_main = new JPanel();
        jp_main.setLayout(new BoxLayout(jp_main, 3));
        JPanel jp_controls = new JPanel();
        jp_controls.setLayout(new SpringLayout());
        int rows_used = this.init_control_components(jp_controls);
        Vector<String> distances = new Vector<String>();
        distances.add(LABEL_DISTANCE_MAX);
        distances.add(LABEL_DISTANCE_AVG);
        distances.add(LABEL_DISTANCE_MIN);
        this.jc_distance = new JComboBox(distances);
        jp_controls.add(new JLabel("Cluster-joining metric:", 11));
        jp_controls.add(this.jc_distance);
        ++rows_used;
        jp_controls.add(new JLabel("Place unclustered empty samples at bottom:", 11));
        this.jc_separate = new JCheckBox();
        jp_controls.add(this.jc_separate);
        this.jc_separate.setToolTipText("Samples which can't be clustered are placed at the bottom of the display.  If this checkbox is set and any of these samples have no underlying data, they are shown at the very bottom.");
        this.jc_separate.setSelected(true);
        ++rows_used;
        jp_controls.add(new JLabel("Zoom to cluster results:", 11));
        this.jc_zoom = new JCheckBox();
        jp_controls.add(this.jc_zoom);
        this.jc_zoom.setSelected(true);
        ++rows_used;
        jp_controls.add(new JLabel("Generate report:", 11));
        this.jc_report = new JCheckBox();
        jp_controls.add(this.jc_report);
        this.jc_report.setSelected(true);
        SpringUtilities.makeCompactGrid((Container)jp_controls, (int)(++rows_used), (int)2, (int)6, (int)6, (int)6, (int)6);
        JPanel jp_buttons = new JPanel();
        JButtonGenerator jbg = new JButtonGenerator(this, jp_buttons);
        jbg.generate_jbutton(LABEL_OK);
        jbg.generate_jbutton(LABEL_CANCEL);
        jp_main.add(jp_controls);
        jp_main.add(jp_buttons);
        this.jf.getContentPane().add(jp_main);
        this.final_panel_setup(jp_main);
        this.jf.pack();
    }

    public void setVisible(boolean v) {
        this.jf.setVisible(v);
    }

    public void actionPerformed(ActionEvent e) {
        String label;
        Object src = e.getSource();
        String error = null;
        if (src instanceof AbstractButton && (label = ((AbstractButton)src).getText()).equals(LABEL_OK)) {
            String distance = (String)this.jc_distance.getSelectedItem();
            int method = -1;
            if (distance.equals(LABEL_DISTANCE_MAX)) {
                method = 1;
            } else if (distance.equals(LABEL_DISTANCE_AVG)) {
                method = 2;
            } else if (distance.equals(LABEL_DISTANCE_MIN)) {
                method = 3;
            }
            this.ct.set_distance_method(method);
            this.ct.set_wants_zoom(this.jc_zoom.isSelected());
            error = this.cluster_setup(this.ct);
            if (error == null) {
                this.ct.cluster(this.get_control_cluster(), this.jc_separate.isSelected(), this.jc_report.isSelected());
            }
        }
        if (error == null) {
            this.jf.setVisible(false);
            this.jf.dispose();
        } else {
            JOptionPane.showMessageDialog(this.jf, error, "Error", 0);
        }
    }

    private void debug_r() {
        System.err.println("DEBUG");
        PearsonRCluster c = new PearsonRCluster();
        SampleSortTools sst = new SampleSortTools(this.gm);
        HashMap<String, ArrayList<GenomicSample>> patient2sample = sst.get_patient2samples();
        for (GenomicSample b1 : patient2sample.get("TCGA-02-0089")) {
            for (GenomicSample b2 : patient2sample.get("TCGA-02-0432")) {
                double result = -999.0;
                try {
                    result = c.compute_single_distance(b1.copynum_data, b2.copynum_data);
                }
                catch (Exception e) {
                    // empty catch block
                }
                System.err.println(b1.sample_id + " vs " + b2.sample_id + " dist=" + result);
            }
        }
    }
}

