/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JScrollBar;

public class MouseDragScroller
implements MouseListener,
MouseMotionListener,
KeyListener {
    private JScrollBar sb_h;
    private JScrollBar sb_v;
    private Component c;
    private Point origin = null;
    private Point sb_start = new Point(0, 0);
    private boolean compensate_for_applied = false;
    private int ACTIVE_BUTTON_MASK = 8;
    private static boolean EMULATE_WITH_KEYBOARD = true;
    private static int EMULATION_KEYCODE = 17;
    private boolean emulation_active = false;
    private MouseEvent last_mouse_event;
    private boolean REVERSE_MOUSE_DRAG_SCROLL = true;
    private Cursor previous_cursor = null;
    private Cursor drag_cursor = Cursor.getPredefinedCursor(13);
    private int drag_scale_factor = 0;

    public MouseDragScroller(Component c, JScrollBar sb_h) {
        this.sb_h = sb_h;
        this.c = c;
        this.setup();
    }

    public MouseDragScroller(Component c, JScrollBar sb_h, JScrollBar sb_v) {
        this.c = c;
        this.sb_h = sb_h;
        this.sb_v = sb_v;
        this.setup();
    }

    public void set_drag_button_mask(int button_mask) {
        this.ACTIVE_BUTTON_MASK = button_mask;
    }

    private void setup() {
        this.drag_scale_factor = 0;
        this.c.addMouseMotionListener(this);
        this.c.addMouseListener(this);
        if (EMULATE_WITH_KEYBOARD) {
            this.c.addKeyListener(this);
        }
    }

    private boolean usable_event(MouseEvent e) {
        return (e.getModifiers() & this.ACTIVE_BUTTON_MASK) > 0;
    }

    private void drag_it(int here, int origin_value, int sb_start, JScrollBar sb) {
        int total_diff = here - origin_value;
        int already_applied = sb.getValue() - sb_start;
        if (this.compensate_for_applied) {
            total_diff -= already_applied;
        }
        if (this.drag_scale_factor > 0) {
            total_diff /= this.drag_scale_factor;
        }
        if (total_diff != 0) {
            int next_v = this.REVERSE_MOUSE_DRAG_SCROLL ? sb_start - total_diff : sb_start + total_diff;
            sb.setValue(next_v);
        }
    }

    public void set_compensate_for_applied(boolean c) {
        this.compensate_for_applied = c;
    }

    public void mouseDragged(MouseEvent e) {
        if (e.getID() == 506 && this.usable_event(e)) {
            this.do_drag(e);
        }
    }

    private void do_drag(MouseEvent e) {
        Point p = e.getPoint();
        this.drag_it(p.x, this.origin.x, this.sb_start.x, this.sb_h);
        if (this.sb_v != null) {
            this.drag_it(p.y, this.origin.y, this.sb_start.y, this.sb_v);
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (EMULATE_WITH_KEYBOARD) {
            this.last_mouse_event = e;
            this.origin_setup(this.last_mouse_event, false);
            if (this.emulation_active) {
                this.do_drag(e);
            }
        }
    }

    private void origin_setup(MouseEvent e, boolean force) {
        if (e != null && (force || this.origin == null)) {
            this.origin = e.getPoint();
            if (this.sb_h != null) {
                this.sb_start.x = this.sb_h.getValue();
            }
            if (this.sb_v != null) {
                this.sb_start.y = this.sb_v.getValue();
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (EMULATE_WITH_KEYBOARD) {
            this.c.requestFocusInWindow();
        }
        if (this.usable_event(e)) {
            this.origin_setup(e, true);
            if (this.previous_cursor == null) {
                this.previous_cursor = this.c.getCursor();
                this.c.setCursor(this.drag_cursor);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.previous_cursor != null && !this.previous_cursor.equals(this.drag_cursor)) {
            this.c.setCursor(this.previous_cursor);
            this.previous_cursor = null;
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == EMULATION_KEYCODE) {
            this.origin = null;
            this.origin_setup(this.last_mouse_event, false);
            this.emulation_active = true;
        }
    }

    public void keyReleased(KeyEvent ke) {
        if (ke.getKeyCode() == EMULATION_KEYCODE) {
            this.emulation_active = false;
        }
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void set_drag_scale_factor(int factor) {
        this.drag_scale_factor = factor;
    }
}

