/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.AnnotationFlatfile2;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSet;
import TCGA.Heatmap6;
import TCGA.HeatmapConfiguration;
import TCGA.Options;
import TCGA.URLLauncher;
import java.awt.BorderLayout;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class HeatmapApplet
extends JApplet
implements Runnable {
    public String dataset;
    public String auth;
    public boolean has_annotations = false;
    public boolean has_bins = false;
    private HeatmapConfiguration config;

    public void init() {
        this.config = new HeatmapConfiguration();
        URLLauncher.set_applet(this);
        Options.IS_APPLET = true;
        this.dataset = this.getParameter("dataset");
        this.auth = this.getParameter("auth");
        if (this.getParameter("annotations") != null) {
            this.has_annotations = true;
        }
        if (this.getParameter("bin") != null) {
            this.has_bins = true;
        }
        this.config.start_bin = this.getParameter("start_bin");
        if (this.getParameter("start_pos") != null) {
            this.config.start_pos = new Integer(this.getParameter("start_pos"));
        }
        if (this.getParameter("end_pos") != null) {
            this.config.end_pos = new Integer(this.getParameter("end_pos"));
        }
        this.config.start_marker = this.getParameter("start_marker");
        this.config.title = this.getParameter("title");
        new Thread(this).start();
    }

    public void run() {
        this.setLayout(new BorderLayout());
        this.add("Center", new JLabel("applet launched."));
        System.err.println("running");
        URL url = URLLauncher.get_modified_url("/cgi-bin/heatmap");
        System.err.println(url);
        try {
            boolean use_binary = Options.DEFAULT_USE_BINARY_SAMPLE_FILE;
            Hashtable<String, String> p = new Hashtable<String, String>();
            p.clear();
            p.put("ds", this.dataset);
            p.put("serve", "data");
            if (this.auth != null) {
                p.put("auth", this.auth);
            }
            if (use_binary) {
                p.put("binary", "1");
            }
            this.config.gm = new GenomicMeasurement(new GZIPInputStream(this.open_url(url, p)), true, use_binary);
            if (this.has_bins) {
                p.clear();
                p.put("ds", this.dataset);
                p.put("serve", "bin");
                this.config.gs = new GenomicSet(new GZIPInputStream(this.open_url(url, p)));
            } else {
                System.err.println("synthetic genomic bins");
                this.config.gs = new GenomicSet(this.config.gm, 1, null);
            }
            if (this.has_annotations) {
                p.clear();
                p.put("ds", this.dataset);
                p.put("serve", "annotations");
                if (this.auth != null) {
                    p.put("auth", this.auth);
                }
                this.config.af = new AnnotationFlatfile2(new GZIPInputStream(this.open_url(url, p)));
            }
            Heatmap6 hm = new Heatmap6(this.config);
            this.config.gs.addObserver(hm);
        }
        catch (Exception e) {
            this.report_exception(e);
        }
    }

    private void report_exception(Exception e) {
        System.err.println("ERROR: " + e);
        e.printStackTrace();
        System.exit(1);
    }

    public InputStream open_url(URL url, Hashtable params) throws IOException {
        URLConnection urlConn = url.openConnection();
        urlConn.setDoInput(true);
        urlConn.setDoOutput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        DataOutputStream printout = new DataOutputStream(urlConn.getOutputStream());
        int count = 0;
        StringBuffer sb = new StringBuffer();
        Enumeration e = params.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)params.get(key);
            if (count++ > 0) {
                sb.append("&");
            }
            sb.append(key + "=" + URLEncoder.encode(value, "UTF-8"));
        }
        System.err.println("POST: " + url + "?" + sb.toString());
        printout.writeBytes(sb.toString());
        printout.flush();
        printout.close();
        return urlConn.getInputStream();
    }

    public static void main(String[] argv) {
        JFrame jf = new JFrame();
        HeatmapApplet hma = new HeatmapApplet();
        hma.dataset = "11";
        jf.add(hma);
        jf.pack();
        jf.setVisible(true);
        new Thread(hma).start();
    }
}

