/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import java.awt.Rectangle;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenomicBin {
    String bin_name;
    int start;
    int end;
    float center;

    public GenomicBin(String bin_name, int start, int end) {
        this.bin_name = bin_name;
        this.set_start_end(start, end);
    }

    public void set_start_end(int start, int end) {
        this.start = start;
        this.end = end;
        int len = end - start + 1;
        this.center = (float)start + (float)len / 2.0f;
    }

    public Rectangle get_rectangle() {
        return new Rectangle(this.start - 1, 0, this.end - this.start + 1, 1);
    }

    public GenomicBin map(ArrayList<Integer> bins, int new_start) {
        int si = this.start - 1;
        int ei = this.end - 1;
        int hits = 0;
        for (Integer i : bins) {
            if (i < si || i > ei) continue;
            ++hits;
        }
        GenomicBin result = null;
        if (hits > 0) {
            result = new GenomicBin(this.bin_name, new_start, new_start + hits - 1);
        }
        return result;
    }

    public void change_start(int new_start) {
        this.set_start_end(new_start, new_start + (this.end - this.start));
    }
}

