/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import Ace2.Chromosome;
import IsoView.JDBCQuery;
import IsoView.UCSCRefGene;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UCSCTools {
    private JDBCQuery ucsc;

    public UCSCTools(JDBCQuery ucsc) {
        this.ucsc = ucsc;
    }

    public UCSCRefGene get_refgenes_for_gene(String gene) {
        UCSCRefGene result = null;
        try {
            result = new UCSCRefGene(this.ucsc.query_single_row("refGene", "name2", gene));
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
        return result;
    }

    public ArrayList<UCSCRefGene> get_all_refgenes() {
        ArrayList<UCSCRefGene> results = new ArrayList<UCSCRefGene>();
        try {
            for (HashMap<String, String> row : this.ucsc.query("select * from refGene")) {
                results.add(new UCSCRefGene(row));
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
        return results;
    }

    public ArrayList<UCSCRefGene> get_refgenes_for_genes(Collection<String> genes) {
        ArrayList<UCSCRefGene> results = new ArrayList<UCSCRefGene>();
        try {
            for (HashMap<String, String> row : this.ucsc.query_column("refGene", "name2", genes, false)) {
                results.add(new UCSCRefGene(row));
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
        return results;
    }

    public String get_gene_from_region(String chrom, int start, int end) {
        String result = null;
        String cmd = "select name2,txStart,txEnd from refGene where chrom='" + Chromosome.standardize_name(chrom) + "'" + " and txStart <= " + start + " and txEnd >= " + end;
        System.err.println("SQL=" + cmd);
        try {
            ArrayList<HashMap<String, String>> results = this.ucsc.query(cmd);
            if (results.size() >= 1) {
                if (results.size() > 1) {
                    System.err.println("WARNING: multiple rows hit!");
                }
                result = results.get(0).get("name2");
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
        return result;
    }

    public static void main(String[] argv) {
        UCSCTools ut = new UCSCTools(JDBCQuery.get_stjude_hg19());
        System.err.println(ut.get_gene_from_region("7", 75054991, 75070232));
    }
}

