/*
 * Decompiled with CFR 0.152.
 */
package Funk;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipTools {
    private ZipInputStream zis;
    private ZipEntry current_ze;
    private byte[] current_bar;

    public ZipTools(ZipInputStream zis) {
        this.zis = zis;
    }

    public byte[] get_bytearray() throws IOException {
        byte[] buf = null;
        if (this.current_ze != null) {
            int wanted;
            int read;
            long size = this.current_ze.getSize();
            if (size == -1L) {
                throw new IOException("unknown size for " + this.current_ze.getName());
            }
            buf = new byte[(int)size];
            int ptr = 0;
            for (wanted = (int)size; wanted > 0; wanted -= read) {
                read = this.zis.read(buf, ptr, wanted);
                ptr += read;
                if (read != -1) continue;
            }
            if (wanted > 0) {
                throw new IOException("read length mismatch");
            }
        }
        return buf;
    }

    public ByteArrayInputStream get_bytearrayinputstream() throws IOException {
        byte[] buf = this.get_bytearray();
        ByteArrayInputStream bais = null;
        if (buf != null) {
            bais = new ByteArrayInputStream(buf);
        }
        return bais;
    }

    public boolean next() throws IOException {
        this.current_bar = null;
        this.current_ze = this.zis.getNextEntry();
        return this.current_ze != null;
    }

    public String get_name() {
        return this.current_ze == null ? null : this.current_ze.getName();
    }

    public static void main(String[] argv) {
        try {
            FileInputStream fis = new FileInputStream("text.zip");
            ZipInputStream zis = new ZipInputStream(fis);
            ZipTools zt = new ZipTools(zis);
            while (zt.next()) {
                String line;
                ByteArrayInputStream bais = zt.get_bytearrayinputstream();
                BufferedReader br = new BufferedReader(new InputStreamReader(bais));
                System.err.println("name=" + zt.get_name());
                while ((line = br.readLine()) != null) {
                    System.err.println("hey now:" + line);
                }
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
    }
}

