/*
 * Decompiled with CFR 0.152.
 */
package Funk;

import Funk.Str;
import java.util.Enumeration;
import java.util.Vector;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.print.attribute.standard.PageRanges;

public class StringTokeniza {
    private boolean allow_null_tokens = true;
    private boolean quote_mode = false;
    private boolean trim_whitespace = false;
    private boolean unquote_mode = false;

    public void set_quote_mode(boolean mode) {
        this.quote_mode = mode;
    }

    public void set_trim_whitespace(boolean mode) {
        this.trim_whitespace = mode;
    }

    public void set_unquote_mode(boolean mode) {
        this.unquote_mode = mode;
    }

    public Enumeration tokenize(String parse_string, String delimiter) {
        int i;
        int delim_len = delimiter.length();
        int parse_string_length = parse_string.length();
        if (delim_len > 1) {
            StringTokeniza.die("delim_len > 1 untested");
        }
        if (!this.allow_null_tokens) {
            StringTokeniza.die("allow_null_tokens false, fix me!");
        }
        Vector<String> tokens = new Vector<String>();
        Vector<Integer> stops = new Vector<Integer>();
        stops.addElement(new Integer(0));
        SetOfIntegerSyntax quoted_regions = null;
        if (this.quote_mode) {
            boolean single_quote_mode = false;
            boolean double_quote_mode = false;
            int single_quote_start = 0;
            int double_quote_start = 0;
            Vector<String> quote_ranges = new Vector<String>();
            for (i = 0; i < parse_string_length; ++i) {
                char c = parse_string.charAt(i);
                if (c == '\"') {
                    if (double_quote_mode) {
                        quote_ranges.addElement(double_quote_start + "-" + i);
                    } else {
                        double_quote_start = i;
                    }
                    double_quote_mode = !double_quote_mode;
                    continue;
                }
                if (c != '\'') continue;
                if (single_quote_mode) {
                    quote_ranges.addElement(single_quote_start + "-" + i);
                } else {
                    single_quote_start = i;
                }
                single_quote_mode = !single_quote_mode;
            }
            if (quote_ranges.size() > 0) {
                quoted_regions = new PageRanges(Str.join(quote_ranges.elements()));
            }
        }
        i = parse_string.indexOf(delimiter);
        while (i > -1) {
            if (quoted_regions == null || !quoted_regions.contains(i)) {
                stops.addElement(new Integer(i));
            }
            i = parse_string.indexOf(delimiter, i + 1);
        }
        stops.addElement(new Integer(parse_string_length));
        int slen = stops.size();
        for (i = 0; i < slen - 1; ++i) {
            int hither = (Integer)stops.elementAt(i);
            if (i > 0) {
                hither += delim_len;
            }
            int yon = (Integer)stops.elementAt(i + 1);
            if (this.trim_whitespace) {
                while (hither < yon && Character.isWhitespace(parse_string.charAt(hither))) {
                    ++hither;
                }
                while (yon > hither && Character.isWhitespace(parse_string.charAt(yon - 1))) {
                    --yon;
                }
            }
            if (this.unquote_mode && hither != yon && (parse_string.charAt(hither) == '\"' && parse_string.charAt(yon - 1) == '\"' || parse_string.charAt(hither) == '\'' && parse_string.charAt(yon - 1) == '\'')) {
                ++hither;
                --yon;
            }
            tokens.addElement(parse_string.substring(hither, yon));
        }
        return tokens.elements();
    }

    private static void die(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    public static void main(String[] argv) {
        StringTokeniza st = new StringTokeniza();
        st.set_quote_mode(true);
        st.set_trim_whitespace(true);
        st.set_unquote_mode(true);
        Enumeration e = st.tokenize("key=\"\"", "=");
        while (e.hasMoreElements()) {
            String token = (String)e.nextElement();
            System.err.println(token + ":" + token.length());
        }
    }
}

