/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.SAMResource;
import Ace2.Sample;
import Funk.LookAndFeeler;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import layout.SpringUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TumorNormalStatusDialog
implements ItemListener {
    private JDialog jd;
    private static final String TUMOR = "tumor";
    private static final String NORMAL = "normal";
    private static final String UNSPECIFIED = "unspecified";
    private JFrame parent_frame;
    private ArrayList<SAMResource> sams;
    private JComboBox jcb_source;
    private JComboBox jcb_tn;
    private HashMap<String, SAMResource> basename2sr;

    public TumorNormalStatusDialog() {
        this.sams = null;
        this.parent_frame = null;
        this.setup();
    }

    public TumorNormalStatusDialog(JFrame parent_frame, ArrayList<SAMResource> sams) {
        this.parent_frame = parent_frame;
        this.sams = sams;
        this.setup();
    }

    private void setup() {
        this.jd = this.parent_frame == null ? new JDialog() : new JDialog((Frame)this.parent_frame, true);
        JPanel jp_main = new JPanel();
        jp_main.setLayout(new BoxLayout(jp_main, 3));
        JPanel jp_controls = this.get_buffer_titled_panel(jp_main, "Set tumor/normal status");
        jp_controls.setLayout(new SpringLayout());
        int rows = 0;
        int columns = 2;
        jp_controls.add(new JLabel("BAM file: ", 4));
        Vector<String> items = new Vector<String>();
        this.basename2sr = new HashMap();
        if (this.sams == null) {
            items.add("file1");
            items.add("file2");
        } else {
            for (SAMResource sr : this.sams) {
                String basename = sr.get_basename();
                this.basename2sr.put(basename, sr);
                items.add(basename);
            }
        }
        this.jcb_source = new JComboBox(items);
        this.jcb_source.addItemListener(this);
        jp_controls.add(this.jcb_source);
        ++rows;
        jp_controls.add(new JLabel("data type: ", 4));
        items = new Vector();
        items.add(TUMOR);
        items.add(NORMAL);
        items.add(UNSPECIFIED);
        this.jcb_tn = new JComboBox(items);
        this.jcb_tn.addItemListener(this);
        jp_controls.add(this.jcb_tn);
        int border_pad = 2;
        SpringUtilities.makeCompactGrid((Container)jp_controls, (int)(++rows), (int)columns, (int)border_pad, (int)border_pad, (int)border_pad, (int)border_pad);
        JButton jb_close = new JButton("Close");
        jb_close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TumorNormalStatusDialog.this.jd.setVisible(false);
                TumorNormalStatusDialog.this.jd.dispose();
            }
        });
        JPanel jp_buttons = new JPanel();
        jp_buttons.add(jb_close);
        jp_main.add(jp_buttons);
        this.jd.getContentPane().add(new JScrollPane(jp_main));
        this.change_source();
        this.jd.pack();
        this.jd.setTitle("Tumor/normal status");
        this.jd.setVisible(true);
    }

    private JPanel get_buffer_titled_panel(JPanel panel, String title) {
        JPanel jp_buffer = new JPanel();
        jp_buffer.setLayout(new BorderLayout());
        JPanel jp_titled = new JPanel();
        jp_titled.setLayout(new BoxLayout(jp_titled, 3));
        jp_titled.setBorder(BorderFactory.createTitledBorder(title));
        jp_buffer.add("Center", jp_titled);
        panel.add(jp_buffer);
        return jp_titled;
    }

    public static void main(String[] argv) {
        LookAndFeeler.set_native_lookandfeel();
        new TumorNormalStatusDialog();
    }

    private void change_source() {
        String basename = (String)this.jcb_source.getSelectedItem();
        SAMResource sr = this.basename2sr.get(basename);
        if (sr != null) {
            Sample sample = sr.get_sample();
            String value = sample.is_normal() ? NORMAL : (sample.is_tumor() ? TUMOR : UNSPECIFIED);
            this.jcb_tn.setSelectedItem(value);
        } else {
            System.err.println("ERROR: no SAMResource for " + basename);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source.equals(this.jcb_source)) {
            this.change_source();
        } else if (source.equals(this.jcb_tn)) {
            String basename = (String)this.jcb_source.getSelectedItem();
            SAMResource sr = this.basename2sr.get(basename);
            if (sr != null) {
                String tn = (String)this.jcb_tn.getSelectedItem();
                Sample sample = sr.get_sample();
                if (tn.equals(NORMAL)) {
                    sample.set_normal(true);
                } else if (tn.equals(TUMOR)) {
                    sample.set_tumor(true);
                } else {
                    sample.reset_tumor_normal();
                }
            }
        } else {
            System.err.println("?");
        }
    }
}

