/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AceViewer;
import Ace2.AceViewerConfig;
import Ace2.Base;
import Ace2.BaseCountInfo;
import Ace2.BaseCounter3;
import Ace2.Chromosome;
import Ace2.Counter;
import Ace2.DuplicateLimiter;
import Ace2.FASTADirectory;
import Ace2.FASTAIndexedFAI;
import Ace2.GermlineSomaticLOH;
import Ace2.IndelEquivalence;
import Ace2.IndelInfo;
import Ace2.JointPolymorphismScore;
import Ace2.MapQTracker;
import Ace2.MarkupReader;
import Ace2.NIB;
import Ace2.Range;
import Ace2.ReferenceOrVariant;
import Ace2.ReferenceSequence;
import Ace2.ReferenceSequenceByte;
import Ace2.Reporter;
import Ace2.SAMIndelFilter;
import Ace2.SAMMismatchFilter;
import Ace2.SAMPooledIterator;
import Ace2.SAMResource;
import Ace2.SAMResourceTags;
import Ace2.SAMTagFilter;
import Ace2.SAMTagTracker;
import Ace2.SAMUtils;
import Ace2.SNP2;
import Ace2.SNPConfig;
import Ace2.SNPTrackInfo;
import Ace2.Sample;
import Ace2.SampleNamingConvention;
import Ace2.Strand;
import Ace2.StrandSkewFilter;
import Ace2.StringCounter;
import Ace2.TumorNormal;
import Ace2.TumorNormalReferenceTracker;
import Ace2.TwoBitFileLite;
import Ace2.UniqueStartTracker;
import Ace2.dbSNPDB;
import Ace2.dbSNPEntry;
import Ace2.dbSNPQueryCacher;
import Funk.Str;
import Funk.Timer;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import net.maizegenetics.pal.statistics.FisherExact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMStreamingSNPFinder {
    public static boolean VERBOSE = false;
    Iterable<SAMRecord> sam;
    private static final int SNP_FLANK_LEN = 20;
    byte[] reference_sequence = null;
    private int start_offset = 0;
    private boolean limited_refseq = false;
    private String output_filename = null;
    private String current_reference_name;
    private String current_reference_label;
    private boolean single_sam = false;
    private boolean has_samples = false;
    Sample[] samples = null;
    int current_ref_index = 0;
    AbstractMap<Integer, BaseCounter3> tracker;
    HashMap<Integer, EnumMap<Base, EnumMap<Strand, EnumMap<TumorNormal, Integer>>>> tracker_broad;
    HashMap<Integer, HashMap<String, EnumMap<Strand, EnumMap<TumorNormal, Integer>>>> tracker_broad_indels;
    AbstractMap<Integer, HashMap<String, ArrayList<IndelInfo>>> indel_tracker;
    private SAMPooledIterator spi;
    private SAMMismatchFilter mmf;
    private Reporter rpt = null;
    private Reporter rpt_reads = null;
    private boolean use_dbsnp = true;
    private dbSNPDB dbsnp = null;
    private SNPConfig config;
    private ArrayList<SNP2> results = null;
    private ArrayList<SAMResource> srs = null;
    private ReferenceSequence refseq = null;
    private long PROCESSED;
    private ArrayList<SamReader> sfrs;
    private Counter counter;
    public static final String HEADER_NORMAL_SAMPLE = "NormalSample";
    public static final String HEADER_TUMOR_SAMPLE = "TumorSample";
    public static final String HEADER_NAME = "Name";
    public static final String HEADER_CHR = "Chr";
    public static final String HEADER_POS = "Pos";
    public static final String HEADER_TYPE = "Type";
    public static final String HEADER_SIZE = "Size";
    public static final String HEADER_COVERAGE = "Coverage";
    public static final String HEADER_PCT_ALT_ALLELE = "Percent_alternative_allele";
    public static final String HEADER_CHR_ALLELE = "Chr_Allele";
    public static final String HEADER_ALT_ALLELE = "Alternative_Allele";
    public static final String HEADER_P_VALUE = "Score";
    public static final String HEADER_TEXT = "Text";
    public static final String HEADER_UNIQUE_ALT_READS = "unique_alternative_ids";
    public static final String HEADER_REF_NORMAL_COUNT = "reference_normal_count";
    public static final String HEADER_REF_TUMOR_COUNT = "reference_tumor_count";
    public static final String HEADER_ALT_NORMAL_COUNT = "alternative_normal_count";
    public static final String HEADER_ALT_TUMOR_COUNT = "alternative_tumor_count";
    public static final String HEADER_COUNT_REF_NORMAL_FWD = "count_ref_normal_fwd";
    public static final String HEADER_COUNT_REF_NORMAL_REV = "count_ref_normal_rev";
    public static final String HEADER_COUNT_VAR_NORMAL_FWD = "count_var_normal_fwd";
    public static final String HEADER_COUNT_VAR_NORMAL_REV = "count_var_normal_rev";
    public static final String HEADER_COUNT_REF_TUMOR_FWD = "count_ref_tumor_fwd";
    public static final String HEADER_COUNT_REF_TUMOR_REV = "count_ref_tumor_rev";
    public static final String HEADER_COUNT_VAR_TUMOR_FWD = "count_var_tumor_fwd";
    public static final String HEADER_COUNT_VAR_TUMOR_REV = "count_var_tumor_rev";
    public static final String HEADER_ALT_FWD_COUNT = "alternative_fwd_count";
    public static final String HEADER_ALT_REV_COUNT = "alternative_rev_count";
    public static final String HEADER_ALT_HAS_RC = "alternative_bidirectional_confirmation";
    public static final String HEADER_BROAD_COVERAGE = "broad_coverage";
    public static final String HEADER_BROAD_REF_NORMAL_COUNT = "broad_reference_normal_count";
    public static final String HEADER_BROAD_REF_TUMOR_COUNT = "broad_reference_tumor_count";
    public static final String HEADER_BROAD_ALT_NORMAL_COUNT = "broad_alternative_normal_count";
    public static final String HEADER_BROAD_ALT_TUMOR_COUNT = "broad_alternative_tumor_count";
    public static final String HEADER_UNIQUE_ALT_READ_START = "unique_alt_read_starts";
    public static final String HEADER_UNIQUE_ALT_READ_START_F = "unique_alt_read_starts_fwd";
    public static final String HEADER_UNIQUE_ALT_READ_START_R = "unique_alt_read_starts_rev";
    public static final String HEADER_AVG_MAPQ_ALTERNATIVE = "avg_mapq_alternative";
    public static final String HEADER_SAM_TAGS_ALTERNATIVE = "alt_sam_tags";
    public static final String HEADER_READ_NAME = "read_name";
    public static final String HEADER_STRAND = "strand";
    public static final String HEADER_REFERENCE_OR_VARIANT = "reference_or_variant";
    public static final String HEADER_TN = "tumor_normal";
    public static final String HEADER_SAM_FLAGS = "sam_flags";
    public static final String HEADER_SOMATIC_OR_GERMLINE = "somatic_or_germline";
    public static final String HEADER_LOH_FLAG = "loh_flag";
    public static final String HEADER_ALT_RATIO_NORMAL = "alt_to_ref_ratio_normal";
    public static final String HEADER_ALT_RATIO_TUMOR = "alt_to_ref_ratio_tumor";
    public static final String HEADER_ALT_RATIO_NORMAL_TUMOR_DIFF = "alt_to_ref_ratio_diff_normal_tumor";
    public static final String HEADER_STRAND_SKEW = "strand_skew";

    public SAMStreamingSNPFinder(SNPConfig config) {
        this.config = config;
    }

    public SAMStreamingSNPFinder() {
        this.config = new SNPConfig();
    }

    public void set_genome_version_check(boolean v) {
        this.config.CHECK_GENOME_VERSION = v;
    }

    public void extent_setup(AceViewerConfig avc) throws IOException {
        this.set_resources(avc.sams);
        this.limited_refseq = true;
        this.start_offset = avc.ruler_start;
        this.reference_sequence = avc.target_sequence;
        this.current_reference_name = this.current_reference_label = avc.CONSENSUS_TAG;
    }

    public void set_readers(ArrayList<SamReader> sfrs) {
        this.sfrs = sfrs;
        boolean use_internal_iterators = false;
        if (this.srs != null) {
            use_internal_iterators = true;
            for (SAMResource sr : this.srs) {
                if (sr.has_maps()) continue;
                use_internal_iterators = false;
            }
        }
        if (sfrs.size() == 1) {
            this.single_sam = true;
            this.sam = use_internal_iterators ? this.srs.get(0).get_samrecord_iterable() : (Iterable)sfrs.get(0);
        } else if (this.config.STREAMING_MODE) {
            this.single_sam = false;
            this.spi = new SAMPooledIterator();
            this.spi.set_genome_version_check(this.config.CHECK_GENOME_VERSION);
            this.spi.addAll(sfrs);
            if (use_internal_iterators) {
                ArrayList<Iterable<SAMRecord>> its = new ArrayList<Iterable<SAMRecord>>();
                for (SAMResource sr : this.srs) {
                    its.add(sr.get_samrecord_iterable());
                }
                this.spi.set_custom_iterables(its);
            }
            if (this.spi.prepare()) {
                this.sam = this.spi;
            } else {
                System.err.println("ERROR: BAM files can't be pooled in streaming mode because layouts are incompatible.  Try using the -query-mode command-line flag (see documentation)");
                System.exit(1);
            }
        } else {
            this.single_sam = false;
        }
    }

    public void set_resources(ArrayList<SAMResource> srs) throws IOException {
        this.srs = srs;
        ArrayList<SamReader> sfrs = new ArrayList<SamReader>();
        this.samples = new Sample[srs.size()];
        int i = 0;
        this.has_samples = true;
        for (SAMResource sr : srs) {
            this.samples[i++] = sr.sample;
            SamReader sfr = sr.getSamReader();
            if (this.config.CHECK_GENOME_VERSION) {
                if (this.refseq == null) {
                    System.err.println("ERROR: no ReferenceSequence ref");
                    System.exit(1);
                }
                SAMFileHeader h = sfr.getFileHeader();
                SAMSequenceDictionary dict = h.getSequenceDictionary();
                for (SAMSequenceRecord ssr : dict.getSequences()) {
                    int diff;
                    String normalized_name = Chromosome.standardize_name(ssr.getSequenceName());
                    int rs_len = this.refseq.get_length(normalized_name);
                    if (rs_len == -1 || (diff = Math.abs(ssr.getSequenceLength() - rs_len)) <= 1) continue;
                    String msg = "possible genome version mismatch for " + normalized_name + ": BAM_header=" + ssr.getSequenceLength() + " reference_sequence=" + rs_len + " file=" + sr.get_url();
                    throw new IOException(msg);
                }
            }
            sfrs.add(sfr);
        }
        this.set_readers(sfrs);
    }

    public void set_dbsnp(boolean v) {
        this.use_dbsnp = v;
    }

    public void set_output_file(String s) {
        this.output_filename = s;
    }

    private void call_snps(boolean flush_all) throws IOException {
        Collection<Integer> t_keys;
        ArrayList<Integer> indel_flush_queue = new ArrayList<Integer>();
        HashSet<String> called_indels = new HashSet<String>();
        if (VERBOSE) {
            System.err.println("call_snps(): CRI=" + this.current_ref_index);
        }
        Iterable<Integer> it_keys = this.get_it_keys();
        if (!flush_all) {
            for (Integer ci : it_keys) {
                if (ci >= this.current_ref_index) break;
                HashMap<String, ArrayList<IndelInfo>> cons_bucket = this.indel_tracker.get(ci);
                for (String indel_key : cons_bucket.keySet()) {
                    for (IndelInfo ii : cons_bucket.get(indel_key)) {
                        int end_i;
                        if (!ii.indel_type.equals((Object)CigarOperator.DELETION) || (end_i = ci + ii.length - 1) < this.current_ref_index) continue;
                        if (VERBOSE) {
                            System.err.println("indel of " + indel_key + " at " + ci + " extends to " + end_i + ", CRI=" + this.current_ref_index + ", postponing calling");
                        }
                        return;
                    }
                }
            }
        }
        if (this.config.MERGE_EQUIVALENT_INDELS) {
            IndelEquivalence ie = new IndelEquivalence(this.reference_sequence);
            boolean all_done = false;
            block3: while (!all_done) {
                all_done = true;
                ArrayList<Integer> ready_to_call = new ArrayList<Integer>();
                ArrayList<Integer> all_sites = new ArrayList<Integer>();
                for (Integer ci : it_keys) {
                    all_sites.add(ci);
                    if (flush_all) {
                        ready_to_call.add(ci);
                        continue;
                    }
                    int i = ci - this.start_offset;
                    if (i < 0 || i >= this.reference_sequence.length || ci >= this.current_ref_index) continue;
                    ready_to_call.add(ci);
                }
                if (ready_to_call.size() > 0 && this.config.MERGE_EQUIVALENT_INDELS_VERBOSE) {
                    System.err.println("equivalent_check: ready=" + ready_to_call + " all_sites" + all_sites);
                }
                for (Integer ready_site : ready_to_call) {
                    HashMap<String, ArrayList<IndelInfo>> ready_bucket = this.indel_tracker.get(ready_site);
                    for (Integer other_site : all_sites) {
                        if (ready_site.equals(other_site) || ready_site > other_site || other_site - ready_site > this.config.EQUIVALENT_INDEL_MAX_DISTANCE) continue;
                        HashMap<String, ArrayList<IndelInfo>> other_bucket = this.indel_tracker.get(other_site);
                        for (String ready_indel_key : ready_bucket.keySet()) {
                            ArrayList<IndelInfo> migrate;
                            boolean is_equivalent;
                            ArrayList<IndelInfo> other_set;
                            ArrayList<IndelInfo> ready_set;
                            block166: {
                                if (!other_bucket.containsKey(ready_indel_key)) continue;
                                if (this.config.MERGE_EQUIVALENT_INDELS_VERBOSE) {
                                    System.err.println(" yay " + ready_indel_key + " at " + ready_site + " also at " + other_site);
                                }
                                ready_set = ready_bucket.get(ready_indel_key);
                                other_set = other_bucket.get(ready_indel_key);
                                CigarOperator indel_type = ready_set.get((int)0).indel_type;
                                is_equivalent = false;
                                migrate = null;
                                if (indel_type.equals((Object)CigarOperator.INSERTION)) {
                                    HashSet<String> ready_seqs = IndelInfo.get_insertion_sequences(ready_set);
                                    HashSet<String> other_seqs = IndelInfo.get_insertion_sequences(other_set);
                                    for (String ready_seq : ready_seqs) {
                                        for (String other_seq : other_seqs) {
                                            if (this.config.MERGE_EQUIVALENT_INDELS_VERBOSE) {
                                                System.err.println("  compare " + ready_seq + " vs " + other_seq);
                                            }
                                            if (is_equivalent = ie.check_insertion_equivalence(ready_site, ready_seq, other_site, other_seq)) {
                                                migrate = new ArrayList();
                                                for (IndelInfo ii : ready_set) {
                                                    if (!ii.sequence.equalsIgnoreCase(ready_seq)) continue;
                                                    ii.reference_i = other_site;
                                                    ii.sequence = other_seq;
                                                    migrate.add(ii);
                                                }
                                                break block166;
                                            }
                                            if (!this.config.MERGE_EQUIVALENT_INDELS_VERBOSE) continue;
                                            System.err.println("insertions NOT equivalent");
                                        }
                                    }
                                } else {
                                    int dlen = ready_set.get((int)0).length;
                                    is_equivalent = ie.check_deletion_equivalence(ready_site, other_site, dlen);
                                    if (is_equivalent) {
                                        System.err.println("found equivalent deletion!");
                                        migrate = new ArrayList<IndelInfo>();
                                        for (IndelInfo ii : ready_set) {
                                            migrate.add(ii);
                                        }
                                    } else if (this.config.MERGE_EQUIVALENT_INDELS_VERBOSE) {
                                        System.err.println("deletions NOT equivalent");
                                    }
                                }
                            }
                            if (this.config.MERGE_EQUIVALENT_INDELS_VERBOSE) {
                                System.err.println("after THIS_INDEL, equiv=" + is_equivalent);
                            }
                            if (!is_equivalent) continue;
                            if (this.config.MERGE_EQUIVALENT_INDELS_VERBOSE) {
                                System.err.println("migrate before=" + ready_set.size() + " -> " + other_set.size() + " mig=" + migrate.size());
                            }
                            ready_set.removeAll(migrate);
                            other_set.addAll(migrate);
                            if (this.config.MERGE_EQUIVALENT_INDELS_VERBOSE) {
                                System.err.println("migrate after=" + ready_set.size() + " -> " + other_set.size());
                            }
                            if (ready_set.size() == 0) {
                                ready_bucket.remove(ready_indel_key);
                                if (ready_bucket.size() == 0) {
                                    if (this.config.MERGE_EQUIVALENT_INDELS_VERBOSE) {
                                        System.err.println("tracking bucket empty!");
                                    }
                                    this.indel_tracker.remove(ready_site);
                                }
                            }
                            all_done = false;
                            it_keys = this.get_it_keys();
                            continue block3;
                        }
                    }
                }
            }
        }
        for (Integer ci : it_keys) {
            if (!flush_all && ci >= this.current_ref_index) break;
            int i = ci - this.start_offset;
            if (i < 0 || i >= this.reference_sequence.length) {
                indel_flush_queue.add(ci);
                continue;
            }
            HashMap<String, ArrayList<IndelInfo>> cons_bucket = this.indel_tracker.get(ci);
            for (String indel_key : cons_bucket.keySet()) {
                boolean usable;
                int bc_count;
                ArrayList<IndelInfo> infos = cons_bucket.get(indel_key);
                if (infos.get((int)0).indel_type.equals((Object)CigarOperator.INSERTION)) {
                    Counter c = new Counter();
                    for (IndelInfo ii : infos) {
                        c.increment(ii.sequence);
                    }
                    if (c.keySet().size() > 1) {
                        ArrayList<String> sorted = c.get_by_incidence();
                        String wanted = sorted.get(0);
                        ArrayList<IndelInfo> infos_new = new ArrayList<IndelInfo>();
                        int rejected = 0;
                        for (IndelInfo ii : infos) {
                            if (ii.sequence.equals(wanted)) {
                                infos_new.add(ii);
                                continue;
                            }
                            ++rejected;
                        }
                        System.err.println("pruning insertion alleles at " + this.current_reference_label + "." + (ci + 1) + " from " + sorted + " to " + wanted + ", kept " + infos_new.size() + ", dropped " + rejected);
                        infos = infos_new;
                    }
                }
                int indel_count = infos.size();
                BaseCounter3 bc3 = this.tracker.get(ci);
                int n = bc_count = bc3 == null ? 0 : bc3.count_sequences();
                if (infos.get((int)0).indel_type.equals((Object)CigarOperator.INSERTION)) {
                    bc_count -= indel_count;
                }
                if (bc_count < 0) {
                    bc_count = 0;
                }
                int coverage = bc_count + indel_count;
                float indel_freq = (float)indel_count / (float)coverage;
                Base cons_nt = Base.valueOf((char)this.reference_sequence[ci - this.start_offset]);
                boolean bl = usable = coverage >= this.config.MIN_COVERAGE && indel_count >= this.config.MIN_ALT_ALLELE_COUNT && indel_freq >= this.config.MIN_MINOR_ALLELE_FREQUENCY && !cons_nt.equals((Object)Base.BASE_UNKNOWN);
                if (VERBOSE) {
                    System.err.println("candidate indel at: " + (ci + 1) + " usable=" + usable);
                }
                if (usable && indel_count >= this.config.MIN_ALT_ALLELE_COUNT_FOR_FILTER_ENABLE && this.config.MIN_ALT_READS_WITH_FLANKING_SEQUENCE > 0) {
                    if (VERBOSE) {
                        System.err.println("at: " + (ci + 1) + " size=" + infos.size());
                    }
                    int ok_count = 0;
                    for (IndelInfo ii : infos) {
                        if (VERBOSE) {
                            System.err.println("   " + SAMUtils.get_printable_read_name(ii.sr) + " flank=" + ii.minimum_flanking_sequence + " len=" + ii.length);
                        }
                        if (ii.minimum_flanking_sequence < this.config.MIN_ALT_READS_WITH_FLANKING_SEQUENCE_WINDOW || ++ok_count < this.config.MIN_ALT_READS_WITH_FLANKING_SEQUENCE) continue;
                        break;
                    }
                    if (ok_count < this.config.MIN_ALT_READS_WITH_FLANKING_SEQUENCE) {
                        if (VERBOSE) {
                            System.err.println("indel flank flunk @ " + (ci + 1));
                        }
                        usable = false;
                    }
                }
                if (usable && indel_count >= this.config.MIN_ALT_ALLELE_COUNT_FOR_FILTER_ENABLE && this.config.MIN_UNIQUE_START_POSITIONS_FOR_ALT_ALLELE > 1) {
                    UniqueStartTracker ust = new UniqueStartTracker(this.config, infos);
                    int unique_alt_read_start_positions = ust.get_unique_read_start_positions();
                    if (VERBOSE) {
                        System.err.println("unique starts for indel at " + (ci + 1) + " = " + unique_alt_read_start_positions);
                    }
                    if (!ust.are_counts_ok()) {
                        if (VERBOSE) {
                            System.err.println("unique start flunk @ " + (ci + 1));
                        }
                        usable = false;
                    }
                    if (VERBOSE) {
                        System.err.println("usable min_unique_start_positions_for_alt_allele check: " + usable);
                    }
                }
                if (!usable) continue;
                String save_key = Integer.toString(ci) + indel_key;
                called_indels.add(save_key);
                if (VERBOSE) {
                    System.err.println("indel of " + indel_key + " at " + (ci + 1) + " reads=" + indel_count + " mfreq=" + indel_freq + " cons_nt:" + this.reference_sequence[ci - this.start_offset]);
                    System.err.println("indel reads:");
                    for (IndelInfo ii : infos) {
                        System.err.println("  " + ii.sr.getReadName());
                    }
                    System.err.println("other reads");
                    if (bc3 == null) {
                        System.err.println("  [none aligned]");
                    } else {
                        ArrayList<Base> bases = new ArrayList<Base>();
                        bases.add(Base.BASE_A);
                        bases.add(Base.BASE_C);
                        bases.add(Base.BASE_G);
                        bases.add(Base.BASE_T);
                        for (Base b : bases) {
                            BaseCountInfo bci = bc3.get_info(b);
                            if (bci == null) continue;
                            for (Object o : bci.sequences) {
                                SNPTrackInfo sti = (SNPTrackInfo)o;
                                System.err.println("  " + sti.sr.getReadName());
                            }
                        }
                    }
                }
                TumorNormalReferenceTracker tnrt = new TumorNormalReferenceTracker();
                tnrt.addAll(infos);
                boolean DEBUG_INDEL = false;
                if (DEBUG_INDEL) {
                    System.err.println("indel at ref base " + (ci + 1));
                    System.err.println("indel reads:");
                    for (IndelInfo ii : infos) {
                        System.err.println("  " + SAMUtils.get_printable_read_name(ii.sr));
                    }
                }
                if (DEBUG_INDEL) {
                    System.err.println("normal reads:");
                }
                if (bc3 != null) {
                    BaseCountInfo bc = bc3.get_info(cons_nt);
                    if (bc == null) {
                        System.err.println("urgh: undef bc");
                    } else {
                        for (Object o : bc.sequences) {
                            SNPTrackInfo sti = (SNPTrackInfo)o;
                            if (DEBUG_INDEL) {
                                System.err.println("  " + SAMUtils.get_printable_read_name(sti.sr));
                            }
                            tnrt.add(ReferenceOrVariant.REFERENCE, sti);
                        }
                    }
                }
                tnrt.analyze();
                if (!this.unique_alt_reads_check(tnrt)) {
                    usable = false;
                }
                this.starts_populate(this.rpt, new UniqueStartTracker(this.config, infos));
                this.mapq_populate(this.rpt, new MapQTracker(infos));
                if (this.config.REPORT_ALT_ALLELE_SAM_TAGS) {
                    this.sam_tag_populate(this.rpt, new SAMTagTracker(infos));
                }
                JointPolymorphismScore jps = new JointPolymorphismScore();
                jps.set_variant_probability(infos);
                ArrayList<SNPTrackInfo> ref_sti = tnrt.get_sti(ReferenceOrVariant.REFERENCE);
                if (ref_sti == null || ref_sti.size() == 0) {
                    jps.set_reference_probability_from_quality(50);
                    System.err.println("TEST ME: indel at " + (ci + 1) + " germline only");
                } else {
                    jps.set_reference_probability(ref_sti);
                }
                double score = jps.calculate_score();
                if (score < (double)this.config.MIN_SCORE) {
                    usable = false;
                }
                this.rpt.set_value(HEADER_P_VALUE, Str.float_decimal_format(score, this.config.REPORT_DECIMAL_ROUNDING));
                IndelInfo ii = infos.get(0);
                int ref_base_num = ci + 1;
                this.rpt.set_value(HEADER_NAME, this.current_reference_label + "." + ref_base_num);
                this.rpt.set_value(HEADER_CHR, this.current_reference_label);
                this.rpt.set_value(HEADER_POS, Integer.toString(ref_base_num));
                String chr_allele = "";
                String alternative_allele = "";
                if (ii.indel_type.equals((Object)CigarOperator.INSERTION)) {
                    this.rpt.set_value(HEADER_TYPE, "insertion");
                    chr_allele = "";
                    alternative_allele = ii.sequence;
                } else if (ii.indel_type.equals((Object)CigarOperator.DELETION)) {
                    this.rpt.set_value(HEADER_TYPE, "deletion");
                    int end_i = ii.reference_i + (ii.length - 1);
                    if (end_i - this.start_offset >= this.reference_sequence.length) {
                        System.err.println("WTF: indel beyond end of reference sequence");
                        chr_allele = "?";
                    } else {
                        chr_allele = new String(this.reference_sequence, ii.reference_i - this.start_offset, ii.length);
                    }
                    alternative_allele = "";
                } else {
                    this.rpt.set_value(HEADER_TYPE, "error");
                }
                this.rpt.set_value(HEADER_CHR_ALLELE, chr_allele);
                this.rpt.set_value(HEADER_ALT_ALLELE, alternative_allele);
                this.rpt.set_value(HEADER_SIZE, Integer.toString(ii.length));
                this.rpt.set_value(HEADER_COVERAGE, Integer.toString(coverage));
                this.rpt.set_value(HEADER_PCT_ALT_ALLELE, Str.float_decimal_format(indel_freq, this.config.REPORT_DECIMAL_ROUNDING));
                String before = this.get_flanking_sequence(ci, true);
                String after = this.get_flanking_sequence(ci, false);
                String chunk = before + "[" + chr_allele + "/" + alternative_allele + "]" + after;
                this.rpt.set_value(HEADER_TEXT, "");
                this.tnrt_report_populate(tnrt);
                if (!this.skew_populate(tnrt) && !this.config.FISHERS_EXACT_STRAND_BIAS_ENABLE) {
                    System.err.println("rejecting indel due to skew at " + this.rpt.get_value(HEADER_CHR) + "." + this.rpt.get_value(HEADER_POS));
                    usable = false;
                }
                if (this.config.FISHERS_EXACT_STRAND_BIAS_ENABLE && !this.fishers_exact_strand_bias_check(tnrt)) {
                    if (VERBOSE) {
                        System.err.println("rejecting indel due to Fisher's Exact strand bias at " + this.rpt.get_value(HEADER_CHR) + "." + this.rpt.get_value(HEADER_POS));
                    }
                    usable = false;
                }
                if (this.config.ENABLE_BROAD_BASE_TRACKING) {
                    tnrt = new TumorNormalReferenceTracker();
                    EnumMap<Base, EnumMap<Strand, EnumMap<TumorNormal, Integer>>> base2strand = this.tracker_broad.get(ci);
                    if (base2strand != null) {
                        this.gather_counts(base2strand, cons_nt, ReferenceOrVariant.REFERENCE, tnrt);
                    }
                    HashMap<String, EnumMap<Strand, EnumMap<TumorNormal, Integer>>> base2strand_i = this.tracker_broad_indels.get(ci);
                    System.err.println("ci=" + ci);
                    this.gather_counts2(base2strand_i, ii.getTypeHashString(), ReferenceOrVariant.VARIANT, tnrt);
                    int rnc = tnrt.get_count(ReferenceOrVariant.REFERENCE, TumorNormal.NORMAL);
                    int rtc = tnrt.get_count(ReferenceOrVariant.REFERENCE, TumorNormal.TUMOR);
                    int vnc = tnrt.get_count(ReferenceOrVariant.VARIANT, TumorNormal.NORMAL);
                    int vtc = tnrt.get_count(ReferenceOrVariant.VARIANT, TumorNormal.TUMOR);
                    if (ii.indel_type.equals((Object)CigarOperator.INSERTION)) {
                        rtc -= vtc;
                        if ((rnc -= vnc) < 0) {
                            rnc = 0;
                        }
                        if (rtc < 0) {
                            rtc = 0;
                        }
                    }
                    int broad_coverage = rnc + rtc + vnc + vtc;
                    this.rpt.set_value(HEADER_BROAD_COVERAGE, Integer.toString(broad_coverage));
                    this.rpt.set_value(HEADER_BROAD_REF_NORMAL_COUNT, Integer.toString(rnc));
                    this.rpt.set_value(HEADER_BROAD_REF_TUMOR_COUNT, Integer.toString(rtc));
                    this.rpt.set_value(HEADER_BROAD_ALT_NORMAL_COUNT, Integer.toString(vnc));
                    this.rpt.set_value(HEADER_BROAD_ALT_TUMOR_COUNT, Integer.toString(vtc));
                }
                this.populate_sample();
                this.somatic_germline_populate();
                if (usable) {
                    this.end_row();
                } else {
                    this.rpt.reset_row();
                }
                if (!VERBOSE) continue;
                for (IndelInfo inf : infos) {
                    System.err.println("  " + SAMUtils.get_printable_read_name(inf.sr));
                }
            }
            indel_flush_queue.add(ci);
        }
        if (VERBOSE) {
            System.err.println("calling SNPs...");
        }
        ArrayList<Integer> flush_queue = new ArrayList<Integer>();
        if (this.config.USE_TREEMAP) {
            t_keys = this.tracker.keySet();
        } else if (this.tracker == null) {
            ArrayList empty = new ArrayList();
            t_keys = empty;
        } else {
            ArrayList<Integer> al = new ArrayList<Integer>(this.tracker.keySet());
            Collections.sort(al);
            t_keys = al;
        }
        for (Integer ci : t_keys) {
            if (!flush_all && ci >= this.current_ref_index) break;
            BaseCounter3 bc = this.tracker.get(ci);
            Base cons_nt = Base.valueOf((char)this.reference_sequence[ci - this.start_offset]);
            int coverage = bc.count_sequences();
            if (VERBOSE) {
                System.err.println("reference at " + (ci + 1) + " is " + (Object)((Object)cons_nt) + ", coverage=" + coverage + " bases:" + bc.count_bases());
            }
            if (!cons_nt.equals((Object)Base.BASE_UNKNOWN) && bc.count_bases() > 1 && coverage >= this.config.MIN_COVERAGE) {
                boolean usable;
                Base[] freq = bc.get_bases_by_frequency();
                if (this.config.MINOR_ALLELE_MODE && cons_nt != freq[0]) {
                    System.err.println("minor-allele-mode: replacing ref " + (Object)((Object)cons_nt) + " with more-frequent " + (Object)((Object)freq[0]) + " at " + (ci + 1));
                    cons_nt = freq[0];
                }
                boolean snp_vs_consensus = freq.length < 2;
                BaseCountInfo[] bcis = new BaseCountInfo[2];
                int max = freq.length > 2 ? 2 : freq.length;
                int alt_i = -1;
                for (int i = 0; i < max; ++i) {
                    bcis[i] = bc.get_info(freq[i]);
                    if (freq[i] != cons_nt && alt_i == -1) {
                        alt_i = i;
                    }
                    if (!VERBOSE) continue;
                    System.err.println(i + " => " + (Object)((Object)freq[i]) + " => " + bcis[i].count);
                    for (Object o : bcis[i].sequences) {
                        SNPTrackInfo sti = (SNPTrackInfo)o;
                        System.err.println("  " + sti.sr.getReadName() + " " + SAMUtils.get_printable_read_name(sti.sr) + " min_flank=" + sti.get_minimum_flanking_sequence());
                    }
                }
                if (freq[0] != cons_nt) {
                    alt_i = 0;
                    snp_vs_consensus = true;
                }
                if (this.config.MINOR_ALLELE_MODE && snp_vs_consensus) {
                    System.err.println("EPIC FAIL: snp_vs_consensus active even in population freq mode");
                    System.exit(1);
                }
                if (this.config.ENABLE_MATE_PAIR_DISAGREEMENT_FILTER && bcis[0] != null && bcis[1] != null && !this.mate_pair_qa(bcis[0], bcis[1])) {
                    System.err.println("mate pair QA fail at " + (ci + 1));
                }
                if (this.config.ENABLE_MISMAPPED_DELETION_FILTER) {
                    if (VERBOSE) {
                        System.err.println("itracker: keys=" + this.indel_tracker.keySet());
                        System.err.println("called_indels: keys=" + called_indels);
                    }
                    for (Integer ipos : this.indel_tracker.keySet()) {
                        HashMap<String, ArrayList<IndelInfo>> bucket = this.indel_tracker.get(ipos);
                        for (String itype : bucket.keySet()) {
                            ArrayList<IndelInfo> iis = bucket.get(itype);
                            IndelInfo ii = iis.get(0);
                            String called_key = ipos.toString() + itype;
                            if (!ii.indel_type.equals((Object)CigarOperator.DELETION) || !called_indels.contains(called_key)) continue;
                            if (VERBOSE) {
                                System.err.println("itracker: called del at " + ipos + ", len=" + ii.length);
                            }
                            if (ci < ipos || ci > ipos + (ii.length - 1)) continue;
                            ArrayList<SNPTrackInfo> remove = new ArrayList<SNPTrackInfo>();
                            for (Object o : bcis[alt_i].sequences) {
                                SNPTrackInfo sti = (SNPTrackInfo)o;
                                if (sti.get_minimum_flanking_sequence() >= 10) continue;
                                remove.add(sti);
                            }
                            if (remove.size() <= 0) continue;
                            System.err.println("mismapped deletion filter: removing " + remove.size() + " near-end reads at " + (ipos + 1) + " within deletion site");
                            if (VERBOSE) {
                                for (SNPTrackInfo sti : remove) {
                                    System.err.println("  removing:" + SAMUtils.get_printable_read_name(sti.sr));
                                }
                            }
                            bcis[alt_i].sequences.removeAll(remove);
                            bcis[alt_i].count -= remove.size();
                        }
                    }
                }
                int total_count = 0;
                for (int i = 0; i < max; ++i) {
                    total_count += bcis[i].count;
                }
                int alt_count = bcis[alt_i].count;
                float alt_freq = (float)alt_count / (float)total_count;
                if (VERBOSE) {
                    System.err.println("alt_count=" + alt_count + " alt_freq=" + alt_freq);
                }
                boolean bl = usable = alt_count >= this.config.MIN_ALT_ALLELE_COUNT && alt_freq >= this.config.MIN_MINOR_ALLELE_FREQUENCY;
                if (VERBOSE) {
                    System.err.println("usable after count/freq check: " + usable);
                }
                if (usable && alt_count >= this.config.MIN_ALT_ALLELE_COUNT_FOR_FILTER_ENABLE && this.config.MIN_ALT_READS_WITH_FLANKING_SEQUENCE > 0) {
                    Object o;
                    SNPTrackInfo sti;
                    int ok_count = 0;
                    Iterator<Object> i$ = bcis[alt_i].sequences.iterator();
                    while (i$.hasNext() && ((sti = (SNPTrackInfo)(o = i$.next())).get_minimum_flanking_sequence() < this.config.MIN_ALT_READS_WITH_FLANKING_SEQUENCE_WINDOW || ++ok_count < this.config.MIN_ALT_READS_WITH_FLANKING_SEQUENCE)) {
                    }
                    if (ok_count < this.config.MIN_ALT_READS_WITH_FLANKING_SEQUENCE) {
                        if (VERBOSE) {
                            System.err.println("SNP flank flunk @ " + (ci + 1));
                        }
                        usable = false;
                    }
                }
                if (VERBOSE) {
                    System.err.println("usable after min_alt_reads_with_flanking_sequence check: " + usable);
                }
                if (usable && alt_count >= this.config.MIN_ALT_ALLELE_COUNT_FOR_FILTER_ENABLE && this.config.MIN_UNIQUE_START_POSITIONS_FOR_ALT_ALLELE > 1) {
                    UniqueStartTracker ust = new UniqueStartTracker(this.config, bcis[alt_i].sequences);
                    int unique_alt_read_start_positions = ust.get_unique_read_start_positions();
                    if (VERBOSE) {
                        System.err.println("unique starts for alt allele at " + (ci + 1) + " = " + unique_alt_read_start_positions);
                    }
                    if (!ust.are_counts_ok()) {
                        if (VERBOSE) {
                            System.err.println("unique start flunk @ " + (ci + 1));
                        }
                        usable = false;
                    }
                }
                if (VERBOSE) {
                    System.err.println("usable min_unique_start_positions_for_alt_allele check: " + usable);
                }
                if (usable && this.config.ENABLE_MISMAP_FILTER) {
                    Integer suspicious_count;
                    EnumMap<Base, Integer> hq_mismatches;
                    if (VERBOSE) {
                        System.err.println("mismap test for " + (ci + 1));
                    }
                    if ((hq_mismatches = this.mmf.get_hq_mismatches(ci + 1)) != null && (suspicious_count = hq_mismatches.get((Object)freq[alt_i])) != null) {
                        int usable_count = bcis[alt_i].count;
                        float suspicious_ratio = (float)suspicious_count.intValue() / (float)usable_count;
                        if (VERBOSE) {
                            System.err.println("usable count for " + (Object)((Object)freq[alt_i]) + ":" + usable_count + " suspicious=" + suspicious_count + " ratio:" + suspicious_ratio);
                        }
                        if (suspicious_ratio >= this.config.MISMAP_BASE_FREQUENCY_THRESHOLD) {
                            System.err.println("rejecting SNP at " + (ci + 1) + ", mismap filter base ratio of " + suspicious_ratio);
                            usable = false;
                        } else if ((double)suspicious_ratio >= 0.2 && usable_count > 3) {
                            System.err.println("allowing SNP at " + (ci + 1) + " w/mismap ratio of " + suspicious_ratio + ", usable_count=" + usable_count);
                        }
                    }
                }
                if (VERBOSE) {
                    System.err.println("usable after mismap filter: " + usable);
                }
                double score = -1.0;
                if (usable) {
                    JointPolymorphismScore jps = new JointPolymorphismScore();
                    jps.set_variant_probability(bcis[alt_i]);
                    if (snp_vs_consensus) {
                        jps.set_reference_probability_from_quality(50);
                    } else {
                        int reference_i = alt_i == 1 ? 0 : 1;
                        jps.set_reference_probability(bcis[reference_i]);
                    }
                    score = jps.calculate_score();
                    if (score < (double)this.config.MIN_SCORE) {
                        usable = false;
                    }
                }
                if (usable) {
                    dbSNPEntry snp;
                    Base alt_nt = freq[alt_i];
                    int blen = 20;
                    int bi = ci - blen;
                    if (bi < 0) {
                        blen += bi;
                        bi = 0;
                    }
                    String before = this.get_flanking_sequence(ci, true);
                    String after = this.get_flanking_sequence(ci, false);
                    String chunk = before + "[" + (Object)((Object)cons_nt) + "/" + (Object)((Object)alt_nt) + "]" + after;
                    int ref_base_num = ci + 1;
                    if (VERBOSE) {
                        System.err.println("SNP:" + chunk + " at " + ref_base_num);
                    }
                    TumorNormalReferenceTracker tnrt = new TumorNormalReferenceTracker();
                    BaseCountInfo bci = bc.get_info(cons_nt);
                    for (Object o : bci.sequences) {
                        tnrt.add(ReferenceOrVariant.REFERENCE, (SNPTrackInfo)o);
                    }
                    bci = bc.get_info(alt_nt);
                    for (Object o : bci.sequences) {
                        SNPTrackInfo sti = (SNPTrackInfo)o;
                        tnrt.add(ReferenceOrVariant.VARIANT, sti);
                    }
                    tnrt.analyze();
                    if (!this.unique_alt_reads_check(tnrt)) {
                        usable = false;
                    }
                    this.starts_populate(this.rpt, new UniqueStartTracker(this.config, bci.sequences));
                    this.mapq_populate(this.rpt, new MapQTracker(bci.sequences));
                    if (this.config.REPORT_ALT_ALLELE_SAM_TAGS) {
                        this.sam_tag_populate(this.rpt, new SAMTagTracker(bci.sequences));
                    }
                    if (this.config.ENABLE_BROAD_BASE_TRACKING) {
                        int broad_coverage = 0;
                        TumorNormalReferenceTracker btnrt = new TumorNormalReferenceTracker();
                        EnumMap<Base, EnumMap<Strand, EnumMap<TumorNormal, Integer>>> base2strand = this.tracker_broad.get(ci);
                        if (base2strand != null) {
                            broad_coverage += this.gather_counts(base2strand, cons_nt, ReferenceOrVariant.REFERENCE, btnrt);
                            broad_coverage += this.gather_counts(base2strand, alt_nt, ReferenceOrVariant.VARIANT, btnrt);
                        }
                        this.rpt.set_value(HEADER_BROAD_COVERAGE, Integer.toString(broad_coverage));
                        this.rpt.set_value(HEADER_BROAD_REF_NORMAL_COUNT, Integer.toString(btnrt.get_count(ReferenceOrVariant.REFERENCE, TumorNormal.NORMAL)));
                        this.rpt.set_value(HEADER_BROAD_REF_TUMOR_COUNT, Integer.toString(btnrt.get_count(ReferenceOrVariant.REFERENCE, TumorNormal.TUMOR)));
                        this.rpt.set_value(HEADER_BROAD_ALT_NORMAL_COUNT, Integer.toString(btnrt.get_count(ReferenceOrVariant.VARIANT, TumorNormal.NORMAL)));
                        this.rpt.set_value(HEADER_BROAD_ALT_TUMOR_COUNT, Integer.toString(btnrt.get_count(ReferenceOrVariant.VARIANT, TumorNormal.TUMOR)));
                    }
                    this.rpt.set_value(HEADER_NAME, this.current_reference_label + "." + ref_base_num);
                    this.rpt.set_value(HEADER_CHR, this.current_reference_label);
                    this.rpt.set_value(HEADER_POS, Integer.toString(ref_base_num));
                    this.rpt.set_value(HEADER_TYPE, "SNP");
                    this.rpt.set_value(HEADER_SIZE, "1");
                    this.rpt.set_value(HEADER_COVERAGE, Integer.toString(coverage));
                    this.rpt.set_value(HEADER_PCT_ALT_ALLELE, Str.float_decimal_format(alt_freq, this.config.REPORT_DECIMAL_ROUNDING));
                    this.rpt.set_value(HEADER_CHR_ALLELE, cons_nt.toString());
                    this.rpt.set_value(HEADER_ALT_ALLELE, alt_nt.toString());
                    this.rpt.set_value(HEADER_P_VALUE, Str.float_decimal_format(score, this.config.REPORT_DECIMAL_ROUNDING));
                    this.rpt.set_value(HEADER_TEXT, chunk);
                    if (this.dbsnp != null && (snp = this.dbsnp.find(ref_base_num, cons_nt, alt_nt)) != null) {
                        this.rpt.set_value("dbSNP", snp.get_name());
                    }
                    this.tnrt_report_populate(tnrt);
                    if (!this.skew_populate(tnrt) && !this.config.FISHERS_EXACT_STRAND_BIAS_ENABLE) {
                        System.err.println("rejecting SNP due to skew at " + this.rpt.get_value(HEADER_CHR) + "." + this.rpt.get_value(HEADER_POS));
                        usable = false;
                    }
                    if (VERBOSE) {
                        System.err.println("before FE, at " + this.rpt.get_value(HEADER_CHR) + "." + this.rpt.get_value(HEADER_POS));
                    }
                    if (this.config.FISHERS_EXACT_STRAND_BIAS_ENABLE && !this.fishers_exact_strand_bias_check(tnrt)) {
                        System.err.println("rejecting SNP due to Fisher's Exact strand bias at " + this.rpt.get_value(HEADER_CHR) + "." + this.rpt.get_value(HEADER_POS));
                        usable = false;
                    }
                    this.populate_sample();
                    this.somatic_germline_populate();
                    if (VERBOSE) {
                        System.err.println("final usable=" + usable);
                    }
                    if (usable) {
                        this.end_row();
                    } else {
                        this.rpt.reset_row();
                    }
                }
            }
            flush_queue.add(ci);
        }
        int max_flush = -1;
        for (Integer ci : flush_queue) {
            if (ci > max_flush) {
                max_flush = ci;
            }
            this.tracker.remove(ci);
        }
        for (Integer ci : indel_flush_queue) {
            if (VERBOSE) {
                System.err.println("itracker: flushing " + ci);
            }
            this.indel_tracker.remove(ci);
        }
        if (this.config.ENABLE_BROAD_BASE_TRACKING && max_flush >= 0) {
            this.clean_intmap_through(this.tracker_broad, max_flush);
            this.clean_intmap_through(this.tracker_broad_indels, max_flush);
        }
        if (this.config.ENABLE_MISMAP_FILTER && this.mmf != null) {
            this.mmf.clean_hq_mismatch_tracker_through(max_flush + 1);
        }
        if (this.config.LIMIT_READ_TRACKING) {
            this.prune_tracker();
        }
        if (this.config.DEBUG_SNP_MEMORY_USAGE) {
            System.err.println("end of call_snps() at " + this.current_ref_index + ", tracker keys:" + this.tracker.keySet().size());
            int seqs_tracked = 0;
            for (Integer pos : this.tracker.keySet()) {
                BaseCounter3 bc = this.tracker.get(pos);
                EnumMap<Base, BaseCountInfo> saw_bases = bc.get_saw_bases();
                for (Base b : saw_bases.keySet()) {
                    BaseCountInfo bci = saw_bases.get((Object)b);
                    int count = bci.sequences.size();
                    seqs_tracked += count;
                    System.err.println("  seq count for ref base " + (pos + 1) + ", " + (Object)((Object)b) + " = " + count);
                }
            }
            System.err.println("total tracker objects: " + seqs_tracked);
            seqs_tracked = 0;
            for (Integer pos : this.indel_tracker.keySet()) {
                HashMap<String, ArrayList<IndelInfo>> bucket = this.indel_tracker.get(pos);
                for (String ikey : bucket.keySet()) {
                    ArrayList<IndelInfo> il = bucket.get(ikey);
                    int count = il.size();
                    seqs_tracked += count;
                    System.err.println("  ii count at " + (pos + 1) + " = " + count);
                }
            }
            System.err.println("total indel_tracker objects: " + seqs_tracked);
        }
    }

    public void find_snps() {
        this.mmf = null;
        if (this.limited_refseq) {
            this.mmf = new SAMMismatchFilter(this.config, this.reference_sequence, this.start_offset);
        } else {
            this.reference_sequence = null;
            this.current_reference_name = null;
        }
        if (this.config.MIN_ALT_ALLELE_COUNT < this.config.MIN_UNIQUE_START_POSITIONS_FOR_ALT_ALLELE) {
            System.err.println("Note: setting minimum unique start positions for alt allele to " + this.config.MIN_ALT_ALLELE_COUNT + " because min_alt_allele_count is set to " + this.config.MIN_ALT_ALLELE_COUNT);
            this.config.MIN_UNIQUE_START_POSITIONS_FOR_ALT_ALLELE = this.config.MIN_ALT_ALLELE_COUNT;
        }
        System.err.println("SNP detection configuration:");
        System.err.println("  min_quality: " + this.config.MIN_QUALITY);
        System.err.println("  min_alt_allele_count: " + this.config.MIN_ALT_ALLELE_COUNT);
        System.err.println("  min_minor_allele_frequency: " + this.config.MIN_MINOR_ALLELE_FREQUENCY);
        System.err.println("  if alt coverage >= " + this.config.MIN_ALT_ALLELE_COUNT_FOR_FILTER_ENABLE + ":");
        System.err.println("    min_alt_reads_w_flanking: " + this.config.MIN_ALT_READS_WITH_FLANKING_SEQUENCE + ", window=" + this.config.MIN_ALT_READS_WITH_FLANKING_SEQUENCE_WINDOW);
        System.err.println("    minimum unique start positions for alt allele: " + this.config.MIN_UNIQUE_START_POSITIONS_FOR_ALT_ALLELE);
        System.err.println("  min mapping quality: " + this.config.MIN_MAPPING_QUALITY);
        System.err.println("  min unique read names for alternative allele: " + this.config.MIN_UNIQUE_READ_NAMES_FOR_ALT_ALLELE);
        System.err.println("  min unique read start positions for alternative allele: " + this.config.MIN_UNIQUE_START_POSITIONS_FOR_ALT_ALLELE);
        System.err.println("  min_flanking_quality: " + this.config.MIN_FLANKING_QUALITY + ", window=" + this.config.MIN_FLANKING_QUALITY_WINDOW);
        System.err.println("  exclude reads w/non-primary alignments: " + this.config.SKIP_NONPRIMARY_ALIGNMENTS);
        System.err.println("  mismatch filter: " + (this.config.ENABLE_MISMATCH_FILTER ? "enabled" : "disabled"));
        if (this.config.ENABLE_MISMATCH_FILTER) {
            System.err.println("    autotune: " + (this.config.AUTOTUNE ? "enabled" : "disabled"));
            System.err.print("    max high-quality reference mismatches: " + this.config.MISMATCH_FILTER_MAX_HQ_MISMATCH_COUNT + " of quality " + this.config.MISMATCH_FILTER_MIN_HIGH_QUALITY + "+");
            if (this.config.ENABLE_MISMATCH_FILTER_HQ_XTU) {
                System.err.print(" (if XT=U, allow " + this.config.MISMATCH_FILTER_MAX_HQ_MISMATCH_COUNT_XTU + ")");
            }
            System.err.println("");
            System.err.println("    max low-quality mismatches: " + this.config.MISMATCH_FILTER_MAX_LQ_MISMATCH_COUNT + " of quality " + this.config.MISMATCH_FILTER_MIN_LOW_QUALITY + "+");
            System.err.print("    low-quality window: ");
            if (this.config.MISMATCH_FILTER_LQ_WINDOW == 0.0f) {
                System.err.println("disabled");
            } else {
                System.err.println(this.config.MISMATCH_FILTER_LQ_WINDOW);
            }
        }
        System.err.println("  mismap filter: " + (this.config.ENABLE_MISMAP_FILTER ? "enabled" : "disabled") + ", frequency threshold=" + this.config.MISMAP_BASE_FREQUENCY_THRESHOLD);
        System.err.println("  broad base tracking:" + this.config.ENABLE_BROAD_BASE_TRACKING + " min_quality:" + this.config.BROAD_BASE_TRACKING_MIN_QUALITY);
        System.err.println("  read-end mismatch filter: " + this.config.ENABLE_END_MISMATCH_FILTER);
        System.err.println("  strand skew filter: " + this.config.STRAND_SKEW_FILTER_ENABLE);
        if (this.config.STRAND_SKEW_FILTER_ENABLE) {
            System.err.println("    to generate skew call: " + this.config.STRAND_SKEW_CALL_MIN_STRAND_COVERAGE + "+ reads/strand, " + this.config.STRAND_SKEW_CALL_MIN_VARIANT_COUNT + "+ variant observations");
            System.err.println("    to reject variant: " + this.config.STRAND_SKEW_FILTER_MIN_STRAND_COVERAGE + "+ reads/strand, " + this.config.STRAND_SKEW_FILTER_MIN_VARIANT_COUNT + "+ variant observations, " + Math.round(this.config.STRAND_SKEW_FILTER_MIN_STRAND_PERCENT_TO_CONSIDER_SKEWED * 100.0) + "%+ skewed");
        }
        System.err.println("  read_limit_tracking: " + this.config.LIMIT_READ_TRACKING + " " + (this.config.LIMIT_READ_TRACKING ? "(" + this.config.READ_TRACKING_LIMIT + ", trigger at " + this.config.READ_TRACKING_LIMIT_TRIGGER + ")" : ""));
        System.err.println("  insertions: " + (this.config.AVERAGE_INSERTION_QUALITY ? "average inserted base qualities for quality check" : "require each base to meet minimum quality"));
        System.err.println("  tracker map implementation: " + (this.config.USE_TREEMAP ? "TreeMap" : "HashMap"));
        System.err.println("  poly-X runs:");
        System.err.println("    minimum run length: " + this.config.POLY_X_MIN_RUN_LENGTH);
        System.err.println("    indel filter enabled: " + this.config.ENABLE_POLY_X_RUN_MASK_INDEL);
        System.err.println("    SNPs: low-quality mask filter enabled: " + this.config.ENABLE_POLY_X_RUN_MASK_SNP);
        System.err.println("  allow optical/PCR duplicates?: " + this.config.ALLOW_OPTICAL_DUPLICATES);
        System.err.print("  duplicate limiter enabled?: " + this.config.DUPLICATE_LIMITER_ENABLED);
        if (this.config.DUPLICATE_LIMITER_ENABLED) {
            System.err.println(" (" + this.config.DUPLICATE_LIMITER_MAX + " reads)");
            System.err.println("  limit optical/PCR duplicates only?: " + this.config.DUPLICATE_LIMITER_OPTICAL_ONLY);
        } else {
            System.err.println("");
        }
        System.err.println("  merge supporting reads for equivalent indels?: " + this.config.MERGE_EQUIVALENT_INDELS);
        System.err.println("");
        if (!this.config.REPORT_RESULTS) {
            this.results = new ArrayList();
        }
        if (this.use_dbsnp) {
            boolean usable = false;
            if (this.config.DBSNP_BLOB_FILE != null) {
                File f = new File(this.config.DBSNP_BLOB_FILE);
                if (f.exists() && f.canRead()) {
                    this.dbsnp = new dbSNPDB(this.config.DBSNP_BLOB_FILE);
                    this.dbsnp.set_caching(false);
                    this.config.snp_query = new dbSNPQueryCacher(this.dbsnp);
                    usable = true;
                } else {
                    System.err.println("WARNING: dbSNP flatfile not found or not readable, can't perform dbSNP lookups: " + this.config.DBSNP_BLOB_FILE);
                }
            }
            this.use_dbsnp = usable;
        }
        this.rpt = new Reporter();
        if (this.config.ENABLE_READ_REPORT) {
            this.rpt_reads = new Reporter();
        }
        Timer call_timer = new Timer("SNP calling");
        try {
            if (this.output_filename != null) {
                this.rpt.set_output_filename(this.output_filename);
            }
            this.rpt.add_header(HEADER_NORMAL_SAMPLE);
            this.rpt.add_header(HEADER_TUMOR_SAMPLE);
            this.rpt.add_header(HEADER_NAME);
            this.rpt.add_header(HEADER_CHR);
            this.rpt.add_header(HEADER_POS);
            this.rpt.add_header(HEADER_TYPE);
            this.rpt.add_header(HEADER_SIZE);
            this.rpt.add_header(HEADER_COVERAGE);
            this.rpt.add_header(HEADER_PCT_ALT_ALLELE);
            this.rpt.add_header(HEADER_CHR_ALLELE);
            this.rpt.add_header(HEADER_ALT_ALLELE);
            this.rpt.add_header(HEADER_P_VALUE);
            this.rpt.add_header(HEADER_TEXT);
            this.rpt.add_header(HEADER_UNIQUE_ALT_READS);
            this.rpt.add_header(HEADER_REF_NORMAL_COUNT);
            this.rpt.add_header(HEADER_REF_TUMOR_COUNT);
            this.rpt.add_header(HEADER_ALT_NORMAL_COUNT);
            this.rpt.add_header(HEADER_ALT_TUMOR_COUNT);
            this.rpt.add_header(HEADER_COUNT_REF_NORMAL_FWD);
            this.rpt.add_header(HEADER_COUNT_REF_NORMAL_REV);
            this.rpt.add_header(HEADER_COUNT_REF_TUMOR_FWD);
            this.rpt.add_header(HEADER_COUNT_REF_TUMOR_REV);
            this.rpt.add_header(HEADER_COUNT_VAR_NORMAL_FWD);
            this.rpt.add_header(HEADER_COUNT_VAR_NORMAL_REV);
            this.rpt.add_header(HEADER_COUNT_VAR_TUMOR_FWD);
            this.rpt.add_header(HEADER_COUNT_VAR_TUMOR_REV);
            this.rpt.add_header(HEADER_ALT_FWD_COUNT);
            this.rpt.add_header(HEADER_ALT_REV_COUNT);
            this.rpt.add_header(HEADER_ALT_HAS_RC);
            if (this.config.ENABLE_BROAD_BASE_TRACKING) {
                this.rpt.add_header(HEADER_BROAD_COVERAGE);
                this.rpt.add_header(HEADER_BROAD_REF_NORMAL_COUNT);
                this.rpt.add_header(HEADER_BROAD_REF_TUMOR_COUNT);
                this.rpt.add_header(HEADER_BROAD_ALT_NORMAL_COUNT);
                this.rpt.add_header(HEADER_BROAD_ALT_TUMOR_COUNT);
            }
            if (this.dbsnp != null) {
                this.rpt.add_header("dbSNP");
            }
            this.rpt.add_header(HEADER_UNIQUE_ALT_READ_START);
            this.rpt.add_header(HEADER_UNIQUE_ALT_READ_START_F);
            this.rpt.add_header(HEADER_UNIQUE_ALT_READ_START_R);
            this.rpt.add_header(HEADER_AVG_MAPQ_ALTERNATIVE);
            this.rpt.add_header(HEADER_SOMATIC_OR_GERMLINE);
            this.rpt.add_header(HEADER_LOH_FLAG);
            this.rpt.add_header(HEADER_ALT_RATIO_NORMAL);
            this.rpt.add_header(HEADER_ALT_RATIO_TUMOR);
            this.rpt.add_header(HEADER_ALT_RATIO_NORMAL_TUMOR_DIFF);
            this.rpt.add_header(HEADER_STRAND_SKEW);
            if (this.config.REPORT_ALT_ALLELE_SAM_TAGS) {
                this.rpt.add_header(HEADER_SAM_TAGS_ALTERNATIVE);
            }
            if (this.config.ENABLE_READ_REPORT) {
                this.rpt_reads.set_output_filename(this.config.READ_REPORT_FILENAME);
                this.rpt_reads.add_header(HEADER_CHR);
                this.rpt_reads.add_header(HEADER_POS);
                this.rpt_reads.add_header(HEADER_TYPE);
                this.rpt_reads.add_header(HEADER_SIZE);
                this.rpt_reads.add_header(HEADER_READ_NAME);
                this.rpt_reads.add_header(HEADER_STRAND);
                this.rpt_reads.add_header(HEADER_TN);
                this.rpt_reads.add_header(HEADER_REFERENCE_OR_VARIANT);
                this.rpt_reads.add_header(HEADER_SAM_FLAGS);
                if (this.config.READ_REPORT_TAGS != null) {
                    ArrayList<String> tags = new ArrayList<String>(this.config.READ_REPORT_TAGS);
                    Collections.sort(tags);
                    for (String tag : tags) {
                        this.rpt_reads.add_header("tag_" + tag);
                    }
                }
            }
            if (this.limited_refseq) {
                this.init_trackers();
            }
            this.PROCESSED = 0L;
            this.counter = new Counter();
            if (this.config.STREAMING_MODE) {
                this.get_some();
            } else {
                if (this.config.SNP_SEARCH_CHR_LIST == null) {
                    HashSet<String> saw_refs = new HashSet<String>();
                    for (SamReader sfr : this.sfrs) {
                        SAMFileHeader sfh = sfr.getFileHeader();
                        SAMSequenceDictionary ssd = sfh.getSequenceDictionary();
                        HashMap lengths = new HashMap();
                        for (SAMSequenceRecord ssr : ssd.getSequences()) {
                            String seq_name = ssr.getSequenceName();
                            String std = Chromosome.standardize_name(seq_name);
                            if (this.config.SKIP_RANDOM_REFERENCE_SEQUENCES && std.toLowerCase().indexOf("_random") > -1) continue;
                            saw_refs.add(std);
                        }
                    }
                    this.config.SNP_SEARCH_CHR_LIST = new ArrayList(saw_refs);
                }
                ArrayList<String> passed = new ArrayList<String>();
                for (String name : this.config.SNP_SEARCH_CHR_LIST) {
                    int ref_len = -1;
                    System.err.print("checking local refseq availability for " + name + ": ");
                    try {
                        ref_len = this.refseq.get_length(name);
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    if (ref_len == -1) {
                        System.err.println("missing; will NOT search for this sequence.");
                        continue;
                    }
                    System.err.println("ok (" + ref_len + " bytes)");
                    passed.add(name);
                }
                if (passed.size() == 0) {
                    System.err.println("ERROR: no local reference sequences available, does your reference database provide them?");
                    System.exit(1);
                }
                this.config.SNP_SEARCH_CHR_LIST = passed;
                Collections.sort(this.config.SNP_SEARCH_CHR_LIST);
                for (String ref_name : this.config.SNP_SEARCH_CHR_LIST) {
                    System.err.println("query mode: processing " + ref_name);
                    this.reference_sequence = null;
                    this.current_reference_name = null;
                    this.spi = new SAMPooledIterator();
                    this.spi.set_genome_version_check(this.config.CHECK_GENOME_VERSION);
                    this.spi.set_restrict_reference(ref_name);
                    if (this.config.SNP_SEARCH_RANGE != null) {
                        if (this.config.SNP_SEARCH_RANGE.isValid()) {
                            System.err.println("valid restrict range");
                            this.spi.set_restrict_range(this.config.SNP_SEARCH_RANGE);
                        } else {
                            System.err.println("ERROR: invalid search region!: " + this.config.SNP_SEARCH_RANGE.start + " " + this.config.SNP_SEARCH_RANGE.end);
                            System.exit(1);
                        }
                    }
                    this.spi.addAll(this.sfrs);
                    if (this.spi.prepare()) {
                        if (this.spi.hasNext()) {
                            this.sam = this.spi;
                            this.get_some();
                            this.call_snps(true);
                        }
                        this.spi.close();
                        continue;
                    }
                    System.err.println("ERROR: can't pool iterators for given files!");
                    System.exit(1);
                }
            }
            this.call_snps(true);
            this.rpt.close();
            if (this.config.ENABLE_READ_REPORT) {
                this.rpt_reads.close();
            }
            if (this.counter.get_total() > 0L) {
                HashMap<String, Long> counts = this.counter.get_counts();
                ArrayList<String> labels = new ArrayList<String>(counts.keySet());
                Collections.sort(labels);
                System.err.println("skipped reads summary:");
                for (String label : labels) {
                    System.err.println("  " + label + ": " + counts.get(label));
                }
            } else {
                System.err.println("no skipped reads");
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
        call_timer.finish();
    }

    public SNPConfig get_config() {
        return this.config;
    }

    public static void main(String[] argv) {
        SAMStreamingSNPFinder sf = new SAMStreamingSNPFinder();
        ArrayList<SAMResource> srs = new ArrayList<SAMResource>();
        SNPConfig config = sf.get_config();
        ReferenceSequence refseq = null;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-bam") || argv[i].equals("-cram")) {
                SAMResource sr = new SAMResource();
                sr.import_data(SAMResourceTags.SAM_URL, argv[++i]);
                sr.detect_sample_id();
                srs.add(sr);
                continue;
            }
            if (argv[i].equals("-convention")) {
                SampleNamingConvention.import_convention(argv[++i]);
                continue;
            }
            if (argv[i].equals("-alt-sam-report")) {
                config.REPORT_ALT_ALLELE_SAM_TAGS = true;
                continue;
            }
            if (argv[i].equals("-jz")) {
                config.MIN_QUALITY = 15;
                config.MIN_ALT_ALLELE_COUNT = 2;
                config.MIN_MINOR_ALLELE_FREQUENCY = 0.0f;
                continue;
            }
            if (argv[i].equals("-flush")) {
                config.READ_FLUSH_INTERVAL = Integer.parseInt(argv[++i]);
                System.err.println("setting read flush interval to " + config.READ_FLUSH_INTERVAL);
                continue;
            }
            if (argv[i].equals("-dbsnp-file")) {
                config.DBSNP_BLOB_FILE = argv[++i];
                continue;
            }
            if (argv[i].equals("-query-mode")) {
                config.STREAMING_MODE = false;
                continue;
            }
            if (argv[i].equals("-min-quality")) {
                config.MIN_QUALITY = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-min-score")) {
                config.MIN_SCORE = Float.parseFloat(argv[++i]);
                continue;
            }
            if (argv[i].equals("-min-mapq")) {
                config.MIN_MAPPING_QUALITY = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-unique-filter-coverage")) {
                config.MIN_ALT_ALLELE_COUNT_FOR_FILTER_ENABLE = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-min-unique-alt-reads")) {
                config.MIN_UNIQUE_READ_NAMES_FOR_ALT_ALLELE = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-min-unique-alt-read-start")) {
                config.MIN_UNIQUE_START_POSITIONS_FOR_ALT_ALLELE = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-skip-non-primary")) {
                config.SKIP_NONPRIMARY_ALIGNMENTS = true;
                continue;
            }
            if (argv[i].equals("-allow-non-primary")) {
                config.SKIP_NONPRIMARY_ALIGNMENTS = false;
                continue;
            }
            if (argv[i].equals("-min-coverage")) {
                config.MIN_COVERAGE = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-min-flanking-quality")) {
                config.MIN_FLANKING_QUALITY = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-min-flanking-quality-window")) {
                config.MIN_FLANKING_QUALITY_WINDOW = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-min-alt-allele-count")) {
                config.MIN_ALT_ALLELE_COUNT = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-min-alt-flanking-reads")) {
                config.MIN_ALT_READS_WITH_FLANKING_SEQUENCE = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-min-alt-flanking-reads-window")) {
                config.MIN_ALT_READS_WITH_FLANKING_SEQUENCE_WINDOW = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-min-minor-frequency")) {
                config.MIN_MINOR_ALLELE_FREQUENCY = Float.parseFloat(argv[++i]);
                if (!(config.MIN_MINOR_ALLELE_FREQUENCY > 1.0f) && !(config.MIN_MINOR_ALLELE_FREQUENCY < 0.0f)) continue;
                System.err.println("-min-minor-frequency must be >= 0 and <= 1");
                System.exit(1);
                continue;
            }
            if (argv[i].equals("-read-report")) {
                config.ENABLE_READ_REPORT = true;
                config.READ_REPORT_FILENAME = new String(argv[++i]);
                continue;
            }
            if (argv[i].equals("-rr-tags")) {
                config.READ_REPORT_TAGS = new HashSet();
                String[] list = argv[++i].split(",");
                for (int li = 0; li < list.length; ++li) {
                    config.READ_REPORT_TAGS.add(new String(list[li]));
                }
                continue;
            }
            if (argv[i].equals("-require-tags")) {
                if (config.sam_tag_filter != null) {
                    System.err.println("ERROR: only one of -require-tags and -optional-tags may be specified");
                    System.exit(1);
                }
                config.sam_tag_filter = new SAMTagFilter(true);
                config.sam_tag_filter.parse(argv[++i]);
                continue;
            }
            if (argv[i].equals("-optional-tags")) {
                if (config.sam_tag_filter != null) {
                    System.err.println("ERROR: only one of -require-tags and -optional-tags may be specified");
                    System.exit(1);
                }
                config.sam_tag_filter = new SAMTagFilter(false);
                config.sam_tag_filter.parse(argv[++i]);
                continue;
            }
            if (argv[i].equals("-mmf-disable")) {
                config.ENABLE_MISMATCH_FILTER = false;
                continue;
            }
            if (argv[i].equals("-mmf-max-hq-mismatches-xt-u")) {
                config.ENABLE_MISMATCH_FILTER_HQ_XTU = true;
                config.MISMATCH_FILTER_MAX_HQ_MISMATCH_COUNT_XTU = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-mmf-max-hq-mismatches")) {
                config.MISMATCH_FILTER_MAX_HQ_MISMATCH_COUNT = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-mmf-min-hq-quality") || argv[i].equals("-mmf-min-quality")) {
                if (argv[i].equals("-mmf-min-quality")) {
                    System.err.println("WARNING: -mmf-min-quality obsolete, use -mmf-min-hq-quality");
                }
                config.MISMATCH_FILTER_MIN_HIGH_QUALITY = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-mmf-min-lq-quality")) {
                config.MISMATCH_FILTER_MIN_LOW_QUALITY = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-mmf-max-lq-mismatches") || argv[i].equals("-mmf-max-any-mismatches")) {
                if (argv[i].equals("-mmf-max-any-mismatches")) {
                    System.err.println("WARNING: -mmf-max-any-mismatches obsolete, use -mmf-max-lq-mismatches");
                }
                config.MISMATCH_FILTER_MAX_LQ_MISMATCH_COUNT = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-no-mismap-filter")) {
                config.ENABLE_MISMAP_FILTER = false;
                continue;
            }
            if (argv[i].equals("-mismap-frequency")) {
                config.MISMAP_BASE_FREQUENCY_THRESHOLD = Float.parseFloat(argv[++i]);
                continue;
            }
            if (argv[i].equals("-nib")) {
                NIB.DEFAULT_NIB_DIR = new String(argv[++i]);
                refseq = new NIB();
                continue;
            }
            if (argv[i].equals("-ref-byte")) {
                refseq = new ReferenceSequenceByte(argv[++i]);
                continue;
            }
            if (argv[i].equals("-2bit")) {
                try {
                    refseq = new TwoBitFileLite(argv[++i]);
                }
                catch (Exception e) {
                    System.err.println("ERROR initializing reference sequence: " + e);
                    e.printStackTrace();
                    System.exit(1);
                }
                continue;
            }
            if (argv[i].equals("-fasta")) {
                try {
                    String thing = argv[++i];
                    File f = new File(thing);
                    if (f.isFile()) {
                        refseq = new FASTAIndexedFAI(thing);
                        continue;
                    }
                    if (f.isDirectory()) {
                        refseq = new FASTADirectory(thing);
                        continue;
                    }
                    System.err.println("ERROR: not a file/directory: " + thing);
                }
                catch (Exception ex) {
                    System.err.println("ERROR: " + ex);
                    System.exit(1);
                }
                continue;
            }
            if (argv[i].equals("-tree-map")) {
                config.USE_TREEMAP = true;
                continue;
            }
            if (argv[i].equals("-hash-map")) {
                config.USE_TREEMAP = false;
                continue;
            }
            if (argv[i].equals("-no-strand-skew-filter")) {
                config.STRAND_SKEW_FILTER_ENABLE = false;
                continue;
            }
            if (argv[i].equals("-strand-skew-filter-verbose")) {
                StrandSkewFilter.VERBOSE = true;
                continue;
            }
            if (argv[i].equals("-strand-skew-filter-config")) {
                String[] things;
                boolean error = false;
                if (i >= argv.length - 1) {
                    error = true;
                } else if ((things = argv[++i].split(",")).length == 5) {
                    config.STRAND_SKEW_CALL_MIN_STRAND_COVERAGE = Integer.parseInt(things[0]);
                    config.STRAND_SKEW_CALL_MIN_VARIANT_COUNT = Integer.parseInt(things[1]);
                    config.STRAND_SKEW_FILTER_MIN_STRAND_COVERAGE = Integer.parseInt(things[2]);
                    config.STRAND_SKEW_FILTER_MIN_VARIANT_COUNT = Integer.parseInt(things[3]);
                    config.STRAND_SKEW_FILTER_MIN_STRAND_PERCENT_TO_CONSIDER_SKEWED = Double.parseDouble(things[4]);
                    if (config.STRAND_SKEW_FILTER_MIN_STRAND_PERCENT_TO_CONSIDER_SKEWED < 0.0 || config.STRAND_SKEW_FILTER_MIN_STRAND_PERCENT_TO_CONSIDER_SKEWED > 1.0) {
                        error = true;
                    }
                } else {
                    error = true;
                }
                if (!error) continue;
                System.err.println("-strand-skew-filter-config requires comma-delimited list of call_min_strand_coverage,call_min_variant_count,filter_min_strand_coverage,filter_min_variant_count,skew_fraction_to_filter");
                System.exit(1);
                continue;
            }
            if (argv[i].equals("-no-broad-base-tracking")) {
                config.ENABLE_BROAD_BASE_TRACKING = false;
                continue;
            }
            if (argv[i].equals("-broad-min-quality")) {
                config.BROAD_BASE_TRACKING_MIN_QUALITY = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-no-dbsnp")) {
                sf.set_dbsnp(false);
                continue;
            }
            if (argv[i].equals("-verbose")) {
                VERBOSE = true;
                continue;
            }
            if (argv[i].equals("-no-version-check")) {
                sf.set_genome_version_check(false);
                continue;
            }
            if (argv[i].equals("-limit")) {
                config.LIMIT_READ_TRACKING = true;
                config.READ_TRACKING_LIMIT = Integer.parseInt(argv[++i]);
                config.READ_TRACKING_LIMIT_TRIGGER = (int)((double)config.READ_TRACKING_LIMIT * 1.33);
                System.err.println("trigger=" + config.READ_TRACKING_LIMIT_TRIGGER);
                continue;
            }
            if (argv[i].equals("-debug-memory")) {
                config.DEBUG_SNP_MEMORY_USAGE = true;
                continue;
            }
            if (argv[i].equals("-debug-start-base")) {
                SNPConfig.QUERY_START_BASE = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-ping")) {
                config.READ_PING_INTERVAL = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-chr")) {
                String[] stuff;
                config.SNP_SEARCH_CHR_LIST = new ArrayList();
                for (String name : stuff = argv[++i].split(",")) {
                    config.SNP_SEARCH_CHR_LIST.add(Chromosome.standardize_name(name));
                }
                config.STREAMING_MODE = false;
                System.err.println("searching reads mapped to: " + config.SNP_SEARCH_CHR_LIST.get(0));
                continue;
            }
            if (argv[i].equals("-fast-target-refseq")) {
                config.ENABLE_FAST_TARGET_REFSEQ = true;
                continue;
            }
            if (argv[i].equals("-start") || argv[i].equals("-end")) {
                int value = Integer.parseInt(argv[i + 1]);
                System.err.println("val " + value);
                if (config.SNP_SEARCH_RANGE == null) {
                    config.SNP_SEARCH_RANGE = new Range();
                }
                if (argv[i].equals("-start")) {
                    config.SNP_SEARCH_RANGE.start = value;
                } else {
                    config.SNP_SEARCH_RANGE.end = value;
                }
                System.err.println("range valid?: " + config.SNP_SEARCH_RANGE.isValid());
                ++i;
                continue;
            }
            if (argv[i].equals("-tcga-sample-fields")) {
                int fields;
                if ((fields = Integer.parseInt(argv[++i])) == 3 || fields == 4) {
                    System.err.println("using TCGA sample names of " + fields + " fields");
                    SNPConfig.TCGA_SAMPLE_FIELD_COUNT = fields;
                    continue;
                }
                System.err.println("invalid TCGA sample field count (3 or 4)");
                System.exit(1);
                continue;
            }
            if (argv[i].equals("-sample")) {
                if (srs.size() > 0) {
                    String sid = argv[++i];
                    srs.get(srs.size() - 1).import_data(SAMResourceTags.SAM_SAMPLE, sid);
                    continue;
                }
                System.err.println("ERROR: must specify -sample after -bam");
                System.exit(1);
                continue;
            }
            if (argv[i].equals("-tn")) {
                if (srs.size() > 0) {
                    SAMResource sr = srs.get(srs.size() - 1);
                    sr.set_tumor_normal(argv[++i]);
                    continue;
                }
                System.err.println("ERROR: -tn must be specified after -bam");
                continue;
            }
            if (argv[i].equals("-average-insertion-quality")) {
                config.AVERAGE_INSERTION_QUALITY = true;
                continue;
            }
            if (argv[i].equals("-of")) {
                sf.set_output_file(argv[++i]);
                continue;
            }
            if (argv[i].equals("-force-indel-accept-mapq")) {
                config.SKIP_NT_QUALITY_CHECKS_FOR_HIGH_MAPQ_INDELS = true;
                config.HIGH_MAPQ_INDEL_MIN_MAPQ = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-force-indel-accept-length")) {
                config.SKIP_NT_QUALITY_CHECKS_FOR_HIGH_MAPQ_INDELS = true;
                config.HIGH_MAPQ_INDEL_MIN_LENGTH = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-markup")) {
                try {
                    MarkupReader mr = new MarkupReader(argv[++i]);
                    srs = mr.get_config().sams;
                }
                catch (Exception e) {
                    System.err.println("error: " + e);
                    e.printStackTrace();
                    System.exit(1);
                }
                continue;
            }
            if (argv[i].equals("-version")) {
                AceViewer.print_version();
                System.exit(0);
                continue;
            }
            if (argv[i].equals("-no-poly-x-indel-filter")) {
                config.ENABLE_POLY_X_RUN_MASK_INDEL = false;
                continue;
            }
            if (argv[i].equals("-poly-x-min-run-length")) {
                config.POLY_X_MIN_RUN_LENGTH = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-no-poly-x-snp-filter")) {
                config.ENABLE_POLY_X_RUN_MASK_SNP = false;
                continue;
            }
            if (argv[i].equals("-illumina-q2")) {
                int value = Integer.parseInt(argv[++i]);
                config.AUTODETECT_ILLUMINA_QUALITY_2_RUNS = false;
                if (value == 0) {
                    config.ILLUMINA_QUALITY_2_RUN_MODE = false;
                    continue;
                }
                if (value == 1) {
                    config.ILLUMINA_QUALITY_2_RUN_MODE = true;
                    continue;
                }
                System.err.println("ERROR: -illumina-q2 must be 0 or 1");
                System.exit(1);
                continue;
            }
            if (argv[i].equals("-minor-allele-mode")) {
                config.MINOR_ALLELE_MODE = true;
                continue;
            }
            if (argv[i].equals("-precision")) {
                config.REPORT_DECIMAL_ROUNDING = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-fisher-strand-enable")) {
                config.FISHERS_EXACT_STRAND_BIAS_ENABLE = true;
                continue;
            }
            if (argv[i].equals("-ignore-first-base-mismatches")) {
                config.IGNORE_MISMATCHES_IN_FIRST_READ_BASE = true;
                continue;
            }
            if (argv[i].equals("-ignore-last-base-mismatches")) {
                config.IGNORE_MISMATCHES_IN_LAST_READ_BASE = true;
                continue;
            }
            if (argv[i].equals("-allow-duplicates")) {
                config.ALLOW_OPTICAL_DUPLICATES = true;
                continue;
            }
            if (argv[i].equals("-mmf-lq-filter-window")) {
                config.MISMATCH_FILTER_LQ_WINDOW = Float.parseFloat(argv[++i]);
                continue;
            }
            if (argv[i].equals("-duplicate-limiter")) {
                config.DUPLICATE_LIMITER_ENABLED = true;
                config.DUPLICATE_LIMITER_MAX = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-duplicate-limiter-any")) {
                config.DUPLICATE_LIMITER_OPTICAL_ONLY = false;
                continue;
            }
            if (argv[i].equals("-autotune")) {
                config.AUTOTUNE = true;
                continue;
            }
            if (argv[i].equals("-merge-equivalent-indels")) {
                config.MERGE_EQUIVALENT_INDELS = true;
                continue;
            }
            if (argv[i].equals("-max-equivalent-indel-distance")) {
                config.EQUIVALENT_INDEL_MAX_DISTANCE = Integer.parseInt(argv[++i]);
                continue;
            }
            System.err.println("ERROR: unknown parameter " + argv[i]);
            System.exit(1);
        }
        if (config.SKIP_NT_QUALITY_CHECKS_FOR_HIGH_MAPQ_INDELS && (config.HIGH_MAPQ_INDEL_MIN_MAPQ == -1 || config.HIGH_MAPQ_INDEL_MIN_LENGTH == -1)) {
            System.err.println("ERROR: must specify both -force-indel-accept-length and -force-indel-accept-mapq");
            System.exit(1);
        }
        if (refseq == null) {
            System.err.println("ERROR: no reference sequence provided (specify with -2bit or -nib)");
            System.exit(1);
        } else {
            sf.set_reference_sequence(refseq);
        }
        for (SAMResource sr : srs) {
            sr.reference_sequence = refseq;
        }
        for (SAMResource sr : srs) {
            System.err.println("sample " + sr.sample.get_sample_name() + ": is_tumor:" + sr.sample.is_tumor());
        }
        if (srs.size() == 0) {
            System.err.println("ERROR: specify -bam or -markup");
        } else {
            try {
                sf.set_resources(srs);
                sf.find_snps();
            }
            catch (Exception e) {
                System.err.println("SAMStreamingSNPFinder error: " + e);
                e.printStackTrace();
            }
        }
    }

    public String get_flanking_sequence(int ci, boolean before) {
        String result;
        if (before) {
            int blen = 20;
            int bi = ci - this.start_offset - blen;
            if (bi < 0) {
                blen += bi;
                bi = 0;
            }
            result = new String(this.reference_sequence, bi, blen);
        } else {
            int len = 20;
            int start = ci - this.start_offset + 1;
            int end = start + 20;
            if (end >= this.reference_sequence.length) {
                len -= end - this.reference_sequence.length;
            }
            result = new String(this.reference_sequence, start, len);
        }
        return result;
    }

    public int get_minimum_flanking_sequence(SAMRecord sr, int read_i) {
        int l_distance = read_i;
        int r_distance = sr.getReadLength() - (read_i + 1);
        System.err.println("ri=" + read_i + " l=" + l_distance + " r=" + r_distance + " using=" + (l_distance < r_distance ? l_distance : r_distance));
        return l_distance < r_distance ? l_distance : r_distance;
    }

    private void end_row() throws IOException {
        if (this.config.REPORT_RESULTS) {
            this.rpt.end_row();
        } else {
            this.results.add(new SNP2(this.rpt));
            this.rpt.reset_row();
        }
    }

    public ArrayList<SNP2> get_results() {
        return this.results;
    }

    public void set_reference_sequence(ReferenceSequence refseq) {
        this.refseq = refseq;
    }

    private void track_secondary_bases(SAMRecord sr, byte tumor_normal, TumorNormal tumor_normal2) {
        byte[] read = sr.getReadBases();
        byte[] quals = sr.getBaseQualities();
        Strand strand = Strand.valueOfSAMRecord(sr);
        for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
            int len = ab.getLength();
            int read_i = ab.getReadStart() - 1;
            int ref_i = ab.getReferenceStart() - 1;
            int ref_i2 = ref_i - this.start_offset;
            if (read_i < 0 || ref_i < 0) continue;
            int end = read_i + len;
            while (read_i < end) {
                if (read_i < quals.length && quals[read_i] >= this.config.BROAD_BASE_TRACKING_MIN_QUALITY) {
                    if (ref_i2 >= this.reference_sequence.length) {
                        System.err.println("ERROR: read past end of reference seq");
                    } else if (ref_i2 < 0) {
                        System.err.println("error: index < 0");
                    } else {
                        Integer count;
                        EnumMap<TumorNormal, Integer> tn2count;
                        EnumMap<Strand, EnumMap<TumorNormal, Integer>> strand2tn;
                        Base base = Base.valueOf((char)read[read_i]);
                        EnumMap<Base, EnumMap<Strand, EnumMap<TumorNormal, Integer>>> base2strand = this.tracker_broad.get(ref_i);
                        if (base2strand == null) {
                            base2strand = new EnumMap(Base.class);
                            this.tracker_broad.put(ref_i, base2strand);
                        }
                        if ((strand2tn = base2strand.get((Object)base)) == null) {
                            strand2tn = new EnumMap(Strand.class);
                            base2strand.put(base, strand2tn);
                        }
                        if ((tn2count = strand2tn.get((Object)strand)) == null) {
                            tn2count = new EnumMap(TumorNormal.class);
                            strand2tn.put(strand, tn2count);
                        }
                        if ((count = tn2count.get((Object)tumor_normal2)) == null) {
                            count = 0;
                        }
                        tn2count.put(tumor_normal2, count + 1);
                    }
                }
                ++read_i;
                ++ref_i;
                ++ref_i2;
            }
        }
    }

    private void track_broad_indels(SAMIndelFilter sif, SAMRecord sr, byte tumor_normal, TumorNormal tumor_normal2) {
        ArrayList<IndelInfo> broad = sif.get_broad_indels();
        if (broad == null) {
            return;
        }
        Strand strand = Strand.valueOfSAMRecord(sr);
        for (IndelInfo ii : broad) {
            Integer count;
            EnumMap<TumorNormal, Integer> tn2count;
            EnumMap<Strand, EnumMap<TumorNormal, Integer>> strand2tn;
            String indel_type = ii.getTypeHashString();
            HashMap<String, EnumMap<Strand, EnumMap<TumorNormal, Integer>>> base2strand = this.tracker_broad_indels.get(ii.reference_i);
            if (base2strand == null) {
                base2strand = new HashMap();
                this.tracker_broad_indels.put(ii.reference_i, base2strand);
            }
            if ((strand2tn = base2strand.get(indel_type)) == null) {
                strand2tn = new EnumMap(Strand.class);
                base2strand.put(indel_type, strand2tn);
            }
            if ((tn2count = strand2tn.get((Object)strand)) == null) {
                tn2count = new EnumMap(TumorNormal.class);
                strand2tn.put(strand, tn2count);
            }
            if ((count = tn2count.get((Object)tumor_normal2)) == null) {
                count = 0;
            }
            tn2count.put(tumor_normal2, count + 1);
        }
    }

    private void init_trackers() {
        if (this.config.USE_TREEMAP) {
            this.tracker = new TreeMap<Integer, BaseCounter3>();
            this.indel_tracker = new TreeMap<Integer, HashMap<String, ArrayList<IndelInfo>>>();
        } else {
            this.tracker = new HashMap<Integer, BaseCounter3>();
            this.indel_tracker = new HashMap<Integer, HashMap<String, ArrayList<IndelInfo>>>();
        }
        if (this.config.ENABLE_BROAD_BASE_TRACKING) {
            this.tracker_broad = new HashMap();
            this.tracker_broad_indels = new HashMap();
        }
    }

    private void tnrt_report_populate(TumorNormalReferenceTracker tnrt) {
        this.rpt.set_value(HEADER_REF_NORMAL_COUNT, Integer.toString(tnrt.get_count(ReferenceOrVariant.REFERENCE, TumorNormal.NORMAL)));
        this.rpt.set_value(HEADER_REF_TUMOR_COUNT, Integer.toString(tnrt.get_count(ReferenceOrVariant.REFERENCE, TumorNormal.TUMOR)));
        this.rpt.set_value(HEADER_ALT_NORMAL_COUNT, Integer.toString(tnrt.get_count(ReferenceOrVariant.VARIANT, TumorNormal.NORMAL)));
        this.rpt.set_value(HEADER_ALT_TUMOR_COUNT, Integer.toString(tnrt.get_count(ReferenceOrVariant.VARIANT, TumorNormal.TUMOR)));
        this.rpt.set_value(HEADER_ALT_FWD_COUNT, Integer.toString(tnrt.get_variant_fwd_count()));
        this.rpt.set_value(HEADER_ALT_REV_COUNT, Integer.toString(tnrt.get_variant_rev_count()));
        this.rpt.set_value(HEADER_ALT_HAS_RC, tnrt.get_variant_fwd_reverse_confirmation() ? "1" : "0");
        for (TumorNormal tn : TumorNormalReferenceTracker.all_tn) {
            if (tn.equals((Object)TumorNormal.UNKNOWN)) continue;
            for (ReferenceOrVariant rov : TumorNormalReferenceTracker.all_rov) {
                for (Strand str : TumorNormalReferenceTracker.all_strand) {
                    ArrayList<String> stuff = new ArrayList<String>();
                    stuff.add("count");
                    stuff.add(rov.equals((Object)ReferenceOrVariant.REFERENCE) ? "ref" : "var");
                    stuff.add(tn.equals((Object)TumorNormal.TUMOR) ? "tumor" : "normal");
                    stuff.add(str.equals((Object)Strand.STRAND_POSITIVE) ? "fwd" : "rev");
                    String key = Str.join("_", stuff);
                    this.rpt.set_value(key, Integer.toString(tnrt.get_count(rov, tn, str)));
                }
            }
        }
        if (this.config.ENABLE_READ_REPORT) {
            this.tnrt_read_report(tnrt, ReferenceOrVariant.REFERENCE);
            this.tnrt_read_report(tnrt, ReferenceOrVariant.VARIANT);
        }
    }

    private void tnrt_read_report(TumorNormalReferenceTracker tnrt, ReferenceOrVariant rov) {
        ArrayList<SNPTrackInfo> stis = tnrt.get_sti(rov);
        if (stis != null) {
            for (SNPTrackInfo sti : stis) {
                this.rpt_reads.set_value(HEADER_CHR, this.rpt.get_value(HEADER_CHR));
                this.rpt_reads.set_value(HEADER_POS, this.rpt.get_value(HEADER_POS));
                this.rpt_reads.set_value(HEADER_TYPE, this.rpt.get_value(HEADER_TYPE));
                this.rpt_reads.set_value(HEADER_SIZE, this.rpt.get_value(HEADER_SIZE));
                this.rpt_reads.set_value(HEADER_READ_NAME, sti.sr.getReadName());
                this.rpt_reads.set_value(HEADER_STRAND, sti.sr.getReadNegativeStrandFlag() ? "-" : "+");
                if (sti.tumor_normal == 78 || sti.tumor_normal == 84) {
                    this.rpt_reads.set_value(HEADER_TN, Character.toString((char)sti.tumor_normal));
                } else {
                    this.rpt_reads.set_value(HEADER_TN, "?");
                }
                this.rpt_reads.set_value(HEADER_REFERENCE_OR_VARIANT, rov == ReferenceOrVariant.REFERENCE ? "R" : "V");
                this.rpt_reads.set_value(HEADER_SAM_FLAGS, Integer.toString(sti.sr.getFlags()));
                if (this.config.READ_REPORT_TAGS != null) {
                    for (String tag : this.config.READ_REPORT_TAGS) {
                        this.rpt_reads.set_value("tag_" + tag, "");
                    }
                    for (SAMRecord.SAMTagAndValue tav : sti.sr.getAttributes()) {
                        if (!this.config.READ_REPORT_TAGS.contains(tav.tag)) continue;
                        this.rpt_reads.set_value("tag_" + tav.tag, tav.value.toString());
                    }
                }
                try {
                    this.rpt_reads.end_row();
                }
                catch (Exception e) {
                    System.err.println("ERROR writing read report: " + e);
                    e.printStackTrace();
                }
            }
        }
    }

    private void get_some() throws IOException {
        int i;
        SAMIndelFilter sif = new SAMIndelFilter(this.config);
        int reads_with_quality_mapping_problem = 0;
        int end_mismatch_max_window = 0;
        Counter ctr = new Counter();
        if (this.config.ENABLE_END_MISMATCH_FILTER) {
            for (i = 0; i < this.config.END_MISMATCH_FILTER_WINDOWS.length; ++i) {
                if (this.config.END_MISMATCH_FILTER_WINDOWS[i][0] <= end_mismatch_max_window) continue;
                end_mismatch_max_window = this.config.END_MISMATCH_FILTER_WINDOWS[i][0];
            }
        }
        SAMRecord last_usable_sr = null;
        DuplicateLimiter dl = null;
        if (this.config.DUPLICATE_LIMITER_ENABLED) {
            dl = new DuplicateLimiter(this.config.DUPLICATE_LIMITER_MAX);
        }
        for (SAMRecord sr : this.sam) {
            int end;
            int ref_i2;
            int ref_i;
            int read_i;
            int len;
            int ignore_read_i_last;
            int ignore_read_i_first;
            TumorNormal tumor_normal2;
            byte tumor_normal;
            if (VERBOSE) {
                System.err.println("read: " + sr.getReadName() + " at " + sr.getAlignmentStart());
            }
            if (this.PROCESSED > 0L && this.PROCESSED % (long)this.config.READ_PING_INTERVAL == 0L) {
                System.err.print("processed " + this.PROCESSED + ", skipped " + this.counter.get_total() + " (" + this.counter.get_summary() + ")");
                if (last_usable_sr != null) {
                    System.err.print(" last map pos=" + sr.getReferenceName() + ":" + sr.getAlignmentStart());
                }
                System.err.println("");
            }
            ++this.PROCESSED;
            if (sr == null) {
                System.err.println("ERROR: null SAMRecord, quitting");
                break;
            }
            if (!this.config.ALLOW_OPTICAL_DUPLICATES && sr.getDuplicateReadFlag()) {
                this.counter.increment("optical_pcr_duplicate");
                continue;
            }
            if (sr.getReadUnmappedFlag()) {
                this.counter.increment("unmapped");
                continue;
            }
            if (this.config.SKIP_NONPRIMARY_ALIGNMENTS && sr.getNotPrimaryAlignmentFlag()) {
                this.counter.increment("non_primary_alignment");
                continue;
            }
            if (sr.getMappingQuality() < this.config.MIN_MAPPING_QUALITY) {
                this.counter.increment("low_mapq");
                continue;
            }
            if (this.config.sam_tag_filter != null && !this.config.sam_tag_filter.check(sr, this.counter)) continue;
            if (this.has_samples) {
                i = this.single_sam ? 0 : this.spi.current_buf_index;
                Sample current_sample = this.samples[i];
                if (current_sample.is_tumor()) {
                    tumor_normal = 84;
                    tumor_normal2 = TumorNormal.TUMOR;
                } else if (current_sample.is_normal()) {
                    tumor_normal = 78;
                    tumor_normal2 = TumorNormal.NORMAL;
                } else {
                    tumor_normal = 63;
                    tumor_normal2 = TumorNormal.UNKNOWN;
                }
            } else {
                tumor_normal = 63;
                tumor_normal2 = TumorNormal.UNKNOWN;
            }
            if (this.config.DUPLICATE_LIMITER_ENABLED && (!this.config.DUPLICATE_LIMITER_OPTICAL_ONLY || sr.getDuplicateReadFlag()) && !dl.add(sr, tumor_normal2.toString())) {
                this.counter.increment("duplicate_limiter");
                continue;
            }
            if (this.config.AUTODETECT_ILLUMINA_QUALITY_2_RUNS) {
                int run_len;
                if (this.PROCESSED > (long)this.config.ILLUMINA_QUALITY_2_READ_SCAN_COUNT) {
                    this.config.AUTODETECT_ILLUMINA_QUALITY_2_RUNS = false;
                }
                if (!this.config.ILLUMINA_QUALITY_2_HEADER_CHECKED) {
                    boolean is_illumina = false;
                    if (this.sfrs != null) {
                        block2: for (SamReader sfr : this.sfrs) {
                            SAMFileHeader sfh = sfr.getFileHeader();
                            for (SAMReadGroupRecord srgr : sfh.getReadGroups()) {
                                String platform = srgr.getPlatform();
                                if (platform == null || (platform = platform.toLowerCase()).indexOf("illumina") <= -1) continue;
                                is_illumina = true;
                                continue block2;
                            }
                        }
                    }
                    if (is_illumina) {
                        this.config.ILLUMINA_QUALITY_2_HEADER_PASSED = true;
                    } else {
                        this.config.AUTODETECT_ILLUMINA_QUALITY_2_RUNS = false;
                    }
                    this.config.ILLUMINA_QUALITY_2_HEADER_CHECKED = true;
                }
                byte[] quals = sr.getBaseQualities();
                int run_start = -1;
                int run_end = -1;
                boolean qualified_run = false;
                for (int ri = 0; ri < quals.length; ++ri) {
                    if (quals[ri] == 2) {
                        if (run_start == -1) {
                            run_start = run_end = ri;
                            continue;
                        }
                        ++run_end;
                        continue;
                    }
                    if (run_start == -1 || run_end == -1) continue;
                    int run_len2 = run_end - run_start + 1;
                    if (run_len2 >= this.config.ILLUMINA_QUALITY_2_MIN_RUN_LENGTH) {
                        qualified_run = true;
                    }
                    run_end = -1;
                    run_start = -1;
                }
                if (run_start != -1 && run_end != -1 && (run_len = run_end - run_start + 1) >= this.config.ILLUMINA_QUALITY_2_MIN_RUN_LENGTH) {
                    qualified_run = true;
                }
                if (qualified_run && this.config.ILLUMINA_QUALITY_2_HEADER_PASSED) {
                    this.config.AUTODETECT_ILLUMINA_QUALITY_2_RUNS = false;
                    this.config.ILLUMINA_QUALITY_2_RUN_MODE = true;
                    System.err.println("Note: Illumina quality-2 runs detected, using kinder/gentler flanking sequence quality check");
                }
            }
            last_usable_sr = sr;
            int as = sr.getAlignmentStart();
            if (as > 0) {
                this.current_ref_index = as - 1;
                if (this.PROCESSED % (long)this.config.READ_FLUSH_INTERVAL == 0L) {
                    this.call_snps(false);
                }
            }
            String rn = sr.getReferenceName();
            if (!this.limited_refseq && (this.current_reference_name == null || (this.config.STREAMING_MODE || this.single_sam) && !this.current_reference_name.equals(rn))) {
                if (this.current_reference_name != null) {
                    this.call_snps(true);
                }
                Runtime rt = Runtime.getRuntime();
                rt.gc();
                System.err.println("free memory: " + rt.freeMemory());
                Chromosome chr = Chromosome.valueOfString(rn);
                System.err.print("loading refseq for " + rn + "...");
                String standardized_name = Chromosome.standardize_name(rn);
                long before = System.currentTimeMillis();
                if (this.config.ENABLE_FAST_TARGET_REFSEQ && this.config.SNP_SEARCH_RANGE != null && this.config.SNP_SEARCH_RANGE.isValid()) {
                    int rlen = this.refseq.get_length(standardized_name);
                    this.reference_sequence = new byte[rlen];
                    int rstart = this.config.SNP_SEARCH_RANGE.start - this.config.FAST_TARGET_REFSEQ_FLANK;
                    int rend = this.config.SNP_SEARCH_RANGE.end + this.config.FAST_TARGET_REFSEQ_FLANK;
                    if (rstart < 1) {
                        rstart = 1;
                    }
                    if (rend > rlen) {
                        rend = rlen;
                    }
                    int chunk_len = rend - rstart + 1;
                    Arrays.fill(this.reference_sequence, (byte)78);
                    byte[] chunk = this.refseq.get_region(standardized_name, rstart, chunk_len);
                    System.arraycopy(chunk, 0, this.reference_sequence, rstart - 1, chunk_len);
                } else {
                    this.reference_sequence = this.refseq.get_all(standardized_name);
                }
                long elapsed = System.currentTimeMillis() - before;
                System.err.println("took " + elapsed + " ms");
                this.init_trackers();
                this.mmf = new SAMMismatchFilter(this.config, this.reference_sequence, this.start_offset);
                this.current_reference_name = rn;
                this.current_reference_label = standardized_name;
                if (this.use_dbsnp) {
                    this.dbsnp.set_current_chromosome(chr);
                }
            }
            if (this.config.ENABLE_BROAD_BASE_TRACKING) {
                this.track_secondary_bases(sr, tumor_normal, tumor_normal2);
            }
            boolean mmf_ok = this.mmf.filter(sr);
            if (VERBOSE) {
                System.err.println("mismatch filter passed for " + SAMUtils.get_printable_read_name(sr) + " => " + mmf_ok);
            }
            if (!mmf_ok) continue;
            byte[] read = sr.getReadBases();
            byte[] quals = sr.getBaseQualities();
            if (sr.getReadNegativeStrandFlag()) {
                ignore_read_i_first = read.length - 1;
                ignore_read_i_last = 0;
            } else {
                ignore_read_i_first = 0;
                ignore_read_i_last = read.length - 1;
            }
            if (sif.filter(sr)) {
                if (VERBOSE) {
                    System.err.println("SIF hit for " + sr.getReadName());
                }
                for (IndelInfo ii : sif.get_indels()) {
                    String key;
                    ArrayList<IndelInfo> list;
                    HashMap<String, ArrayList<IndelInfo>> cons_bucket = this.indel_tracker.get(ii.reference_i);
                    if (cons_bucket == null) {
                        cons_bucket = new HashMap();
                        this.indel_tracker.put(ii.reference_i, cons_bucket);
                    }
                    if ((list = cons_bucket.get(key = ii.getTypeHashString())) == null) {
                        list = new ArrayList();
                        cons_bucket.put(key, list);
                    }
                    ii.sr = sr;
                    ii.tumor_normal = tumor_normal;
                    list.add(ii);
                }
            } else if (VERBOSE) {
                System.err.println("SIF miss for " + sr.getReadName());
            }
            if (this.config.ENABLE_BROAD_BASE_TRACKING) {
                this.track_broad_indels(sif, sr, tumor_normal, tumor_normal2);
            }
            boolean[] blacklist = null;
            if (this.config.ENABLE_END_MISMATCH_FILTER) {
                int window_end = read.length - end_mismatch_max_window;
                boolean[] mismatches = new boolean[read.length];
                Arrays.fill(mismatches, false);
                for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
                    len = ab.getLength();
                    read_i = ab.getReadStart() - 1;
                    ref_i = ab.getReferenceStart() - 1;
                    ref_i2 = ref_i - this.start_offset;
                    if (read_i < 0 || ref_i < 0) continue;
                    end = read_i + len;
                    while (read_i < end) {
                        Base read_base;
                        if (!(read_i >= quals.length || quals[read_i] < this.config.MIN_QUALITY || ref_i2 < 0 || ref_i2 >= this.reference_sequence.length || read_i >= end_mismatch_max_window && read_i < window_end || (read_base = Base.valueOf((char)read[read_i])).equals((char)this.reference_sequence[ref_i2]))) {
                            mismatches[read_i] = true;
                        }
                        ++read_i;
                        ++ref_i;
                        ++ref_i2;
                    }
                }
                for (int wi = 0; wi < this.config.END_MISMATCH_FILTER_WINDOWS.length; ++wi) {
                    int window_size = this.config.END_MISMATCH_FILTER_WINDOWS[wi][0];
                    int total_mismatches = this.config.END_MISMATCH_FILTER_WINDOWS[wi][1];
                    for (int dir = 0; dir <= 1; ++dir) {
                        int ei;
                        int si;
                        if (dir == 0) {
                            si = 0;
                            ei = window_size;
                            if (ei > read.length) {
                                ei = read.length;
                            }
                        } else {
                            si = read.length - window_size;
                            if (si < 0) {
                                si = 0;
                            }
                            ei = read.length;
                        }
                        int count = 0;
                        for (i = si; i < ei; ++i) {
                            if (!mismatches[i]) continue;
                            ++count;
                        }
                        if (count < total_mismatches) continue;
                        if (blacklist == null) {
                            blacklist = new boolean[read.length];
                            Arrays.fill(blacklist, false);
                        }
                        for (i = si; i < ei; ++i) {
                            if (!mismatches[i]) continue;
                            blacklist[i] = true;
                        }
                    }
                }
            }
            boolean qual_mapping_problem = false;
            for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
                len = ab.getLength();
                read_i = ab.getReadStart() - 1;
                ref_i = ab.getReferenceStart() - 1;
                ref_i2 = ref_i - this.start_offset;
                if (read_i < 0) {
                    System.err.println("ERROR: can't include " + sr.getReadName() + ", read_i < 0");
                    continue;
                }
                if (ref_i < 0) {
                    System.err.println("ERROR: can't include " + sr.getReadName() + ", ref_i < 0");
                    continue;
                }
                end = read_i + len;
                while (read_i < end) {
                    if (read_i >= quals.length) {
                        qual_mapping_problem = true;
                    } else if (quals[read_i] >= this.config.MIN_QUALITY) {
                        if (ref_i2 >= this.reference_sequence.length) {
                            System.err.println("ERROR: read past end of reference seq");
                        } else if (ref_i2 < 0) {
                            System.err.println("error: index < 0");
                        } else if (!(this.config.MIN_FLANKING_QUALITY_WINDOW > 0 && !SAMUtils.flanking_quality_check(quals, read_i, 1, this.config.MIN_FLANKING_QUALITY, this.config.MIN_FLANKING_QUALITY_WINDOW, this.config.ILLUMINA_QUALITY_2_RUN_MODE) || this.config.ENABLE_END_MISMATCH_FILTER && blacklist != null && blacklist[read_i] != false)) {
                            BaseCounter3 bc = this.tracker.get(ref_i);
                            if (bc == null) {
                                bc = new BaseCounter3();
                                if (!this.config.MINOR_ALLELE_MODE) {
                                    bc.add_base((char)this.reference_sequence[ref_i2]);
                                }
                                this.tracker.put(ref_i, bc);
                            }
                            Base current_base = Base.valueOf((char)read[read_i]);
                            if ((this.config.IGNORE_MISMATCHES_IN_FIRST_READ_BASE && read_i == ignore_read_i_first || this.config.IGNORE_MISMATCHES_IN_LAST_READ_BASE && read_i == ignore_read_i_last) && !Base.valueOf((char)this.reference_sequence[ref_i2]).equals((Object)current_base)) {
                                System.err.println("ignoring " + (read_i == ignore_read_i_first ? "first" : "last") + "-base mismatch on " + (sr.getReadNegativeStrandFlag() ? "-" : "+") + " read=" + sr.getReadName() + " pos=" + (ref_i + 1) + " as=" + sr.getAlignmentStart() + " ae=" + sr.getAlignmentEnd());
                            } else {
                                bc.add_base(current_base, new SNPTrackInfo(sr, read_i, tumor_normal), true);
                            }
                        }
                    }
                    ++read_i;
                    ++ref_i;
                    ++ref_i2;
                }
            }
            if (!qual_mapping_problem) continue;
            ++reads_with_quality_mapping_problem;
        }
        if (this.config.DUPLICATE_LIMITER_ENABLED) {
            dl.finish();
        }
        if (reads_with_quality_mapping_problem > 0) {
            System.err.println("reads with quality mapping problem: " + reads_with_quality_mapping_problem);
        }
    }

    private void clean_intmap_through(AbstractMap map, int max_value) {
        ArrayList keys = new ArrayList(map.keySet());
        for (Object o : keys) {
            if ((Integer)o > max_value) continue;
            map.remove(o);
        }
    }

    private int gather_counts(EnumMap<Base, EnumMap<Strand, EnumMap<TumorNormal, Integer>>> base2strand, Base b, ReferenceOrVariant rov, TumorNormalReferenceTracker tnrt) {
        int total = 0;
        EnumMap<Strand, EnumMap<TumorNormal, Integer>> strand2tn = base2strand.get((Object)b);
        if (strand2tn != null) {
            for (Strand strand : strand2tn.keySet()) {
                EnumMap<TumorNormal, Integer> tn2count = strand2tn.get((Object)strand);
                for (TumorNormal tn : tn2count.keySet()) {
                    Integer count = tn2count.get((Object)tn);
                    total += count.intValue();
                    tnrt.add_set(rov, strand, tn, count);
                }
            }
        }
        return total;
    }

    private int gather_counts2(HashMap<String, EnumMap<Strand, EnumMap<TumorNormal, Integer>>> base2strand, String key, ReferenceOrVariant rov, TumorNormalReferenceTracker tnrt) {
        EnumMap<Strand, EnumMap<TumorNormal, Integer>> strand2tn;
        int total = 0;
        if (base2strand != null && (strand2tn = base2strand.get(key)) != null) {
            for (Strand strand : strand2tn.keySet()) {
                EnumMap<TumorNormal, Integer> tn2count = strand2tn.get((Object)strand);
                for (TumorNormal tn : tn2count.keySet()) {
                    Integer count = tn2count.get((Object)tn);
                    total += count.intValue();
                    tnrt.add_set(rov, strand, tn, count);
                }
            }
        }
        return total;
    }

    private void prune_tracker() {
        if (this.tracker == null) {
            return;
        }
        for (Integer ci : this.tracker.keySet()) {
            EnumMap<Base, BaseCountInfo> base_map = this.tracker.get(ci).get_saw_bases();
            for (Base b : base_map.keySet()) {
                BaseCountInfo bci = base_map.get((Object)b);
                if (bci.sequences.size() < this.config.READ_TRACKING_LIMIT_TRIGGER) continue;
                System.err.println("pruning " + (Object)((Object)b) + " counts at " + (ci + 1) + ": " + bci.sequences.size() + " reads");
                this.prune_snp_track_info(bci.sequences);
            }
        }
    }

    private void prune_snp_track_info(ArrayList<Object> list_to_prune) {
        TreeMap<Integer, ArrayList<SNPTrackInfo>> bucket2score;
        HashMap buckets = new HashMap();
        boolean verbose_prune = false;
        StringCounter sc = new StringCounter();
        float scale_factor = (float)this.config.READ_TRACKING_LIMIT / (float)list_to_prune.size();
        if (verbose_prune) {
            System.err.println("scaling needed: " + scale_factor + " " + list_to_prune.size());
        }
        for (Object o : list_to_prune) {
            ArrayList<SNPTrackInfo> track_list;
            SNPTrackInfo sti = (SNPTrackInfo)o;
            String bucket_key = (char)sti.tumor_normal + (sti.sr.getReadNegativeStrandFlag() ? "-" : "+") + sti.sr.getUnclippedStart() % 5;
            int score = sti.get_quality() * (sti.get_minimum_flanking_sequence() >= this.config.MIN_ALT_READS_WITH_FLANKING_SEQUENCE_WINDOW ? 100 : 1);
            bucket2score = (TreeMap<Integer, ArrayList<SNPTrackInfo>>)buckets.get(bucket_key);
            if (bucket2score == null) {
                bucket2score = new TreeMap<Integer, ArrayList<SNPTrackInfo>>();
                buckets.put(bucket_key, bucket2score);
            }
            if ((track_list = (ArrayList<SNPTrackInfo>)bucket2score.get(score)) == null) {
                track_list = new ArrayList<SNPTrackInfo>();
                bucket2score.put(score, track_list);
            }
            track_list.add(sti);
            sc.increment(bucket_key);
            if (!verbose_prune) continue;
            System.err.println("key=" + bucket_key + " q=" + sti.get_quality() + " score=" + score + " spos=" + sti.sr.getUnclippedStart());
        }
        if (verbose_prune) {
            System.err.println("bucket count: " + buckets.keySet().size());
        }
        ArrayList<SNPTrackInfo> trimmed = new ArrayList<SNPTrackInfo>();
        if (verbose_prune) {
            System.err.println("begin trimming");
        }
        for (String bucket_key : buckets.keySet()) {
            int bucket_size = sc.get_count_for(bucket_key);
            int after_size = (int)((float)bucket_size * scale_factor);
            if (after_size < this.config.READ_TRACKING_LIMIT_BUCKET_EXEMPTION) {
                if (!verbose_prune) continue;
                System.err.println("not trimming " + bucket_key);
                continue;
            }
            int remove_count = bucket_size - after_size;
            if (verbose_prune) {
                System.err.println("bucket " + bucket_key + "=" + bucket_size + " after=" + after_size + " remove=" + remove_count);
            }
            bucket2score = (TreeMap)buckets.get(bucket_key);
            for (Integer score : bucket2score.keySet()) {
                ArrayList set = (ArrayList)bucket2score.get(score);
                for (SNPTrackInfo sti : (ArrayList)bucket2score.get(score)) {
                    if (verbose_prune) {
                        System.err.print(bucket_key + " " + score);
                    }
                    if (remove_count-- > 0) {
                        if (!verbose_prune) continue;
                        System.err.println(" pruned");
                        continue;
                    }
                    if (verbose_prune) {
                        System.err.println(" kept");
                    }
                    trimmed.add(sti);
                }
            }
        }
        if (verbose_prune) {
            System.err.println("final: left=" + trimmed.size());
        }
        list_to_prune.clear();
        list_to_prune.addAll(trimmed);
    }

    private void populate_sample() {
        if (this.has_samples) {
            HashSet<String> ns = new HashSet<String>();
            HashSet<String> ts = new HashSet<String>();
            for (int i = 0; i < this.samples.length; ++i) {
                if (this.samples[i] == null) continue;
                String sname = this.samples[i].get_sample_name();
                TumorNormal tn = this.samples[i].get_tumornormal();
                if (sname == null || tn == null) continue;
                if (tn.equals((Object)TumorNormal.NORMAL)) {
                    ns.add(sname);
                    continue;
                }
                if (!tn.equals((Object)TumorNormal.TUMOR)) continue;
                ts.add(sname);
            }
            if (ns.size() > 0) {
                this.rpt.set_value(HEADER_NORMAL_SAMPLE, Str.join(",", ns));
            }
            if (ts.size() > 0) {
                this.rpt.set_value(HEADER_TUMOR_SAMPLE, Str.join(",", ts));
            }
        }
    }

    private boolean unique_alt_reads_check(TumorNormalReferenceTracker tnrt) {
        boolean ok = true;
        int unique_alt_reads = tnrt.get_unique_read_name_count(ReferenceOrVariant.VARIANT);
        this.rpt.set_value(HEADER_UNIQUE_ALT_READS, Integer.toString(unique_alt_reads));
        if (unique_alt_reads < this.config.MIN_UNIQUE_READ_NAMES_FOR_ALT_ALLELE) {
            ok = false;
        }
        return ok;
    }

    private boolean mate_pair_qa(BaseCountInfo bci1, BaseCountInfo bci2) {
        String rn;
        BaseCountInfo set2;
        BaseCountInfo set1;
        boolean result = true;
        if (bci1.sequences.size() < bci2.sequences.size()) {
            set1 = bci1;
            set2 = bci2;
        } else {
            set1 = bci2;
            set2 = bci1;
        }
        HashSet<String> set1_ids = new HashSet<String>();
        for (Object o : set1.sequences) {
            set1_ids.add(((SNPTrackInfo)o).sr.getReadName());
        }
        ArrayList<Object> set1_delete = new ArrayList<Object>();
        ArrayList<Object> set2_delete = new ArrayList<Object>();
        HashSet<String> bad_ids = new HashSet<String>();
        for (Object o : set2.sequences) {
            rn = ((SNPTrackInfo)o).sr.getReadName();
            if (!set1_ids.contains(rn)) continue;
            bad_ids.add(rn);
            set2_delete.add(o);
        }
        if (bad_ids.size() > 1) {
            result = false;
            set2.sequences.removeAll(set2_delete);
            set2.count -= set2_delete.size();
            for (Object o : set1.sequences) {
                rn = ((SNPTrackInfo)o).sr.getReadName();
                if (!bad_ids.contains(rn)) continue;
                set1_delete.add(o);
            }
            set1.sequences.removeAll(set1_delete);
            set1.count -= set1_delete.size();
        }
        return result;
    }

    private void starts_populate(Reporter rpt, UniqueStartTracker ust) {
        rpt.set_value(HEADER_UNIQUE_ALT_READ_START, Integer.toString(ust.get_unique_read_start_positions()));
        rpt.set_value(HEADER_UNIQUE_ALT_READ_START_F, Integer.toString(ust.get_unique_read_start_positions_fwd()));
        rpt.set_value(HEADER_UNIQUE_ALT_READ_START_R, Integer.toString(ust.get_unique_read_start_positions_rev()));
    }

    private void mapq_populate(Reporter rpt, MapQTracker mapq) {
        rpt.set_value(HEADER_AVG_MAPQ_ALTERNATIVE, Integer.toString(mapq.get_average_mapping_quality()));
    }

    private void sam_tag_populate(Reporter rpt, SAMTagTracker stt) {
        rpt.set_value(HEADER_SAM_TAGS_ALTERNATIVE, Str.join(" ", stt.get_results()));
    }

    private void somatic_germline_populate() {
        int alt_t_count;
        int alt_n_count;
        int ref_t_count;
        int ref_n_count;
        if (this.config.ENABLE_BROAD_BASE_TRACKING) {
            ref_n_count = Integer.parseInt(this.rpt.get_value(HEADER_BROAD_REF_NORMAL_COUNT));
            ref_t_count = Integer.parseInt(this.rpt.get_value(HEADER_BROAD_REF_TUMOR_COUNT));
            alt_n_count = Integer.parseInt(this.rpt.get_value(HEADER_BROAD_ALT_NORMAL_COUNT));
            alt_t_count = Integer.parseInt(this.rpt.get_value(HEADER_BROAD_ALT_TUMOR_COUNT));
        } else {
            ref_n_count = Integer.parseInt(this.rpt.get_value(HEADER_REF_NORMAL_COUNT));
            ref_t_count = Integer.parseInt(this.rpt.get_value(HEADER_REF_TUMOR_COUNT));
            alt_n_count = Integer.parseInt(this.rpt.get_value(HEADER_ALT_NORMAL_COUNT));
            alt_t_count = Integer.parseInt(this.rpt.get_value(HEADER_ALT_TUMOR_COUNT));
        }
        GermlineSomaticLOH gsl = new GermlineSomaticLOH();
        if (gsl.call(ref_n_count, ref_t_count, alt_n_count, alt_t_count)) {
            String value = "";
            if (gsl.is_somatic()) {
                value = "S";
            } else if (gsl.is_germline()) {
                value = "G";
            }
            this.rpt.set_value(HEADER_SOMATIC_OR_GERMLINE, value);
            String loh_desc = "";
            if (gsl.is_loh()) {
                int code = gsl.get_loh_type();
                if (code == 1) {
                    loh_desc = "LOH_reference";
                } else if (code == 2) {
                    loh_desc = "LOH_variant";
                } else {
                    System.err.println("ERROR: unhandled LOH code " + code);
                    loh_desc = "LOH_error_fix_me";
                }
            }
            this.rpt.set_value(HEADER_LOH_FLAG, loh_desc);
        } else {
            this.rpt.set_value(HEADER_SOMATIC_OR_GERMLINE, "0");
            this.rpt.set_value(HEADER_LOH_FLAG, "0");
        }
        this.rpt.set_value(HEADER_ALT_RATIO_NORMAL, Str.float_decimal_format(gsl.get_alt_freq_normal(), this.config.REPORT_DECIMAL_ROUNDING));
        this.rpt.set_value(HEADER_ALT_RATIO_TUMOR, Str.float_decimal_format(gsl.get_alt_freq_tumor(), this.config.REPORT_DECIMAL_ROUNDING));
        this.rpt.set_value(HEADER_ALT_RATIO_NORMAL_TUMOR_DIFF, Str.float_decimal_format(gsl.get_alt_tn_freq_diff(), this.config.REPORT_DECIMAL_ROUNDING));
    }

    private boolean skew_populate(TumorNormalReferenceTracker tnrt) {
        StrandSkewFilter ssf = new StrandSkewFilter(this.config, tnrt);
        boolean result = ssf.skew_test();
        String value = "";
        if (ssf.is_evaluatable()) {
            value = Str.float_decimal_format(ssf.get_normalized_variant_plus_strand_frequency(), this.config.REPORT_DECIMAL_ROUNDING);
        }
        this.rpt.set_value(HEADER_STRAND_SKEW, value);
        return result;
    }

    private boolean fishers_exact_strand_bias_check(TumorNormalReferenceTracker tnrt) {
        boolean result = true;
        int reference_fwd = 0;
        int reference_rev = 0;
        int variant_fwd = 0;
        int variant_rev = 0;
        if (this.config.FISHERS_EXACT_DATA_TYPE.equals((Object)TumorNormal.UNKNOWN)) {
            ArrayList<TumorNormal> tns = new ArrayList<TumorNormal>();
            tns.add(TumorNormal.NORMAL);
            tns.add(TumorNormal.TUMOR);
            for (TumorNormal tn : tns) {
                reference_fwd += tnrt.get_count(ReferenceOrVariant.REFERENCE, tn, Strand.STRAND_POSITIVE);
                reference_rev += tnrt.get_count(ReferenceOrVariant.REFERENCE, tn, Strand.STRAND_NEGATIVE);
                variant_fwd += tnrt.get_count(ReferenceOrVariant.VARIANT, tn, Strand.STRAND_POSITIVE);
                variant_rev += tnrt.get_count(ReferenceOrVariant.VARIANT, tn, Strand.STRAND_NEGATIVE);
            }
        } else {
            reference_fwd = tnrt.get_count(ReferenceOrVariant.REFERENCE, this.config.FISHERS_EXACT_DATA_TYPE, Strand.STRAND_POSITIVE);
            reference_rev = tnrt.get_count(ReferenceOrVariant.REFERENCE, this.config.FISHERS_EXACT_DATA_TYPE, Strand.STRAND_NEGATIVE);
            variant_fwd = tnrt.get_count(ReferenceOrVariant.VARIANT, this.config.FISHERS_EXACT_DATA_TYPE, Strand.STRAND_POSITIVE);
            variant_rev = tnrt.get_count(ReferenceOrVariant.VARIANT, this.config.FISHERS_EXACT_DATA_TYPE, Strand.STRAND_NEGATIVE);
        }
        if ((variant_fwd == 0 || variant_rev == 0) && reference_fwd + variant_fwd > 0 && reference_rev + variant_rev > 0) {
            FisherExact fe = new FisherExact(reference_fwd + reference_rev + variant_fwd + variant_rev);
            double p = fe.getTwoTailedP(reference_fwd, reference_rev, variant_fwd, variant_rev);
            if (VERBOSE) {
                System.err.println("Fisher's exact: " + reference_fwd + " " + reference_rev + " " + variant_fwd + " " + variant_rev + " => " + p);
            }
            if (p < this.config.FISHERS_EXACT_STRAND_BIAS_CUTOFF) {
                result = false;
            }
        }
        return result;
    }

    private Iterable<Integer> get_it_keys() {
        Collection<Integer> it_keys;
        if (this.config.USE_TREEMAP) {
            it_keys = this.indel_tracker.keySet();
        } else if (this.indel_tracker == null) {
            ArrayList empty = new ArrayList();
            it_keys = empty;
        } else {
            ArrayList<Integer> al = new ArrayList<Integer>(this.indel_tracker.keySet());
            Collections.sort(al);
            it_keys = al;
        }
        return it_keys;
    }
}

