/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Chromosome;
import Ace2.Range;

public class SAMRegion {
    public String tname = null;
    public Range range;
    public String gene_name = null;

    public SAMRegion() {
        this.range = new Range();
    }

    public SAMRegion(String tname) {
        this.range = new Range();
        this.tname = tname;
    }

    public SAMRegion(String tname, int start, int end) {
        this.tname = tname;
        this.range = new Range(start, end);
    }

    public boolean isValid() {
        return this.tname != null && this.range.isValid();
    }

    public String toString() {
        if (this.isValid()) {
            return this.tname + ":" + this.range.start + "-" + this.range.end;
        }
        return null;
    }

    public String get_ucsc_chromosome() {
        Chromosome c = Chromosome.valueOfString(this.tname);
        return c == null ? null : c.toString();
    }

    public int get_length() {
        return this.range.end - this.range.start + 1;
    }

    public void set_start(int v) {
        this.range.start = v;
    }

    public void set_end(int v) {
        this.range.end = v;
    }
}

