/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PairedExtractHack {
    File bam;

    public PairedExtractHack(File bam) {
        this.bam = bam;
    }

    public void extract() {
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(this.bam);
        SAMFileHeader h = reader.getFileHeader();
        SAMSequenceDictionary dict = h.getSequenceDictionary();
        String seu_suffix = "\\.[FR]\\d+";
        Pattern pattern = Pattern.compile(seu_suffix);
        for (SAMSequenceRecord ssr : dict.getSequences()) {
            System.err.println("ref = " + ssr.getSequenceName());
            SAMRecordIterator query = reader.queryOverlapping(ssr.getSequenceName(), 1, ssr.getSequenceLength());
            while (query.hasNext()) {
                SAMRecord sr = (SAMRecord)query.next();
                String name = sr.getReadName();
                System.err.println(name);
                Matcher matcher = pattern.matcher(name);
                if (!matcher.find()) continue;
                name = matcher.replaceAll("");
                sr.setReadName(name);
            }
        }
    }

    public static void main(String[] argv) {
        PairedExtractHack peh = new PairedExtractHack(new File("rob_seu.bam"));
        peh.extract();
    }
}

