/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Chromosome;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChromosomeDisambiguator {
    HashMap<String, String> map;
    HashMap<String, Integer> lengths;

    public ChromosomeDisambiguator(ArrayList<String> list) {
        this.setup(list);
    }

    public ChromosomeDisambiguator(Set<String> list) {
        this.setup(new ArrayList<String>(list));
    }

    public ChromosomeDisambiguator(SamReader reader) {
        SAMFileHeader h = reader.getFileHeader();
        SAMSequenceDictionary dict = h.getSequenceDictionary();
        ArrayList<String> refs = new ArrayList<String>();
        this.lengths = new HashMap();
        for (SAMSequenceRecord ssr : dict.getSequences()) {
            String ref_name = ssr.getSequenceName();
            refs.add(ref_name);
            this.lengths.put(ref_name, ssr.getSequenceLength());
        }
        this.setup(refs);
    }

    public ChromosomeDisambiguator(SAMFileHeader h) {
        SAMSequenceDictionary dict = h.getSequenceDictionary();
        ArrayList<String> refs = new ArrayList<String>();
        this.lengths = new HashMap();
        for (SAMSequenceRecord ssr : dict.getSequences()) {
            String ref_name = ssr.getSequenceName();
            refs.add(ref_name);
            this.lengths.put(ref_name, ssr.getSequenceLength());
        }
        this.setup(refs);
    }

    private void setup(ArrayList<String> list) {
        this.map = new HashMap();
        for (String raw : list) {
            String cooked = Chromosome.standardize_name(raw);
            this.map.put(cooked, raw);
        }
    }

    public String find(String raw) {
        return this.map.get(Chromosome.standardize_name(raw));
    }

    public int get_length(String raw) {
        String cooked = this.find(raw);
        return cooked == null ? -1 : this.lengths.get(cooked);
    }
}

