# USAGE

To import: 
```
from pypagination import paginate
```

Call the paginate function:

paginate(150):
```
{ 
    totalItems: 150,
    currentPage: 1,
    pageSize: 10,
    totalPages: 15,
    startPage: 1,
    endPage: 10,
    startIndex: 0,
    endIndex: 9,
    pages: [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 ] 
}
```

paginate(150, 7):
totalItems: 150, currentPage: 7, pageSize: 15
```
{ 
    totalItems: 150,
    currentPage: 7,
    pageSize: 10,
    totalPages: 15,
    startPage: 2,
    endPage: 11,
    startIndex: 60,
    endIndex: 69,
    pages: [ 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 ] 
}
```

paginate(150, 7, 15, 5)
totalItems: 150, currentPage: 7, pageSize: 15, maxPages: 5
```
{ 
    totalItems: 150,
    currentPage: 7,
    pageSize: 15,
    totalPages: 10,
    startPage: 5,
    endPage: 9,
    startIndex: 90,
    endIndex: 104,
    pages: [ 5, 6, 7, 8, 9 ] 
}
```

# BRIEF

The paginate function accepts the following parameters:

1. `totalItems (required)` - the total number of items to be paged
2. `currentPage (optional)` - the current active page, defaults to the first page
3. `pageSize (optional)` - the number of items per page, defaults to 10
4. `maxPages (optional)` - the maximum number of page navigation links to display, defaults to 10

The output of the paginate function is an object containing all the information needed to display the current page of items in the view and the page navigation links.