# XTMigrations
A fast and easy to use database migration tool for Postgresql, written in Python.
This tool helps you keep track of changes in your database.
---

### Let's assume you have an `employees` table with the fields `id` and `first_name`.
### You would create a new "migration" as follows:

```bash
$ migrate new my first migration
Migration file generated scripts/20221012_234403_996058_my_first_migration.sql
```

### You would edit the file `scripts/20221012_234403_996058_my_first_migration.sql` as follows:
```text
# Autogenerated: scripts/20221012_234403_996058_my_first_migration.sql

@Up
# Your Up migration goes here (this section describes the database changes you want to apply)
CREATE TABLE employees (id BIGSERIAL, first_name VARCHAR(100));

@Down
# Your Down migration goes here (this section is to "undo" the change in the "Up" section above)
DROP TABLE employees;
```

### To apply your changes you would just run
```
$ migrate up
$ migrate status   # to show your changes
----------------------------------------------- - --------------------
| Name                                          |   Status           |
----------------------------------------------- - --------------------
| init                                          |   Applied          |
| 20221012_234403_996058_my_first_migration     |   Applied.         |
----------------------------------------------- - --------------------
```

### On your next software release, you decide that you want to add an `email` field, you would just do the following
```bash
$ migrate new adding email field
Migration file generated scripts/20221012_234936_024571_adding_email_field.sql
```

### You just edit the file `scripts/20221012_234936_024571_adding_email_field.sql`
```text
# Autogenerated: scripts/20221012_234936_024571_adding_email_field.sql

@Up
# Your Up migration goes here
ALTER TABLE employees ADD COLUMN email VARCHAR(255) DEFAULT NULL;

@Down
# Your Down migration goes here
ALTER TABLE employees DROP COLUMN email;
```

### Before applying the change, you can check the state of your database:
```
$ migrate status
----------------------------------------------- - --------------------
| Name                                          |   Status           |
----------------------------------------------- - --------------------
| init                                          |   Applied          |
| 20221012_234403_996058_my_first_migration     |   Applied          |
| 20221012_234936_024571_adding_email_field     |   Pending...       |
----------------------------------------------- - --------------------
```

### You then apply the new change
```
$ migrate up
```

### If for some reason, you decide to remove the change, you can *undo* the migration
```
$ migrate down
```

### You can also undo multiple migrations.  For example, if you want to undo 2 migrations, you would simply run
```
$ migrate down 2
```
---

### Installation

Via [`pip`](https://pypi.org/project/xtmigrations/)(python 3+ supported)
```
$ pip install xtmigrations
```

If you have virtualenv, make sure to run source ~/<virtualenv_folder/bin/activate to be able to have access to the "migrate" command.
You can alternatively open a new shell.  Make sure that the "migrate" command works by running "migrate version" which should display something like this:
```
$ migrate version
xtmigrations v1.1.3
```

### To initialize a new migrations directory structure
Go to your project folder (e.g. /Users/myuser/Projects/my_project/) and run
```
$ migrate init <name>
```
### <name> is your migrations folder.  This will create a new <name>/ directory structure.
### For this example, let's assume we call it "migrations" and it will generate a migrations/ folder.  We will run
```
$ migrate init migrations
```

### Now go inside migrations/ folder
```
$ cd migrations
```

###  Configure config/db.cnf with your database settings
Once it is configured, try to run the following command to make sure that xtmigrations is able to connect to your database.
```
migrate status
```

### To create a new migration, run the following (no quotes needed)
```
$ migrate new my first feature
```
This will create a new migration script (SQL file) under scripts/ folder.

### Make sure to edit the new sql file.  There is a @Up and a @Down section.
### Keep in mind that your SQL inside @Down section should *undo* the database change defined in the @Up section.

###  Apply the migration
```
$ migrate up
```

### To unapply a migration, run the following:
```
$ migrate down
```
---

### Environment-specific migrations and seed data.
### In some scenarios, we want to prepopulate seed our application with seed data depending on the environment
### Use the following command to create an environment-specific migration (Noting that your config/db.cnf is where you define your current environment)
### In our example, let's say we want to create a migration for our `dev` environment and our `integration` environment.  We would run the following
```
$ migrate new -e dev seed data for development

$ migrate new -e integration seed data for integration testing
```

### Let's assume our current environment is `dev` (defined in config/db.cnf).  To see all migrations for all environment, you can run:
```
$ migrate status -a
```

### To see all the migrations that will be applied for a particular environment (e.g. integration environment), you can run
```
$ migrate status -e integration
```

### Note that running `migrate up` will only run the migration scripts for your current environment

---

### Usage
```
migrate init <name> | status [-a | -e] | new [-e <env>] <title> | up [<number>] | down [<number>] | help | version
```
    
Note: <number> can be 0 which means "all" (migrate down 0 would undo all of the migrations).

### License

Copyright © Nejmatek Inc 2022

Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.

### For any question, contact me at startechm@proton.me
### If you are looking for support, go to [Nejmatek.com](https://www.nejmatek.com)




