# coding: utf-8

"""
    FINBOURNE Workflows API

    FINBOURNE Technology  # noqa: E501

    The version of the OpenAPI document: 0.1.24
    Contact: info@finbourne.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from lusid_workflows.configuration import Configuration


class WorkflowActivitySummary(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
      required_map (dict): The key is attribute name
                           and the value is whether it is 'required' or 'optional'.
    """
    openapi_types = {
        'activity_name': 'str',
        'activity_type': 'str',
        'activity_execution_status': 'str',
        'started_at': 'datetime',
        'finished_at': 'datetime',
        'execution_info': 'str',
        'activity_context': 'dict(str, object)',
        'state_transition_from': 'str',
        'state_transition_to': 'str'
    }

    attribute_map = {
        'activity_name': 'activityName',
        'activity_type': 'activityType',
        'activity_execution_status': 'activityExecutionStatus',
        'started_at': 'startedAt',
        'finished_at': 'finishedAt',
        'execution_info': 'executionInfo',
        'activity_context': 'activityContext',
        'state_transition_from': 'stateTransitionFrom',
        'state_transition_to': 'stateTransitionTo'
    }

    required_map = {
        'activity_name': 'optional',
        'activity_type': 'optional',
        'activity_execution_status': 'optional',
        'started_at': 'optional',
        'finished_at': 'optional',
        'execution_info': 'optional',
        'activity_context': 'optional',
        'state_transition_from': 'optional',
        'state_transition_to': 'optional'
    }

    def __init__(self, activity_name=None, activity_type=None, activity_execution_status=None, started_at=None, finished_at=None, execution_info=None, activity_context=None, state_transition_from=None, state_transition_to=None, local_vars_configuration=None):  # noqa: E501
        """WorkflowActivitySummary - a model defined in OpenAPI"
        
        :param activity_name:  Name of the Activity, for example WaitingForFileToReceive, WaitingForIssueToBeAssigned etc
        :type activity_name: str
        :param activity_type:  Type of the Activity, for example Start/StopActivity, ReceiveSignalActivity, SendEmailActivity, ReceiveHttpRequestActivity etc
        :type activity_type: str
        :param activity_execution_status:  Activity's execution status
        :type activity_execution_status: str
        :param started_at:  Timestamp when activity execution began.
        :type started_at: datetime
        :param finished_at:  Timestamp when activity execution finished/faulted/cancelled.
        :type finished_at: datetime
        :param execution_info:  Any info associated with the activity execution. Error message for example.
        :type execution_info: str
        :param activity_context:  Any arbitrary data context associated with the activity.
        :type activity_context: dict(str, object)
        :param state_transition_from:  State associated with previous activity if any otherwise empty.
        :type state_transition_from: str
        :param state_transition_to:  State associated with current activity if any otherwise empty.
        :type state_transition_to: str

        """  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._activity_name = None
        self._activity_type = None
        self._activity_execution_status = None
        self._started_at = None
        self._finished_at = None
        self._execution_info = None
        self._activity_context = None
        self._state_transition_from = None
        self._state_transition_to = None
        self.discriminator = None

        self.activity_name = activity_name
        self.activity_type = activity_type
        self.activity_execution_status = activity_execution_status
        self.started_at = started_at
        self.finished_at = finished_at
        self.execution_info = execution_info
        self.activity_context = activity_context
        self.state_transition_from = state_transition_from
        self.state_transition_to = state_transition_to

    @property
    def activity_name(self):
        """Gets the activity_name of this WorkflowActivitySummary.  # noqa: E501

        Name of the Activity, for example WaitingForFileToReceive, WaitingForIssueToBeAssigned etc  # noqa: E501

        :return: The activity_name of this WorkflowActivitySummary.  # noqa: E501
        :rtype: str
        """
        return self._activity_name

    @activity_name.setter
    def activity_name(self, activity_name):
        """Sets the activity_name of this WorkflowActivitySummary.

        Name of the Activity, for example WaitingForFileToReceive, WaitingForIssueToBeAssigned etc  # noqa: E501

        :param activity_name: The activity_name of this WorkflowActivitySummary.  # noqa: E501
        :type activity_name: str
        """

        self._activity_name = activity_name

    @property
    def activity_type(self):
        """Gets the activity_type of this WorkflowActivitySummary.  # noqa: E501

        Type of the Activity, for example Start/StopActivity, ReceiveSignalActivity, SendEmailActivity, ReceiveHttpRequestActivity etc  # noqa: E501

        :return: The activity_type of this WorkflowActivitySummary.  # noqa: E501
        :rtype: str
        """
        return self._activity_type

    @activity_type.setter
    def activity_type(self, activity_type):
        """Sets the activity_type of this WorkflowActivitySummary.

        Type of the Activity, for example Start/StopActivity, ReceiveSignalActivity, SendEmailActivity, ReceiveHttpRequestActivity etc  # noqa: E501

        :param activity_type: The activity_type of this WorkflowActivitySummary.  # noqa: E501
        :type activity_type: str
        """

        self._activity_type = activity_type

    @property
    def activity_execution_status(self):
        """Gets the activity_execution_status of this WorkflowActivitySummary.  # noqa: E501

        Activity's execution status  # noqa: E501

        :return: The activity_execution_status of this WorkflowActivitySummary.  # noqa: E501
        :rtype: str
        """
        return self._activity_execution_status

    @activity_execution_status.setter
    def activity_execution_status(self, activity_execution_status):
        """Sets the activity_execution_status of this WorkflowActivitySummary.

        Activity's execution status  # noqa: E501

        :param activity_execution_status: The activity_execution_status of this WorkflowActivitySummary.  # noqa: E501
        :type activity_execution_status: str
        """

        self._activity_execution_status = activity_execution_status

    @property
    def started_at(self):
        """Gets the started_at of this WorkflowActivitySummary.  # noqa: E501

        Timestamp when activity execution began.  # noqa: E501

        :return: The started_at of this WorkflowActivitySummary.  # noqa: E501
        :rtype: datetime
        """
        return self._started_at

    @started_at.setter
    def started_at(self, started_at):
        """Sets the started_at of this WorkflowActivitySummary.

        Timestamp when activity execution began.  # noqa: E501

        :param started_at: The started_at of this WorkflowActivitySummary.  # noqa: E501
        :type started_at: datetime
        """

        self._started_at = started_at

    @property
    def finished_at(self):
        """Gets the finished_at of this WorkflowActivitySummary.  # noqa: E501

        Timestamp when activity execution finished/faulted/cancelled.  # noqa: E501

        :return: The finished_at of this WorkflowActivitySummary.  # noqa: E501
        :rtype: datetime
        """
        return self._finished_at

    @finished_at.setter
    def finished_at(self, finished_at):
        """Sets the finished_at of this WorkflowActivitySummary.

        Timestamp when activity execution finished/faulted/cancelled.  # noqa: E501

        :param finished_at: The finished_at of this WorkflowActivitySummary.  # noqa: E501
        :type finished_at: datetime
        """

        self._finished_at = finished_at

    @property
    def execution_info(self):
        """Gets the execution_info of this WorkflowActivitySummary.  # noqa: E501

        Any info associated with the activity execution. Error message for example.  # noqa: E501

        :return: The execution_info of this WorkflowActivitySummary.  # noqa: E501
        :rtype: str
        """
        return self._execution_info

    @execution_info.setter
    def execution_info(self, execution_info):
        """Sets the execution_info of this WorkflowActivitySummary.

        Any info associated with the activity execution. Error message for example.  # noqa: E501

        :param execution_info: The execution_info of this WorkflowActivitySummary.  # noqa: E501
        :type execution_info: str
        """

        self._execution_info = execution_info

    @property
    def activity_context(self):
        """Gets the activity_context of this WorkflowActivitySummary.  # noqa: E501

        Any arbitrary data context associated with the activity.  # noqa: E501

        :return: The activity_context of this WorkflowActivitySummary.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._activity_context

    @activity_context.setter
    def activity_context(self, activity_context):
        """Sets the activity_context of this WorkflowActivitySummary.

        Any arbitrary data context associated with the activity.  # noqa: E501

        :param activity_context: The activity_context of this WorkflowActivitySummary.  # noqa: E501
        :type activity_context: dict(str, object)
        """

        self._activity_context = activity_context

    @property
    def state_transition_from(self):
        """Gets the state_transition_from of this WorkflowActivitySummary.  # noqa: E501

        State associated with previous activity if any otherwise empty.  # noqa: E501

        :return: The state_transition_from of this WorkflowActivitySummary.  # noqa: E501
        :rtype: str
        """
        return self._state_transition_from

    @state_transition_from.setter
    def state_transition_from(self, state_transition_from):
        """Sets the state_transition_from of this WorkflowActivitySummary.

        State associated with previous activity if any otherwise empty.  # noqa: E501

        :param state_transition_from: The state_transition_from of this WorkflowActivitySummary.  # noqa: E501
        :type state_transition_from: str
        """

        self._state_transition_from = state_transition_from

    @property
    def state_transition_to(self):
        """Gets the state_transition_to of this WorkflowActivitySummary.  # noqa: E501

        State associated with current activity if any otherwise empty.  # noqa: E501

        :return: The state_transition_to of this WorkflowActivitySummary.  # noqa: E501
        :rtype: str
        """
        return self._state_transition_to

    @state_transition_to.setter
    def state_transition_to(self, state_transition_to):
        """Sets the state_transition_to of this WorkflowActivitySummary.

        State associated with current activity if any otherwise empty.  # noqa: E501

        :param state_transition_to: The state_transition_to of this WorkflowActivitySummary.  # noqa: E501
        :type state_transition_to: str
        """

        self._state_transition_to = state_transition_to

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WorkflowActivitySummary):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, WorkflowActivitySummary):
            return True

        return self.to_dict() != other.to_dict()
