# coding: utf-8

"""
    FINBOURNE Workflows API

    FINBOURNE Technology  # noqa: E501

    The version of the OpenAPI document: 0.1.24
    Contact: info@finbourne.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lusid_workflows.api_client import ApiClient
from lusid_workflows.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class WorkflowsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def execute_workflow(self, workflow_code, execute_workflow_request, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Execute workflow  # noqa: E501

        This will create a new workflow instance for the specified workflow  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.execute_workflow(workflow_code, execute_workflow_request, async_req=True)
        >>> result = thread.get()

        :param workflow_code: Workflow Code (required)
        :type workflow_code: str
        :param execute_workflow_request: Data associated with execute request (required)
        :type execute_workflow_request: ExecuteWorkflowRequest
        :param correlation_id: Optional. This id can be used to correlate a workflow instance with any entity (e.g. a custom entity or other workflow instance) and also to retrieve and transit workflow instances
        :type correlation_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkflowInstance
        """
        kwargs['_return_http_data_only'] = True
        return self.execute_workflow_with_http_info(workflow_code, execute_workflow_request, **kwargs)  # noqa: E501

    def execute_workflow_with_http_info(self, workflow_code, execute_workflow_request, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Execute workflow  # noqa: E501

        This will create a new workflow instance for the specified workflow  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.execute_workflow_with_http_info(workflow_code, execute_workflow_request, async_req=True)
        >>> result = thread.get()

        :param workflow_code: Workflow Code (required)
        :type workflow_code: str
        :param execute_workflow_request: Data associated with execute request (required)
        :type execute_workflow_request: ExecuteWorkflowRequest
        :param correlation_id: Optional. This id can be used to correlate a workflow instance with any entity (e.g. a custom entity or other workflow instance) and also to retrieve and transit workflow instances
        :type correlation_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WorkflowInstance, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'workflow_code',
            'execute_workflow_request',
            'correlation_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method execute_workflow" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_code' is set
        if self.api_client.client_side_validation and ('workflow_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_code` when calling `execute_workflow`")  # noqa: E501
        # verify the required parameter 'execute_workflow_request' is set
        if self.api_client.client_side_validation and ('execute_workflow_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['execute_workflow_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `execute_workflow_request` when calling `execute_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_code' in local_var_params:
            path_params['workflowCode'] = local_var_params['workflow_code']  # noqa: E501

        query_params = []
        if 'correlation_id' in local_var_params and local_var_params['correlation_id'] is not None:  # noqa: E501
            query_params.append(('correlationId', local_var_params['correlation_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'execute_workflow_request' in local_var_params:
            body_params = local_var_params['execute_workflow_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.1.24'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501
        
        response_types_map = {
            200: "WorkflowInstance",
            400: "LusidValidationProblemDetails",
            404: "str",
        }

        return self.api_client.call_api(
            '/api/v1/workflows/{workflowCode}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_workflow_instance(self, workflow_instance_id, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get workflow instance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_workflow_instance(workflow_instance_id, async_req=True)
        >>> result = thread.get()

        :param workflow_instance_id: Unique workflow instance identifier (required)
        :type workflow_instance_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkflowInstance
        """
        kwargs['_return_http_data_only'] = True
        return self.get_workflow_instance_with_http_info(workflow_instance_id, **kwargs)  # noqa: E501

    def get_workflow_instance_with_http_info(self, workflow_instance_id, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get workflow instance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_workflow_instance_with_http_info(workflow_instance_id, async_req=True)
        >>> result = thread.get()

        :param workflow_instance_id: Unique workflow instance identifier (required)
        :type workflow_instance_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WorkflowInstance, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'workflow_instance_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_instance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_instance_id' is set
        if self.api_client.client_side_validation and ('workflow_instance_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_instance_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_instance_id` when calling `get_workflow_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_instance_id' in local_var_params:
            path_params['workflowInstanceId'] = local_var_params['workflow_instance_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501
        
        response_types_map = {
            200: "WorkflowInstance",
            400: "LusidValidationProblemDetails",
            404: "str",
        }

        return self.api_client.call_api(
            '/api/v1/workflows/instances/{workflowInstanceId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_workflow_instance_by_correlation_id(self, correlation_id, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get workflow instance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_workflow_instance_by_correlation_id(correlation_id, async_req=True)
        >>> result = thread.get()

        :param correlation_id: CorrelationId associated with the workflow instance (required)
        :type correlation_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkflowInstance
        """
        kwargs['_return_http_data_only'] = True
        return self.get_workflow_instance_by_correlation_id_with_http_info(correlation_id, **kwargs)  # noqa: E501

    def get_workflow_instance_by_correlation_id_with_http_info(self, correlation_id, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get workflow instance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_workflow_instance_by_correlation_id_with_http_info(correlation_id, async_req=True)
        >>> result = thread.get()

        :param correlation_id: CorrelationId associated with the workflow instance (required)
        :type correlation_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WorkflowInstance, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'correlation_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_instance_by_correlation_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'correlation_id' is set
        if self.api_client.client_side_validation and ('correlation_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['correlation_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `correlation_id` when calling `get_workflow_instance_by_correlation_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'correlation_id' in local_var_params:
            path_params['correlationId'] = local_var_params['correlation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501
        
        response_types_map = {
            200: "WorkflowInstance",
            400: "LusidValidationProblemDetails",
            404: "str",
        }

        return self.api_client.call_api(
            '/api/v1/workflows/instance/{correlationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_workflow_instances(self, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get workflow instances  # noqa: E501

        If no parameters are passed then all instances will be returned  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_workflow_instances(async_req=True)
        >>> result = thread.get()

        :param workflow_code: Optional. Workflow code
        :type workflow_code: str
        :param workflow_execution_status: Optional. Workflow execution status
        :type workflow_execution_status: str
        :param workflow_instance_state: Optional. Custom state associated with workflow instance
        :type workflow_instance_state: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfWorkflowInstance
        """
        kwargs['_return_http_data_only'] = True
        return self.list_workflow_instances_with_http_info(**kwargs)  # noqa: E501

    def list_workflow_instances_with_http_info(self, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get workflow instances  # noqa: E501

        If no parameters are passed then all instances will be returned  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_workflow_instances_with_http_info(async_req=True)
        >>> result = thread.get()

        :param workflow_code: Optional. Workflow code
        :type workflow_code: str
        :param workflow_execution_status: Optional. Workflow execution status
        :type workflow_execution_status: str
        :param workflow_instance_state: Optional. Custom state associated with workflow instance
        :type workflow_instance_state: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfWorkflowInstance, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'workflow_code',
            'workflow_execution_status',
            'workflow_instance_state'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_workflow_instances" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'workflow_code' in local_var_params and local_var_params['workflow_code'] is not None:  # noqa: E501
            query_params.append(('workflowCode', local_var_params['workflow_code']))  # noqa: E501
        if 'workflow_execution_status' in local_var_params and local_var_params['workflow_execution_status'] is not None:  # noqa: E501
            query_params.append(('workflowExecutionStatus', local_var_params['workflow_execution_status']))  # noqa: E501
        if 'workflow_instance_state' in local_var_params and local_var_params['workflow_instance_state'] is not None:  # noqa: E501
            query_params.append(('workflowInstanceState', local_var_params['workflow_instance_state']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501
        
        response_types_map = {
            200: "ResourceListOfWorkflowInstance",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/v1/workflows/instances', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_workflows(self, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get all available workflows  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_workflows(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfWorkflow
        """
        kwargs['_return_http_data_only'] = True
        return self.list_workflows_with_http_info(**kwargs)  # noqa: E501

    def list_workflows_with_http_info(self, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get all available workflows  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_workflows_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfWorkflow, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_workflows" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501
        
        response_types_map = {
            200: "ResourceListOfWorkflow",
        }

        return self.api_client.call_api(
            '/api/v1/workflows', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def transit_workflow(self, workflow_instance_id, transit_workflow_request, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Transit workflow  # noqa: E501

        This would transit the workflow instance to proceed to next step using WorkflowInstanceId with the attached data/context and action  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.transit_workflow(workflow_instance_id, transit_workflow_request, async_req=True)
        >>> result = thread.get()

        :param workflow_instance_id: Unique workflow instance identifier (required)
        :type workflow_instance_id: str
        :param transit_workflow_request: Data associated with the transit request (required)
        :type transit_workflow_request: TransitWorkflowRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkflowInstance
        """
        kwargs['_return_http_data_only'] = True
        return self.transit_workflow_with_http_info(workflow_instance_id, transit_workflow_request, **kwargs)  # noqa: E501

    def transit_workflow_with_http_info(self, workflow_instance_id, transit_workflow_request, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Transit workflow  # noqa: E501

        This would transit the workflow instance to proceed to next step using WorkflowInstanceId with the attached data/context and action  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.transit_workflow_with_http_info(workflow_instance_id, transit_workflow_request, async_req=True)
        >>> result = thread.get()

        :param workflow_instance_id: Unique workflow instance identifier (required)
        :type workflow_instance_id: str
        :param transit_workflow_request: Data associated with the transit request (required)
        :type transit_workflow_request: TransitWorkflowRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WorkflowInstance, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'workflow_instance_id',
            'transit_workflow_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method transit_workflow" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_instance_id' is set
        if self.api_client.client_side_validation and ('workflow_instance_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_instance_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_instance_id` when calling `transit_workflow`")  # noqa: E501
        # verify the required parameter 'transit_workflow_request' is set
        if self.api_client.client_side_validation and ('transit_workflow_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['transit_workflow_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `transit_workflow_request` when calling `transit_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_instance_id' in local_var_params:
            path_params['workflowInstanceId'] = local_var_params['workflow_instance_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'transit_workflow_request' in local_var_params:
            body_params = local_var_params['transit_workflow_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.1.24'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501
        
        response_types_map = {
            200: "WorkflowInstance",
            400: "LusidValidationProblemDetails",
            404: "str",
        }

        return self.api_client.call_api(
            '/api/v1/workflows/instances/{workflowInstanceId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def transit_workflow_by_correlation_id(self, correlation_id, transit_workflow_request, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Transit workflow  # noqa: E501

        This would transit the workflow instance to proceed to next step using CorrelationId with the attached data/context and action  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.transit_workflow_by_correlation_id(correlation_id, transit_workflow_request, async_req=True)
        >>> result = thread.get()

        :param correlation_id: CorrelationId associated with the workflow instance (required)
        :type correlation_id: str
        :param transit_workflow_request: Data associated with the transit request (required)
        :type transit_workflow_request: TransitWorkflowRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkflowInstance
        """
        kwargs['_return_http_data_only'] = True
        return self.transit_workflow_by_correlation_id_with_http_info(correlation_id, transit_workflow_request, **kwargs)  # noqa: E501

    def transit_workflow_by_correlation_id_with_http_info(self, correlation_id, transit_workflow_request, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Transit workflow  # noqa: E501

        This would transit the workflow instance to proceed to next step using CorrelationId with the attached data/context and action  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.transit_workflow_by_correlation_id_with_http_info(correlation_id, transit_workflow_request, async_req=True)
        >>> result = thread.get()

        :param correlation_id: CorrelationId associated with the workflow instance (required)
        :type correlation_id: str
        :param transit_workflow_request: Data associated with the transit request (required)
        :type transit_workflow_request: TransitWorkflowRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WorkflowInstance, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'correlation_id',
            'transit_workflow_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method transit_workflow_by_correlation_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'correlation_id' is set
        if self.api_client.client_side_validation and ('correlation_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['correlation_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `correlation_id` when calling `transit_workflow_by_correlation_id`")  # noqa: E501
        # verify the required parameter 'transit_workflow_request' is set
        if self.api_client.client_side_validation and ('transit_workflow_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['transit_workflow_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `transit_workflow_request` when calling `transit_workflow_by_correlation_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'correlation_id' in local_var_params:
            path_params['correlationId'] = local_var_params['correlation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'transit_workflow_request' in local_var_params:
            body_params = local_var_params['transit_workflow_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.1.24'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501
        
        response_types_map = {
            200: "WorkflowInstance",
            400: "LusidValidationProblemDetails",
            404: "str",
        }

        return self.api_client.call_api(
            '/api/v1/workflows/instance/{correlationId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
